<?php

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function process_log($infile, $outfile)
{
  global $OG_shm_delivered;
  global $OASISmsg;

  if(!@$fpr = fopen($infile, "r"))
  {
    print("$OASISmsg[Could_not_open] $infile: $php_errormsg\n");
    return;
  }

  if(!@$fpw = fopen($outfile, "a"))
  {
    print("$OASISmsg[Could_not_open] $outfile: $php_errormsg\n");
    return;
  }

  $log_imp_delivered = array();
  $log_click_delivered = array();

  $line_count = 0;
  while($line = fgets($fpr, 65536))
  {
    $line_count++;
    fputs($fpw, $line);

    list($timestamp, $ipaddr, $user, $event, $section, $cr_id, $code)
      = split("\t", $line);

    $hour = date('G', $timestamp);
    $day = date('Y-m-d', $timestamp);

    if($cr_id == '') $cr_id = -1;

    $ca_id = '';
    if(!($ca_id = $ca_ids[$cr_id]))
    {
      if($result = mysql_query("select CampaignID, Width, Height from Creatives where CreativeID=$cr_id"))
      {
        list($ca_id, $w, $h) = mysql_fetch_row($result);
	$ca_ids[$cr_id] = $ca_id;
	$widths[$cr_id] = $w;
	$heights[$cr_id] = $h;
      }
    }

    if($event == 'imp')
    {
      $stats[$day][$hour][$section][$cr_id][0]++;
      if($ca_id) $ca_stats[$day][$ca_id][0]++;
      $log_imp_delivered[$cr_id]++;
    }
    elseif($event == 'click')
    {
      $stats[$day][$hour][$section][$cr_id][1]++;
      if($ca_id) $ca_stats[$day][$ca_id][1]++;
      $log_click_delivered[$cr_id]++;
    }
    elseif($event == 'ierr')
    {
      $stats[$day][$hour][$section][$cr_id][2]++;
      if($ca_id) $ca_stats[$day][$ca_id][2]++;
    }
    elseif($event == 'cerr')
    {
      $stats[$day][$hour][$section][$cr_id][3]++;
      if($ca_id) $ca_stats[$day][$ca_id][3]++;
    }
  }
  admin_log("$line_count lines processed");
  fclose($fpr);
  fclose($fpw);
  unlink($infile);

  #### check for discrepancies between what shared memory reported and what
  #### the log reports
  $discrep_report = '';
  $master_list = array();
  while(list($cr_id, $j) = each($OG_shm_delivered)) $master_list[$cr_id] = 1;
  while(list($cr_id, $j) = each($log_imp_delivered)) $master_list[$cr_id] = 1;
  while(list($cr_id, $j) = each($log_click_delivered)) $master_list[$cr_id] = 1;

  while(list($cr_id, $j) = each($master_list))
  {
    if($OG_shm_delivered[$cr_id]) list($i, $c) = $OG_shm_delivered[$cr_id];
    else                       list($i, $c) = array(0,0);

    if (!$log_imp_delivered[$cr_id]) $log_imp_delivered[$cr_id] = 0;
    if (!$log_click_delivered[$cr_id]) $log_click_delivered[$cr_id] = 0;
    admin_log("[Cr $cr_id] shm: $i i/$c c, log: $log_imp_delivered[$cr_id] i/$log_click_delivered[$cr_id] c");

    $cr_discrep = '';

    #### we'll go ahead and adjust the DailyTargets, Creatives, and Campaigns
    #### tables now to make it match up with the logs.
    #### The logs are the definitive source for impression/click
    #### counts (for reports and invoices) anyway, so this is OK.  But it
    #### is a hack; shared memory and logs should always jibe unless something
    #### goes wrong.  Note that if we get a discrepancy right before the
    #### last hour of the last day of a campaign, we will most likely see
    #### an over or underdelivery.
    if($i != $log_imp_delivered[$cr_id])
    {
      $cr_discrep .= "  shm: $i imp,  log: $log_imp_delivered[$cr_id] imp\n";

      $result = mysql_query("select CampaignID from Creatives where CreativeID=$cr_id");
      list($ca_id) = mysql_fetch_row($result);

      $imp_adjust = $i - $log_imp_delivered[$cr_id];
      $ia = ($imp_adjust > 0) ? "+$imp_adjust" : $imp_adjust;

      $sql = "update DailyTargets set Remaining=Remaining$ia where CreativeID=$cr_id";
      admin_log($sql);
      mysql_query($sql);

      $ia = ($imp_adjust > 0) ? "-$imp_adjust" : "+" . abs($imp_adjust);

      $sql = "update Creatives set ImpressionsDelivered=ImpressionsDelivered$ia where CreativeID=$cr_id";
      admin_log($sql);
      mysql_query($sql);
	
      $sql = "update Campaigns set ImpressionsDelivered=ImpressionsDelivered$ia where CampaignID=$ca_id";
      admin_log($sql);
      mysql_query($sql);
    }

    #### see discussion above about impression discrepancies
    if($c != $log_click_delivered[$cr_id])
    {
      $cr_discrep .= "  shm: $c clicks, log: $log_click_delivered[$cr_id] clicks\n";

      $result = mysql_query("select CampaignID from Creatives where CreativeID=$cr_id");
      list($ca_id) = mysql_fetch_row($result);

      $click_adjust = $c - $log_click_delivered[$cr_id];
      $ca = ($click_adjust > 0) ? "-$click_adjust" : "+" . abs($click_adjust);

      $sql = "update Creatives set ClicksDelivered=ClicksDelivered$ca where CreativeID=$cr_id";
      admin_log($sql);
      mysql_query($sql);
	
      $sql = "update Campaigns set ClicksDelivered=ClicksDelivered$ca where CampaignID=$ca_id";
      admin_log($sql);
      mysql_query($sql);
    }
    if($cr_discrep)
      $discrep_report .= "[Creative $cr_id]\n$cr_discrep\n";
  }

  if($discrep_report)
  {
    $admin_email = get_prefs('AdminEmail');
    mail($admin_email, "Discrepancy Report", $discrep_report);
  }

  while(list($day, $a0) = each($stats))
  {
    while(list($hour, $a1) = each($a0))
    {
      while(list($section, $a2) = each($a1))
      {
        while(list($cr_id, $a3) = each($a2))
        {
          for($i = 0; $i < 4; $i++) if(!$a3[$i]) $a3[$i] = 0;
          #print "$day, $hour, $section, $cr_id, $a3[0], $a3[1], $a3[2], $a3[3]\n";
          mysql_query("insert into HourlyStats values ('$day', $hour, $section, $cr_id, $a3[0], $a3[1], $a3[2], $a3[3])");

	  $w = $widths[$cr_id];
	  $h = $heights[$cr_id];
	  $s_stats[$day][$section]["$w,$h"] += $a3[0] + $a3[2];
        }
      }
    }
  }

  #### update the section impression traffic
  while(list($day, $a0) = each($s_stats))
  {
    while(list($section, $a1) = each($a0))
    {
      while(list($dim, $imp) = each($a1))
      {
        preg_match('#(\d+),(\d+)#', $dim, $matches);
	list($c, $w, $h) = $matches;
        mysql_query("update SectionDailyTraffic set Impressions=Impressions+$imp where SectionID=$section and Width=$w and Height=$h and Day='$day'");

        if(mysql_affected_rows() == 0)
          mysql_query("insert into SectionDailyTraffic values ('$day', $section, $dim, $imp)");
      }
    }
  }

  #### update the campaign numbers
  while(list($day, $a0) = each($ca_stats))
  {
    while(list($ca_id, $a1) = each($a0))
    {
      for($i = 0; $i < 4; $i++) if(!$a1[$i]) $a1[$i] = 0;

      mysql_query("update CampaignDailyStats set Impressions=Impressions+$a1[0], Clicks=Clicks+$a1[1], ImpressionErrors=ImpressionErrors+$a1[2], ClickErrors=ClickErrors+$a1[3] where CampaignID=$ca_id and Day='$day'");

      if(mysql_affected_rows() == 0)
        mysql_query("insert into CampaignDailyStats values ('$day', $ca_id, $a1[0], $a1[1], $a1[2], $a1[3])");

      #admin_log("recorded $a1[0] imps, $a1[1] clicks for campaign $ca_id");
    }
  }

  $hour = date('H', time());
  if($hour == 0)
  {
    $gzip = get_prefs("GzipPath");
    if($gzip) `$gzip $outfile`;
  }
}

?>
