<?php

require_once('lib-i18n.inc');

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function print_html_header($title)
{
  global $OASIScharset;
  global $HTTP_USER_AGENT;

  header ("Content-Type: text/html; charset=$OASIScharset");

  $gecko = preg_match ('#gecko/([0-9]+)#i', $HTTP_USER_AGENT) ? 1 : 0;

  #### don't explicitly print doctype for Mozilla; doing so would result
  #### in it applying strict rendering, which doesn't look right for our
  #### interface
  if (!$gecko) {
    print <<<__TEXT__
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/REC-html40/loose.dtd">
__TEXT__;
  }

  print <<<__TEXT__
<HTML>
<HEAD>
<LINK rel="stylesheet" type="text/css" href="oasis.css">
<TITLE>OASIS - $title</TITLE>
</HEAD>
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function print_footer()
{
  print <<<__TEXT__

</TD>
<TD WIDTH=1 BGCOLOR="#000000"><IMG SRC="graphics/1x1.gif"></TD>
</TR>
<TR>
<TD COLSPAN=3 BGCOLOR="#000000"><IMG SRC="graphics/1x1.gif"></TD>
</TR>
</TABLE>
</BODY></HTML>

__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_select($hash, $sel_name, $sel_option, $num_rows, $multiple)
{
  if($num_rows) $r_opt = " SIZE=$num_rows";
  if($multiple) $m_opt = " MULTIPLE";

  $select = "<SELECT NAME='$sel_name'$r_opt$m_opt>\n";

  if($multiple)
  {
    while(list($k, $v) = each($hash))
      $select .= ($sel_option[$k])
        ? "<OPTION VALUE='$k' SELECTED>$v\n" : "<OPTION VALUE='$k'>$v\n";
  }
  else
  {
    if($sel_option == '') $select .= "<OPTION VALUE='' SELECTED>\n";
    else                  $select .= "<OPTION VALUE=''>\n";
    while(list($k, $v) = each($hash))
      $select .= ($k == $sel_option)
        ? "<OPTION VALUE='$k' SELECTED>$v\n" : "<OPTION VALUE='$k'>$v\n";
  }

  $select .= "</SELECT>\n";

  return $select;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_date_widget($name, $date, $blank_disallowed)
{
  global $OASISmsg, $OASISdatefmt;

  if(!preg_match('#(\d+)-(\d+)-(\d+)#', $date, $matches))
  {
    $month = '';
    $day = '';
    $year = '';
  }

  list($junk, $year, $month, $day) = $matches;

  $month_dropdown = build_select(array('01' => $OASISmsg[January],
                                       '02' => $OASISmsg[February],
                                       '03' => $OASISmsg[March],
                                       '04' => $OASISmsg[April],
                                       '05' => $OASISmsg[May],
                                       '06' => $OASISmsg[June],
                                       '07' => $OASISmsg[July],
                                       '08' => $OASISmsg[August],
                                       '09' => $OASISmsg[September],
                                       '10' => $OASISmsg[October],
                                       '11' => $OASISmsg[November],
                                       '12' => $OASISmsg[December]),
					 $name . "_Month", $month, '', '');

  $day_dropdown = build_select(array('01' => 1, '02' => 2, '03' => 3,
                                       '04' => 4, '05' => 5, '06' => 6,
				       '07' => 7, '08' => 8, '09' => 9,
				       10 => 10, 11 => 11, 12 => 12,
                                       13 => 13, 14 => 14, 15 => 15, 16 => 16,
                                       17 => 17, 18 => 18, 19 => 19, 20 => 20,
                                       21 => 21, 22 => 22, 23 => 23, 24 => 24,
                                       25 => 25, 26 => 26, 27 => 27, 28 => 28,
                                       29 => 29, 30 => 30, 31 => 31),
					 $name . "_Day", $day, '', '');

  $start_year = ($year > 0) ? $year : date('Y');
  for($i = $start_year - 2; $i < $start_year + 3; $i++) 
    $year_array[$i] = $i;

  $year_dropdown = build_select($year_array, $name . "_Year", $year, '', '');

  if($blank_disallowed)
  {
    $month_dropdown = preg_replace("#<OPTION VALUE=''>\n#", '', $month_dropdown);
    $day_dropdown   = preg_replace("#<OPTION VALUE=''>\n#", '', $day_dropdown);
    $year_dropdown  = preg_replace("#<OPTION VALUE=''>\n#", '', $year_dropdown);
  }

  if ($OASISdatefmt == 'mdy')
    return $month_dropdown . $day_dropdown . $year_dropdown;
  if ($OASISdatefmt == 'dmy')
    return $day_dropdown . $month_dropdown . $year_dropdown;
}


$date_mgmt_script = <<<__TEXT__
<SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript">

<!--
function change_month(increment)
{
  var monthdays = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

  current_month = document.form1.StartDate_Month.selectedIndex;
  current_year = document.form1.StartDate_Year.selectedIndex;

  // do we have a blank entry at the top of the date list?
  // if so, assume that Day, Month, and Year all do
  if(document.form1.StartDate_Day.options[0].value != '')
  {
    current_month++;
    current_year++;
  }

  //alert("currently: " + current_month + ", " + current_year);

  s_month = current_month + increment;
  s_year = current_year;
  if(s_month == 0)
  {
    s_month = 12;
    if(current_year == 1)
    {
      alert("Can't set this date; too far in past.");
      return;
    }
    s_year = current_year - 1;
  }
  else if(s_month == 13)
  {
    s_month = 1;
    if(current_year == 5)
    {
      alert("Can't set this date; too far in future.");
      return;
    }
    s_year = current_year + 1;
  }

  s_day = 1;
  e_month = s_month;
  e_year = s_year;

  if(document.form1.StartDate_Day.options[0].value != '')
  {
    s_day--;
    s_month--;
    s_year--;
  }
  //alert("changing start to : " + s_day + ", " + s_month + ", " + s_year);
  document.form1.StartDate_Day.selectedIndex = s_day;
  document.form1.StartDate_Month.selectedIndex = s_month;
  document.form1.StartDate_Year.selectedIndex = s_year;

  actual_year = document.form1.StartDate_Year.options[s_year].text;
  // Is it a leap year?
  if ( actual_year % 4 == 0
       && !(actual_year % 100 == 0 && actual_year % 400 != 0) )
  {
    monthdays[1] = 29;
  }
  e_day = monthdays[e_month - 1];

  if(document.form1.EndDate_Day.options[0].value != '')
  {
    e_day--;
    e_month--;
    e_year--;
  }
  //alert("changing end to : " + e_day + ", " + e_month + ", " + e_year);
  document.form1.EndDate_Day.selectedIndex = e_day;
  document.form1.EndDate_Month.selectedIndex = e_month;
  document.form1.EndDate_Year.selectedIndex = e_year;
}
//-->

</SCRIPT>
__TEXT__;


$date_mgmt_buttons = <<<__TEXT__
<FONT SIZE="-1">
<INPUT TYPE=button onclick="change_month(-1)" VALUE="$OASISmsg[Prev_month]">
<INPUT TYPE=button onclick="change_month(1)" VALUE="$OASISmsg[Next_month]">
</FONT>
__TEXT__;


?>
