<?php

require("lib-mgmt.inc");
require("lib-invoice.inc");

if($InvoiceID)
{
  print html_invoice($InvoiceID);
  exit;
}
elseif($batch_print)
{
  batch_print();
  exit;
}

print_html_header($OASISmsg[Invoicing]);
print_header('Invoicing', '', '');

if($mark_as_sent)
{
  mark_as_sent();
}
elseif($mark_as_paid)
{
  mark_as_paid();
}

if($function == 'list_unsent')
{
  list_invoices("where Sent='N'", $OASISmsg[Unsent_Invoices]);
  print_footer();
  exit;
}
elseif($function == 'list_unpaid')
{
  list_invoices("where Paid='N'", $OASISmsg[Unpaid_Invoices]);
  print_footer();
  exit;
}
elseif($function == 'generate_form')
{
  build_generate_form();
  print_footer();
  exit;
}
elseif($function == 'generate')
{
  if(!($FromDate_Year && $FromDate_Month && $FromDate_Day))
    print $OASISmsg[error_specify_start_invoicing];
  elseif(!($ToDate_Year && $ToDate_Month && $ToDate_Day))
    print $OASISmsg[error_specify_end_invoicing];
  elseif(!($InvoiceDate_Year && $InvoiceDate_Month && $InvoiceDate_Day))
    print $OASISmsg[error_specify_invoicing_date];
  else
  {
    $FromDate = "$FromDate_Year-$FromDate_Month-$FromDate_Day";
    $ToDate = "$ToDate_Year-$ToDate_Month-$ToDate_Day";
    if($ToDate < $FromDate)
      print $OASISmsg[error_to_before_from];
    else
    {
      $InvoiceDate = "$InvoiceDate_Year-$InvoiceDate_Month-$InvoiceDate_Day";
      generate_invoices($FromDate, $ToDate, $InvoiceDate);
    }
  }

  print_footer();
  exit;
}

?>

<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG><?php echo $OASISmsg[Invoicing]; ?></STRONG></FONT><BR>
<P>
<A HREF="invoice.php?function=list_unsent"><?php echo $OASISmsg[List_unsent_invoices]; ?></A>
<P>
<A HREF="invoice.php?function=list_unpaid"><?php echo $OASISmsg[List_unpaid_invoices]; ?></A>
<P>
<A HREF="invoice.php?function=generate_form"><?php echo $OASISmsg[Generate_invoices]; ?></A>
</UL>
</TD></TR></TABLE>

<?php

print_footer();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_generate_form()
{
  global $startdate_widget, $enddate_widget, $invoicedate_widget;
  global $OASISmsg;

  build_form_elements();

  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG>$OASISmsg[Generate_Invoices]</STRONG></FONT><BR>
<P>

<FORM METHOD=POST ACTION=invoice.php>
<INPUT TYPE=hidden NAME=function VALUE=generate>
<TABLE>
<TR>
<TD>$OASISmsg[Start_Date]</TD>
<TD>$startdate_widget</TD>
</TR>
<TR>
<TD>$OASISmsg[End_Date]</TD>
<TD>$enddate_widget</TD>
</TR>
<TR>
<TD>$OASISmsg[Invoice_Date]</TD>
<TD>$invoicedate_widget</TD>
</TR>
<TR>
<TD COLSPAN=2>
<INPUT TYPE=submit VALUE="$OASISmsg[Generate_Invoices]">
</TD>
</TR>
</TABLE>
</FORM>
</TD></TR></TABLE>
__TEXT__;
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function list_invoices($filter_string, $title)
{
  global $OASISmsg;

  print "<FONT SIZE='+1'><STRONG>$title</STRONG></FONT><BR>\n";
  $sql = "select InvoiceID, InvoiceNumber, Campaigns.Name, Advertisers.Name, InvoiceDate from Invoices left join Campaigns on Invoices.CampaignID=Campaigns.CampaignID left join Advertisers on Campaigns.AdvertiserID=Advertisers.AdvertiserID $filter_string order by Advertisers.Name, Campaigns.Name";

  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[error_pulling_invoice]: " . mysql_error();
    exit;
  }

  print <<<__TEXT__
<FORM METHOD=POST ACTION="invoice.php">
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Invoice]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Advertiser]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Invoice_Date]</SPAN></TD>
</TR>
__TEXT__;

  while(list($id, $inum, $ca_name, $a_name, $idate) = mysql_fetch_row($result))
  {
    $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

    print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR='$bgcolor'>
<TD><INPUT TYPE=checkbox NAME="invoices[]" VALUE=$id checked></TD>
<TD><A HREF="invoice.php?InvoiceID=$id">$inum</A></TD>
<TD>$a_name</TD>
<TD>$ca_name</TD>
<TD>$idate</TD>
</TR>
__TEXT__;
  }

  if($title == $OASISmsg[Unsent_Invoices])
    $button = "<INPUT TYPE=submit NAME=mark_as_sent VALUE=\"$OASISmsg[Mark_as_Sent]\">";
  else
    $button = "<INPUT TYPE=submit NAME=mark_as_paid VALUE=\"$OASISmsg[Mark_as_Paid]\">";

  print <<<__TEXT__
</TABLE>
<TABLE WIDTH=615>
<TR>
<TD ALIGN=center>
<INPUT TYPE=submit NAME=batch_print VALUE="$OASISmsg[Batch_Print]">
$button
</TD>
</TR>
</TABLE>
</FORM>
__TEXT__;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function generate_invoices($FromDate, $ToDate, $InvoiceDate)
{
  global $OASISmsg, $OASIScurrdp, $OASISdecpt, $OASIStsep;
  global $OASISlcurrsym, $OASIStcurrsym;

  $sql = "select CampaignID, Campaigns.Name, Campaigns.AdvertiserID, Advertisers.Name from Campaigns left join Advertisers on Campaigns.AdvertiserID=Advertisers.AdvertiserID where StartDate <= '$ToDate' and (EndDate = '0000-00-00' or EndDate >= '$FromDate') and (CPC > 0 or CPM > 0 or Fixed > 0 or ForceInvoice='Y') and Status!='Cancelled'";
  if(!($result = mysql_query($sql)))
  {
    print "$OASISmsg[error_pulling_campaign]: " . mysql_error();
    exit;
  }

  print <<<__TEXT__
<TABLE WIDTH=615 CELLPADDING=0 CELLSPACING=0 BORDER=1>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Campaign]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[CPM]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[CPC]</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>$OASISmsg[Fixed]</SPAN></TD>
</TR>
__TEXT__;

  while(list($ca_id, $ca_name, $a_id, $a_name) = mysql_fetch_row($result))
  {
    list ($fixedc, $cpmc, $cpcc, $acc) = generate_invoice($ca_id, $FromDate, $ToDate, $InvoiceDate, 0, 0);

    if((string)$fixedc != '')
    {
      $fixedc = number_format($fixedc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpmc   = number_format($cpmc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $cpcc   = number_format($cpcc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
      $acc    = number_format($acc, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  
      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';
      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR='$bgcolor'>
<TD>$ca_name</TD>
<TD ALIGN=right>$OASISlcurrsym$cpmc$OASIStcurrsym</TD>
<TD ALIGN=right>$OASISlcurrsym$cpcc$OASIStcurrsym</TD>
<TD ALIGN=right>$OASISlcurrsym$fixedc$OASIStcurrsym</TD>
</TR>
__TEXT__;
     }
  }

  print <<<__TEXT__
</TABLE>
<P>
$OASISmsg[Invoices_generated]
<A HREF="invoice.php">$OASISmsg[back_to_invoicing]</A>.
__TEXT__;

}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_form_elements()
{
  global $startdate_widget, $enddate_widget, $invoicedate_widget;

  $now = time();
  if(date('d', $now) < 7)
  {
    $lm = $now - 14 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $lm), 1, date('Y', $lm)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $now), 0, date('Y', $now)));
    $id = date('Y-m-d',
                mktime(0, 0, 0, date('m', $now), 0, date('Y', $now)) + 86400);
  }
  else
  {
    $nm = $now + 28 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $now), 1, date('Y', $now)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $nm), 0, date('Y', $nm)));
    $id = date('Y-m-d', 
                mktime(0, 0, 0, date('m', $nm), 0, date('Y', $nm)) + 86400);
  }

  $startdate_widget   = build_date_widget('FromDate', $sd, 1);
  $enddate_widget     = build_date_widget('ToDate', $ed, 1);
  $invoicedate_widget = build_date_widget('InvoiceDate', $id, 1);
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mark_as_sent()
{
  global $invoices, $OASISmsg;

  $invoice_list = implode(",", $invoices);

  if(!mysql_query("update Invoices set Sent='Y' where InvoiceID in ($invoice_list)"))
  {
    print "$OASISmsg[error_marking_sent]: " . mysql_error();
    exit;
  }

  print "<EM>$OASISmsg[marked_sent]</EM><BR>\n";
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function mark_as_paid()
{
  global $invoices, $OASISmsg;

  $invoice_list = implode(",", $invoices);

  if(!mysql_query("update Invoices set Paid='Y' where InvoiceID in ($invoice_list)"))
  {
    print "$OASISmsg[error_marking_paid]: " . mysql_error();
    exit;
  }

  print "<EM>$OASISmsg[marked_paid]</EM><BR>\n";
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function batch_print()
{
  global $invoices, $OASISmsg;

  $filelist = array();

  $ihg = get_prefs("InvoiceHeaderGraphic");
  copy($ihg, "/tmp/$ihg");

  foreach($invoices as $i)
  {
    $html = html_invoice($i);

    $filename = tempnam("/tmp", "OASISi-") . ".html";
    if(!@$fp = fopen($filename, "w"))
    {
      print "$OASISmsg[Could_not_open] $filename: $php_errormsg<BR>\n";
      exit;
    }
    fputs($fp, $html);
    fclose($fp);
     
    array_push($filelist, $filename);
  }

  #### convert the HTML pages into PDF files
  $filename = tempnam("/tmp", "OASISi-") . ".pdf";

  $htmldoc = get_prefs("HtmldocPath");
  $command = "$htmldoc --left 0.5in --right 0.5in --top 0.5in --bottom 0.5in --header . --footer . --no-toc --bodyfont helvetica --browserwidth 620 --webpage -f $filename " . implode(" ", $filelist);
  #print "$command\n";
  `$command`;

  if(!@$fp = fopen($filename, "r"))
  {
    print "$OASISmsg[Could_not_open] $filename: $php_errormsg<BR>\n";
    exit;
  }

  #### print out the PDF file
  header("Content-Type: application/pdf");
  while($buf = fread($fp, 8192)) print $buf;
  fclose($fp);

  #### clean up the files
  #array_push($filelist, $filename);
  foreach($filelist as $f) unlink($f);
}


?>
