<?php

require("lib-mgmt.inc");
require("lib-maint.inc");
require("lib-dengine.inc");

print_html_header($OASISmsg[Campaign_Insertion]);
print_header('CampaignInsertion', '', '');

if(get_magic_quotes_gpc())
{
  $AdvertiserName = stripslashes($AdvertiserName);
  $StreetAddress  = stripslashes($StreetAddress);
  $CampaignName   = stripslashes($CampaignName);
  $PurchaseOrder  = stripslashes($PurchaseOrder);
  $cr_names       = stripslashes($cr_names);
  $cr_alttexts    = stripslashes($cr_alttexts);
  $CreativeName   = stripslashes($CreativeName);
  $AltText        = stripslashes($AltText);
}

$ImpressionsGuaranteed = preg_replace("#[$OASIStsep]#", '', $ImpressionsGuaranteed);
$CPM = preg_replace("#[$OASIStsep]#", '', $CPM);
$CPC = preg_replace("#[$OASIStsep]#", '', $CPC);
$Fixed = preg_replace("#[$OASIStsep]#", '', $Fixed);

if($save)
{
  $message = save_campaign();
  build_form_elements();
  preview_campaign(0, $message);
  print_footer();

  #### we can't really unlink here; if we do, the preview will fail!
  #$cr_files =      explode("\t", $cr_files);
  #foreach($cr_files as $f)
    #if($f) unlink($f);

  exit;
}

if($step1) $step = 1;
elseif($step2) $step = 2;
elseif($step3) $step = 3;
elseif($step4) $step = 4;
elseif($step5) $step = 5;
elseif($step6) $step = 6;
elseif(!$step) $step = 0;

if($imagefile_name || $ThirdParty)
{
  if(!$CreativeName)
  {
    print "$OASISmsg[error_specify_creative]\n";
    print_footer();
    exit;
  }
  if(!$ClickthroughURL)
  {
    print "$OASISmsg[error_specify_click]\n";
    print_footer();
    exit;
  }
  else
  {
    if(get_prefs("ValidateClickthrough") == 'Y')
    {
      if(!($content = fetch_url($ClickthroughURL)))
      {
        print "$OASISmsg[Error]: $OASISmsg[Could_not_open] $ClickthroughURL";
        print_footer();
	exit;
      }
    }
  }
  if($imagefile_name)
    $filename = check_image($imagefile, 1, 1);
  else
  {
    check_image($ThirdParty, 0, 0);
    $filename = '';
  }

  if($cr_clickurls)
  {
    $cr_names      = explode("\t", $cr_names);
    $cr_files      = explode("\t", $cr_files);
    $cr_3rdparties = explode("\t", $cr_3rdparties);
    $cr_clickurls  = explode("\t", $cr_clickurls);
    $cr_alttexts   = explode("\t", $cr_alttexts);
  }
  else
  {
    $cr_names = array();
    $cr_files = array();
    $cr_3rdparties = array();
    $cr_clickurls = array();
    $cr_alttexts = array();
  }
  array_push($cr_names, $CreativeName);
  array_push($cr_files, $filename);
  array_push($cr_3rdparties, $ThirdParty);
  array_push($cr_clickurls, $ClickthroughURL);
  array_push($cr_alttexts, $AltText);

  $cr_names      = implode("\t", $cr_names);
  $cr_files      = implode("\t", $cr_files);
  $cr_3rdparties = implode("\t", $cr_3rdparties);
  $cr_clickurls  = implode("\t", $cr_clickurls);
  $cr_alttexts   = implode("\t", $cr_alttexts);
}

validate_input($step);

build_form_elements();

if($step == 4 || $step == 5)
{
  print <<<__TEXT__
<FORM ENCTYPE="multipart/form-data" METHOD=POST ACTION="campaigninsertion.php">
__TEXT__;
}
else
{
  print <<<__TEXT__
<FORM METHOD=POST ACTION="campaigninsertion.php" NAME=form1>
__TEXT__;
}

?>

<TABLE WIDTH=615><TR><TD>
<FONT SIZE="+1"><STRONG><?php echo $OASISmsg[New_Campaign]; ?></STRONG></FONT>

<?php if($step == 0): ?>

<P>
<TABLE>
<TR>
<TD><STRONG><?php echo $OASISmsg[Choose_an_advertiser]; ?>:</STRONG></TD>
<TD>
<?php echo $advertiser_dropdown; ?>
</TD>
</TR>

<TR><TD COLSPAN=2><STRONG>
-- <?php echo $OASISmsg['OR']; ?> --
<P><?php echo $OASISmsg[Enter_info_for_a_new_advertiser]; ?>:</STRONG></TD></TR>

<TR>
<TD><?php echo $OASISmsg[Name]; ?>&nbsp;*</TD>
<TD><INPUT SIZE=32 MAXLENGTH=128 NAME="AdvertiserName"></TD>
</TR>
<TR>
<TD VALIGN=top><?php echo $OASISmsg[Street_Address]; ?>&nbsp;*</TD>
<TD><TEXTAREA NAME="StreetAddress" WRAP=virtual ROWS=2 COLS=30></TEXTAREA></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[City]; ?>&nbsp;*</TD>
<TD><INPUT SIZE=32 MAXLENGTH=64 NAME="City"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[State]; ?>&nbsp;*</TD>
<TD><INPUT SIZE=16 MAXLENGTH=64 NAME="State"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Postal_Code]; ?>&nbsp;*</TD>
<TD><INPUT SIZE=16 MAXLENGTH=64 NAME="PostalCode"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Country]; ?></TD>
<TD><INPUT SIZE=16 MAXLENGTH=64 NAME="Country"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Phone]; ?></TD>
<TD><INPUT SIZE=14 MAXLENGTH=64 NAME="Phone"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Fax]; ?></TD>
<TD><INPUT SIZE=14 MAXLENGTH=64 NAME="Fax"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Contact_Email]; ?></TD>
<TD><INPUT SIZE=32 MAXLENGTH=255 NAME="ContactEmail"></TD>
</TR>
<TR>
<TD COLSPAN=2>
<FONT SIZE="-1">* <?php echo $OASISmsg[Required_msg] ?></FONT>
</TD>
</TR>
<TR>
<TD COLSPAN=2 ALIGN=right>
<INPUT TYPE=submit NAME=step1 VALUE="<?php echo $OASISmsg[Next]; ?> -&gt;">
</TD>
</TR>

</TABLE>

<?php endif ?>

<?php if($step >= 1): ?>
<INPUT TYPE=hidden NAME=AdvertiserID VALUE="<?php echo $AdvertiserID; ?>">
<INPUT TYPE=hidden NAME=AdvertiserName VALUE="<?php echo $AdvertiserName; ?>">
<INPUT TYPE=hidden NAME=StreetAddress VALUE="<?php echo $StreetAddress; ?>">
<INPUT TYPE=hidden NAME=City VALUE="<?php echo $City; ?>">
<INPUT TYPE=hidden NAME=State VALUE="<?php echo $State; ?>">
<INPUT TYPE=hidden NAME=PostalCode VALUE="<?php echo $PostalCode; ?>">
<INPUT TYPE=hidden NAME=Country VALUE="<?php echo $Country; ?>">
<INPUT TYPE=hidden NAME=Phone VALUE="<?php echo $Phone; ?>">
<INPUT TYPE=hidden NAME=Fax VALUE="<?php echo $Fax; ?>">
<INPUT TYPE=hidden NAME=ContactEmail VALUE="<?php echo $ContactEmail; ?>">
<?php endif ?>


<?php if($step == 1): ?>
<TABLE>

<TR>
<TD><?php echo $OASISmsg[Campaign_Name]; ?></TD>
<TD><INPUT SIZE=32 MAXLENGTH=128 NAME="CampaignName"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Num_Impressions]; ?></TD>
<TD><INPUT SIZE=10 MAXLENGTH=10 NAME="ImpressionsGuaranteed">
</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Fixed]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?> <INPUT SIZE=10 MAXLENGTH=10 NAME="Fixed"><?php echo "$OASIStcurrsym $pay_dropdown"; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPM]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?> <INPUT SIZE=10 MAXLENGTH=10 NAME="CPM"><?php echo $OASIStcurrsym; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[CPC]; ?></TD>
<TD><?php echo $OASISlcurrsym; ?> <INPUT SIZE=10 MAXLENGTH=10 NAME="CPC"><?php echo $OASIStcurrsym; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Agency_Commission]; ?></TD>
<TD><INPUT SIZE=10 MAXLENGTH=10 NAME="AgencyCommission"> %</TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Purchase_Order]; ?></TD>
<TD><INPUT SIZE=16 MAXLENGTH=64 NAME="PurchaseOrder"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Force_Invoice]; ?></TD>
<TD><INPUT TYPE=checkbox NAME="ForceInvoice"></TD>
</TR>
<TR>
<TD VALIGN=top><?php echo $OASISmsg[Email_Reports]; ?></TD>
<TD>
<TEXTAREA NAME="Notify" ROWS=2 COLS=30 WRAP=virtual><?php echo $Notify; ?></TEXTAREA>
</TD>
</TR>
<TR>
<TD COLSPAN=2 ALIGN=right>
<INPUT TYPE=submit NAME=step2 VALUE="<?php echo $OASISmsg[Next]; ?> -&gt;">
</TD>
</TR>

</TABLE>

<?php endif ?>


<?php if($step >= 2): ?>
<INPUT TYPE=hidden NAME=CampaignName VALUE="<?php echo $CampaignName; ?>">
<INPUT TYPE=hidden NAME=ImpressionsGuaranteed VALUE="<?php echo $ImpressionsGuaranteed; ?>">
<INPUT TYPE=hidden NAME=Fixed VALUE="<?php echo $Fixed; ?>">
<INPUT TYPE=hidden NAME=CPM VALUE="<?php echo $CPM; ?>">
<INPUT TYPE=hidden NAME=CPC VALUE="<?php echo $CPC; ?>">
<INPUT TYPE=hidden NAME=AgencyCommission VALUE="<?php echo $AgencyCommission; ?>">
<INPUT TYPE=hidden NAME=Notify VALUE="<?php echo $Notify; ?>">
<INPUT TYPE=hidden NAME=PurchaseOrder VALUE="<?php echo $PurchaseOrder; ?>">
<INPUT TYPE=hidden NAME=ForceInvoice VALUE="<?php echo $ForceInvoice; ?>">
<INPUT TYPE=hidden NAME=PayFixed VALUE="<?php echo $PayFixed; ?>">
<?php endif ?>


<?php if($step == 2): ?>

<?php echo $date_mgmt_script; ?>

<P>
<TABLE>
<TR>
<TD COLSPAN=2><STRONG><?php echo $OASISmsg[Set_start_and_end_dates]; ?>:</STRONG></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Start_Date]; ?></TD>
<TD><?php echo $startdate_widget; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[End_Date]; ?></TD>
<TD><?php echo $enddate_widget; ?></TD>
</TR>
<TR>
<TD></TD>
<TD><?php echo $date_mgmt_buttons; ?></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Deliver]; ?></TD>
<TD><?php echo $deliver_dropdown; ?></TD>
</TR>
<TD COLSPAN=2>
<P>
<FONT SIZE="-1">
<?php echo $OASISmsg[clear_out_end_date]; ?></FONT>
</TD>
</TR>
<TR>
<TD COLSPAN=2 ALIGN=right>
<INPUT TYPE=submit NAME=step3 VALUE="<?php echo $OASISmsg[Next]; ?> -&gt;">
</TD>
</TR>

</TABLE>
<?php endif ?>

<?php if($step >= 3): ?>
<INPUT TYPE=hidden NAME=StartDate VALUE="<?php echo $StartDate; ?>">
<INPUT TYPE=hidden NAME=EndDate VALUE="<?php echo $EndDate; ?>">
<INPUT TYPE=hidden NAME=EvenDelivery VALUE="<?php echo $EvenDelivery; ?>">
<?php endif ?>

<?php if($step == 3): ?>
<P>
<STRONG><?php echo $OASISmsg[Assign_Sections]; ?></STRONG>

<TABLE CELLPADDING=0 CELLSPACING=0>
<TR>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Section</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Include</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Exclude</SPAN></TD>
<TD CLASS=tablehead><SPAN CLASS=tablehead>Exclusive</SPAN></TD>
</TR>
</TR>
<?php build_section_tree(0, 0) ?>
<TR>
<TD COLSPAN=4 ALIGN=right>
<INPUT TYPE=submit NAME=step4 VALUE="<?php echo $OASISmsg[Next]; ?> -&gt;">
</TD>

</TABLE>
<?php endif ?>

<?php if($step >= 4): ?>
<INPUT TYPE=hidden NAME="includes" VALUE="<?php echo $includes; ?>">
<INPUT TYPE=hidden NAME="excludes" VALUE="<?php echo $excludes; ?>">
<INPUT TYPE=hidden NAME="exclusives" VALUE="<?php echo $exclusives; ?>">
<INPUT TYPE=hidden NAME="cr_names" VALUE="<?php echo $cr_names; ?>">
<INPUT TYPE=hidden NAME="cr_files" VALUE="<?php echo $cr_files; ?>">
<INPUT TYPE=hidden NAME="cr_3rdparties" VALUE="<?php echo $cr_3rdparties; ?>">
<INPUT TYPE=hidden NAME="cr_clickurls" VALUE="<?php echo $cr_clickurls; ?>">
<INPUT TYPE=hidden NAME="cr_alttexts" VALUE="<?php echo $cr_alttexts; ?>">
<?php endif ?>


<?php if($step == 4 || $step == 5): ?>
<P>
<STRONG><?php echo $OASISmsg[Add_Creative]; ?></STRONG>

<TABLE CELLPADDING=0 CELLSPACING=0>
<TR>
<TD><?php echo $OASISmsg[Creative_Name]; ?></TD>
<TD><INPUT NAME="CreativeName" SIZE=32 MAXLENGTH=64></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[File]; ?></TD>
<TD><INPUT NAME="imagefile" TYPE="file"></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Alt_Text]; ?></TD>
<TD><INPUT NAME="AltText" SIZE=32 MAXLENGTH=255></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Third_Party]; ?></TD>
<TD><INPUT NAME="ThirdParty" SIZE=32 MAXLENGTH=255></TD>
</TR>
<TR>
<TD><?php echo $OASISmsg[Clickthrough_URL]; ?></TD>
<TD><INPUT NAME="ClickthroughURL" SIZE=32 MAXLENGTH=255 VALUE="http://"></TD>
</TR>
</TR>
<TR>
<TD COLSPAN=4 ALIGN=right>
<INPUT TYPE=submit NAME=step5 VALUE="<?php echo $OASISmsg[More]; ?> -&gt;">
<INPUT TYPE=submit NAME=step6 VALUE="<?php echo $OASISmsg[Finish]; ?> -&gt;">
</TD>

</TABLE>
<?php endif ?>

<?php if($step == 6) preview_campaign(1, ''); ?>

</TD></TR></TABLE>
</FORM>

<?php

print_footer();

####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function count_months($sd, $ed)
{
  preg_match('#(\d+)-?(\d{2})-?(\d{2})#', $sd, $matches);
  list($junk, $year, $month, $day) = $matches;
  $st = mktime(0,0,0, $month, $day, $year);

  preg_match('#(\d+)-?(\d{2})-?(\d{2})#', $ed, $matches);
  list($junk, $year, $month, $day) = $matches;
  $et = mktime(0,0,0, $month, $day, $year);

  return num_months($st, $et); 
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function count_weeks($sd, $ed)
{
  preg_match('#(\d+)-?(\d{2})-?(\d{2})#', $sd, $matches);
  list($junk, $year, $month, $day) = $matches;
  $st = mktime(0,0,0, $month, $day, $year);

  preg_match('#(\d+)-?(\d{2})-?(\d{2})#', $ed, $matches);
  list($junk, $year, $month, $day) = $matches;
  $et = mktime(0,0,0, $month, $day, $year);

  return num_weeks($st, $et); 
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function save_campaign()
{
  global $StartDate, $EndDate, $ImpressionsGuaranteed;
  global $AdvertiserID, $AdvertiserName, $StreetAddress, $City, $State,
         $PostalCode, $Country, $Phone, $Fax, $ContactName, $ContactEmail,
	 $EvenDelivery;
  global $CampaignName, $Fixed, $PayFixed, $CPM, $CPC,
         $AgencyCommission, $PurchaseOrder, $ForceInvoice, $PayFixed, $Notify;
  global $includes, $excludes, $exclusives;
  global $cr_names, $cr_files, $cr_3rdparties, $cr_clickurls, $cr_alttexts;
  global $OASISmsg;

  #### save advertiser if necessary
  if(!$AdvertiserID)
  {
    $AdvertiserName = addslashes($AdvertiserName);
    $StreetAddress  = addslashes($StreetAddress);

    if(!mysql_query("insert into Advertisers (Name, StreetAddress, City, State, PostalCode, Country, Phone, Fax, ContactName, ContactEmail) values ('$AdvertiserName', '$StreetAddress', '$City', '$State', '$PostalCode', '$Country', '$Phone', '$Fax', '$ContactName', '$ContactEmail')"))
    {
      print "$OASISmsg[error_save_advertiser]: " . mysql_error();
      print_footer();
      exit;
    }
    if(!($result = mysql_query("select LAST_INSERT_ID()")))
    {
      print "$OASISmsg[error_save_advertiser]: " . mysql_error();
      print_footer();
      exit;
    }
    list($AdvertiserID) = mysql_fetch_row($result);
    $message .= "$OASISmsg[Advertiser_info_saved].<BR>\n";
  }

  #### save campaign
  if(!$ImpressionsGuaranteed) $ImpressionsGuaranteed = 0;
  if(!$AgencyCommission) $AgencyCommission = 0;

  $CampaignName  = addslashes($CampaignName);
  $PurchaseOrder = addslashes($PurchaseOrder);
  $ForceInvoice = ($ForceInvoice) ? 'Y' : 'N';

  if(!mysql_query("insert into Campaigns (Name, AdvertiserID, ImpressionsGuaranteed, Fixed, PayFixed, CPM, CPC, AgencyCommission, PurchaseOrder, ForceInvoice, Notify, StartDate, EndDate, EvenDelivery) values ('$CampaignName', $AdvertiserID, $ImpressionsGuaranteed, '$Fixed', '$PayFixed', '$CPM', '$CPC', '$AgencyCommission', '$PurchaseOrder', '$ForceInvoice', '$Notify', '$StartDate', '$EndDate', '$EvenDelivery')"))
  {
    print "$OASISmsg[error_save_campaign]: " . mysql_error();
    print_footer();
    exit;
  }
  if(!($result = mysql_query("select LAST_INSERT_ID()")))
  {
    print "$OASISmsg[error_save_campaign]: " . mysql_error();
    print_footer();
    exit;
  }
  list($CampaignID) = mysql_fetch_row($result);

  #### save campaign assignments
  if($includes)
  {
    foreach(explode(' ', $includes) as $a)
    {
      if(!mysql_query("insert into CampaignAssignments (SectionID, CampaignID, Type) values ($a, $CampaignID, 'Include')"))
      {
        print "$OASISmsg[error_save_assignment]: " . mysql_error();
        print_footer();
        exit;
      }
    }
  }

  if($excludes)
  {
    foreach(explode(' ', $excludes) as $a)
    {
      if(!mysql_query("insert into CampaignAssignments (SectionID, CampaignID, Type) values ($a, $CampaignID, 'Exclude')"))
      {
        print "$OASISmsg[error_save_assignment]: " . mysql_error();
        print_footer();
        exit;
      }
    }
  }

  if($exclusives)
  {
    foreach(explode(' ', $exclusives) as $a)
    {
      if(!mysql_query("insert into CampaignAssignments (SectionID, CampaignID, Type) values ($a, $CampaignID, 'Exclusive')"))
      {
        print "$OASISmsg[error_save_assignment]: " . mysql_error();
        print_footer();
        exit;
      }
    }
  }

  #### save creatives
  $cr_names = addslashes($cr_names);
  $cr_alttexts = addslashes($cr_alttexts);

  $cr_names_a =      explode("\t", $cr_names);
  $cr_files_a =      explode("\t", $cr_files);
  $cr_3rdparties_a = explode("\t", $cr_3rdparties);
  $cr_clickurls_a =  explode("\t", $cr_clickurls);
  $cr_alttexts_a =   explode("\t", $cr_alttexts);
  while($Name = array_shift($cr_names_a))
  {
    $file            = array_shift($cr_files_a);
    $thirdparty      = array_shift($cr_3rdparties_a);
    $ClickthroughURL = array_shift($cr_clickurls_a);
    $AltText         = array_shift($cr_alttexts_a);

    if($file)
    {
      $fp = fopen($file, "r");
      while ($buffer = fread ($fp, 8192)) $Content .= $buffer;
      $Content = addslashes ($Content);
      $Redirect = 'N';
      fclose($fp);
    }
    else
    {
      $Content = $thirdparty;
      $Redirect = 'Y';

      #### try to open the URL; read the contents into a file
      if($imagedata = fetch_url($thirdparty))
      {
        $tempfile = tempnam("/tmp", "OASIS");
        if($fp_w = @fopen($tempfile, "w"))
        {
          fwrite($fp_w, $imagedata);
          fclose($fp_w);
          $file = $tempfile;
        }
        else
        {
          print "$OASISmsg[Could_not_open] <A HREF=\"$tempfile\">$tempfile</A>.";
          print_footer();
          exit;
        }
      }
      else
      {
        print "$OASISmsg[Could_not_open] <A HREF=\"$ThirdParty\">$ThirdParty</A>. $OASISmsg[check_URL]";
        print_footer();
        exit;
      }
    }

    list($w, $h, $MIMEType, $Animated) = identify_image($file);
    if($w > 1) $Width = $w;
    if($h > 1) $Height = $h;
    if(!($Width && $Height))
    {
      print $OASISmsg[error_no_auto_dimension];
      print_footer();
      exit;
    }

    if(!mysql_query("insert into Creatives (CampaignID, Name, MediaType, Width, Height, MIMEType, Redirect, Animated, ClickthroughURL, AltText, Content) values ($CampaignID, '$Name', 'Image', $Width, $Height, '$MIMEType', '$Redirect', '$Animated', '$ClickthroughURL', '$AltText', '$Content')"))
    {
      print "$OASISmsg[Error_saving_creative]: " . mysql_error();
      print_footer();
      exit;
    }
  }

  $message .= "$OASISmsg[Campaign_info_saved].<BR>\n";

  #### save an invoice if appropriate
  if($PayFixed == 'CIA')
  {
    if($CPM == 0 && $CPC == 0)
    {
      require("lib-invoice.inc");
      generate_invoice($CampaignID, $StartDate, $EndDate,
                       date('Y-m-d', time()), 0, 1);
      $message .= "<P>$OASISmsg[fixed_cia]<BR>\n";
    }
  }


  if(get_prefs('InsertActive') != 'Y')
  {
    $root    = 'http://' . get_oasis_env('oasis_host') .  get_oasis_env('oasis_url');
    $msg = <<<__TEXT__
$OASISmsg[New_campaign]: $CampaignName

$OASISmsg[verify_campaign]:
{$root}mgmt/campaign.php?CampaignID=$CampaignID
__TEXT__;

    mail(get_prefs('NewCampaignEmail'), "New Campaign", $msg);
  }
  else
  {
    if(mysql_query("update Campaigns set Status='Active' where CampaignID=$CampaignID"))
    {
      compute_daily_targets($CampaignID, '');
    }
    else
    {
      print "$OASISmsg[error_making_campaign_active]: " . mysql_error() . "<BR>\n";
    }
  }

  return $message;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function preview_campaign($show_save_button, $message)
{
  global $AdvertiserName, $CampaignName, $StartDate, $EndDate;
  global $EvenDelivery, $PayFixed, $creative_block;
  global $ImpressionsGuaranteed, $Fixed, $CPM, $CPC;
  global $OASISmsg, $OASIScurrdp, $OASISdecpt, $OASIStsep;
  global $OASISlcurrsym, $OASIStcurrsym;

  $AdvertiserName = stripslashes($AdvertiserName);
  $StreetAddress  = stripslashes($StreetAddress);
  $CampaignName   = stripslashes($CampaignName);
  $PurchaseOrder  = stripslashes($PurchaseOrder);
  $creative_block = stripslashes($creative_block);

  $ImpressionsGuaranteed = number_format($ImpressionsGuaranteed, 0, $OASISdecpt, $OASIStsep);
  $Fixed = number_format($Fixed, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $CPM = number_format($CPM, $OASIScurrdp, $OASISdecpt, $OASIStsep);
  $CPC = number_format($CPC, $OASIScurrdp, $OASISdecpt, $OASIStsep);

  print <<<__TEXT__
<TABLE WIDTH="100%">
<TR><TD>{$OASISmsg['Advertiser']}:</TD><TD>$AdvertiserName</TD></TR>
<TR><TD>{$OASISmsg['Campaign']}:</TD><TD>$CampaignName</TD></TR>
<TR><TD>{$OASISmsg['Start_Date']}:</TD><TD>$StartDate</TD></TR>
<TR><TD>{$OASISmsg['End_Date']}:</TD><TD>$EndDate</TD></TR>
__TEXT__;

  if($ImpressionsGuaranteed > 0)
    print "<TR><TD>$OASISmsg[Impressions]:</TD><TD>$ImpressionsGuaranteed ($OASISmsg[delivered_evenly_by] $EvenDelivery)</TD></TR>\n";

  if($Fixed > 0) print "<TR><TD>$OASISmsg[Fixed]:</TD><TD>$OASISlcurrsym$Fixed$OASIStcurrsym ($PayFixed)</TD></TR>\n";
  if($CPM > 0) print "<TR><TD>$OASISmsg[CPM]:</TD><TD>$OASISlcurrsym$CPM$OASIStcurrsym</TD></TR>\n";
  if($CPC > 0) print "<TR><TD>$OASISmsg[CPC]:</TD><TD>$OASISlcurrsym$CPC$OASIStcurrsym</TD></TR>\n";


  print <<<__TEXT__
<TR><TD COLSPAN=2>
<STRONG>$OASISmsg[Creatives]</STRONG><BR>
$creative_block
__TEXT__;

  if($show_save_button)
  {
    print <<<__TEXT__
<P>
$OASISmsg[review_campaign]
<P>
<INPUT TYPE=submit NAME=save VALUE="$OASISmsg[Save]">
__TEXT__;
  }
  else
  {
    print <<<__TEXT__
<P>
$message
<P>
$OASISmsg[print_message]
__TEXT__;
  }


  print <<<__TEXT__
</TD></TR>
</TABLE>
__TEXT__;
}



####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function check_image($imagefile, $local_flag, $save_image)
{
  global $imagefile_size;
  global $OASISmsg, $OASISdecpt, $OASIStsep;

  $tempfile = tempnam("/tmp", "OASIS");
  if($local_flag)
  {
    $fp_r = @fopen($imagefile, "r");
    $imagedata = fread($fp_r, filesize($imagefile));
    fclose($fp_r);
  }
  else
  {
    $imagefile = preg_replace('#\[CB\]#i', '123', $imagefile);
    $imagedata = fetch_url($imagefile);
  }

  if(!$imagedata)
  {
    print "$OASISmsg[Could_not_open] $imagefile: $php_errormsg\n";
    print_footer();
    exit;
  }

  if($fp_w = @fopen($tempfile, "w"))
  {
    fwrite($fp_w, $imagedata);
    fclose($fp_w);
  }
  else
  {
    print "$OASISmsg[Could_not_open] $tempfile: $php_errormsg\n";
    print_footer();
    exit;
  }

  list($w, $h, $MIMEType, $Animated) = identify_image($tempfile);

  if($w < 2 || $h < 2)
  {
    print $OASISmsg[error_no_auto_dimension];
    print_footer();
    exit;
  }

  if($result = mysql_query("select Size from MaxSizes where Width=$w and Height=$h"))
  {
    if(list($maxsize) = mysql_fetch_row($result))
    {
      if($imagefile_size > $maxsize)
      {
        $imagefile_size = number_format($imagefile_size, 0, $OASISdecpt, $OASIStsep);
        $maxsize = number_format($maxsize, 0, $OASISdecpt, $OASIStsep);
        print "$OASISmsg[error_size_exceeded] $w x $h ($imagefile_size &gt; $maxsize).<BR>";
        print_footer();
        exit;
      }
    }
    else
    {
      print "$OASISmsg[no_max_size_defined1] $w x $h. $OASISmsg[no_max_size_defined2]";
      print_footer();
      exit;
    }
  }
  else
  {
    print "$OASISmsg[error_looking_for_maxsize] $w x $h: " . mysql_error();
    print_footer();
    exit;
  }

  if(!$save_image) unlink($tempfile);

  return $tempfile;
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_section_tree($root, $depth)
{
  global $CampaignID, $bgcolor;

  if(!$root) $root = 0;

  #### create a spacer
  for($i = 0; $i < $depth * 5; $i++) { $spacer .= "&nbsp;"; }

  if($result = mysql_query("select SectionID, Name from Sections where PSectionID = $root and Active='Y' order by Name"))
  {
    while(list($s_id, $s_name) = mysql_fetch_row($result))
    {
      $bgcolor = ($bgcolor == '#ffffff') ? '#cccccc' : '#ffffff';

      print <<<__TEXT__
<TR BACKGROUND='' BGCOLOR="$bgcolor">
<TD>$spacer$s_name</TD>
<TD><INPUT TYPE=checkbox NAME="Includes[]" VALUE="$s_id"></TD>
<TD><INPUT TYPE=checkbox NAME="Excludes[]" VALUE="$s_id"></TD>
<TD><INPUT TYPE=checkbox NAME="Exclusives[]" VALUE="$s_id"></TD>
</TR>
__TEXT__;

      build_section_tree($s_id, $depth + 1);
    }
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function build_form_elements()
{
  global $advertiser_dropdown, $pay_dropdown, $deliver_dropdown;
  global $startdate_widget, $enddate_widget;
  global $cr_clickurls, $cr_files, $cr_3rdparties, $cr_alttexts, $cr_names;
  global $creative_block;
  global $OASISmsg;

  $pay_array = array('By Period'   => $OASISmsg[By_Period],
                        'CIA'     => $OASISmsg[CIA],
                        'End of Campaign'  => $OASISmsg[End_of_Campaign]);
  $pay_dropdown = build_select($pay_array, 'PayFixed', 'End of Campaign', '', '');

  $deliver_array = array('Day' => $OASISmsg[Evenly_by_Day],
                        'Week'     => $OASISmsg[Evenly_by_Week],
                        'Month'  => $OASISmsg[Evenly_by_Month]);
  $deliver_dropdown = build_select($deliver_array, 'EvenDelivery', 'Day', '', '');

  if($result = mysql_query("select AdvertiserID, Name from Advertisers order by Name"))
  {
    $advertisers = array();
    while(list($id, $name) = mysql_fetch_row($result))
      $advertisers[$id] = $name;
    $advertiser_dropdown
       = build_select($advertisers, 'AdvertiserID', '', '', '');
  }
  else print "error: " . mysql_error() . "<BR>\n";

  $now = time();
  if(date('d', $now) < 7)
  {
    $nm = $now + 31 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $now), 1, date('Y', $now)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $nm), 0, date('Y', $nm)));
  }
  else
  {
    $nm  = $now + 28 * 86400;
    $nnm = $now + 56 * 86400;
    $sd = date('Y-m-d', mktime(0, 0, 0, date('m', $nm), 1, date('Y', $nm)));
    $ed = date('Y-m-d', mktime(0, 0, 0, date('m', $nnm), 0, date('Y', $nnm)));
  }

  $startdate_widget = build_date_widget('StartDate', $sd, 1);
  $enddate_widget   = build_date_widget('EndDate', $ed, 0);

  if($cr_clickurls)
  {
    $ua = split("\t", $cr_clickurls);
    $fa = split("\t", $cr_files);
    $ta = split("\t", $cr_3rdparties);
    $aa = split("\t", $cr_alttexts);
    $na = split("\t", $cr_names);

    $creative_block = '';
    while($u = array_shift($ua))
    {
      $f = array_shift($fa);
      $t = array_shift($ta);
      $a = array_shift($aa);
      $n = array_shift($na);

      if($f)
      {
	$f = preg_replace ('#.*/#', '', $f);
        $creative_block .=<<< __TEXT__
$n<BR>
<A HREF="$u"><IMG SRC="image_preview.php?file=$f" ALT="$a"></A><BR>
__TEXT__;
      }
      else
      {
        $creative_block .=<<< __TEXT__
$n<BR>
<A HREF="$u"><IMG SRC="$t" ALT=$a></A><BR>
__TEXT__;
      }
    }
  }
}


####---------------------------------------------------------------------------
####---------------------------------------------------------------------------
function validate_input($step)
{
  global $AdvertiserID, $AdvertiserName, $StreetAddress, $City, $State,
	 $PostalCode, $ContactEmail,
	 $CampaignName, $Fixed, $CPM, $CPC, 
         $StartDate_Year, $StartDate_Month, $StartDate_Day,
         $EndDate_Year, $EndDate_Month, $EndDate_Day,
         $StartDate, $EndDate, $ImpressionsGuaranteed, $EvenDelivery,
         $Notify,
	 $Includes, $Excludes, $Exclusives,
	 $includes, $excludes, $exclusives,
	 $cr_clickurls, $cr_alttexts;
  global $OASISmsg;

  $error = '';
  if($step == 1)
  {
    if($AdvertiserID == ''
     && !($AdvertiserName && $StreetAddress && $City && $State && $PostalCode))
      $error .= "<LI>$OASISmsg[error_advertiser_info].";

    if($AdvertiserID)
    {
      if($result = mysql_query("select Name, ContactEmail from Advertisers where AdvertiserID=$AdvertiserID"))
        list($AdvertiserName, $Notify) = mysql_fetch_row($result);
    }
    else
    {
      $Notify = $ContactEmail;
    }
  }

  if($step == 2)
  {
    if(!$CampaignName)
      $error .= "<LI>$OASISmsg[error_enter_campaign_name]";

    if($Fixed == '' && $CPM == '' && $CPC == '')
      $error .= "<LI>$OASISmsg[error_enter_cost]";

    if(!$Fixed) $Fixed = 0;
    if(!$CPM) $CPM = 0;
    if(!$CPC) $CPC = 0;
  }

  if($step == 3)
  {
    if(!$StartDate) $StartDate = ("$StartDate_Year$StartDate_Month$StartDate_Day");
    if(!$EndDate) $EndDate = ("$EndDate_Year$EndDate_Month$EndDate_Day");

    if(!$StartDate)
      $error .= "<LI>$OASISmsg[error_enter_start]";

    if(!$EndDate && $ImpressionsGuaranteed)
      $error .= "<LI>$OASISmsg[error_enter_end_imp]";

    if(!$EndDate && $Fixed > 0)
      $error .= "<LI>$OASISmsg[error_enter_end_fixed]";

    if($EndDate && $EndDate < $StartDate)
      $error .= "<LI>$OASISmsg[error_end_before_start]";

    if($EvenDelivery == 'Month')
    {
      $month_count = count_months($StartDate, $EndDate);
      $mimpg = $ImpressionsGuaranteed / $month_count;
      if($mimpg != floor($mimpg))
        $error .= "<LI>$OASISmsg[target_divisible] $month_count $OASISmsg[months]";
    }
    elseif($EvenDelivery == 'Week')
    {
      $week_count = count_weeks($StartDate, $EndDate);
      $wimpg = $ImpressionsGuaranteed / $week_count;
      if($wimpg != floor($wimpg))
        $error .= "<LI>$OASISmsg[target_divisible] $week_count $OASISmsg[weeks]";
    }

    $StartDate = "$StartDate_Year-$StartDate_Month-$StartDate_Day";
    if($EndDate_Year && $EndDate_Month && $EndDate_Day)
      $EndDate = "$EndDate_Year-$EndDate_Month-$EndDate_Day";
  }

  if($step == 4)
  {
    if(!($Includes || $Excludes || $Exclusives)
       && !($includes || $excludes || $exclusives))
      $error .= "<LI>$OASISmsg[error_assign_campaign]";

    if($Includes) $includes = implode(' ', $Includes);
    if($Excludes) $excludes = implode(' ', $Excludes);
    if($Exclusives) $exclusives = implode(' ', $Exclusives);
  }

  if($step == 5)
  {
    if(!$cr_clickurls)
      $error .= "<LI>$OASISmsg[error_specify_creatives]";
  }

  if(!$error) return;

  print <<<__TEXT__
<TABLE WIDTH=615><TR><TD>
<H1>$OASISmsg[Error]</H1>
$OASISmsg[error_list]:
<UL>
$error
</UL>
$OASISmsg[error_list_fix]
</TD></TR></TABLE>
__TEXT__;

  print_footer();
  exit;
}


?>
