<?
/*
nikkipost.php - Control panel for O-Kiraku Nikki
Copyright (C) 2003 Javi Lavandeira (http://www.ag0ny.com)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

session_start();
require 'nikki.inc.php';

header('Content-Type: text/html; charset=UTF-8');

if (!connect_to_database())
{
	echo mb_convert_encoding(gettext("Cannot connect to the database server: "), 'UTF-8', 'auto');
	echo mysql_error();
	exit;
}

function check_auth()
{
	if (isset($_SESSION['nikki_authenticated']))
	{
		if (!$_SESSION['nikki_authenticated'])
		{
			header('Location: '.$GLOBALS['PHP_SELF'].'?action=login');
		}
	} else {
		$_SESSION['nikki_authenticated'] = 0;
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=login');
	}
}

function html_header($title)
{
	echo '<html>';
	echo '<head>';
	echo '<title>'.mb_convert_encoding(gettext("Add entry to the calendar"), 'UTF-8', 'auto').'</title>';
	echo '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
	echo '<style type="text/css">';
	echo '<!--';
	echo '.body		{ font-family: helvetica,sans-serif; font-size: 9pt; color: #000000; background-color: #d0d0d0 }';
	echo '.body A		{ color: #2020ff; text-decoration: none }';
	echo '.body A:visited	{ color: #2020ff }';
	echo '.login		{ font-family: helvetica,sans-serif; font-size: 9pt; color: #000080; background-color: #c0c0ff }';
	echo '.list		{ font-family: helvetica,sans-serif; font-size: 9pt; color: #000000; background-color: #000000 }';
	echo '.list A		{ text-decoration: none; font-weight: normal; color: #4040ff }';
	echo '.list A:visited	{ color: #4040ff }';
	echo '.list A:hover	{ color: #ff0000; background-color: #ffff00 }';
	echo '-->';
	echo '</style>';
	echo '</head>';
	echo '<body class="body">';
	echo '<center>';

}

function html_footer()
{
	if ($_SESSION['nikki_authenticated'])
	{
		echo '<br>';
		echo '<form method="POST" action="'.$GLOBALS['PHP_SELF'].'?action=logout">';
		echo '<input type="submit" value="'.mb_convert_encoding(gettext("Logout"), 'UTF-8', 'auto').'">';
		echo '</form>';
	}
	echo '<br>';
	copyright();
	echo '</center>';
	echo '</body>';
	echo '</html>';
}

function copyright()
{
	echo mb_convert_encoding(gettext("Copyright (C) 2003 Javi Lavandeira (<a href=\"http://www.ag0ny.com\">http://www.ag0ny.com</a>)."), 'UTF-8', 'auto');
}

function action_display_login_dialog()
{
	if (isset($_SESSION['nikki_authenticated']))
	{
		if ($_SESSION['nikki_authenticated'])
		{
			header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		}
	} else {
		$_SESSION['nikki_authenticated'] = 0;
	}
	html_header(mb_convert_encoding(gettext("Login screen"), 'UTF-8', 'auto'));

	echo '<h1>'.mb_convert_encoding(gettext("program_name"), 'UTF-8', 'auto').'</h1>';

	echo '<form method="post" action="'.$GLOBALS['PHP_SELF'].'?action=setlang">';
	echo '<select name="lang">';
	echo '<option value="en">English</option>';
	echo '<option value="de">German</option>';
	echo '<option value="es">Spanish</option>';
	echo '<option value="it">Italian</option>';
	echo '<option value="ja">Japanese</option>';
	echo '<option value="nl">Dutch</option>';
	echo '<option value="sv">Swedish</option>';
	echo '</select>';
	echo '<input type="submit" value="Ok">';
	echo '</form>';

	echo '<table border="0" cellpadding="5" cellspacing="1" bgcolor="#000000">';
	echo '<tr>';
	echo '<td class="login">';

	echo '<form method="post" action="'.$GLOBALS['PHP_SELF'].'?action=authenticate">';
	echo mb_convert_encoding(gettext("Login"), 'UTF-8', 'auto');
	echo '<br><input type="text" name="login"><br>';
	echo mb_convert_encoding(gettext("Password"), 'UTF-8', 'auto');
	echo '<br><input type="password" name="password"><br>';
	echo '<br>';
	echo '<center><input type="submit" value="'.mb_convert_encoding(gettext("Ok"), 'UTF-8', 'auto').'"></center>';
	echo '</form>';

	echo '</td>';
	echo '</tr>';
	echo '</table>';

	html_footer();
}

function action_logout()
{
	$_SESSION['nikki_authenticated'] = 0;
	header('Location: '.$GLOBALS['PHP_SELF']);
}

function action_authenticate()
{
	$login = trim($_POST['login']);
	$password = trim($_POST['password']);

	if ($login == $GLOBALS['post_login'] && $password == $GLOBALS['post_password'])
	{
		$_SESSION['nikki_authenticated'] = 1;
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
	} else {
		$_SESSION['nikki_authenticated'] = 0;
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=login');
	}
}

function action_check_post()
{
	check_auth();
	$day = isset($_POST['day'])?abs($_POST['day']):date('j');
	$month = isset($_POST['month'])?abs($_POST['month']):date('n');
	$year = isset($_POST['year'])?abs($_POST['year']):date('Y');
	$message = isset($_POST['message'])?addslashes(mb_convert_encoding(trim($_POST['message']), 'UTF-8', 'auto')):'';

	if (!$message)
	{
		html_header(mb_convert_encoding(gettext("Error!"), 'UTF-8', 'auto'));
		echo mb_convert_encoding(gettext("Error: you didn't write anything!"), 'UTF-8', 'auto');
		html_footer();
	} else {
		$timestamp = substr('0000'.$year,-4,4).substr('00'.$month,-2,2).substr('00'.$day,-2,2);
		if ($result = mysql_query('INSERT INTO nikki SET timestamp=\''.$timestamp.'\', text=\''.$message.'\''))
		{
			header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		} else {
			html_header(mb_convert_encoding(gettext("Error!"), 'UTF-8', 'auto'));
			echo mb_convert_encoding(gettext("Error: can't post to the database:"), 'UTF-8', 'auto');
			echo '<br>';
			echo mysql_error();
			html_footer();
		}	
	}
}

function action_check_modify()
{
	check_auth();
	$id = isset($_POST['id'])?abs($_POST['id']):0;
	if (!$id)
	{
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		exit();
	}
	$day = isset($_POST['day'])?abs($_POST['day']):date('j');
	$month = isset($_POST['month'])?abs($_POST['month']):date('n');
	$year = isset($_POST['year'])?abs($_POST['year']):date('Y');
	$message = isset($_POST['message'])?addslashes(mb_convert_encoding(trim($_POST['message']), 'UTF-8', 'auto')):'';

	if (!$message)
	{
		html_header(mb_convert_encoding(gettext("Error!"), 'UTF-8', 'auto'));
		echo mb_convert_encoding(gettext("Error: you didn't write anything!"), 'UTF-8', 'auto');
		html_footer();
	} else {
		$timestamp = substr('0000'.$year,-4,4).substr('00'.$month,-2,2).substr('00'.$day,-2,2);
		if ($result = mysql_query("UPDATE nikki SET timestamp='$timestamp.', text='$message' WHERE id='$id'"))
		{
			header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		} else {
			html_header(mb_convert_encoding(gettext("Error!"), 'UTF-8', 'auto'));
			echo mb_convert_encoding(gettext("Error: can't post to the database:"), 'UTF-8', 'auto');
			echo '<br>';
			echo mysql_error();
			html_footer();
		}	
	}
}

function action_delete()
{
	check_auth();
	$id = isset($_GET['id'])?abs($_GET['id']):0;
	if ($id)
	{
		mysql_query("DELETE FROM nikki WHERE id='$id'");
	}
	header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
}

function action_modify()
{
	check_auth();
	$id = isset($_GET['id'])?abs($_GET['id']):0;
	if (!$id)
	{
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		exit();
	}
	html_header(mb_convert_encoding(gettext("Modify message"), 'UTF-8', 'auto'));
	echo '<h1>'.mb_convert_encoding(gettext("Modify message"), 'UTF-8', 'auto').'</h1>';
	
	$result = mysql_query("SELECT * FROM nikki WHERE id='$id'");
	if (!mysql_num_rows($result))
	{
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=list');
		exit();
	}

	$message = mysql_fetch_object($result);
	echo '<table border="0" cellpadding="2" cellspacing="1" bgcolor="#000000" class="list">';
	echo '<tr>';
	echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Date"), 'UTF-8', 'auto').'</b></td>';
	echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Message"), 'UTF-8', 'auto').'</b></td>';
	echo '</tr>';
	echo '<tr>';
	echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
	echo '<form method="post" action="'.$GLOBALS['PHP_SELF'].'?action=checkmodify">';
	echo '<input type="hidden" name="id" value="'.$message->id.'">';
	echo mb_convert_encoding(gettext("Year"), 'UTF-8', 'auto');
	echo '<br>';
	$cur_year = abs(substr($message->timestamp,0,4));
	echo '<select name="year">';
	for ($i = $cur_year - 5; $i <= $cur_year + 5; $i++)
	{
		echo '<option value="'.$i.'"'.($i == $cur_year?' selected':'').'>'.$i.'</option>';
	}
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo mb_convert_encoding(gettext("Month"), 'UTF-8', 'auto');
	$cur_month = abs(substr($message->timestamp,4,2));
	echo '<br>';
	echo '<select name="month">';
	echo '<option value="1"'.($cur_month == 1?' selected':'').'>'.mb_convert_encoding(gettext("January"), 'UTF-8', 'auto').'</option>';
	echo '<option value="2"'.($cur_month == 2?' selected':'').'>'.mb_convert_encoding(gettext("February"), 'UTF-8', 'auto').'</option>';
	echo '<option value="3"'.($cur_month == 3?' selected':'').'>'.mb_convert_encoding(gettext("March"), 'UTF-8', 'auto').'</option>';
	echo '<option value="4"'.($cur_month == 4?' selected':'').'>'.mb_convert_encoding(gettext("April"), 'UTF-8', 'auto').'</option>';
	echo '<option value="5"'.($cur_month == 5?' selected':'').'>'.mb_convert_encoding(gettext("May"), 'UTF-8', 'auto').'</option>';
	echo '<option value="6"'.($cur_month == 6?' selected':'').'>'.mb_convert_encoding(gettext("June"), 'UTF-8', 'auto').'</option>';
	echo '<option value="7"'.($cur_month == 7?' selected':'').'>'.mb_convert_encoding(gettext("July"), 'UTF-8', 'auto').'</option>';
	echo '<option value="8"'.($cur_month == 8?' selected':'').'>'.mb_convert_encoding(gettext("August"), 'UTF-8', 'auto').'</option>';
	echo '<option value="9"'.($cur_month == 9?' selected':'').'>'.mb_convert_encoding(gettext("September"), 'UTF-8', 'auto').'</option>';
	echo '<option value="10"'.($cur_month == 10?' selected':'').'>'.mb_convert_encoding(gettext("October"), 'UTF-8', 'auto').'</option>';
	echo '<option value="11"'.($cur_month == 11?' selected':'').'>'.mb_convert_encoding(gettext("November"), 'UTF-8', 'auto').'</option>';
	echo '<option value="12"'.($cur_month == 12?' selected':'').'>'.mb_convert_encoding(gettext("December"), 'UTF-8', 'auto').'</option>';
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo mb_convert_encoding(gettext("Day"), 'UTF-8', 'auto');
	echo '<br>';
	$cur_day = abs(substr($message->timestamp,6,2));
	echo '<select name="day">';
	for ($i = 1; $i <= 31; $i++)
	{
		echo '<option value="'.$i.'"'.($i == $cur_day?' selected':'').'>'.$i.'</option>';
	}
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo '<center>';
	echo '<input type="submit" value="'.mb_convert_encoding(gettext("Save"), 'UTF-8', 'auto').'">';
	echo '</center>';
	echo '</td>';
	echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
	echo '<textarea name="message" cols="60" rows="10" autowrap>'.stripslashes($message->text).'</textarea>';
	echo '</td>';
	echo '</tr>';
	echo '</table>';
	echo '</form>';

	html_footer();
}

function action_list()
{
	check_auth();
	html_header(mb_convert_encoding(gettext("Message list"), 'UTF-8', 'auto'));
	echo '<h1>'.mb_convert_encoding(gettext("Message list"), 'UTF-8', 'auto').'</h1>';
	$result = mysql_query('SELECT * FROM nikki ORDER BY timestamp,id');
	if (mysql_num_rows($result))
	{
		echo '<table border="0" width="80%" cellspacing="1" cellpadding="2" class="list">';
		echo '<tr>';
		echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Date"), 'UTF-8', 'auto').'</b></td>';
		echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Message"), 'UTF-8', 'auto').'</b></td>';
		echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Options"), 'UTF-8', 'auto').'</b></td>';
		echo '</tr>';
		while ($entry = mysql_fetch_object($result))
		{
			echo '<tr>';
			echo '<td bgcolor="#e7e7ff" align="center" valign="top">'.$entry->timestamp.'</td>';
			echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
			echo mb_convert_encoding(stripslashes($entry->text), 'UTF-8', 'auto');
			echo '</td>';
			echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
			echo '<a href="'.$GLOBALS['PHP_SELF'].'?action=delete&id='.$entry->id.'">'.mb_convert_encoding(gettext("Delete"), 'UTF-8', 'auto').'</a><br>';
			echo '<a href="'.$GLOBALS['PHP_SELF'].'?action=modify&id='.$entry->id.'">'.mb_convert_encoding(gettext("Modify"), 'UTF-8', 'auto').'</a>';
			echo '</td>';
			echo '</tr>';
		}
		echo '</table>';
	} 

	echo '<br>';

	echo '<table border="0" cellpadding="2" cellspacing="1" bgcolor="#000000" class="list">';
	echo '<tr>';
	echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Date"), 'UTF-8', 'auto').'</b></td>';
	echo '<td bgcolor="#c0c0ff" align="center" valign="top"><b>'.mb_convert_encoding(gettext("Message"), 'UTF-8', 'auto').'</b></td>';
	echo '</tr>';
	echo '<tr>';
	echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
	echo '<form method="post" action="'.$GLOBALS['PHP_SELF'].'?action=checkpost">';
	echo mb_convert_encoding(gettext("Year"), 'UTF-8', 'auto');
	echo '<br>';
	$cur_year = date('Y');
	echo '<select name="year">';
	for ($i = $cur_year - 5; $i <= $cur_year + 5; $i++)
	{
		echo '<option value="'.$i.'"'.($i == $cur_year?' selected':'').'>'.$i.'</option>';
	}
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo mb_convert_encoding(gettext("Month"), 'UTF-8', 'auto');
	$cur_month = date('n');
	echo '<br>';
	echo '<select name="month">';
	echo '<option value="1"'.($cur_month == 1?' selected':'').'>'.mb_convert_encoding(gettext("January"), 'UTF-8', 'auto').'</option>';
	echo '<option value="2"'.($cur_month == 2?' selected':'').'>'.mb_convert_encoding(gettext("February"), 'UTF-8', 'auto').'</option>';
	echo '<option value="3"'.($cur_month == 3?' selected':'').'>'.mb_convert_encoding(gettext("March"), 'UTF-8', 'auto').'</option>';
	echo '<option value="4"'.($cur_month == 4?' selected':'').'>'.mb_convert_encoding(gettext("April"), 'UTF-8', 'auto').'</option>';
	echo '<option value="5"'.($cur_month == 5?' selected':'').'>'.mb_convert_encoding(gettext("May"), 'UTF-8', 'auto').'</option>';
	echo '<option value="6"'.($cur_month == 6?' selected':'').'>'.mb_convert_encoding(gettext("June"), 'UTF-8', 'auto').'</option>';
	echo '<option value="7"'.($cur_month == 7?' selected':'').'>'.mb_convert_encoding(gettext("July"), 'UTF-8', 'auto').'</option>';
	echo '<option value="8"'.($cur_month == 8?' selected':'').'>'.mb_convert_encoding(gettext("August"), 'UTF-8', 'auto').'</option>';
	echo '<option value="9"'.($cur_month == 9?' selected':'').'>'.mb_convert_encoding(gettext("September"), 'UTF-8', 'auto').'</option>';
	echo '<option value="10"'.($cur_month == 10?' selected':'').'>'.mb_convert_encoding(gettext("October"), 'UTF-8', 'auto').'</option>';
	echo '<option value="11"'.($cur_month == 11?' selected':'').'>'.mb_convert_encoding(gettext("November"), 'UTF-8', 'auto').'</option>';
	echo '<option value="12"'.($cur_month == 12?' selected':'').'>'.mb_convert_encoding(gettext("December"), 'UTF-8', 'auto').'</option>';
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo mb_convert_encoding(gettext("Day"), 'UTF-8', 'auto');
	echo '<br>';
	$cur_day = date('j');
	echo '<select name="day">';
	for ($i = 1; $i <= 31; $i++)
	{
		echo '<option value="'.$i.'"'.($i == $cur_day?' selected':'').'>'.$i.'</option>';
	}
	echo '</select>';
	echo '<br>';
	echo '<br>';
	echo '<center>';
	echo '<input type="submit" value="'.mb_convert_encoding(gettext("Save"), 'UTF-8', 'auto').'">';
	echo '</center>';
	echo '</td>';
	echo '<td bgcolor="#e7e7ff" align="left" valign="top">';
	echo '<textarea name="message" cols="60" rows="10" autowrap></textarea>';
	echo '</td>';
	echo '</tr>';
	echo '</table>';
	echo '</form>';

	html_footer();
}

$action = isset($_GET['action'])?$_GET['action']:'';

switch ($action)
{
	case 'list':
		action_list();
		break;
	case 'checkpost':
		action_check_post();
		break;	
	case 'checkmodify':
		action_check_modify();
		break;	
	case 'delete':
		action_delete();
		break;
	case 'modify':
		action_modify();
		break;
	case 'authenticate':
		action_authenticate();
		break;
	case 'logout':
		action_logout();
		break;
	case 'setlang':
		$_SESSION['lang'] = isset($_POST['lang'])?$_POST['lang']:$GLOBALS['default_language'];
		header('Location: '.$GLOBALS['PHP_SELF'].'?action=login');
		break;
	case 'login':
	default:
		action_display_login_dialog();
		break;
}

?>
