<?
/*
nikkipost.php - Control panel for O-Kiraku Nikki
Copyright (C) 2003 Javi Lavandeira (http://www.ag0ny.com)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

require 'nikki.conf.php';

if (isset($_GET['lang']))
{
	$lang = $_GET['lang'];
} else {
	if (isset($_SESSION['lang']))
	{
		$lang = $_SESSION['lang'];
	} else {
		$lang = $GLOBALS['default_language'];
	}
}

#$lang = isset($_GET['lang'])?$_GET['lang']:isset($_SESSION['lang'])?$_SESSION['lang']:$GLOBALS['default_language'];

switch($lang)
{
	case 'de':
		$language_dir = 'de_DE';
		$_SESSION['lang'] = 'de';
		break;
	case 'es':
		$language_dir = 'es_ES';
		$_SESSION['lang'] = 'es';
		break;
	case 'it':
		$language_dir = 'it_IT';
		$_SESSION['lang'] = 'it';
		break;
	case 'ja':
		$language_dir = 'ja_JP';
		$_SESSION['lang'] = 'ja';
		break;
	case 'nl':
		$language_dir = 'nl_NL';
		$_SESSION['lang'] = 'nl';
		break;
	case 'sv':
		$language_dir = 'sv_SE';
		$_SESSION['lang'] = 'sv';
		break;
	case 'en':
	default:
		$language_dir = 'en_US';
		$_SESSION['lang'] = 'en';
		break;
}

putenv("LANG=$language_dir");
setlocale(LC_ALL, "$language_dir");
bindtextdomain("nikki", $GLOBALS['prefix']."/locale");
textdomain("nikki");

$program_version = mb_convert_encoding(gettext("program_name"), 'UTF-8', 'auto');

header('Content-Type: text/html; charset=UTF-8');

$month[0] = mb_convert_encoding(gettext("January"), 'UTF-8', 'auto');
$month[1] = mb_convert_encoding(gettext("February"), 'UTF-8', 'auto');
$month[2] = mb_convert_encoding(gettext("March"), 'UTF-8', 'auto');
$month[3] = mb_convert_encoding(gettext("April"), 'UTF-8', 'auto');
$month[4] = mb_convert_encoding(gettext("May"), 'UTF-8', 'auto');
$month[5] = mb_convert_encoding(gettext("June"), 'UTF-8', 'auto');
$month[6] = mb_convert_encoding(gettext("July"), 'UTF-8', 'auto');
$month[7] = mb_convert_encoding(gettext("August"), 'UTF-8', 'auto');
$month[8] = mb_convert_encoding(gettext("September"), 'UTF-8', 'auto');
$month[9] = mb_convert_encoding(gettext("October"), 'UTF-8', 'auto');
$month[10] = mb_convert_encoding(gettext("November"), 'UTF-8', 'auto');
$month[11] = mb_convert_encoding(gettext("December"), 'UTF-8', 'auto');
$week_day[0] = mb_convert_encoding(gettext("Sunday"), 'UTF-8', 'auto');
$week_day[1] = mb_convert_encoding(gettext("Monday"), 'UTF-8', 'auto');
$week_day[2] = mb_convert_encoding(gettext("Tuesday"), 'UTF-8', 'auto');
$week_day[3] = mb_convert_encoding(gettext("Wednesday"), 'UTF-8', 'auto');
$week_day[4] = mb_convert_encoding(gettext("Thursday"), 'UTF-8', 'auto');
$week_day[5] = mb_convert_encoding(gettext("Friday"), 'UTF-8', 'auto');
$week_day[6] = mb_convert_encoding(gettext("Saturday"), 'UTF-8', 'auto');
$week_day_abb[0] = mb_convert_encoding(gettext("Sunday_abb"), 'UTF-8', 'auto');
$week_day_abb[1] = mb_convert_encoding(gettext("Monday_abb"), 'UTF-8', 'auto');
$week_day_abb[2] = mb_convert_encoding(gettext("Tuesday_abb"), 'UTF-8', 'auto');
$week_day_abb[3] = mb_convert_encoding(gettext("Wednesday_abb"), 'UTF-8', 'auto');
$week_day_abb[4] = mb_convert_encoding(gettext("Thursday_abb"), 'UTF-8', 'auto');
$week_day_abb[5] = mb_convert_encoding(gettext("Friday_abb"), 'UTF-8', 'auto');
$week_day_abb[6] = mb_convert_encoding(gettext("Saturday_abb"), 'UTF-8', 'auto');
$month_days[0] = 31;
$month_days[1] = 28;
$month_days[2] = 31;
$month_days[3] = 30;
$month_days[4] = 31;
$month_days[5] = 30;
$month_days[6] = 31;
$month_days[7] = 31;
$month_days[8] = 30;
$month_days[9] = 31;
$month_days[10] = 30;
$month_days[11] = 31;

$border_color = '#000000';

connect_to_database();

function connect_to_database()
{
	if ($descriptor = mysql_connect($GLOBALS['mysql_host'], $GLOBALS['mysql_user'], $GLOBALS['mysql_password']))
	{
		mysql_query('USE '.$GLOBALS['mysql_database']);
		return $descriptor;
	} else {
		return 0;
	}
}

# display a month
# Input:	$year	Year in 4 digits format (ie: 2000, 1999...)
#		$month	Month (1-12)
function calendar_display_month()
{
	$day_id = calendar_get_date();
	$year = abs(substr($day_id,0,4));
	$month = abs(substr($day_id,4,2));

	$attributes = localtime(mktime(0,0,1, $month, 1, $year), 1);
	$start_day = $attributes['tm_wday'];
	$month_name = $GLOBALS['month'][$month-1];
	$days_this_month = $GLOBALS['month_days'][$month-1];

	# is this a leap year?	
	if ($month == 2)
	{
		$days_this_month = ($year/4 == (int)($year/4) && ($year/100 != (int)($year/100) || $year/400 == (int)($year/400)))?29:28;
	}

	$today = localtime(time(), 1);

	echo '<table border="0" cellspacing="1" cellpadding="2" bgcolor="'.$GLOBALS['border_color'].'">';
	echo '<tr>';
	echo '<td colspan="1" class="cal_monthname">';
	echo calendar_link_previous_month('&lt;');
	echo '</td>';
	echo '<td colspan="5" class="cal_monthname">';
	echo $month_name.'&nbsp;('.$year.')&nbsp;';
	echo '</td>';
	echo '<td colspan="1" class="cal_monthname">';
	echo calendar_link_next_month('&gt;');
	echo '</td>';
	echo '</tr>';

	# Print weekday abbreviations
	echo '<tr>';
	for ($column = 0; $column < 7; $column++)
	{
		echo '<td class="cal_wdayname">';
		#echo $GLOBALS['week_day_abb'][$column];
		echo $GLOBALS['week_day_abb'][($column + $GLOBALS['week_start']) % 7];
		echo '</td>';
	}
	echo '</tr>';

	$column = 0;
	echo '<tr>';
	while ($column < ($start_day - $GLOBALS['week_start']))
	{
		echo '<td class="cal_empty_cell">&nbsp;</td>';
		$column++;
	}

	$time = substr('0000'.abs($year), -4, 4).substr('00'.abs($month), -2, 2);
	$entries = mysql_query('SELECT * FROM nikki WHERE timestamp>'.$time.'00 AND timestamp<'.$time.'32');
	if (mysql_num_rows($entries))
	{
		$calendar_id = array();
		while ($object = mysql_fetch_object($entries))
		{
			$calendar_id["$object->timestamp"] = $object->id;
		}
	}

	for ($day = 1; $day <= $days_this_month; $day++)
	{
		$day_index = $time.substr('00'.abs($day), -2, 2);
		if (($column>0) && ($column%7 == 0)) echo '</tr><tr>';

		$check_wend = getdate(mktime(0,0,0,$month, $day, $year));	
		$weekend = (($check_wend['wday'] == 0) || ($check_wend['wday'] == 6))?1:0;

		$its_today = ($today['tm_mday'] == $day && $today['tm_mon'] == ($month-1) && ($today['tm_year'] + 1900) == $year)?1:0;
		$theres_text = isset($calendar_id[$day_index])?1:0;
		if (isset($_GET['day_id']))
		{
			$is_selected = abs(substr($_GET['day_id'],-2,2) == $day)?1:0;
		} else {
			$is_selected = ($today['tm_mday'] == $day)?1:0;
		}

		$class = $weekend?'cal_wend':'cal_wday';
		$class .= $its_today?'_t':'_nt';
		$class .= $theres_text?'_e':'_ne';
		$class .= $is_selected?'_s':'_ns';

		echo '<td class="'.$class.'">';
		if (isset($calendar_id[$day_index]))
		{
			echo '<a href="'.$GLOBALS['PHP_SELF'].'?lang='.$GLOBALS['lang'].'&day_id='.$day_index.'">'.$day.'</a>';
		} else {
			echo $day;
		}
		echo '</td>';
		$column++;
	}

	while ($column % 7 > 0)
	{
		echo '<td class="cal_empty_cell">&nbsp;</td>';
		$column++;
	}
	echo '</tr>';
	echo '</table>';
}

function calendar_display_entries()
{
	$day_id = calendar_get_date();
	$entries = mysql_query('SELECT * FROM nikki WHERE timestamp=\''.$day_id.'\' ORDER BY id');
	if (mysql_num_rows($entries))
	{
		$year = abs(substr($day_id, 0, 4));
		$month = abs(substr($day_id, 4, 2));
		$day = abs(substr($day_id, 6, 2));
		printf(mb_convert_encoding(gettext("today_date"), 'UTF-8', 'auto'), $year, $month, $day);
		echo '<br><br>';
		$calendar_id = array();
		while ($object = mysql_fetch_object($entries))
		{
			echo mb_convert_encoding($object->text, 'UTF-8', 'auto').'<br><br>';
		}
	}
}

function calendar_link_previous_month($text)
{
	$day_id = calendar_get_date();
	$year = abs(substr($day_id, 0, 4));
	$month = abs(substr($day_id, 4, 2));
	$day = abs(substr($day_id, 6, 2));

	$month = ($month == 1)?12:$month-1;
	$year = ($month == 12)?$year-1:$year;

	$day_index = substr('0000'.$year,-4,4).substr('00'.$month,-2,2).substr('00'.$day,-2,2);
	echo '<a href="'.$GLOBALS['PHP_SELF'].'?lang='.$GLOBALS['lang'].'&day_id='.$day_index.'">'.mb_convert_encoding($text, 'UTF-8', 'auto').'</a>';
}

function calendar_link_next_month($text)
{
	$day_id = calendar_get_date();
	$year = abs(substr($day_id, 0, 4));
	$month = abs(substr($day_id, 4, 2));
	$day = abs(substr($day_id, 6, 2));

	$month = ($month == 12)?1:$month+1;
	$year = ($month == 1)?$year+1:$year;

	$day_index = substr('0000'.$year,-4,4).substr('00'.$month,-2,2).substr('00'.$day,-2,2);
	echo '<a href="'.$GLOBALS['PHP_SELF'].'?lang='.$GLOBALS['lang'].'&day_id='.$day_index.'">'.mb_convert_encoding($text, 'UTF-8', 'auto').'</a>';
}

function calendar_get_date()
{
	if (isset($GLOBALS['day_id']))
	{
		return $GLOBALS['day_id'];
	} else {
		return isset($_GET['day_id'])?addslashes($_GET['day_id']):date('Ymd');
	}
}
?>
