<?

  class sql_class{
       
       /* 
          error no 
          0   - no error 
          101 - can't connect to database
          102 - can't select database          
          
          201 - database not connected
          301 - SQL statement is empty
          302 - SQL statement query error
          401 - sql_insert second parameter is not array()
       */
       
       /* 
          create_table
          
          input parameter 
          1 - table name
          2 - array 
              key = field name
              val = array(field type,other criteria)                 
       */
       
       var $IS_CONNECTED = false;
       
       // database name
       var $DBNAME = "";
       
       // for insert & update
       var $ADDSLASHES = false;
       
       var $SQL = "";
       
       var $ERR_MSG;
       
       var $ERR_NO;
       
       var $errmsg = array(
           "101" => "Can't connect to database",
           "201" => "Database not connected",
           "301" => "SQL statement is empty",
           "401" => "Second parameter should be array"
       );
        
       function get_errno(){
         return $this->ERR_NO;
       }

       function set_errno($str){
         $this->ERR_NO = $str;
       }

       function get_errmsg(){
         return $this->ERR_MSG;
       }

       function set_errmsg($str = ""){
         $this->ERR_MSG = $str;
       }
       
       function get_isconnected(){
         return $this->IS_CONNECTED;
       }

       function set_isconnected($boolean){
         $this->IS_CONNECTED = $boolean;
       }

       // get current SQL statement
       function get_sql(){
          return $this->SQL;
       }

       // set SQL statement
       function set_sql($str){
          $this->SQL = $str;
       }
       
       // get database name
       function get_dbname(){
          return $this->DBNAME;
       }

       // set database name
       function set_dbname($str){
          $this->DBNAME = $str;
       }

       function get_addslashes() {
          return $this->ADDSLASHES;
       }
       
       function set_addslashes($boolean) {
          $this->ADDSLASHES = $boolean;
       }

 	function sql_class($db_host, $db_username, $db_password, $db_name){
  	  	            
            $link = @mysql_connect("$db_host", "$db_username", "$db_password");
            if($link){
               if(mysql_select_db("$db_name", $link)){
                  // success to select database
                  $this->set_errmsg();
                  $this->set_errno(0);
                  $this->set_isconnected(true);
                  $this->set_dbname($db_name);
               }
               else{
                  // fail to select database
                  $this->set_errmsg(mysql_error());
                  $this->set_errno(102);
                  $this->set_isconnected(false);
               }
            }
            else{
               // fail to connect database
               $this->set_errmsg($this->errmsg[101]);
               $this->set_errno(101);               
               $this->set_isconnected(false);
           }                                                  
	}
       
       // execute SQL statement
       function sql_execute(){
          
          if($this->get_errno()){
            return false;
          }
          
          if(!$this->get_isconnected()){          
            $this->set_errmsg($this->errmsg[201]);
            $this->set_errno(201);          
            return false;
          }
          
          if($this->get_sql() == ""){
            $this->set_errmsg($this->errmsg[301]);
            $this->set_errno(301);          
            return false;          
          }

          $result = mysql_db_query($this->get_dbname(),$this->get_sql());
          if($result) {
            $this->set_errmsg();
            $this->set_errno(0);
            $this->set_sql("");
            return $result;
          }
          else{
            $this->set_errmsg(mysql_error());
            $this->set_errno(302);                    
            return false;
          }           
       }
       
       // construct SQL select statement
       function sql_select($table, $select_fields, $where = "",$order = ""){
           
           $fields = "";
           
           if(gettype($select_fields) == "array") {
              for($i=0;$i<count($select_fields);$i++){
                $fields .= trim($select_fields[$i]) . ",";
              }
              $fields = substr($fields,0,strlen($fields) - 1);                  
           }
           else{
              $fields = $select_fields;
           }
           
           if(trim($where) <> "") {
              $where_clause = " WHERE $where ";
           }
           else {
              $where_clause = "";
           }   
           
           $this->set_sql("SELECT $fields FROM $table $where_clause $order");  
           $this->set_errmsg();
           $this->set_errno(0);                     
       }
       
       function sql_insert($table, $insert_fields){
           
           $fields = "";
           $values = "";

           if(gettype($insert_fields) <> "array") { 
             $this->set_errmsg($this->errmsg[401]);
             $this->set_errno(401);  
             $this->set_sql("");
             return;
           }
                      
           $is_magic_quotes = get_magic_quotes_gpc();
           
           while(list($key,$val) = each($insert_fields)){            
              $fields .= trim($key) . ",";             
              if(!$is_magic_quotes || $this->get_addslashes()){        
                 $values .= "'". addslashes(trim($val)) ."',";   
              }
              else{
                 $values .= "'". trim($val) ."',";   
              }     
           }

           $fields = substr($fields,0,strlen($fields) - 1);     
           $values = substr($values,0,strlen($values) - 1);
            
           $this->set_sql(sprintf("INSERT INTO %s (%s) VALUES (%s)",$table,$fields,$values));

           $this->set_errmsg();
           $this->set_errno(0);                        
       } 
   
       function sql_update($table, $update_fields, $where){

           if(gettype($update_fields) <> "array") { 
             $this->set_errmsg($this->errmsg[401]);
             $this->set_errno(401);  
             $this->set_sql("");
             return;
           }
                                 
           $fields = "";
           $values = "";
           
           $is_magic_quotes = get_magic_quotes_gpc();    
           while(list($key,$val) = each($update_fields)){            
              
              if(gettype($val) == "array") { 
                $value = trim($val[0]);
                $operator = trim($val[1]);
              }
              else{
                $value = trim($val); 
                $operator = "";
              }
        
              if(!$is_magic_quotes || $this->get_addslashes()){        
                 $value = addslashes($value);   
              }
              
              switch($operator) {
                 case "+" :
                   $value = "$key + $value,";
                   break;
                 case "-" :
                   $value = "$key - $value,";
                   break;
                 case "*" :
                   $value = "$key * $value,";
                   break;
                 case "/" :
                   $value = "$key / $value,";
                   break;                   
                 default:
                   $value = "'$value',";
              }

              $fields .= trim($key) . " = " . $value ;        
          }      

          $fields = substr($fields,0,strlen($fields) - 1);     
     
          if(trim($where) <> "") {           
             $this->set_sql(sprintf("UPDATE %s SET %s WHERE (%s)",$table,$fields,$where));
          }
          else{
             $this->set_sql(sprintf("UPDATE %s SET %s ",$table,$fields));
          }   

          $this->set_errmsg();
          $this->set_errno(0);  
       } 
       
       function sql_delete($table,$where){
                             
          if(trim($where) <> "") {
             $where_clause = " WHERE $where ";
          }
          else{
             $where_clause = "";
          }
                      
          $this->set_sql("DELETE FROM $table $where_clause");           
          $this->set_errmsg();
          $this->set_errno(0); 
       }
       
       function create_table($table_name,$fields,$index = ""){
          
          if(gettype($fields) <> "array") { 
             $this->set_errmsg($this->errmsg[401]);
             $this->set_errno(401);  
             $this->set_sql("");
             return;
          }
          
          $table_fields = "";
          while(list($key,$val) = each($fields)){             
             $type = $val[0];
             $other_criteria = $val[1];                                       
             $table_fields .= "$key $type $other_criteria,";               
          }

          if(gettype($index) == "array"){
            for($i=0;$i<count($index);$i++){
               $table_fields .= "$index[$i],";
            }
          }  

          $table_fields = substr($table_fields,0,strlen($table_fields) - 1);                  
          
          $this->set_sql("CREATE TABLE $table_name ($table_fields)");           
          $this->set_errmsg();
          $this->set_errno(0); 
          
       }
       
       function sql_fetch_array($result){    
          return mysql_fetch_array($result);
       }
       
       function sql_num_rows($result){
          return mysql_num_rows($result);
       }	       
  }              
      
?>
