CREATE TABLE emml_email_template (
  id int(10) DEFAULT '0' NOT NULL auto_increment,
  name varchar(250) DEFAULT '' NOT NULL,
  subject varchar(100),
  message text,
  html_message text,
  charset varchar(30),
  PRIMARY KEY (id)
);

CREATE TABLE emml_mail_subscribe (
  emailid int(10),
  maillistid int(10)
);

CREATE TABLE emml_maillist (
  id int(10) DEFAULT '0' NOT NULL auto_increment,
  listdesc text,
  listname varchar(200),
  ispublic char(1),
  PRIMARY KEY (id)
);

CREATE TABLE emml_list (
  id int(10) DEFAULT '0' NOT NULL auto_increment,
  listname varchar(250) DEFAULT '' NOT NULL,
  template_html_path varchar(250),
  maillist text,
  default_maillist text,
  sub_frommail varchar(250),
  sub_template int(10), 
  unsub_frommail varchar(250),
  unsub_template int(10),   
  flag char(1),
  PRIMARY KEY (id)
);

CREATE TABLE emml_login_session (
  username char(20),
  string char(32),
  lastupdatedtime datetime
);

CREATE TABLE emml_options (
  option_key varchar(200),
  option_value text
);

CREATE TABLE emml_sendmail (
  id varchar(32) DEFAULT '' NOT NULL,
  todesc varchar(250) DEFAULT '',
  toemail varchar(250) DEFAULT '',
  fromemail varchar(250) DEFAULT '',
  charset varchar(30) DEFAULT '',
  subject varchar(100) DEFAULT '',
  message text,
  html_message text,
  senddate datetime,
  completeddate datetime,
  status char(1),
  PRIMARY KEY (id)
);

CREATE TABLE emml_subscriber (
  id int(10) DEFAULT '0' NOT NULL auto_increment,
  emailaddress varchar(250),
  jointime datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (id)
);
