<? 

########### main menu ########################

   function display_emml_admin_html($contents,$back = "") {
       
        global $admin_url;
        global $emml_image_url;
        global $tpl_html;
        global $emml_version;

        if($back[msg] <> ""){                  
          $contents .= display_back($back);         
        }  
        else{
          $contents .= "<BR>&nbsp;";
        }
                
        $tpl_html ->assign( array( 
             "LOGO"       => "$emml_image_url/emlogo.gif",
             "SCRIPT_URL" => "$admin_url",
             "CONTENTS"   => "$contents",
             "VERSION"    => "$emml_version"
        ));        
        $tpl_html->parse(TPL_ADMIN, "tpl_emml_admin"); 
        $tpl_html->fastprint(TPL_ADMIN);
        	                                     
   }

   function display_back($back){       
       $str = "<table width=100%><tr><td align=right><font face=\"Verdana, Arial, Helvetica, sans-serif\" size=-1><a href=\"$back[link]\">$back[msg]</a></font></td></tr></table>";
       return $str;       
   }

##############################################   

########### subscriber functions #############
   
   function validate_subscriber($subscriber,$id,&$subscriber_mark){
       
       global $admin_msg;
       global $emsql;
       
       $err_msg = "";
       
       $subscriber_mark = array(); 
       
       if(gettype($subscriber) <> "array") {
          $subscriber = array();
       }
       
       $subscriber[email] = trim($subscriber[email]);       
       if($subscriber[email] == "") {            
          $err_msg .= $admin_msg["subscriber_empty_email"] . "<BR>";
       }      
       else{
          if(!is_valid_email($subscriber[email])){
             $err_msg .= $admin_msg["subscriber_invalid_email"] . "<BR>";          
          }
       }          
              
       if($id <> "") {    
          $rc = is_subscriber_exist($subscriber[email]);
          if($rc <> "" AND $rc <> "db_err" ) {
             $row = $emsql->sql_fetch_array($rc);
             if($id <> $row[id]){
                $err_msg .= $admin_msg["subscriber_email_exist"]."<BR>";
             }   
          }
          elseif($rc == "db_err") {
             // database error
             display_db_err();
          }
       }
       else{
         $rc = is_subscriber_exist($subscriber[email]);
         if($rc <> "" AND $rc <> "db_err"){
            $err_msg .= $admin_msg["subscriber_email_exist"] . "<BR>";
         }
         elseif($rc == "db_err"){
            // database error
            display_db_err();
         }
       }
       
       if($err_msg <> "") {
         $subscriber_mark[email] = true;
       }
       
       if(!is_subscribe_mailing_list($subscriber)){
          $err_msg .= $admin_msg["subscriber_empty_maillist"] . "<BR>";
          $subscriber_mark[mailing_list] = true;
       }

       return $err_msg;
   }
   
   function display_subscriber_maint($criteria) {
   
        global $tpl_html;
        global $page;
        global $default;
        global $admin_url;
        global $emsql;

        $page = intval($page);
        
        if($page == 0){
          $page = 1;
        }
        
        $lines = get_options("display_lines");
        
        $lines = intval($lines);
      
        if(!$lines){
          $lines = $default["display_lines"];
        }
        
        if(get_magic_quotes_gpc()){                      
           $criteria = trim(stripslashes($criteria));
        }
        else{
           $criteria = trim($criteria);
        }   
        
        $total_subscriber = 0;
        
        if($criteria == "*" || $criteria == ""){
          $sql = "SELECT * , date_format(jointime, '%d-%b-%Y') as subscribe_time FROM emml_subscriber ";
        }
        else{
          $sql = "SELECT * , date_format(jointime, '%d-%b-%Y') as subscribe_time FROM emml_subscriber WHERE emailaddress like '%$criteria%' ";
        }

        $emsql->set_sql($sql);
        $result = $emsql->sql_execute();
        
        if($result){
           $total_subscriber = $emsql->sql_num_rows($result);        
        }                  

        if($total_subscriber % $lines <> 0){ 
           $max_page = floor($total_subscriber / $lines) + 1;
        }
        else{
           $max_page = $total_subscriber/$lines;
        }  
         
        if($page > $max_page){
           $page = $max_page;
        }

        $limit = ($page - 1) * $lines;

        $sql .= " ORDER BY jointime DESC LIMIT $limit,$lines";
        
        $emsql->set_sql($sql);

        $result = $emsql->sql_execute();

        $subscriber_row = "";

        if($result){
           
           $link = "$admin_url?type=subscriber&criteria=" . urlencode($criteria);
           
           $page_nav = get_page_nav($page,$total_subscriber,$lines,$link);        
           while($row = $emsql->sql_fetch_array($result)){               
               $tpl_html ->assign( array( 
                   "EMAIL"       => "$row[emailaddress]",
                   "JOINTIME"    => "$row[subscribe_time]"."&nbsp;",
                   "UPDATE_LINK" => "$admin_url?type=subscriber&action=update&id=$row[id]",
                   "DELETE_LINK" => "$admin_url?type=subscriber&action=delete&id=$row[id]"
               ));        
               $tpl_html->parse(TPL_SUBSCRIBER_ROW, "tpl_emml_subscriber_row");            
               $subscriber_row .= $tpl_html->fetch(TPL_SUBSCRIBER_ROW);	                                                       
           }           
                      
           $tpl_html ->assign( array( 
              "SCRIPT_URL"   => "$admin_url",
              "RECORD_FOUND" => "$total_subscriber",
              "ROWS"         => "$subscriber_row",
              "PAGE"         => "$page_nav"
           ));        
           $tpl_html->parse(TPL_SUBSCRIBER_TABLE, "tpl_emml_subscriber_table");            
           return $tpl_html->fetch(TPL_SUBSCRIBER_TABLE);	                                     
        }                               
        else{           
           // database error
           display_db_err();
        }             
   }

   function display_search_subscriber() {
       
       global $tpl_html;
       global $criteria;
       global $admin_url;
       
       if(get_magic_quotes_gpc()){                             
           $criteria = htmlspecialchars(stripslashes($criteria));
       }
       else{
           $criteria = htmlspecialchars($criteria);
       }    

       $tpl_html ->assign( array( 
          "SCRIPT_URL" => "$admin_url",
          "CRITERIA"   => "$criteria"
       ));        

       $tpl_html->parse(TPL_SUBSCRIBER_SEARCH, "tpl_emml_subscriber_search");            
       return $tpl_html->fetch(TPL_SUBSCRIBER_SEARCH);	                                     
   }
   
   function display_add_subscriber($subscriber_mark = "") {
       
       global $tpl_html;
       global $subscriber;
       global $err_msg;
       global $admin_msg;
       global $admin_url;

       if(get_magic_quotes_gpc()){                             
          $subscriber_email = htmlspecialchars(stripslashes(trim($subscriber[email])));
       }
       else{
          $subscriber_email = htmlspecialchars(trim($subscriber[email]));
       }   
       
       $mailing_list_rows = get_mailing_list($subscriber);
       
       $display_mark = get_mark($subscriber_mark); 
       
       if($mailing_list_rows <> "") {          
          $tpl_html ->assign( array( 
             "SCRIPT_URL"            => "$admin_url",          
             "ERR_MSG"               => "$err_msg",
             "SUBSCRIBER_EMAIL_MARK" => $display_mark[email],
             "MAILING_LIST_MARK"     => $display_mark[mailing_list],
             "SUBSCRIBER_EMAIL"      => "$subscriber_email",
             "ROWS"                  => "$mailing_list_rows"
          ));               
          $tpl_html->parse(TPL_SUBSCRIBER_ADD, "tpl_emml_subscriber_add");            
          return $tpl_html->fetch(TPL_SUBSCRIBER_ADD);	                                                        
       } 
       else{       
          return $admin_msg[subscriber_no_mailing_list];
       }                     
   }

   function display_update_subscriber($id,$subscriber_mark = ""){
        
       global $tpl_html; 
       global $admin_url;
       global $err_msg;
       global $subscriber;
       global $admin_msg;
       global $back_subscriber;
       global $emsql;

       $subscriber_email = $subscriber[email];

       if($err_msg == ""){       
         
         $sql = "SELECT * FROM emml_subscriber WHERE id = '$id'";
         $emsql->set_sql($sql);
         $result = $emsql->sql_execute();
         if($result){          
            if($emsql->sql_num_rows($result)){
              $subscriber = $emsql->sql_fetch_array($result);
              $subscriber_email = $subscriber[emailaddress];
              $sql = "SELECT * FROM emml_mail_subscribe WHERE emailid = '$id'";
              $emsql->set_sql($sql);
              $result = $emsql->sql_execute();
              $subscriber = array();
              if($result){              
                 while($maillist_row = $emsql->sql_fetch_array($result)){
                    $subscriber[$maillist_row[maillistid]] = "Y";
                 }
              }
            }
            else{             
              display_emml_admin_html($admin_msg[subscriber_not_found],$back_subscriber);  
              exit;                   
            }  
         }
       }  

       if(get_magic_quotes_gpc()){                             
          $subscriber_email = htmlspecialchars(stripslashes(trim($subscriber_email)));
       }
       else{
          $subscriber_email = htmlspecialchars(trim($subscriber_email));
       }   
              
       $mailing_list_rows = get_mailing_list($subscriber);

       $display_mark = get_mark($subscriber_mark);

       $tpl_html ->assign( array(
          "SCRIPT_URL"            => "$admin_url",
          "ID"                    => "$id",
          "ERR_MSG"               => "$err_msg",
          "SUBSCRIBER_EMAIL"      => "$subscriber_email",
          "SUBSCRIBER_EMAIL_MARK" => "$display_mark[email]",
          "MAILING_LIST_MARK"     => "$display_mark[mailing_list]",
          "ROWS"                  => "$mailing_list_rows"
       ));

       $tpl_html->parse(TPL_SUBSCRIBER_UPDATE, "tpl_emml_subscriber_update");
       return $tpl_html->fetch(TPL_SUBSCRIBER_UPDATE);
   }

   function display_delete_subscriber($id){
        
       global $tpl_html; 
       global $admin_url;
       global $admin_msg;
       global $back_subscriber;
       global $emsql;
       
       $sql = "SELECT * FROM emml_subscriber WHERE id = '$id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){          
          if($emsql->sql_num_rows($result)){
             
             $row = $emsql->sql_fetch_array($result);
             
             $sql = "SELECT * FROM emml_mail_subscribe AS A, emml_maillist AS B WHERE B.id = A.maillistid AND A.emailid = '$row[id]'";
             $emsql->set_sql($sql);
             $result = $emsql->sql_execute();
             if($result){              
                while($maillist_row = $emsql->sql_fetch_array($result)){
                    $mailing_list .= $maillist_row[listname] . "<BR>";
                }
             }
             
             $tpl_html ->assign( array( 
               "SCRIPT_URL"       => "$admin_url",                           
               "ID"               => "$row[id]",
               "ERR_MSG"          => "$err_msg",
               "SUBSCRIBER_EMAIL" => "$row[emailaddress]",
               "MAILING_LIST"     => "$mailing_list"
             ));        

             $tpl_html->parse(TPL_SUBSCRIBER_DELETE, "tpl_emml_subscriber_delete");            
             return $tpl_html->fetch(TPL_SUBSCRIBER_DELETE);	                                                  
          }
          else{
             display_emml_admin_html($admin_msg[subscriber_not_found],$back_subscriber);  
             exit;                                
          }
       }
   }

   function add_subscriber($subscriber) {
      
      global $emsql;
              
      $emml_subscriber_fields = array(
         "emailaddress" => "$subscriber[email]",
         "jointime"     => date("Y-m-d H:i:s")
      );                       
      $emsql->sql_insert("emml_subscriber",$emml_subscriber_fields);
      $result = $emsql->sql_execute();            

      if(!$result){
         return false;
      }
         
      $id = get_emailid($subscriber[email]);             
      
      if($id <> "" AND $id <> "db_err") {
         
         reset($subscriber);
         while(list($key,$val) = each($subscriber)){
           if($val == "Y"){
              $emml_mail_subscribe_fields = array(
                 "emailid"    => "$id",
                 "maillistid" => "$key"                
              );            
              $emsql->sql_insert("emml_mail_subscribe",$emml_mail_subscribe_fields);
              $result = $emsql->sql_execute();
              if(!$result){
                 return false;
              }
           }   
         }                                 
         return true;  
      }
      elseif($id == "db_err"){
        return false;       
      }
   }   
   
   function update_subscriber($id,$subscriber){
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_subscriber WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
        if(!$emsql->sql_num_rows($result)){
            return "subscriber_not_found";
        }
      }
      else{
        return "FAILED";
      }
      
      $emsql->sql_delete("emml_mail_subscribe","emailid = '$id'");
      $result = $emsql->sql_execute();
      
      if($result){
         if(gettype($subscriber) == "array"){
            $emml_subscriber_fields = array(
               "emailaddress" => "$subscriber[email]"
            );
            $emsql->sql_update("emml_subscriber",$emml_subscriber_fields," id = '$id'");
            $result = $emsql->sql_execute();
            if($result){
               while(list($key,$val) = each($subscriber)){
                  if($val == "Y") {
                    $emml_mail_subscribe_fields = array(
                        "emailid"    => "$id",
                        "maillistid" => "$key"
                    );
                    $emsql->sql_insert("emml_mail_subscribe",$emml_mail_subscribe_fields);
                    $result = $emsql->sql_execute();
                    if(!$result){
                       return "FAILED";
                    }
                  }
               }
            }
         }
      }   
      else{
        return "FAILED";
      }            
      return "OK";
   }

   function delete_subscriber($id){
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_subscriber WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
         if(!$emsql->sql_num_rows($result)){
            return "subscriber_not_found";
         }
      }
      else{
         return "FAILED";
      }      
         
      $emsql->sql_delete("emml_mail_subscribe","emailid = '$id'");
      $result = $emsql->sql_execute();
            
      if($result){
         $emsql->sql_delete("emml_subscriber","id = '$id'");
         $result = $emsql->sql_execute();
         if(!$result){
           return "FAILED";        
         }
      }   
            
      return "OK";
   }

##############################################

########### mailing list functions ###########
   
   function validate_maillist($maillist,$id,&$maillist_mark){
        
      global $admin_msg;  
      global $emsql;

      $listname = trim($maillist[listname]);
      $listdesc = trim($maillist[listdesc]);
      
      $maillist_mark = array();
      
      $err_msg = "";
            
      $maillist_mark = array();
      if(trim($listname) == "") {
         $err_msg = $admin_msg["maillist_empty_title"]."<BR>";
         $maillist_mark[listname] = true;
      }
      
      if(trim($listdesc) == ""){
         $err_msg .= $admin_msg["maillist_empty_desc"]. "<BR>";
         $maillist_mark[listdesc] = true;
      }            
      
      $id = trim($id);
      
      if(!get_magic_quotes_gpc()){
         $listname = addslashes($listname);      
      }
      
      $sql = "SELECT * FROM emml_maillist WHERE listname = '$listname'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
         if($emsql->sql_num_rows($result)){
            if($id == ""){      
               $err_msg .= $admin_msg["maillist_list_exist"]. "<BR>";
               $maillist_mark[listname] = true;
            }
            else{
               $row = $emsql->sql_fetch_array($result);
               if($id <> $row[id]){
                 $err_msg .= $admin_msg["maillist_list_exist"]. "<BR>";
                 $maillist_mark[listname] = true;                  
               }
            }              
         }
      }
      else{
        // database error
        display_db_err();                      
      }            
      return $err_msg;
   }
        
   function display_maillist_maint() {
   
      global $tpl_html;
      global $admin_url;
      global $msg;
      global $emsql;
      
      $sql = "SELECT * FROM emml_maillist ORDER BY id";  
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
        
      $maillist_row = "";
      if($result){           
         while($row = $emsql->sql_fetch_array($result)){           
            $listcount = get_list_count($row[id]);
            
            if($row[ispublic] <> "N"){
              $hidden = "";
            }
            else{
              $hidden = $msg["maillist_hidden"];
            }  
            
            $tpl_html ->assign( array( 
                 "LISTNAME"        => "$row[listname]",               
                 "LISTDESC"        => "$row[listdesc]",
                 "LISTCOUNT"       => "$listcount",
                 "HIDDEN"          => "$hidden",
                 "UPDATE_LINK"     => "$admin_url?type=maillist&action=update&id=$row[id]",
                 "DELETE_LINK"     => "$admin_url?type=maillist&action=delete&id=$row[id]",
                 "SUBSCRIBER_LINK" => "$admin_url?type=maillist&action=subscriber&id=$row[id]",
                 "IMPORT_LINK"     => "$admin_url?type=maillist&action=import&id=$row[id]",
                 "EXPORT_LINK"     => "$admin_url?type=maillist&action=export&id=$row[id]"
            ));        
            $tpl_html->parse(TPL_MAILLIST_ROW, "tpl_emml_maillist_row");            
            $maillist_row .= $tpl_html->fetch(TPL_MAILLIST_ROW);	                                     
         }
                    
         $tpl_html ->assign( array( 
            "SCRIPT_URL" => "$admin_url",              
            "ROWS"       => "$maillist_row"
         ));        
         $tpl_html->parse(TPL_MAILLIST_TABLE, "tpl_emml_maillist_table");            
         return $tpl_html->fetch(TPL_MAILLIST_TABLE);	                                     
      }
      else{
        // database error
        display_db_err();
      }
   }

   function display_add_maillist($maillist_mark = "") {
       
      global $tpl_html;
      global $maillist;
      global $err_msg;
      global $admin_url;

      if(get_magic_quotes_gpc()){                             
         $maillist[listname] = htmlspecialchars(stripslashes(trim($maillist[listname])));
         $maillist[listdesc] = htmlspecialchars(stripslashes(trim($maillist[listdesc])));
      }
      else{
         $maillist[listname] = htmlspecialchars(trim($maillist[listname]));
         $maillist[listdesc] = htmlspecialchars(trim($maillist[listdesc]));      
      }   
      
      if($maillist[public] == "N") {
         $public_yes_checked = "";
         $public_no_checked  = "SELECTED";               
      }
      else{      
         $public_yes_checked = "SELECTED";
         $public_no_checked  = "";                        
      }   
      
      $display_mark = get_mark($maillist_mark);

      $tpl_html ->assign( array( 
          "SCRIPT_URL" => "$admin_url",                     
          "ERR_MSG"    => "$err_msg",
          "TITLE_MARK" => "$display_mark[listname]",
          "DESC_MARK"  => "$display_mark[listdesc]",
          "PUBLIC_YES_CHECKED" => "$public_yes_checked",
          "PUBLIC_NO_CHECKED"  => "$public_no_checked",
          "LISTNAME"   => "$maillist[listname]",
          "LISTDESC"   => "$maillist[listdesc]"
      ));        

      $tpl_html->parse(TPL_MAILLIST_ADD, "tpl_emml_maillist_add");
      return $tpl_html->fetch(TPL_MAILLIST_ADD);	                                     
   }

   function display_update_maillist($id,$maillist_mark = "") {
       
       global $tpl_html;
       global $maillist;
       global $err_msg;
       global $admin_url;
       global $admin_msg;
       global $back_maillist;
       global $emsql;
       
       if($err_msg <> "") {
          if(get_magic_quotes_gpc()){    
             $name = htmlspecialchars(stripslashes($maillist[listname]));
             $desc = htmlspecialchars(stripslashes($maillist[listdesc]));
             $ispublic = htmlspecialchars(stripslashes($maillist[public]));             
          }
          else{
             $name = htmlspecialchars($maillist[listname]);
             $desc = htmlspecialchars($maillist[listdesc]);
             $ispublic = htmlspecialchars($maillist[public]);
          }    
       }
       else{    
          $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
          $emsql->set_sql($sql);
          $result = $emsql->sql_execute();
          if($result){
             if($emsql->sql_num_rows($result)){             
                $row = $emsql->sql_fetch_array($result);        
                $name = htmlspecialchars($row[listname]);
                $desc = htmlspecialchars($row[listdesc]);
                $ispublic = htmlspecialchars($row[ispublic]);
             }
             else{
                display_emml_admin_html($admin_msg[maillist_not_found],$back_maillist);  
                exit;                            
             }
          }       
       }   

       if($ispublic == "N") {
         $public_yes_checked = "";
         $public_no_checked  = "SELECTED";               
       }
       else{      
         $public_yes_checked = "SELECTED";
         $public_no_checked  = "";                        
       }   
 
       $display_mark = get_mark($maillist_mark);

       $tpl_html ->assign( array( 
          "SCRIPT_URL" => "$admin_url",                     
          "ERR_MSG"    => "$err_msg",
          "ID"         => "$id",
          "TITLE_MARK" => "$display_mark[listname]",
          "DESC_MARK"  => "$display_mark[listdesc]",
          "PUBLIC_YES_CHECKED" => "$public_yes_checked",
          "PUBLIC_NO_CHECKED"  => "$public_no_checked",          
          "LISTNAME"   => "$name",
          "LISTDESC"   => "$desc"
       ));        
       $tpl_html->parse(TPL_MAILLIST_UPDATE, "tpl_emml_maillist_update");            
       return $tpl_html->fetch(TPL_MAILLIST_UPDATE);	                                                   
   }

   function display_delete_maillist($id) {
       
       global $tpl_html;
       global $err_msg;
       global $admin_msg;
       global $admin_url;
       global $emsql;
       
       $list_count = get_list_count($id);

       if(!$list_count) {       
          $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
          $emsql->set_sql($sql);          
          $result = $emsql->sql_execute();                 
          if($result){                      
             if($emsql->sql_num_rows($result)){
                 $row = $emsql->sql_fetch_array($result);
                 $tpl_html ->assign( array( 
                     "SCRIPT_URL" => "$admin_url",                               
                     "ERR_MSG"    => "$err_msg",
                     "LISTNAME"   => "$row[listname]",               
                     "LISTDESC"   => "$row[listdesc]",
                     "ID"         => "$row[id]"
                 ));        

                 $tpl_html->parse(TPL_MAILLIST_DELETE, "tpl_emml_maillist_delete");            
                 return $tpl_html->fetch(TPL_MAILLIST_DELETE);	                                     
             }
             else{
                return $admin_msg["maillist_not_found"];
             }   
          }
          else{
            // database error
            display_db_err();
          }
       }
       else {       
         // subscriber exists
         return $admin_msg["maillist_subscriber_exist"];       
       }
   }

   function display_maillist_view_subscriber($id){

       global $tpl_html;
       global $err_msg;
       global $page;
       global $default;
       global $admin_url;
       global $emsql;
       
       $page = intval($page);
        
       if($page == 0){
         $page = 1;
       }
        
       $lines = intval(get_options("display_lines"));
        
       if(!$lines){
         $lines = $default["display_lines"];
       }

       $sql = "SELECT A.emailaddress,A.id FROM emml_subscriber AS A, emml_mail_subscribe AS B WHERE A.id = B.emailid AND B.maillistid = '$id'";
       
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){
         $subscriber_count = $emsql->sql_num_rows($result);
       }

       if($subscriber_count % $lines <> 0){ 
          $max_page = floor($subscriber_count / $lines) + 1;
       }
       else{
          $max_page = $subscriber_count/$lines;
       }  
         
       if($page > $max_page){
          $page = $max_page;
       }

       $limit = ($page - 1) * $lines;
              
       $sql = "SELECT A.emailaddress,A.id FROM emml_subscriber AS A, emml_mail_subscribe AS B WHERE A.id = B.emailid AND B.maillistid = '$id' ORDER BY A.id LIMIT $limit,$lines";
       
       $emsql->set_sql($sql);
       
       $result = $emsql->sql_execute();

       if($result){          
          if($emsql->sql_num_rows($result)){
             while($row = $emsql->sql_fetch_array($result)){
                $tpl_html ->assign( array( 
                   "EMAIL" => "$row[emailaddress]",               
                   "ID"    => "$row[id]"                
                ));        
                $tpl_html->parse(TPL_MAILLIST_VIEW_SUBSCRIBER_ROW, "tpl_emml_maillist_view_subscriber_row");            
                $subscriber_row .= $tpl_html->fetch(TPL_MAILLIST_VIEW_SUBSCRIBER_ROW);                
             }   
             $listcount = $emsql->sql_num_rows($result);
          }
       }  
       
       $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       
       if($result){
          if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);
             $mailing_list = $row[listname];
          }
       }
       $link = "$admin_url?type=maillist&action=subscriber&id=$id";
       $page_nav = get_page_nav($page,$subscriber_count,$lines,$link);        
       
       $tpl_html ->assign( array( 
          "SCRIPT_URL"   => "$admin_url",
          "MAILING_LIST" => "$mailing_list",
          "LIST_COUNT"   => "$subscriber_count",          
          "ROWS"         => "$subscriber_row",
          "MAILLIST_ID"  => "$id",
          "PAGE"         => "$page_nav"          
       ));               
              
       $tpl_html->parse(TPL_MAILLIST_VIEW_SUBSCRIBER_TABLE, "tpl_emml_maillist_view_subscriber_table");            
       return $tpl_html->fetch(TPL_MAILLIST_VIEW_SUBSCRIBER_TABLE);                  
       
   }

   function add_maillist($maillist){      
      
      global $emsql;
      
      $listname = trim($maillist[listname]);
      $listdesc = trim($maillist[listdesc]);
      $ispublic = trim($maillist[public]);
                     
      $emml_maillist_fields = array(         
          "listname" => "$listname",
          "listdesc" => "$listdesc",
          "ispublic" => "$ispublic"
      );     
                  
      $emsql->sql_insert("emml_maillist",$emml_maillist_fields);

      $result = $emsql->sql_execute();
      return $result;
   }

   function update_maillist($id,$maillist){      
      
      global $emsql;
             
      $id = trim($id);
      $listname = trim($maillist[listname]);
      $listdesc = trim($maillist[listdesc]);
      $ispublic = trim($maillist[public]);
      
      $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
         if($emsql->sql_num_rows($result)){
            $emml_maillist_fields = array(         
               "listname" => "$listname",
               "listdesc" => "$listdesc",
               "ispublic" => "$ispublic"
            );                       
            $emsql->sql_update("emml_maillist",$emml_maillist_fields,"id='$id'");                
            $result = $emsql->sql_execute();
         }
         else{
           return "maillist_not_found";
         }
      }
      if($result){
        return "OK";
      }
      else{
        return "FAILED";
      }
   }
   
   function delete_maillist($id){      
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
      $emsql->set_sql($sql);

      $result = $emsql->sql_execute();
      if($result){
         if(!$emsql->sql_num_rows($result)){
            return "maillist_not_found";
         }
         else {
            $emsql->sql_delete("emml_maillist","id = '$id'");
            $result = $emsql->sql_execute();
            if($result){ 
              return "OK";
            }
            else{
              return "FAILED";
            }            
         }
      }
      else{
        return "FAILED";
      }            
   }

// ########## import email #################

   function get_data_from_file($filename,&$rows) {  
      if(!file_exists($filename)){
         return "Error : $filename not found";
         exit;
      }  
      $fp = fopen("$filename", "r");

      while (!feof($fp)) {
         $buffer .= fgets($fp, 4096);
      }
      fclose($fp);  
      
      $rows = split("\n",$buffer);        
      return "";
   }
  
   function import_email($rows,$maillistid){
     
     global $emsql;
     
     $str = "";     
 
     while (list ($key, $val) = each ($rows)) {  
        if(trim($val) <> "") {
          $email = trim($val);                 
          
          if(!is_valid_email($email)){
             $str .= "Invalid email address : $email<BR>";
             continue;
          }
          
          // check if subscriber exists          
          $sql = "SELECT * FROM emml_subscriber WHERE emml_subscriber.emailaddress = '$email'";
          $emsql->set_sql($sql);
          $result = $emsql->sql_execute();          
          if($result){
                              
             $id = "";
             if($emsql->sql_num_rows($result)){  // subscriber exists
                $subscriber_rows = $emsql->sql_fetch_array($result);
                $id = $subscriber_rows[id];
             }
             else{ // subscriber not exist
                $emml_subscriber_fields = array(
                    "emailaddress" => "$email",
                    "jointime"     => date("Y-m-d H:i:s")
                );
                $emsql->set_addslashes(true);                            
                $emsql->sql_insert("emml_subscriber",$emml_subscriber_fields);
                $emsql->set_addslashes(false);                            
                $result = $emsql->sql_execute();
                if($result) {
                   $sql = "SELECT * FROM emml_subscriber WHERE emml_subscriber.emailaddress = '$email'";
                   $emsql->set_sql($sql);
                   $result = $emsql->sql_execute();          
                   if($result){
                      if($emsql->sql_num_rows($result)){
                         $subscriber_rows = $emsql->sql_fetch_array($result);
                         $id = $subscriber_rows[id];
                      }
                   }
                   else{
                      // database error
                      display_db_err();
                   }  
                }
                else{
                  // database error
                  display_db_err();
                }  
             }  
                                                               
             if($id <> ''){
                add_email($id,$maillistid);
             }                
          }
          else{
             // database error
             display_db_err();
          }
        }   
     }     
     return $str;  
   }
  
   function add_email($id,$maillistid){
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_mail_subscribe WHERE emailid = '$id' AND maillistid = '$maillistid'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){                   
         if(!$emsql->sql_num_rows($result)){
            $emml_mail_subscribe_fields = array(
               "emailid"    => "$id",
               "maillistid" => "$maillistid"
            );

            $emsql->set_addslashes(true);                            
            $emsql->sql_insert("emml_mail_subscribe",$emml_mail_subscribe_fields);
            $emsql->set_addslashes(false);                            

            $result = $emsql->sql_execute();
         }
      }
   }

   function get_email($email){       
      $email = trim($email);       
      if($email <> ""){
         $a = split ("\n", $email);
         return $a;
      }
      else{
         return array();
      }
   }
     
   function display_maillist_import_email($maillistid){

       global $tpl_html;
       global $err_msg;
       global $default;
       global $admin_url;
       global $emsql;
       
       $sql = "SELECT A.emailaddress, A.id FROM emml_subscriber AS A, emml_mail_subscribe AS B WHERE A.id = B.emailid AND B.maillistid = '$maillistid'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){
         $subscriber_count = $emsql->sql_num_rows($result);
       }
       
       $sql = "SELECT * FROM emml_maillist WHERE id = '$maillistid'";
       $emsql->set_sql($sql);
       
       $result = $emsql->sql_execute();
       
       if($result){
          if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);
             $mailing_list = $row[listname];
          }
       }
       
       $tpl_html ->assign( array( 
          "SCRIPT_URL"   => "$admin_url",
          "MAILING_LIST" => "$mailing_list",
          "LIST_COUNT"   => "$subscriber_count",          
          "ROWS"         => "$subscriber_row",
          "MAILLIST_ID"  => "$maillistid"
       ));               
              
       $tpl_html->parse(TPL_MAILLIST_IMPORT_EMAIL, "tpl_emml_maillist_import_email");            
       return $tpl_html->fetch(TPL_MAILLIST_IMPORT_EMAIL);                         
   }

   function display_maillist_export_email($maillistid){

       global $tpl_html;
       global $err_msg;
       global $default;
       global $admin_url;
       global $emsql;
       
       $select_fields = array(
           "A.emailaddress", 
           "A.id" 
       );
       
       $sql = "SELECT A.emailaddress, A.id FROM emml_subscriber AS A, emml_mail_subscribe AS B WHERE A.id = B.emailid AND B.maillistid = '$maillistid'";
       
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){
          $subscriber_count = $emsql->sql_num_rows($result);
          if($subscriber_count){
             while($row = $emsql->sql_fetch_array($result)){
               $email .= $row[emailaddress] . "<BR>";
             }
          }
       }
       
       $sql = "SELECT * FROM emml_maillist WHERE id = '$maillistid'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       
       if($result){
          if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);
             $mailing_list = $row[listname];
          }
       }
       
       $tpl_html ->assign( array( 
          "SCRIPT_URL"   => "$admin_url",
          "MAILING_LIST" => "$mailing_list",
          "LIST_COUNT"   => "$subscriber_count",          
          "EMAIL"        => "$email"
       ));               
              
       $tpl_html->parse(TPL_MAILLIST_EXPORT_EMAIL, "tpl_emml_maillist_export_email");            
       return $tpl_html->fetch(TPL_MAILLIST_EXPORT_EMAIL);                         
   }

##############################################
   
########### send email #######################
   
   // validate send mail 
   function validate_sendmail($sendmail,&$sendmail_mark){
       
       global $admin_msg;
       global $emsql;
       
       $sendmail_mark = array();
       
       while(list($key,$val) = each($sendmail)){
          $sendmail[$key] = trim($val);
       }
      
       if($sendmail[radio_toemail] == "default_toemail"){
          // check no. of subscribers
          $list_count = get_list_count($sendmail[default_toemail]);
          if($list_count == 0) {
             $err_msg .="$admin_msg[sendmail_no_subscriber]<BR>";
             $sendmail_mark[tomail] = true;
          }
       }
       else{
          if($sendmail[custom_toemail] == ""){
             $err_msg .= "$admin_msg[sendmail_toemail_fill_in_email]<BR>";
             $sendmail_mark[tomail] = true;
          }
          else{
             if(!is_valid_email($sendmail[custom_toemail])){
               $err_msg .= "$admin_msg[sendmail_toemail_invalid_email]<BR>";
               $sendmail_mark[tomail] = true;
             }
          }
       }
       
       // check 'from email'
       if($sendmail[radio_fromemail] == "default_fromemail"){
          if($sendmail[default_from_email] == ""){
             $err_msg .= "$admin_msg[sendmail_select_email_address]<BR>";
             $sendmail_mark[frommail] = true;
          }
       }
       else{          
          if($sendmail[fromemail] == "") {
             $err_msg .= "$admin_msg[sendmail_fromemail_fill_in_email]<BR>";
             $sendmail_mark[frommail] = true;             
          }
          else {          
             if(!is_valid_email($sendmail[fromemail])){
                $err_msg .= "$admin_msg[sendmail_fromemail_invalid_email]<BR>";     
                $sendmail_mark[frommail] = true;                
             }
          }          
       }
       
       // check email message
       if($sendmail[radio_email] == "default_email"){
          if($sendmail[email_template] == ""){
             $err_msg .= "$admin_msg[sendmail_select_email_template]<BR>";                 
             $sendmail_mark[email] = true;
          }
          else{
             $sql = "SELECT * from emml_email_template WHERE id = '$sendmail[email_template]'";
             $emsql->set_sql($sql);
             $result = $emsql->sql_execute();
             if($result){
                if(!$emsql->sql_num_rows($result)){
                   $err_msg .= "Email Template not found";
                   $sendmail_mark[email] = true;                
                }
             }           
          }   
       }

       return $err_msg;   
   }
   
   // validate preview
   function validate_sendmail_preview($sendmail,&$sendmail_mark){
       
       global $admin_msg;

       $sendmail_mark = array();
       
       while(list($key,$val) = each($sendmail)){
          $sendmail[$key] = trim($val);
       }

       // check subject
       if($sendmail[subject] == ""){
          $err_msg .= "$admin_msg[sendmail_empty_subject]<BR>";                 
          $sendmail_mark[subject] = true;
       }
      
       // check message
       if($sendmail[message] == "" AND $sendmail[html_message] == "" ){
          $err_msg .= "$admin_msg[sendmail_empty_message]<BR>";                 
          $sendmail_mark[message] = true;
       }

       return $err_msg;   
   }
      
   function save_sendmail($sendmail){

       global $admin_msg;
       global $emsql;
       
       $is_sendmail = false;
       $todesc = "";
       
       $sendmail[toemail] = trim($sendmail[toemail]);

       if($sendmail[toemail] == "ALL" OR eregi('^([0-9])$',$sendmail[toemail])){
          $is_sendmail = true;
          if($sendmail[toemail] == "ALL"){
             $todesc = $admin_msg["all_subscriber"];
          }
          else{
             $todesc = get_preview_list($sendmail[toemail]);
          }
       }
       else{              
          if(is_valid_email($sendmail[toemail])){
            $is_sendmail = true;
            $todesc = $sendmail[toemail];
          }  
       }

       if($is_sendmail){       
          
          $id = trim($sendmail[sendmail_id]);
          
          $sql = "SELECT * FROM emml_sendmail WHERE id = '$id'";
          $emsql->set_sql($sql);
          $result = $emsql->sql_execute();
          if($result){
             if($emsql->sql_num_rows($result)){                
                $row = $emsql->sql_fetch_array($result);
                return $row[status]; 
             }

             $emml_sendmail_fields = array(
                "id"        => "$sendmail[sendmail_id]",
                "todesc"    => "$todesc",
                "toemail"   => "$sendmail[toemail]",
                "fromemail" => "$sendmail[fromemail]",
                "charset"   => "$sendmail[charset]",
                "subject"   => convert_htmlspecialchars($sendmail[subject]),
                "message"   => convert_htmlspecialchars($sendmail[message]),
                "html_message" => convert_htmlspecialchars($sendmail[html_message]),
                "senddate"  => date("Y-m-d H:i:s"),
                "status"    => "R"
             );

             $emsql->set_addslashes(true);                            
             $emsql->sql_insert("emml_sendmail",$emml_sendmail_fields);
             $emsql->set_addslashes(false);

             $result = $emsql->sql_execute();                          
             
             if($result){
                return "sendmail_ok";
             }
          }

          if(!$result){
            // database error
            display_db_err();
          }
       }
       else{
         return "sendmail_formdata_error";
       }       
   }
   
   function display_sendmail($sendmail_mark="") {
       
       global $tpl_html;
       global $sendmail;
       global $err_msg;
       global $admin_msg;
       global $admin_url;
       
       $mailing_list  = "<OPTION VALUE=\"ALL\">&lt;$admin_msg[all_subscriber]&gt;". " (". get_list_count("ALL") ." subscribers) </OPTION>";       
       $mailing_list .= get_sendmail_list($sendmail[default_toemail]);

       if($sendmail[radio_toemail] <> "custom_toemail"){
         $default_toemail_checked = "CHECKED";
       }
       else{
         $custom_toemail_checked = "CHECKED";
       }  
       
       if($sendmail[radio_fromemail] <> "custom_fromemail"){
         $default_fromemail_checked = "CHECKED";
       }
       else{
         $custom_fromemail_checked = "CHECKED";
       }  

       if($sendmail[radio_email] <> "custom_email"){
         $default_email_checked = "CHECKED";
       }
       else{
         $custom_email_checked = "CHECKED";
       }  
                      
       $default = get_settings();
       
       $default_emails = get_default_emails($admin_msg[sendmail_select_default_email_address],$default["default_emails"],$sendmail[default_from_email]);
       $email_template = get_email_template($admin_msg[sendmail_select_template],$sendmail[email_template]);
       
       $display_mark = get_mark($sendmail_mark);
       
       if(get_magic_quotes_gpc()){    
          $send_to    = htmlspecialchars(stripslashes(trim($sendmail[custom_toemail])));
          $send_from  = htmlspecialchars(stripslashes(trim($sendmail[fromemail])));
       }
       else{
          $send_to      = htmlspecialchars(trim($sendmail[custom_toemail]));
          $send_from    = htmlspecialchars(trim($sendmail[fromemail]));
       }
              
       $tpl_html ->assign( array( 
          "SCRIPT_URL"                 => "$admin_url",                     
          "ERR_MSG"                    => "$err_msg",
          "DEFAULT_TOEMAIL_CHECKED"    => "$default_toemail_checked",
          "CUSTOM_TOEMAIL_CHECKED"     => "$custom_toemail_checked",
          "DEFAULT_FROMEMAIL_CHECKED"  => "$default_fromemail_checked",
          "CUSTOM_FROMEMAIL_CHECKED"   => "$custom_fromemail_checked",
          "DEFAULT_EMAIL_CHECKED"      => "$default_email_checked",
          "CUSTOM_EMAIL_CHECKED"       => "$custom_email_checked",          
          "TO_MARK"                    => "$display_mark[tomail]",
          "FROM_MARK"                  => "$display_mark[frommail]",
          "EMAIL_MARK"                 => "$display_mark[email]",          
          "TO_MAILING_LIST"            => "$mailing_list",
          "SELECT_LIST"                => "$default_emails",
          "EMAIL_TEMPLATE"             => "$email_template",
          "TO_EMAIL"                   => $send_to,          
          "FROM_EMAIL"                 => $send_from
       ));

       $tpl_html->parse(TPL_SENDMAIL, "tpl_emml_sendmail");
       return $tpl_html->fetch(TPL_SENDMAIL);	                                     
   }
   
   function display_sendemail_build($sendmail_mark="") {
       
       global $tpl_html;
       global $sendmail;
       global $err_msg;
       global $admin_msg;
       global $emsql;
       global $admin_url;
       
       if($err_msg == "") {
         if($sendmail[radio_toemail] == "default_toemail"){
            if($sendmail[default_toemail] == "ALL") {
               $mailing_list = "$admin_msg[all_subscriber]";
            }
            else{
               $mailing_list .= get_preview_list($sendmail[default_toemail]);
            }

            $list_count = get_list_count($sendmail[default_toemail]);
            $mailing_list = "&lt;$mailing_list&gt; ($list_count subscribers)";          
            $maillist_id  = $sendmail[default_toemail];          
         }
         else{
            $mailing_list = $sendmail[custom_toemail];
            $maillist_id  = $sendmail[custom_toemail];          
         }   
       
         if($sendmail[radio_fromemail] == "default_fromemail"){          
            $fromemail = $sendmail[default_from_email];          
         }
         else{
            $fromemail = $sendmail[fromemail];          
         }
       
         if($sendmail[radio_email] == "default_email"){          
            if($sendmail[email_template] <> ""){                 
                $sql = "SELECT * FROM emml_email_template WHERE id = '$sendmail[email_template]'";
                $emsql->set_sql($sql);
                $result = $emsql->sql_execute();
                if($result){
                   if($emsql->sql_num_rows($result)){
                      $row = $emsql->sql_fetch_array($result);
                      $charset      = $row[charset];
                      $subject      = $row[subject];
                      $message      = $row[message];                 
                      $html_message = $row[html_message];                                  
                   }
                }          
            }
         }
         else{          
            $subject      = "";
            $message      = "";          
            $html_message = "";                    
         }
       }
       else{
            $toemail = trim($sendmail[toemail]);       

            if(!is_valid_email($toemail)){
              if($toemail == "ALL") {
                $mailing_list = "$admin_msg[all_subscriber]";
              }
              else{
                $mailing_list .= get_preview_list($toemail);
              }

              $list_count = get_list_count($toemail);
              $mailing_list = "&lt;$mailing_list&gt; ($list_count subscribers)";          
              $maillist_id  = $toemail;          
            }
            else{
              $mailing_list = $toemail;
              $maillist_id  = $toemail;          
            }  
            
            $fromemail    = $sendmail[fromemail];
            $charset      = $sendmail[charset];
            $subject      = $sendmail[subject];
            $message      = $sendmail[message];          
            $html_message = $sendmail[html_message]; 
       }
       
       if(get_magic_quotes_gpc()){           
          $charset      = htmlspecialchars(stripslashes(trim($charset)));
          $subject      = htmlspecialchars(stripslashes(trim($subject)));
          $message      = htmlspecialchars(stripslashes(trim($message)));
          $html_message = htmlspecialchars(stripslashes(trim($html_message)));
       }
       else{       
          $charset      = htmlspecialchars(trim($charset));
          $subject      = htmlspecialchars(trim($subject));
          $message      = htmlspecialchars(trim($message));
          $html_message = htmlspecialchars(trim($html_message));          
       }   

       $display_mark = get_mark($sendmail_mark);

       $charset_list = get_charset("sendmail[charset]",$charset);
                             
       $tpl_html ->assign( array( 
           "SCRIPT_URL"   => "$admin_url",                     
           "ERR_MSG"      => "$err_msg",
           "MAILLIST_ID"  => "$maillist_id",
           "TO_EMAIL"     => "$mailing_list",
           "FROM_EMAIL"   => "$fromemail",
           "CHARSET"      => "$charset_list",
           "SUBJECT"      => "$subject",
           "MESSAGE"      => "$message",
           "HTML_MESSAGE" => "$html_message",
           "SUBJECT_MARK" => "$display_mark[subject]",
           "MESSAGE_MARK" => "$display_mark[message]"
       ));        
       
       $tpl_html->parse(TPL_SENDMAIL_BUILD, "tpl_emml_sendmail_build");            
       return $tpl_html->fetch(TPL_SENDMAIL_BUILD);
   }

   function display_preview() {
       
       global $tpl_html;
       global $sendmail;
       global $err_msg;
       global $admin_msg;
       global $emsql;
       global $admin_url;
       global $charset;

       $toemail = trim($sendmail[toemail]);       

       if(!is_valid_email($toemail)){
          if($toemail == "ALL") {
             $mailing_list = "$admin_msg[all_subscriber]";
          }
          else{
             $mailing_list .= get_preview_list($toemail);
          }

          $list_count = get_list_count($toemail);
          $mailing_list = "&lt;$mailing_list&gt; ($list_count subscribers)";          
          $maillist_id  = $toemail;          
       }
       else{
          $mailing_list = $toemail;
          $maillist_id  = $toemail;          
       }  

       if(get_magic_quotes_gpc()){           
          $fromemail    = htmlspecialchars(stripslashes(trim($sendmail[fromemail])));                 
          $subject      = htmlspecialchars(stripslashes(trim($sendmail[subject])));
          $message      = htmlspecialchars(stripslashes(trim($sendmail[message])));
          $html_message = stripslashes(trim($sendmail[html_message]));          
          $sendmail[charset] = stripslashes(trim($sendmail[charset]));
       }
       else{
          $fromemail    = htmlspecialchars(trim($sendmail[fromemail]));                 
          $subject      = htmlspecialchars(trim($sendmail[subject]));
          $message      = htmlspecialchars(trim($sendmail[message]));
          $html_message = trim($sendmail[html_message]);                    
          $sendmail[charset] = trim($sendmail[charset]);
       }   

       $sendmail_id = md5(uniqid(rand()));
       $display_charset = $charset[$sendmail[charset]];

       $tpl_html ->assign( array( 
           "SCRIPT_URL"   => "$admin_url",                     
           "ERR_MSG"      => "$err_msg",
           "MAILLIST_ID"  => "$maillist_id",
           "TO_EMAIL"     => "$mailing_list",
           "FROM_EMAIL"   => "$fromemail",
           "CHARSET"      => "$display_charset",
           "SUBJECT"      => "$subject",
           "MESSAGE"      => "$message",
           "HTML_MESSAGE" => "$html_message",
           "SENDMAIL_ID"  => "$sendmail_id"
       ));        
       
       $sendmail[toemail]      = $maillist_id;
       $sendmail[fromemail]    = $fromemail;
       $sendmail[charset]      = $sendmail[charset];
       $sendmail[subject]      = $subject;
       $sendmail[message]      = $message;
       $sendmail[html_message] = $html_message;
       $sendmail[sendmail_id]  = $sendmail_id;
       
       save_sendmail($sendmail);
        
       $tpl_html->parse(TPL_SENDMAIL_PREVIEW, "tpl_emml_sendmail_preview");            
       return $tpl_html->fetch(TPL_SENDMAIL_PREVIEW);
   }

##############################################
   
########### email status functions ###########

   function display_emailstatus(){

       global $tpl_html;
       global $err_msg;
       global $page;
       global $default;
       global $admin_url;
       global $emsql;
       
       $page = intval($page);
        
       if($page == 0){
         $page = 1;
       }
        
       $lines = intval(get_options("display_lines"));
        
       if(!$lines){
         $lines = $default["display_lines"];
       }
       
       $sql = "SELECT * FROM emml_sendmail WHERE status <> 'R'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){
         $sendmail_count = $emsql->sql_num_rows($result);
       }

       if($sendmail_count % $lines <> 0){ 
          $max_page = floor($sendmail_count / $lines) + 1;
       }
       else{
          $max_page = $sendmail_count/$lines;
       }  
         
       if($page > $max_page){
          $page = $max_page;
       }

       $limit = ($page - 1) * $lines;

       $sql = "SELECT * , date_format(senddate, '%d-%b-%Y %H:%i:%S') as starttime , date_format(completeddate, '%d-%b-%Y %H:%i:%S') as endtime FROM emml_sendmail WHERE status = 'C' OR status = 'S'";
       $sql .= " ORDER BY senddate DESC LIMIT $limit,$lines";

       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
                     
       if($result){          
          if($emsql->sql_num_rows($result)){
             while($row = $emsql->sql_fetch_array($result)){

                $status = "";
                if($row[status] == "C") {
                  $status = "Completed";                
                }
                elseif($row[status] == "S"){
                  $status = "Processing";
                }
                
                $tpl_html ->assign( array( 
                   "TO"           => "$row[todesc]",
                   "VIEW_DETAILS" => "$admin_url?type=emailstatus&action=view_details&id=$row[id]",
                   "START_TIME"   => "$row[starttime]",
                   "END_TIME"     => "$row[endtime]",
                   "STATUS"       => "$status",
                   "ID"           => "$row[id]"
                ));        
                $tpl_html->parse(TPL_SENDMAIL_SEND_ROW, "tpl_emml_sendmail_status_row");            
                $sendmail_row .= $tpl_html->fetch(TPL_SENDMAIL_SEND_ROW);                
             }   
             $listcount = $emsql->sql_num_rows($result);
          }
       }  
       
       $link = "$admin_url?type=sendmail&action=view_sendmail&id=$id";
       $page_nav = get_page_nav($page,$sendmail_count,$lines,$link);        
       
       $tpl_html ->assign( array( 
          "SCRIPT_URL"   => "$admin_url",
          "LIST_COUNT"   => "$subscriber_count",          
          "ROWS"         => "$sendmail_row",
          "PAGE"         => "$page_nav",
          "REFRESH_LINK" => "$admin_url?type=emailstatus"
       ));               

       $tpl_html->parse(TPL_SENDMAIL_SEND, "tpl_emml_sendmail_status");            
       return $tpl_html->fetch(TPL_SENDMAIL_SEND);                  
       
   }
   
   function display_emailstatus_detail($sendmail_id){
       
       global $tpl_html;
       global $admin_msg;
       global $emsql;
       
       $sql = "SELECT * , date_format(senddate, '%d-%b-%Y %H:%i:%S') as starttime , date_format(completeddate, '%d-%b-%Y %H:%i:%S') as endtime FROM emml_sendmail WHERE id = '$sendmail_id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
                            
       if($result){          
          if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);
             
             if($row[status] == "C") {
                $status = "Completed";                
             }
             else{
                $status = "Pending";
             }
             
             $tpl_html ->assign( array( 
                "TO"           => "$row[todesc]",
                "FROM"         => "$row[fromemail]",
                "SUBJECT"      => "$row[subject]",
                "MESSAGE"      => "$row[message]",                
                "HTML_MESSAGE" => "$row[html_message]",                
                "START_TIME"   => "$row[starttime]",
                "END_TIME"     => "$row[endtime]",
                "STATUS"       => "$status",
                "ID"           => "$row[id]"
             ));        
          }
          else{
            return "$admin_msg[emailstatus_not_found]";
          }
       }  
       else{
          // database error
          display_db_err();
       }

       $tpl_html->parse(TPL_SENDMAIL_VIEW_DETAIL, "tpl_emml_sendmail_viewdetails");            
       return $tpl_html->fetch(TPL_SENDMAIL_VIEW_DETAIL);                         
       
   }
   
   function delete_emailstatus($sendmail_id) {
      
      global $emsql;
       
      if(gettype($sendmail_id) == "array"){       
        while(list($key,$val) = each($sendmail_id)){
          if($val == "Y"){
             $sql = "DELETE FROM emml_sendmail WHERE id = '$key'";
             $emsql->set_sql($sql);
             $result = $emsql->sql_execute();
          }
        }   
      }
      
   }
   
   function delete_old_emailstatus(){
      
      global $emsql;
      
      // 2 hours
      $expiredtime = 2 * 60 * 60;
      $expired = time() - $expiredtime;      
      $sql = "DELETE FROM emml_sendmail WHERE status <> 'C' AND unix_timestamp(senddate) <= '$expired'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
            
   }

##############################################
   
########### email template functions #########
   
   function validate_email_template($email_template,$id ,&$email_template_mark){
       
       global $admin_msg;
       global $emsql;

       $email_template_mark = array();
       
       $err_msg = "";       
       $email_template = html_code($email_template);          
       if( $email_template[name] == "" OR $email_template[subject] == "" OR ($email_template[message] == "" AND $email_template[html_message] == "")) {
          if($email_template[name] == ""){
             $err_msg .= $admin_msg["email_template_empty_name"]."<BR>";
             $email_template_mark[name] = true;
          }
          if($email_template[subject] == ""){
             $err_msg .= $admin_msg["email_template_empty_subject"]."<BR>";
             $email_template_mark[subject] = true;
          }
          if($email_template[message] == "" AND $email_template[html_message] == ""){
             $err_msg .= $admin_msg["email_template_empty_message"]."<BR>";
             $email_template_mark[message] = true;
             $email_template_mark[html_message] = true;
          }
       }
       else{
          
          if(get_magic_quotes_gpc()){
            $email_template[name] = addslashes($email_template[name]);          
          }          
          
          $sql = "SELECT * FROM emml_email_template WHERE name = '$email_template[name]'";
          $emsql->set_sql($sql); 
          $result = $emsql->sql_execute();

          if($result){

            if($emsql->sql_num_rows($result)){
              $row = $emsql->sql_fetch_array($result);
              if($id <> $row[id]){
                 $err_msg .= $admin_msg["email_template_name_exist"]."<BR>";
                 $email_template_mark[name] = true;
              }
            }
          }
          else{
            // database error
            display_db_err();
          }
       }
       return $err_msg;
   }

   function display_email_template_maint(){
   
        global $tpl_html;
        global $admin_url;
        global $emsql;
        
        $sql = "SELECT * FROM emml_email_template ORDER BY name";
        $emsql->set_sql($sql);
        $result = $emsql->sql_execute();
        
        $maillist_row = "";
        if($result){           
           while($row = $emsql->sql_fetch_array($result)){           
               $tpl_html ->assign( array( 
                   "TEMPLATE_NAME" => "$row[name]",               
                   "UPDATE_LINK"   => "$admin_url?type=email_template&action=update&id=$row[id]",
                   "DELETE_LINK"   => "$admin_url?type=email_template&action=delete&id=$row[id]"
               ));        
               $tpl_html->parse(TPL_MAILLIST_ROW, "tpl_emml_email_template_row");            
               $email_template_row .= $tpl_html->fetch(TPL_MAILLIST_ROW);	                                     
           }                      	                                     
        }
        else{
           // database error
           display_db_err();
        }
        
        $tpl_html ->assign( array( 
           "SCRIPT_URL" => "$admin_url",
           "ROWS"       => "$email_template_row"
        ));        
        $tpl_html->parse(TPL_MAILLIST_TABLE, "tpl_emml_email_template_table");            
        return $tpl_html->fetch(TPL_MAILLIST_TABLE);                     
   }
   
   function display_add_email_template($email_template_mark = "") {
       
       global $tpl_html;
       global $email_template;
       global $err_msg;
       global $admin_url;
       
       $email_template = html_code($email_template);

       $display_mark = get_mark($email_template_mark);
       $charset_list = get_charset("email_template[charset]",$email_template[charset]);

       $tpl_html ->assign( array( 
          "ERR_MSG"                => "$err_msg",
          "SCRIPT_URL"             => "$admin_url",
          "NAME_MARK"              => "$display_mark[name]",
          "SUBJECT_MARK"           => "$display_mark[subject]",
          "MESSAGE_MARK"           => "$display_mark[message]",
          "HTML_MESSAGE_MARK"      => "$display_mark[html_message]",
          "CHARSET"                => $charset_list,
          "EMAIL_TEMPLATE_NAME"    => "$email_template[name]",
          "EMAIL_TEMPLATE_SUBJECT" => "$email_template[subject]",
          "EMAIL_TEMPLATE_MESSAGE" => "$email_template[message]",
          "EMAIL_TEMPLATE_HTML_MESSAGE" => "$email_template[html_message]"
       ));        

       $tpl_html->parse(TPL_EMAIL_TEMPLATE_ADD, "tpl_emml_email_template_add");
       return $tpl_html->fetch(TPL_EMAIL_TEMPLATE_ADD);	                                     
   }

   function display_update_email_template($id,$email_template_mark="") {
       
       global $tpl_html;
       global $email_template;
       global $err_msg;
       global $admin_msg;
       global $admin_url;
       global $back_email_template;
       global $emsql;
              
       if($err_msg == ""){
       
         $sql = "SELECT * FROM emml_email_template WHERE id = '$id'";
         $emsql->set_sql($sql);
         $result = $emsql->sql_execute();

         if($result){          
            if($emsql->sql_num_rows($result)){
              $email_template = $emsql->sql_fetch_array($result);
              $display_email_template = html_code($email_template,false);
            }
            else {
              display_emml_admin_html($admin_msg["email_template_not_found"],$back_email_template);
              exit;
            }          
         }
         else {
           // database error
           display_db_err();
         }
                  
       } 
       else{
          $display_email_template = html_code($email_template);
       }
                     
       $display_mark = get_mark($email_template_mark);
       $charset_list = get_charset("email_template[charset]",$email_template[charset]);
       
       $tpl_html ->assign( array( 
          "ERR_MSG"                => "$err_msg",
          "ID"                     => "$id",
          "SCRIPT_URL"             => "$admin_url",
          "NAME_MARK"              => "$display_mark[name]",
          "SUBJECT_MARK"           => "$display_mark[subject]",
          "MESSAGE_MARK"           => "$display_mark[message]",
          "HTML_MESSAGE_MARK"      => "$display_mark[html_message]",                   
          "EMAIL_TEMPLATE_NAME"    => "$display_email_template[name]",
          "CHARSET"                => $charset_list,
          "EMAIL_TEMPLATE_SUBJECT" => "$display_email_template[subject]",
          "EMAIL_TEMPLATE_MESSAGE" => "$display_email_template[message]",
          "EMAIL_TEMPLATE_HTML_MESSAGE" => "$display_email_template[html_message]"          
       ));        

       $tpl_html->parse(TPL_EMAIL_TEMPLATE_UPDATE, "tpl_emml_email_template_update");
       return $tpl_html->fetch(TPL_EMAIL_TEMPLATE_UPDATE);
   }

   function display_delete_email_template($id) {
       
       global $tpl_html;
       global $email_template;
       global $err_msg;
       global $admin_msg;
       global $admin_url;
       global $emsql;
       global $charset;
              
       if($err_msg == ""){
       
         $sql = "SELECT * FROM emml_email_template WHERE id = '$id'";
         $emsql->set_sql($sql);
         $result = $emsql->sql_execute();

         if($result){          
            if($emsql->sql_num_rows($result)){
              $email_template = $emsql->sql_fetch_array($result);
              $display_email_template = html_code($email_template,false);
            }
            else {
              display_emml_admin_html($admin_msg["email_template_not_found"],$back_email_template);
              exit;            
            }          
         }
         else {
            // database error
            display_db_err();
         }
       }
       else{              
          $display_email_template = html_code($email_template);
       }   
              
       $tpl_html ->assign( array( 
          "ERR_MSG"                => "$err_msg",
          "ID"                     => "$id",
          "SCRIPT_URL"             => "$admin_url",
          "EMAIL_TEMPLATE_NAME"    => "$display_email_template[name]",
          "CHARSET"                => $charset[$display_email_template[charset]],
          "EMAIL_TEMPLATE_SUBJECT" => "$display_email_template[subject]",
          "EMAIL_TEMPLATE_MESSAGE" => "$display_email_template[message]",          
          "EMAIL_HTML_TEMPLATE_MESSAGE" => $display_email_template[html_message]
       ));        

       $tpl_html->parse(TPL_EMAIL_TEMPLATE_DELETE, "tpl_emml_email_template_delete");
       return $tpl_html->fetch(TPL_EMAIL_TEMPLATE_DELETE);	                                     
   }
   
   function add_email_template() {
       
       global $email_template;
       global $emsql;
       
       $emml_email_template_fields = array(
          "name"    => "$email_template[name]",          
          "subject" => "$email_template[subject]",
          "message" => "$email_template[message]",
          "html_message" => "$email_template[html_message]",
          "charset" => "$email_template[charset]"
       );             
                        
       $emsql->sql_insert("emml_email_template",$emml_email_template_fields);
       $result = $emsql->sql_execute();            
       return $result;
         
   }

   function update_email_template($id) {
       
       global $email_template;
       global $emsql;
       
       $sql = "SELECT * FROM emml_email_template WHERE id = '$id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){          
          if($emsql->sql_num_rows($result)){
            $emml_email_template_fields = array(
               "name"         => "$email_template[name]",
               "subject"      => "$email_template[subject]",
               "message"      => "$email_template[message]",
               "html_message" => "$email_template[html_message]",
               "charset"      => "$email_template[charset]"
            );                                     
            $emsql->sql_update("emml_email_template",$emml_email_template_fields," id = '$id'");
            $result = $emsql->sql_execute();            
            if($result){
              return "OK";
            }
            else{
              return "FAILED";
            }
          }
          else{
            return "email_template_not_found";
          }           
       }
       else{
         return "FAILED";
       }  
   }

   function delete_email_template($id) {
       
       global $emsql;
       
       $sql = "SELECT * FROM emml_email_template WHERE id = '$id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){          
          if($emsql->sql_num_rows($result)){
            $sql = "DELETE FROM emml_email_template WHERE id = '$id'";
            $emsql->set_sql($sql);
            $result = $emsql->sql_execute();
            if($result){
              return "OK";
            }
            else{
              return "FAILED";
            }
          }
          else{
            return "email_template_not_found";
          }           
       }
       else{
         return "FAILED";
       }  
   }

##############################################

########### HTML code ########################

   function validate_htmlcode($htmlcode,$id,&$htmlcode_mark){
   
       global $admin_msg;
       global $emsql;
       
       $err_msg = "";
       
       $htmlcode_mark = array(); 
       
       if(gettype($htmlcode) <> "array") {
          $htmlcode = array();
       }
       
       $htmlcode[listname]           = trim($htmlcode[listname]);       
       $htmlcode[template_html_path] = trim($htmlcode[template_html_path]);       
       $htmlcode[flag]               = trim($htmlcode[flag]);       
       
       if($htmlcode[listname] == "") {            
          $err_msg .= $admin_msg["htmlcode_empty_listname"] . "<BR>";
          $htmlcode_mark[listname] = true;
       }      

       $htmlcode_mark[maillist] = true;
       
       while(list($key,$val) = each($htmlcode)){
          if(substr($key,0,9) == "maillist_"){
              $htmlcode_mark[maillist] = false;     
          }
       }
       
       if($htmlcode_mark[maillist]){
          $err_msg .= $admin_msg["htmlcode_empty_maillist"] . "<BR>";
       }   
        
       if($htmlcode[template_html_path] == "") {            
          $err_msg .= $admin_msg["htmlcode_empty_html_path"] . "<BR>";
          $htmlcode_mark[template_html_path] = true;         
       }
       else {          
          if(!is_dir($htmlcode[template_html_path])){
             $err_msg .= $admin_msg["htmlcode_not_exist_html_path"] . "<BR>";
             $htmlcode_mark[template_html_path] = true;                   
          }
          else{

             if(!file_exists("$htmlcode[template_html_path]/template_emml.html")){
                 $err_msg .= "template_emml.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }

             if(!file_exists("$htmlcode[template_html_path]/template_emml_form.html")){
                 $err_msg .= "template_emml_form.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }

             if(!file_exists("$htmlcode[template_html_path]/template_emml_subscribe_form.html")){
                 $err_msg .= "template_emml_subscribe_form.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }

             if(!file_exists("$htmlcode[template_html_path]/template_emml_subscribe_row.html")){
                 $err_msg .= "template_emml_subscribe_row.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }

             if(!file_exists("$htmlcode[template_html_path]/template_emml_thankyou.html")){
                 $err_msg .= "template_emml_thankyou.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }                          

             if(!file_exists("$htmlcode[template_html_path]/template_emml_unsubscribe.html")){
                 $err_msg .= "template_emml_unsubscribe.html not found" . "<BR>";
                 $htmlcode_mark[template_html_path] = true;                                
             }                          
             
          }       
       }

       // subscribe email notification 
       
       if($htmlcode[sub_fromemail] == "") {            
          $err_msg .= "$admin_msg[htmlcode_empty_subscribe_fromemail]". "<BR>";
          $htmlcode_mark[sub_fromemail] = true;                         
       }      
       else{
          if(!is_valid_email($htmlcode[sub_fromemail])){
            $err_msg .= "$admin_msg[htmlcode_invalid_subscribe_fromemail]" . "<BR>";          
            $htmlcode_mark[sub_fromemail] = true;                           
          }
       }          
       
       if($htmlcode[sub_email] == ""){
          $err_msg .= $admin_msg[htmlcode_empty_subscribe_email] ."<BR>";
          $htmlcode_mark[sub_email] = true;                         
       }
       else {       
          $sql = "SELECT * FROM emml_email_template WHERE id = '$htmlcode[sub_email]'";
          $emsql->set_sql($sql);
          $result = $emsql->sql_execute();
          if($result){
             if (!$emsql->sql_num_rows($result)){
               $err_msg .= $admin_msg[htmlcode_subscribe_email_template_not_found] ."<BR>";
               $htmlcode_mark[sub_email] = true;
             }
          }
       }   
              
       // unsubscribe email notification 
              
       if($htmlcode[unsub_fromemail] == "") {            
          $err_msg .= "$admin_msg[htmlcode_empty_unsubscribe_fromemail]". "<BR>";
          $htmlcode_mark[unsub_fromemail] = true;                         
       }      
       else{
          if(!is_valid_email($htmlcode[unsub_fromemail])){
            $err_msg .= "$admin_msg[htmlcode_invalid_unsubscribe_fromemail]" . "<BR>";          
            $htmlcode_mark[unsub_fromemail] = true;                           
          }
       }          

       if($htmlcode[unsub_email] == ""){
          $err_msg .= $admin_msg[htmlcode_empty_unsubscribe_email] ."<BR>";
          $htmlcode_mark[unsub_email] = true;                         
       }
       else {       
          $sql = "SELECT * FROM emml_email_template WHERE id = '$htmlcode[unsub_email]'";
          $emsql->set_sql($sql);
          $result = $emsql->sql_execute();
          if($result){
             if (!$emsql->sql_num_rows($result)){
               $err_msg .= $admin_msg[htmlcode_unsubscribe_email_template_not_found] ."<BR>";
               $htmlcode_mark[unsub_email] = true;                                        
             }
          }
       }   
                            
       return $err_msg;             
   }

   function display_htmlcode(){

      global $tpl_html;      
      global $template_html_path,$os;
      global $emml_script_url;
      global $eternalmart;
      global $emml_image_url;
      global $emsql;
      global $admin_url;
      
      $sql = "SELECT * FROM emml_list";
      $emsql->set_sql($sql);
            
      $result = $emsql->sql_execute();
      
      if($result){
        $rows = "";
        while($row = $emsql->sql_fetch_array($result)){
           $show_lists = split ("\n", trim($row[maillist]));
           $list_id = join(",",$show_lists);
           
           $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' AND id IN ($list_id) ORDER BY id";
           $emsql->set_sql($sql);
           
           $maillist_result = $emsql->sql_execute();

           $mailing_lists = "";
           if($maillist_result){
              while($maillist_row = $emsql->sql_fetch_array($maillist_result)){
                $mailing_lists .= $maillist_row[listname] ."<BR>";
              }  
           }
           if($row[default_maillist] <> ""){
              $show_default_lists = split ("\n", trim($row[default_maillist]));
              $default_list_id = join(",",$show_default_lists);
           
              $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' AND id IN ($default_list_id) ORDER BY id";
              $emsql->set_sql($sql);
           
              $default_maillist_result = $emsql->sql_execute();

              $default_mailing_lists = "";
              if($default_maillist_result){
                 while($default_maillist_row = $emsql->sql_fetch_array($default_maillist_result)){
                   $default_mailing_lists .= $default_maillist_row[listname] ."<BR>";
                 }  
              }
           }      
           $form_link = "$emml_script_url?listid=$row[id]";
           $form_link = "<a href=\"$form_link\">$form_link</a>";
           
           if($row[flag] == "Y") {
              $flag = "Yes";
           }
           else{
              $flag = "No";
           } 

           $sub_fromemail      = trim($row["sub_frommail"]);
           $sub_email          = trim($row["sub_template"]);       
           $unsub_fromemail    = trim($row["unsub_frommail"]);          
           $unsub_email        = trim($row["unsub_template"]);        

           $sub_email_template   = get_email_template_name($sub_email);
           $unsub_email_template = get_email_template_name($unsub_email);         

           $tpl_html ->assign( array( 
               "MAILLIST_FORM_NAME" => "$row[listname]",               
               "MAILING_LISTS"      => "$mailing_lists",
               "DEFAULT_MAILING_LISTS" => "$default_mailing_lists",
               "FORM_TEMPLATE_PATH" => "$row[template_html_path]",
               "FORM_LINK"          => "$form_link",
               "SUBMISSION"         => "$flag",
               "SUB_EMAIL"          => "$sub_email_template",
               "UNSUB_EMAIL"        => "$unsub_email_template",         
               "SUB_FROMEMAIL"      => "$sub_fromemail",          
               "UNSUB_FROMEMAIL"    => "$unsub_fromemail",
               "UPDATE_FORM"        => "$admin_url?type=htmlcode&action=update&id=$row[id]",
               "DELETE_FORM"        => "$admin_url?type=htmlcode&action=delete&id=$row[id]",
               "HTML"               => "$admin_url?type=htmlcode&action=html&id=$row[id]"            
           ));        
           $tpl_html->parse(TPL_EMML_HTMLCODE_ROW, "tpl_emml_htmlcode_row");         
           $rows .= $tpl_html->fetch(TPL_EMML_HTMLCODE_ROW);
        }
      }
      
      $tpl_html ->assign( array( 
          "ADD_FORM" => "$admin_url?type=htmlcode&action=add",       
          "ROWS"     => $rows
      ));        

      $tpl_html->parse(TPL_HTMLCODE_TABLE, "tpl_emml_htmlcode_table");            
      $html = $tpl_html->fetch(TPL_HTMLCODE_TABLE);	                                     

      return $html;
   
   }

   function add_htmlcode($htmlcode) {
      
      global $emsql;
      
      $htmlcode[listname]           = trim($htmlcode[listname]);
      $htmlcode[template_html_path] = trim($htmlcode[template_html_path]);
      $htmlcode[flag]               = trim($htmlcode[flag]);
      $htmlcode[sub_fromemail]      = trim($htmlcode[sub_fromemail]);
      $htmlcode[sub_email]          = trim($htmlcode[sub_email]);
      $htmlcode[unsub_fromemail]    = trim($htmlcode[unsub_fromemail]);
      $htmlcode[unsub_email]        = trim($htmlcode[unsub_email]);
      
      while(list($key,$val) = each($htmlcode)){
         $is_maillist = false; 
         if(substr($key,0,9) == "maillist_"){
            $maillist .= substr($key,9)."\n";
            if($htmlcode["default_maillist_".substr($key,9)] <> ""){
               $default_maillist .= substr($key,9)."\n";
            }
         }
      }

      $emml_list_fields = array(
         "listname"           => "$htmlcode[listname]",
         "maillist"           => "$maillist",
         "default_maillist"   => "$default_maillist",
         "template_html_path" => "$htmlcode[template_html_path]",
         "flag"               => "$htmlcode[flag]",
         "sub_frommail"       => "$htmlcode[sub_fromemail]",
         "sub_template"       => "$htmlcode[sub_email]", 
         "unsub_frommail"     => "$htmlcode[unsub_fromemail]",
         "unsub_template"     => "$htmlcode[unsub_email]"         
      );
      
      $emsql->sql_insert("emml_list",$emml_list_fields);
      $result = $emsql->sql_execute();
      return $result;
   }  

   function update_htmlcode($id,$htmlcode){
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_list WHERE id = '$id'";
      $emsql->set_sql($sql);

      $result = $emsql->sql_execute();
      if($result){
         if($emsql->sql_num_rows($result)){
         
            $listname           = trim($htmlcode[listname]);
            $template_html_path = trim($htmlcode[template_html_path]);
            $flag               = trim($htmlcode[flag]);
            $sub_fromemail      = trim($htmlcode[sub_fromemail]);
            $sub_email          = trim($htmlcode[sub_email]);       
            $unsub_fromemail    = trim($htmlcode[unsub_fromemail]);          
            $unsub_email        = trim($htmlcode[unsub_email]);                 
            
            while(list($key,$val) = each($htmlcode)){
               if(substr($key,0,9) == "maillist_"){
                  $maillist .= substr($key,9)."\n";
                  if($htmlcode["default_maillist_".substr($key,9)] <> ""){
                    $default_maillist .= substr($key,9)."\n";
                  }
               }
            }

            $emml_list_fields = array(         
               "listname"           => "$listname",
               "maillist"           => "$maillist",
               "default_maillist"   => "$default_maillist",
               "template_html_path" => "$template_html_path",
               "flag"               => "$flag",
               "sub_frommail"       => "$sub_fromemail",
               "sub_template"       => "$sub_email",       
               "unsub_frommail"     => "$unsub_fromemail",          
               "unsub_template"     => "$unsub_email]"                                
            );                       
            
            $emsql->sql_update("emml_list",$emml_list_fields,"id='$id'");

            $result = $emsql->sql_execute();
            if($result){
              return "OK";
            }
            else{
              return "FAILED";
            }
         }
         else{
            return "htmlcode_not_found";
         }
      }
      else{
        return "FAILED";
      }               
   }

   function delete_htmlcode($id){
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_list WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
         if(!$emsql->sql_num_rows($result)){
            return "htmlcode_not_found";
         }
      }
      else{
         return "FAILED";
      }      
      
      $emsql->sql_delete("emml_list","id = '$id'");         
      $result = $emsql->sql_execute();
      if(!$result){
         return "FAILED";        
      }

      return "OK";
   }   

   function display_add_htmlcode($htmlcode_mark = ""){

      global $tpl_html;
      global $admin_url;
      global $htmlcode;
      global $err_msg;
      global $emsql;
      global $admin_msg;
                  
      if(get_magic_quotes_gpc()){                             
          $htmlcode_listname  = htmlspecialchars(stripslashes(trim($htmlcode[listname])));
          $htmlcode_html_path = htmlspecialchars(stripslashes(trim($htmlcode[template_html_path])));          
          $flag               = htmlspecialchars(stripslashes(trim($htmlcode[flag])));          
          $sub_fromemail      = htmlspecialchars(stripslashes(trim($htmlcode["sub_fromemail"])));
          $unsub_fromemail    = htmlspecialchars(stripslashes(trim($htmlcode["unsub_fromemail"])));          
      }
      else{
          $htmlcode_listname  = htmlspecialchars(trim($htmlcode[listname]));
          $htmlcode_html_path = htmlspecialchars(trim($htmlcode[template_html_path]));          
          $flag               = htmlspecialchars(trim($htmlcode[flag]));          
          $sub_fromemail      = htmlspecialchars(trim($htmlcode["sub_fromemail"]));
          $unsub_fromemail    = htmlspecialchars(trim($htmlcode["unsub_fromemail"]));                    
      }   
       
      $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' ORDER BY id";
      $emsql->set_sql($sql);
      
      $is_empty_maillist = true;
      
      $result = $emsql->sql_execute();
      if($result){
         while($row = $emsql->sql_fetch_array($result)){
            $is_empty_maillist = false;

            $checked = "";  
            $default_checked = "";
            if(gettype($htmlcode) == "array") {
               reset($htmlcode);
               while(list($key,$val) = each($htmlcode)){
                  if($key == "maillist_".$row[id]){
                     $checked = "CHECKED";
                  }               
                  if($key == "default_maillist_".$row[id]){
                     $default_checked = "CHECKED";
                  }               
               }
            }               
            $maillist .= "<INPUT TYPE=CHECKBOX NAME=htmlcode[maillist_".$row[id]."] $checked>" . $row[listname] . "<BR>";
            $default_maillist .= "<INPUT TYPE=CHECKBOX NAME=htmlcode[default_maillist_".$row[id]."] $default_checked>" . $row[listname] . "<BR>";
         }      
      }
      
      $display_mark = get_mark($htmlcode_mark); 
      
      $flag_yes = "";
      $flag_no = "";
      if($flag == "Y") {
        $flag_yes = "SELECTED";
      }
      else{
        $flag_no = "SELECTED";
      }

      $sql = "SELECT count(*) as email_template_count FROM emml_email_template";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      
      $is_empty_email_template = true;
      
      if($result) {
         $row = $emsql->sql_fetch_array($result);         
         if($row["email_template_count"]){
            $is_empty_email_template = false;

            $sub_email_template   = get_email_template("",$htmlcode["sub_email"]);
            $sub_email_template   = "<SELECT NAME=\"htmlcode[sub_email]\">$sub_email_template</SELECT>";
            $unsub_email_template = get_email_template("",$htmlcode["unsub_email"]);
            $unsub_email_template = "<SELECT NAME=\"htmlcode[unsub_email]\">$unsub_email_template</SELECT>";         
         }
      }
      
      $tmp = "";
      if($is_empty_maillist){

         $tmp = $admin_msg["htmlcode_create_mailing_list"]."<BR>";
      
      }

      if($is_empty_email_template){
         $tmp .= $admin_msg["htmlcode_create_email_template"];
      }   
      
      if($tmp <> ""){
        return $tmp;
      }
     
      $tpl_html ->assign( array( 
         "SCRIPT_URL"           => "$admin_url",
         "MSG"                  => "$err_msg", 
         "LISTNAME_MARK"        => "$display_mark[listname]",        
         "MAILLIST_MARK"        => "$display_mark[maillist]",                 
         "HTML_MARK"            => "$display_mark[template_html_path]",                 
         "LISTNAME"             => "$htmlcode_listname",
         "MAILLIST"             => "$maillist",
         "DEFAULT_MAILLIST"     => "$default_maillist",
         "TEMPLATE_HTML_PATH"   => "$htmlcode_html_path",
         "SUB_FROMEMAIL_MARK"   => $display_mark[sub_fromemail],
         "SUB_EMAIL_MARK"       => $display_mark[sub_email],
         "UNSUB_FROMEMAIL_MARK" => $display_mark[unsub_fromemail],
         "UNSUB_EMAIL_MARK"     => $display_mark[unsub_email],         
         "SUB_FROMEMAIL"        => "$sub_fromemail",          
         "SUB_EMAIL"            => "$sub_email_template",
         "UNSUB_EMAIL"          => "$unsub_email_template",
         "UNSUB_FROMEMAIL"      => "$unsub_fromemail",
         "FLAG_YES"             => "$flag_yes",
         "FLAG_NO"              => "$flag_no"
      ));        
      
      $tpl_html->parse(TPL_EMML_HTMLCODE_ADD, "tpl_emml_htmlcode_add");               
      return $tpl_html->fetch(TPL_EMML_HTMLCODE_ADD);  
   }

   function display_update_htmlcode($id,$htmlcode_mark = ""){
        
      global $tpl_html; 
      global $admin_url;
      global $err_msg;
      global $htmlcode;
      global $admin_msg;
      global $back_htmlcode;
      global $emsql;

      $formsubject = trim($form[formsubject]);

      $listname           = trim($htmlcode[listname]);
      $template_html_path = trim($htmlcode[template_html_path]);
      $flag               = trim($htmlcode[flag]);
      $sub_fromemail      = trim($htmlcode["sub_fromemail"]);
      $sub_email          = trim($htmlcode["sub_email"]);       
      $unsub_fromemail    = trim($htmlcode["unsub_fromemail"]);          
      $unsub_email        = trim($htmlcode["unsub_email"]);                 

      if($err_msg == ""){ 
         $sql = "SELECT * FROM emml_list WHERE id = '$id'";
         $emsql->set_sql($sql);
         $result = $emsql->sql_execute();
         if($result){          
            if($emsql->sql_num_rows($result)){
              $row = $emsql->sql_fetch_array($result);
              $listname           = trim($row[listname]);
              $template_html_path = trim($row[template_html_path]);
              $htmlcode_maillist  = split("\n",trim($row[maillist]));
              $htmlcode_default_maillist  = split("\n",trim($row[default_maillist]));
              $flag               = trim($row[flag]);              
              $sub_fromemail      = trim($row["sub_frommail"]);
              $sub_email          = trim($row["sub_template"]);       
              $unsub_fromemail    = trim($row["unsub_frommail"]);          
              $unsub_email        = trim($row["unsub_template"]);                 
                                          
              for($i=0;$i<count($htmlcode_maillist);$i++){
                 $htmlcode["maillist_".$htmlcode_maillist[$i]] = "Y"; 
              }              

              for($i=0;$i<count($htmlcode_default_maillist);$i++){
                 $htmlcode["default_maillist_".$htmlcode_default_maillist[$i]] = "Y"; 
              }              
             
            }
            else{             
              display_emml_admin_html($admin_msg[htmlcode_not_found],$back_htmlcode);  
              exit;                   
            }  
         }
      }  

      if(get_magic_quotes_gpc() AND getenv("REQUEST_METHOD") == "POST"){                             
          $listname           = htmlspecialchars(stripslashes(trim($listname)));
          $template_html_path = htmlspecialchars(stripslashes(trim($template_html_path)));          
          $flag               = htmlspecialchars(stripslashes(trim($flag)));                    
          $sub_fromemail      = htmlspecialchars(stripslashes(trim($sub_fromemail)));
          $sub_email          = htmlspecialchars(stripslashes(trim($sub_email)));       
          $unsub_fromemail    = htmlspecialchars(stripslashes(trim($unsub_fromemail)));          
          $unsub_email        = htmlspecialchars(stripslashes(trim($unsub_email)));                           
      }       
      else{
          $listname           = htmlspecialchars(trim($listname));
          $template_html_path = htmlspecialchars(trim($template_html_path));          
          $flag               = htmlspecialchars(trim($flag));                    
          $sub_fromemail      = htmlspecialchars(trim($sub_fromemail));
          $sub_email          = htmlspecialchars(trim($sub_email));       
          $unsub_fromemail    = htmlspecialchars(trim($unsub_fromemail));          
          $unsub_email        = htmlspecialchars(trim($unsub_email));                                     
      }   
              
      $display_mark = get_mark($html_mark);

      $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' ORDER BY id";
      $emsql->set_sql($sql);
      
      $result = $emsql->sql_execute();
      $is_empty_maillist = true;
      if($result){
          while($row = $emsql->sql_fetch_array($result)){
             $is_empty_maillist = false;
             $checked = "";  
             $default_checked = "";
             reset($htmlcode);
             while(list($key,$val) = each($htmlcode)){
                if($key == "maillist_".$row[id]){
                  $checked = "CHECKED";
                }               
                if($key == "default_maillist_".$row[id]){
                  $default_checked = "CHECKED";
                }               
             }
             $maillist .= "<INPUT TYPE=CHECKBOX NAME=htmlcode[maillist_".$row[id]."] $checked>" .$row[listname] ."<BR>";
             $default_maillist .= "<INPUT TYPE=CHECKBOX NAME=htmlcode[default_maillist_".$row[id]."] $default_checked>" .$row[listname] ."<BR>";
          }      
      }

      $flag_yes = "";
      $flag_no = "";
      if($flag == "Y") {
         $flag_yes = "SELECTED";
      }
      else{
         $flag_no = "SELECTED";
      }

      $sql = "SELECT count(*) as email_template_count FROM emml_email_template";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      $is_empty_email_template = true;
      if($result) {
          $row = $emsql->sql_fetch_array($result);         
          if($row["email_template_count"]){
             $is_empty_email_template = false;
             $sub_email_template   = get_email_template("",$sub_email);
             $sub_email_template   = "<SELECT NAME=\"htmlcode[sub_email]\">$sub_email_template</SELECT>";
             $unsub_email_template = get_email_template("",$unsub_email);
             $unsub_email_template = "<SELECT NAME=\"htmlcode[unsub_email]\">$unsub_email_template</SELECT>";         
          }
      }

      $tmp = "";
      if($is_empty_maillist){
         $tmp = $admin_msg["htmlcode_create_mailing_list"]."<BR>";      
      }

      if($is_empty_email_template){
         $tmp .= $admin_msg["htmlcode_create_email_template"];
      }   
      
      if($tmp <> ""){
        return $tmp;
      }
        
      $tpl_html ->assign( array( 
          "SCRIPT_URL"           => "$admin_url",
          "ID"                   => "$id",          
          "MSG"                  => "$err_msg", 
          "LISTNAME_MARK"        => "$display_mark[listname]",        
          "MAILLIST_MARK"        => "$display_mark[maillist]",                 
          "HTML_MARK"            => "$display_mark[template_html_path]",                 
          "LISTNAME"             => "$listname",
          "MAILLIST"             => "$maillist",
          "DEFAULT_MAILLIST"     => "$default_maillist",
          "TEMPLATE_HTML_PATH"   => "$template_html_path",
          "SUB_FROMEMAIL_MARK"   => $display_mark[sub_fromemail],
          "SUB_EMAIL_MARK"       => $display_mark[sub_email],
          "UNSUB_FROMEMAIL_MARK" => $display_mark[unsub_fromemail],
          "UNSUB_EMAIL_MARK"     => $display_mark[unsub_email],         
          "SUB_EMAIL"            => "$sub_email_template",
          "UNSUB_EMAIL"          => "$unsub_email_template",         
          "SUB_FROMEMAIL"        => "$sub_fromemail",          
          "UNSUB_FROMEMAIL"      => "$unsub_fromemail",
          "FLAG_YES"             => "$flag_yes",
          "FLAG_NO"              => "$flag_no"
      ));        

      $tpl_html->parse(TPL_EMML_HTMLCODE_UPDATE, "tpl_emml_htmlcode_update");
      return $tpl_html->fetch(TPL_EMML_HTMLCODE_UPDATE);
   }

   function display_delete_htmlcode($id){
        
       global $tpl_html; 
       global $admin_url;
       global $admin_msg;
       global $back_htmlcode;
       global $emsql;
       
       $sql = "SELECT * FROM emml_list WHERE id = '$id'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){          
          if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);

             if($row[flag] == "Y") {
               $flag = "Yes";
             }
             else{
               $flag = "No";             
             }
             
             $maillist_id = join(",",split("\n",$row[maillist]));
             
             $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' AND id IN ($maillist_id) ORDER BY id";
             $emsql->set_sql($sql);
      
             $maillist_result = $emsql->sql_execute();
             if($maillist_result){
                 while($maillist_row = $emsql->sql_fetch_array($maillist_result)){
                    $maillist .= $maillist_row[listname] ."<BR>";
                }      
             }

             $default_maillist_id = join(",",split("\n",$row[default_maillist]));
             
             $sql = "SELECT * FROM emml_maillist WHERE ispublic <> 'N' AND id IN ($default_maillist_id) ORDER BY id";
             $emsql->set_sql($sql);
      
             $default_maillist_result = $emsql->sql_execute();
             if($default_maillist_result){
                 while($default_maillist_row = $emsql->sql_fetch_array($default_maillist_result)){
                    $default_maillist .= $default_maillist_row[listname] ."<BR>";
                }      
             }

             $sub_fromemail      = trim($row["sub_frommail"]);
             $sub_email          = trim($row["sub_template"]);       
             $unsub_fromemail    = trim($row["unsub_frommail"]);          
             $unsub_email        = trim($row["unsub_template"]);        

             $sub_email_template   = get_email_template_name($sub_email);
             $unsub_email_template = get_email_template_name($unsub_email);         
       
             $tpl_html ->assign( array( 
                "SCRIPT_URL"         => "$admin_url",
                "ID"                 => "$id",          
                "MSG"                => "$err_msg", 
                "LISTNAME"           => "$row[listname]",
                "MAILLIST"           => "$maillist",
                "DEFAULT_MAILLIST"           => "$default_maillist",
                "TEMPLATE_HTML_PATH" => "$row[template_html_path]",
                "FLAG"               => "$flag",
                "SUB_EMAIL"          => "$sub_email_template",
                "UNSUB_EMAIL"        => "$unsub_email_template",         
                "SUB_FROMEMAIL"      => "$sub_fromemail",          
                "UNSUB_FROMEMAIL"    => "$unsub_fromemail"
             ));        
  
             $tpl_html->parse(TPL_EMML_HTMLCODE_DELETE, "tpl_emml_htmlcode_delete");            
             return $tpl_html->fetch(TPL_EMML_HTMLCODE_DELETE);	                                                  
          }
          else{
             display_emml_admin_html($admin_msg[htmlcode_not_found],$back_htmlcode);  
             exit;                                
          }
       }
   }

   function display_htmlcode_html($id){

      global $tpl_html;      
      global $template_html_path,$os;
      global $emml_script_url;
      global $eternalmart;
      global $emml_image_url;
      global $emsql;

      $sql = "SELECT * FROM emml_list WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){          
         if($emsql->sql_num_rows($result)){
            $row = $emsql->sql_fetch_array($result);
            $template_html_path = trim($row[template_html_path]);
            $htmlcode_maillist  = split("\n",trim($row[maillist]));             
                                          
            for($i=0;$i<count($htmlcode_maillist);$i++){
               $htmlcode["maillist_".$htmlcode_maillist[$i]] = "Y"; 
            }              
          }
          else{             
            display_emml_admin_html($admin_msg[htmlcode_not_found],$back_htmlcode);  
            exit;                   
          }  
      }
      
      $tpl_form = new FastTemplate($template_html_path,$os);
      $tpl_form->no_strict();
      $tpl_form->define(array(
         "tpl_emml_form" => "template_emml_form.html"
      ));
          
      $tpl_form->assign( array( 
        "SCRIPT_URL"           => "$emml_script_url",
        "DEFAULT_MAILING_LIST" => "$default_mailing_list",
        "COPYRIGHT"            => "$eternalmart",
        "IMAGE_URL"            => "$emml_image_url",
        "LISTID"               => "$id"    
      ));  
      
      $tpl_form->parse(TPL_SUBSCIRBE_FORM, "tpl_emml_form");            
      $html = $tpl_form->fetch(TPL_SUBSCIRBE_FORM);	                                     

      $tpl_html ->assign( array( 
          "SUBSCRIBE_FORM" => "$html",              
          "HTMLCODE"       => htmlspecialchars(trim($html))
      ));        

      $tpl_html->parse(TPL_HTMLCODE, "tpl_emml_htmlcode_html");            
      $html = $tpl_html->fetch(TPL_HTMLCODE);	                                     

      return $html;
   
   }

##############################################

########### setting functions ################
   
   function validate_setting($setting,&$setting_mark){
       
       global $admin_msg;
       global $emsql;

       $err_msg = "";
       
       $setting_mark = array();
              
       //validate login username
       if($setting[username] == "") {            
          $err_msg .= "$admin_msg[setting_empty_username]". "<BR>";
          $setting_mark[username] = true;                         
       }
              
       // validate no. of result shown
       $int_display_lines = intval(trim($setting[display_lines]));
       if($int_display_lines <= 0){
          $err_msg .= "$admin_msg[setting_display_lines]<BR>";
          $setting_mark[display_lines] = true;
       }
       
       // validate admin email
       if($setting[admin_email] == "") {            
          $err_msg .= "$admin_msg[setting_empty_admin_email]". "<BR>";
          $setting_mark[admin_email] = true;                         
       }      
       else{
          if(!is_valid_email($setting[admin_email])){
            $err_msg .= "$admin_msg[setting_invalid_admin_email]" . "<BR>";          
            $setting_mark[admin_email] = true;                           
          }
       }          
                     
       // validate default from email address       
       if(get_magic_quotes_gpc()){           
          $setting[default_emails] = stripslashes($setting[default_emails]);    
       }
       
       if(trim($setting[default_emails]) <> ""){
          $email_address = split ("\n", trim($setting[default_emails]));
          for($i=0;$i<count($email_address);$i++){
             $email_address[$i] = trim($email_address[$i]);
             if(!is_valid_email($email_address[$i]) && $email_address[$i] <> ""){
               $strtmp = ereg_replace( "#EMAIL#", "$email_address[$i]", $admin_msg["setting_default_fromemail"]);
               $err_msg .= $strtmp . "<BR>";
               $setting_mark[default_email] = true;
             }
          }
       }
                            
       return $err_msg;      
   }

   function update_setting(){
       
       global $setting;
       global $emsql;
       
       if($setting[password] == ""){
          $sql = "DELETE FROM emml_options WHERE option_key <> 'password'";
       }
       else{
          $sql = "DELETE FROM emml_options";       
       }
       
       $emsql->set_sql($sql);
       
       $result = $emsql->sql_execute();
       if($result){
          reset($setting);
          while(list($key,$val) = each($setting)) {    
                  
            if($key == "password" && trim($val) == ""){
                continue;
            }

            $emml_options_fields = array(                   
                 "option_key"   => "$key",
                 "option_value" => "$val"         
            );     
            $emsql->sql_insert("emml_options",$emml_options_fields);                
            $result = $emsql->sql_execute();             
          }          
       }
       else{
          // database error
          display_db_err();
       }
       return $result;
   }

   function get_settings(){
       
       global $default;
       global $emsql;
       
       $sql = "SELECT * FROM emml_options";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       
       if($result) {
          while($row = $emsql->sql_fetch_array($result)){
             $default[$row[option_key]] = trim($row[option_value]);            
          }
       }
       else{
          // database error
          display_db_err();
       }
       return $default;   
   }
   
   function display_setting_maint($setting_mark) {
       
       global $tpl_html;
       global $setting;
       global $err_msg;
       global $admin_url;
       global $admin_msg;
       global $emsql;
       
       if($err_msg) {
          $default_setting = $setting;
       }
       else{          
          $default_setting = get_settings();
       }   
       
       $default_emails = $default_setting["default_emails"];
       
       $email_address = split ("\n", trim($default_emails));
       $default_emails = "";
       for($i=0;$i<count($email_address);$i++){    
          $email_address[$i] = trim($email_address[$i]);       
          if($email_address[$i] <> ""){
            $default_emails .= "$email_address[$i]\n";    
          }          
       }  
                                   
       for ($i = 10 ; $i<=200;$i = $i + 10) {       
         $selected = "";
         if($i == $default_setting["display_lines"]) {
           $selected = "SELECTED";
         }
         $default_num_result .= "<OPTION VALUE=\"$i\" $selected>$i</OPTION>";
       }  

       if(get_magic_quotes_gpc()){           
          $default_emails           = htmlspecialchars(stripslashes($default_emails));       
          $admin_email              = htmlspecialchars(stripslashes(trim($default_setting["admin_email"])));
       }
       else{
          $default_emails           = htmlspecialchars($default_emails);       
          $admin_email              = htmlspecialchars(trim($default_setting["admin_email"]));          
       }
              
       $display_mark = get_mark($setting_mark);
       
       if($default_setting[email_sender] == "Y") {        
          $email_sender_yes = "CHECKED";
          $email_sender_no  = "";
       }
       else{
          $email_sender_yes = "";
          $email_sender_no  = "CHECKED";       
       }

       if($default_setting[email_admin] == "Y") {        
          $email_admin_yes  = "CHECKED";
          $email_admin_no   = "";      
       }
       else{
          $email_admin_yes  = "";
          $email_admin_no   = "CHECKED";      
       }
         
       $tpl_html ->assign( array( 
          "SCRIPT_URL"            => "$admin_url",              
          "ERR_MSG"               => "$err_msg",
          "USERNAME_MARK"         => $display_mark[username],
          "DISPLAY_LINES_MARK"    => $display_mark[display_lines],
          "ADMIN_EMAIL_MARK"      => $display_mark[admin_email],          
          "DEFAULT_EMAIL_MARK"    => $display_mark[default_email],
          "USERNAME"              => "$default_setting[username]",
          "DEFAULT_NUM_RESULT"    => "$default_num_result",
          "EMAIL_SENDER_YES"      => "$email_sender_yes",
          "EMAIL_SENDER_NO"       => "$email_sender_no",
          "EMAIL_ADMIN_YES"       => "$email_admin_yes",
          "EMAIL_ADMIN_NO"        => "$email_admin_no",
          "ADMIN_EMAIL"           => "$admin_email",                   
          "DEFAULT_EMAIL"         => "$default_emails"
       ));        

       $tpl_html->parse(TPL_SETTING, "tpl_emml_setting");            
       return $tpl_html->fetch(TPL_SETTING);	                                     

   }

##############################################

   function html_code($array, $is_gpc = true){       
       if(gettype($array) == "array"){
          while(list($key,$val) = each($array)){
            if($is_gpc){
               if(get_magic_quotes_gpc()){
                  $array[$key] = htmlspecialchars(stripslashes(trim($val)));
               }
               else{
                  $array[$key] = htmlspecialchars(trim($val));
               }                  
            }   
            else{
               $array[$key] = htmlspecialchars(trim($val));
            }   
          }  
       }
       else{
         $array = array();
       }       
       return $array;
   }

   function get_page_nav($page,$total,$count,$link){
       
       if($count > 0) {
         if($total % $count <> 0){ 
           $max_page = floor($total / $count) + 1;
         }
         else{
           $max_page = $total/$count;
         }  
       }  
       for($i = 1; $i <= $max_page ; $i++){       
          if($page == $i){           
             $str .= "$i &nbsp;";           
          }
          else{
             $str .= "<a href=\"$link&page=$i\">$i</a> &nbsp;";
          }   
       }       
       if($str <> ""){
          $str = "Page : $str";
       }       
       return $str;              
   }
   
   function is_subscribe_mailing_list($subscriber){
       
      $is_subscribe = false;
      while(list($key,$val) = each($subscriber)) {  
        if($val == "Y"){
          $is_subscribe = true;
          break;
        }            
      }       
      return $is_subscribe;        
   }
   
   function get_options($key){
       
      global $emsql; 
       
      $sql = "SELECT * FROM emml_options WHERE emml_options.option_key = '$key'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){           
         if($emsql->sql_num_rows($result)){              
            $row = $emsql->sql_fetch_array($result);
            return $row[option_value];              
         }
         else{
            return array();
         }           
      }
      else{
        return "";
      }       
   }

   function is_subscriber_exist($email){
       
       global $emsql;
       
       $email = trim($email);
       $sql = "SELECT * FROM emml_subscriber WHERE emailaddress = '$email'";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       
       if($result){
          if($emsql->sql_num_rows($result)){
            return $result;
          } 
          else{
            return "";
          }          
       }
       else{
         return "db_err";
       }
       
   }

   function get_subscribed_mailing_list($email){
      
      global $tpl_html;      
      global $emsql;
      
      $str = "";      
      $email = trim($email);      
      $sql = "SELECT C.listname FROM emml_subscriber AS A,emml_mail_subscribe AS B, emml_maillist AS C WHERE C.id = B.maillistid AND A.id = B.emailid AND A.emailaddress = '$email' ORDER BY C.listname";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){                  
         while($row = $emsql->sql_fetch_array($result)){
            $str .= "$row[listname]<BR>";
         }         
      }          
      return $str;
   }

   function get_mailing_list($list){

      global $tpl_html;
      global $admin_url;
      global $emsql;
     
      $sql = "SELECT * FROM emml_maillist ORDER BY id";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
     
      if($result){         
         if($emsql->sql_num_rows($result)){
             while($row = $emsql->sql_fetch_array($result)){            
               $checked = "";
               if($list[$row[id]] <> "") {
                  $checked = "CHECKED";
               }            
                        
               $tpl_html->assign( array( 
                  "MAILLIST_ID" => "$row[id]",
                  "CHECKED"     => "$checked",
                  "LISTNAME"    => "$row[listname]",
                  "LISTDESC"    => "$row[listdesc]"
               ));             
               $tpl_html->parse(TPL_EMML_SUBSCRIBER_MAILLIST_ROWS, "tpl_emml_subscriber_maillist_row"); 
               $emml_subscribe_rows .= $tpl_html->fetch(TPL_EMML_SUBSCRIBER_MAILLIST_ROWS);	                 
             }
                  
             return $emml_subscribe_rows;	                          
         }    
         else{
           return "";
         }           
     }
     else {        
         // database error
         display_db_err();
     }     
   }

   function get_preview_list($id){
      
      global $emsql;
      
      $str = "";
      $sql = "SELECT * FROM emml_maillist WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
     
      if($result){         
         if($emsql->sql_num_rows($result)){
            $row = $emsql->sql_fetch_array($result);
            $str = $row[listname];
         }   
      }      
      return $str;            
   }

   function get_sendmail_list($default = 0){
      
      global $emsql;
      
      $str = "";
      $sql = "SELECT * FROM emml_maillist ORDER BY id";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
     
      if($result){         
         while($row = $emsql->sql_fetch_array($result)){            
            $checked = "";
            if(trim($row[id]) == trim($default) ) {
              $checked = "SELECTED";
            }                      
            
            $list_count = get_list_count($row[id]);
              
            $str .= "<OPTION VALUE=\"$row[id]\" $checked>&lt;$row[listname]&gt; ($list_count subscribers)</OPTION>";
         }
      }      
      return $str;               
   }
         
   function get_email_template($msg,$id) {
       
       global $emsql;
       
       $sql = "SELECT * FROM emml_email_template ORDER BY name";
       $emsql->set_sql($sql);
       $result = $emsql->sql_execute();
       if($result){
          while($row = $emsql->sql_fetch_array($result)){
             $row[name] = htmlspecialchars(trim($row[name]));
             $selected = "";
             if($row[id] == $id){
               $selected = "SELECTED";
             }
             $email_template .= "<OPTION VALUE=\"$row[id]\" $selected >$row[name]</OPTION>\n";
          }
       }
       $email_template = "<OPTION VALUE=\"\">$msg</OPTION>\n".$email_template;
       return $email_template;
   }

   function get_default_emails ($msg,$emails,$default_email){
   
       $email_address = split ("\n", trim($emails));
       $emails = "";
       for($i=0;$i<count($email_address);$i++){    
          $email_address[$i] = trim($email_address[$i]);       
          if($email_address[$i] <> ""){
            if($email_address[$i] == $default_email) {
               $emails .= "<OPTION VALUE=\"$email_address[$i]\" SELECTED>$email_address[$i]</OPTION>\n";    
            }
            else{
               $emails .= "<OPTION VALUE=\"$email_address[$i]\">$email_address[$i]</OPTION>\n";                
            }               
          }          
       }         
       $emails = "<OPTION VALUE=\"\">$msg</OPTION>\n" . $emails;           
       return $emails;          
   }
   
   function get_mark($mark_array){
       
       global $mark;
       $display_mark = array();
       if(gettype($mark_array) == "array"){
          while(list($key,$val) = each($mark_array)){
             if($val == true) {
               $display_mark[$key] = "$mark";
             }
          }
       }       
       return $display_mark;
   }
   
   function display_db_err(){

       global $admin_msg;
       global $emsql;
       
       // database error
       if($emsql->get_errno()){
          $errmsg = $emsql->get_errmsg();
       }
       display_emml_admin_html($admin_msg[db_err]."<BR>".$errmsg);
       exit;                       
   
   }

   function convert_htmlspecialchars($str){
   
      $char = array( 
         "&amp;"  => "&",
         "&quot;" => "\"" ,
         "&lt;"   => "<",
         "&gt;"   => ">"
      );    
      
      while(list($key,$val) = each($char)){
        $str = str_replace($key,$val,$str);
      }        
      return $str;      
   }
     
   function sendout_email($id,$mode = false){     
   
      global $emsql;          

      // for sending email test
      if($mode){
         $sql = "SELECT * FROM emml_sendmail WHERE id = '$id'";
      }
      else{
         $sql = "SELECT * FROM emml_sendmail WHERE id = '$id' AND status = 'S'";
      }   

      $emsql->set_sql($sql); 
      $result = $emsql->sql_execute();

      if($result){

         if($emsql->sql_num_rows($result)){
             $row = $emsql->sql_fetch_array($result);
             $emml_toemail      = $row["toemail"];
             $emml_fromemail    = $row["fromemail"];
             $emml_charset      = $row["charset"];
             $emml_subject      = $row["subject"];
             $emml_message      = $row["message"];              
             $emml_html_message = $row["html_message"];
         }
         else{
           // record not found
         }      
      }
      else{
         // db error
      }
      
      // for sending email test
      if($mode){
         $default = get_settings();
         // send email
         $email_info = array(
            "to_email"     => $default[admin_email],
            "from_email"   => $emml_fromemail,
            "charset"      => $emml_charset,
            "subject"      => $emml_subject,
            "message"      => $emml_message,
            "html_message" => $emml_html_message,            
            "email_sender" => "Y"
         );
         $rc = set_email_content($email_info,false);
         send_email($email_info,$rc);
         exit;         
      }
   
      if($emml_toemail == "ALL") {
         $sql = "SELECT DISTINCT(A.emailaddress) FROM emml_subscriber AS A , emml_mail_subscribe AS B WHERE A.id = B.emailid";
      }     
      elseif(ereg("([0-9])$",$emml_toemail)){
         $sql = "SELECT DISTINCT(A.emailaddress) FROM emml_subscriber AS A , emml_mail_subscribe AS B WHERE A.id = B.emailid AND B.maillistid = '$emml_toemail'";
      }
      else{
         // send email
         $email_info = array(
            "to_email"     => $emml_toemail,
            "from_email"   => $emml_fromemail,
            "charset"      => $emml_charset,
            "subject"      => $emml_subject,
            "message"      => $emml_message,
            "html_message" => $emml_html_message,            
            "email_sender" => "Y"
         );
         $rc = set_email_content($email_info,false);
         send_email($email_info,$rc);         
         update_sendmail($id);
         exit;
      }

      $emsql->set_sql($sql);
 
      $result = $emsql->sql_execute();
      if($result){      
         $email_info = array(
            "from_email"   => $emml_fromemail,
            "charset"      => $emml_charset,
            "subject"      => $emml_subject,
            "message"      => $emml_message,
            "html_message" => $emml_html_message,
            "email_sender" => "Y"
         );

         $rc = set_email_content($email_info,false);      
         
         while($row = $emsql->sql_fetch_array($result)){
            $email_info[to_email] = $row["emailaddress"];
            send_email($email_info,$rc);
         }      
      }
      update_sendmail($id);      
   }

   function update_sendmail($id){
    
      global $emsql;   
  
      $emml_sendmail_fields = array(
        "status"        => "C",
        "completeddate" => date("Y-m-d H:i:s")
      );
   
      $emsql->sql_update("emml_sendmail",$emml_sendmail_fields,"id = '$id'");
   
      return $emsql->sql_execute();        
   }
   
   function get_email_template_name($id) {
      
      global $emsql;
      
      $sql = "SELECT * FROM emml_email_template WHERE id = '$id'";
      $emsql->set_sql($sql);
      $result = $emsql->sql_execute();
      if($result){
         if($emsql->sql_num_rows($result)){
            $email_template_row = $emsql->sql_fetch_array($result);
            return $email_template_row[name];
         }
      }
      
      return "";
   }
   
   function is_php_execute($file_path){
      
      return is_executable($file_path);
      
   }
   
   function get_charset($name,$default = ""){
      
      global $charset;
     
      if(gettype($charset) == "array"){
         while(list($key,$val)=each($charset)){
            $selected = "";
            if($key == $default){
              $selected = "SELECTED";
            }
            $str .= "<OPTION VALUE=\"$key\" $selected>$val</OPTION>";
         } 
      }
      $str = "<SELECT NAME=\"$name\">$str</SELECT>";
      return $str;
   } 
?>
