<?
//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//                                   MiniGal                                        //
//                                                                                  //
//                        Copyright © 2004 Thomas Rybak                             //
//                      http://www.thomasrybak.com/minigal                          //
//                           minigal@thomasrybak.com                                //
//                                                                                  //
//    MiniGal is free software; you can redistribute it and/or modify               //
//    it under the terms of the GNU General Public License as published by          //
//    the Free Software Foundation; either version 2 of the License, or             //
//    (at your option) any later version.                                           //
//                                                                                  //
//    MiniGal is distributed in the hope that it will be useful,                    //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of                //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 //
//    GNU General Public License for more details.                                  //
//                                                                                  //
//    You should have received a copy of the GNU General Public License             //
//    along with this program; if not, you can find it here:                        //
//    http://www.gnu.org/copyleft/gpl.html                                          //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////
class MGadmin
{
  var $headline;
  var $gallerytitle;
  var $adminpass;
  var $gallerydir;
  var $upload_height;
  var $upload_width;
  var $upload_quality;
  var $version;

//////////////////////////////
//                          //
//       IS DIR EMPTY       //
//                          //
//////////////////////////////
  function is_dir_empty($dir)
  {
    $allowed_files = array(".jpg",".jpeg",".gif",".png",".mov",".avi",".mpg",".mpeg",".wmv",".asf");
    if (is_dir($dir)) {
      $dl = opendir($dir);
      if ($dl) {
        while($name = readdir($dl)) {
          if (!is_file($name) && $name != "thumbs" && $name != "." && $name != "..") {
            return false;
            break;
          } else
          if (!is_dir($name) && in_array(strtolower(strrchr($name, ".")), $allowed_files)) {
            return false;
            break;
          }
        }
        closedir($dl);
      }
    return true;
    } else return true;
  }


//////////////////////////////
//                          //
//     ADMIN NAVIGATION     //
//                          //
//////////////////////////////
  function navigation()
  {
    $headline = $this->gallerytitle;
    $updirs = explode("/", rtrim($this->list, "/"));
    $dircount = count($updirs);
    $dirstring="";
    $updirstring="";
    if ($dircount > 0 && strlen($this->list) > 0) {
      echo "<a href=\"admin.php\">" . $this->lang["gallery"] . "</a>";
      for ($i=0; $i < ($dircount - 1); $i++) {
        $updirstring .= "$updirs[$i]/";
        if (strlen($updirs[$i]) > 0) {
          $dirstring .= " &gt; <a href=\"admin.php?list=" . rtrim($updirstring,"/") . "\">" . $updirs[$i] . "</a>";
        }
      }
      $this->headline = $updirs[$dircount-1];
    } else echo "&nbsp;";
    echo $dirstring;
  } //EOF

//////////////////////////////
//                          //
//       SETUP TABLE        //
//                          //
//////////////////////////////
  function setupconfig()
  {
    if (isset($_SERVER["SCRIPT_FILENAME"])) $preset1 = dirname($_SERVER["SCRIPT_FILENAME"]);
    $preset2 = ".";
    if (isset($_SERVER["SERVER_ADMIN"])) { $preset3 = $_SERVER["SERVER_ADMIN"]; } else { $preset3 = "- change this -"; }
    $this->settings = array("MiniGal", $preset2, $preset3, "standard", "1", "1", "1", "0", "1024", "j.m.Y, H:i", "4", "5", "150", "150", "85", "Copyright © " . date("Y"), "1234");
    $this->settingsname = array($this->lang["setting1"],  $this->lang["setting2"],  $this->lang["setting3"],  $this->lang["setting4"], 
      $this->lang["setting5"],  $this->lang["setting6"],  $this->lang["setting7"],  $this->lang["setting8"],  $this->lang["setting9"], 
      $this->lang["setting10"], $this->lang["setting11"], $this->lang["setting12"], $this->lang["setting13"], $this->lang["setting14"], 
      $this->lang["setting15"], $this->lang["setting16"], $this->lang["setting17"]);
    $this->settingshelp = array($this->lang["help1"],
      $this->lang["help2"]. "<br />" . $this->lang["help3"] . ": <font color=\"black\">$preset2</font><br />" . $this->lang["help4"] . ": <font color=\"black\">$preset1</font>",
      $this->lang["help5"],  $this->lang["help6"],  $this->lang["help7"],  $this->lang["help8"],  $this->lang["help9"], 
      $this->lang["help10"], $this->lang["help11"], $this->lang["help12"], $this->lang["help13"], $this->lang["help14"],
      $this->lang["help15"], $this->lang["help16"], $this->lang["help17"], $this->lang["help18"], $this->lang["help19"]);
  } //EOF

//////////////////////////////
//                          //
//      INITIAL SETUP       //
//                          //
//////////////////////////////
  function initialsetup()
  {
    if (!is_file("settings.php")) {
      if (!isset($_REQUEST["initialsetup"])) {
        $this->setupconfig();
        echo "
        <html>
        <head>
          <title>" . $this->lang["first setup"] . "</title>
          <meta name=\"robots\" content=\"noindex,nofollow\">
          <meta http-equiv=\"Content-Type\" content=\"text/html; charset=$this->charset\" />
          <link href=\"styles/shared/admin.css\" rel=\"stylesheet\" type=\"text/css\">
        </head>
        <body>
          <div align=\"center\">
            <h1>" . $this->lang["welcome"] . "</h1>
          </div>
          <table class=\"admintable\" cellpadding=\"0\" cellspacing=\"1\" border=\"1\" width=\"80%\" align=\"center\">
          <tr>
            <td class=\"adminh1\" colspan=\"4\">" . $this->lang["initial"] . "</td>
          </tr>
          <tr>
            <form action=\"admin.php\" method=\"post\" enctype=\"multipart/form-data\">
        ";
        for ($i = 0; count($this->settings) > $i && strlen($this->settings[$i]) > 0; $i++) {
          if ($i == 3) {
            echo "
            <td class=\"admintdleft\">" . $this->settingsname[$i] . "</td>";
            if (is_dir("styles")) {
              echo "
              <td class=\"admintdleft\" valign=\"top\">
                <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
              $workdir = opendir("styles");
              $stylearray = "";
              while (false !== ($pointer = readdir($workdir))) {
                if (is_dir("styles/$pointer") && $pointer !== "." && $pointer !== ".." && $pointer !== "shared") {
                  $stylearray[] = $pointer;
                }
              }
              sort($stylearray);
              for($x=0; $x < count($stylearray); $x++) {
                if ($this->settings[$i] == $stylearray[$x]) {
                  echo "
                  <option value=\"" . $stylearray[$x] . "\" selected=\"selected\">" . $stylearray[$x] . "</option>";
                } else 
                if (is_dir("styles/" . $stylearray[$x]) && $stylearray[$x] !== "." && $stylearray[$x] !== "..") {
                  echo "
                  <option value=\"" . $stylearray[$x] . "\">" . $stylearray[$x] . "</option>";
                }
              }

              echo "
                </select>
              </td>";
            } else echo $this->lang["nostyles"];
            echo "
              <td class=\"admintdleft\">" . $this->settingshelp[$i] . "</td>
            </tr>
            <tr>";
          } else if ($i == 4 || $i == 5 || $i == 6|| $i == 7) {
            //YES/NO DROPDOWNS
             echo "
              <td class=\"admintdleft\">" . $this->settingsname[$i] . "</td>
              <td class=\"admintdleft\">
                <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
              if ($this->settings[$i] == "1") {
                echo "
                <option value =\"1\" selected=\"selected\">" . $this->lang["yes"] . "</option>";
              } else echo "
                <option value =\"1\">" . $this->lang["yes"] . "</option>";
              if ($this->settings[$i] == "0") {
                echo "
                <option value =\"0\" selected=\"selected\">" . $this->lang["no"] . "</option>";
              } else echo "
                <option value =\"0\">" . $this->lang["no"] . "</option>";
              echo "
                </select>
              </td>
              <td class=\"admintdleft\">" . $this->settingshelp[$i] . "</td>
            </tr>
            <tr>";
          } else if ($i == 8) { 
            //SCREEN SIZE DROPDOWN
            echo "
              <td class=\"admintdleft\">" . $this->settingsname[$i] . "</td>
              <td class=\"admintdleft\">
                <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
              if ($this->settings[$i] == "1280") {
                echo "
                <option value =\"1280\" selected=\"selected\">1280x1024</option>";
              } else echo "
                <option value =\"1280\">1280x1024</option>";
              if ($this->settings[$i] == "1024") {
                echo "
                <option value =\"1024\" selected=\"selected\">1024x768</option>";
              } else echo "
                <option value =\"1024\">1024x768</option>";
              if ($this->settings[$i] == "800") {
                echo "
                <option value =\"800\" selected=\"selected\">800x600</option>";
              } else echo "
                <option value =\"800\">800x600</option>";
              if ($this->settings[$i] == "640") {
                echo "
                <option value =\"640\" selected=\"selected\">640x480</option>";
              } else echo "
                <option value =\"640\">640x480</option>";
              if ($this->settings[$i] == "320") {
                echo "
                <option value =\"320\" selected=\"selected\">320x200</option>";
              } else echo "
                <option value =\"320\">320x200</option>";
              if ($this->settings[$i] == "0") {
                echo "
                <option value =\"0\" selected=\"selected\">" . $this->lang["no"] . "</option>";
              } else echo "
                <option value =\"0\">" . $this->lang["no"] . "</option>";
              echo "
                </select>
              </td>
              <td class=\"admintdleft\">" . $this->settingshelp[$i] . "</td>
            </tr>
            <tr>";
          } else if ($i == 9) //DATE FORMAT DROPDOWNS
          {
            echo "
              <td class=\"admintdleft\">" . $this->settingsname[$i] . "</td>
              <td class=\"admintdleft\">
                <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
            if ($settings[$i] == "j.m.Y, H:i") {
              echo "
                <option value =\"j.m.Y, H:i\" selected=\"selected\">" . $this->lang["DMY"] . "</option>";
            } else echo "
                <option value =\"j.m.Y, H:i\">" . $this->lang["DMY"] . "</option>";
            if ($settings[$i] == "m.j.Y, H:i") {
              echo "
                <option value =\"m.j.Y, H:i\" selected=\"selected\">" . $this->lang["MDY"] . "</option>";
            } else echo "
                <option value =\"m.j.Y, H:i\">" . $this->lang["MDY"] . "</option>";
            echo "
                </select>
              </td>
              <td class=\"admintdleft\">" . $this->settingshelp[$i] . "</td>
            </tr>
            <tr>";
          } else echo "
              <td class=\"admintdleft\">" . $this->settingsname[$i] . "</td>
              <td class=\"admintdleft\"><input type=\"text\" size=\"30\" value=\"" . $this->settings[$i] . "\" name=\"newsetting$i\" class=\"admintext\" /></td>
              <td class=\"admintdleft\">" . $this->settingshelp[$i] . "</td>
            </tr>
            <tr>";
        }
        if ($_REQUEST["debug"] == "yes") {
          echo "
              <input type=\"hidden\" name=\"debug\" value=\"yes\" />";
        }
        echo "
              <td class=\"admintd\" colspan=\"4\"><input type=\"submit\" value=\"" . $this->lang["savesettings"] . "\" name=\"initialsetup\" class=\"adminbutton\" /></td>
            </tr>
            </form>
          </table>
        </body>
        </html>";
        exit();
      }
    }
    // WRITE SETTINGS TO FILE
    if (isset($_REQUEST["initialsetup"]) || @$_REQUEST["status"] == $this->lang["status2"]) {
      $filebuffer = "<?\n";
      $filebuffer.= "$"."gallerytitle = ".chr(34).$_REQUEST["newsetting0"].chr(34).";\n";
      $filebuffer.= "$"."gallerydir = ".chr(34).$_REQUEST["newsetting1"].chr(34).";\n";
      $filebuffer.= "$"."owneremail = ".chr(34).$_REQUEST["newsetting2"].chr(34).";\n";
      $filebuffer.= "$"."activestyle = ".chr(34).$_REQUEST["newsetting3"].chr(34).";\n";
      $filebuffer.= "$"."sendmail = ".chr(34).$_REQUEST["newsetting4"].chr(34).";\n";
      $filebuffer.= "$"."showexif = ".chr(34).$_REQUEST["newsetting5"].chr(34).";\n";
      $filebuffer.= "$"."showcomments = ".chr(34).$_REQUEST["newsetting6"].chr(34).";\n";
      $filebuffer.= "$"."thumbcaptions = ".chr(34).$_REQUEST["newsetting7"].chr(34).";\n";
      $filebuffer.= "$"."resizelargeimg = ".chr(34).$_REQUEST["newsetting8"].chr(34).";\n";
      $filebuffer.= "$"."dateformat = ".chr(34).$_REQUEST["newsetting9"].chr(34).";\n";
      $filebuffer.= "$"."images_side = ".chr(34).$_REQUEST["newsetting10"].chr(34).";\n";
      $filebuffer.= "$"."pagerows = ".chr(34).$_REQUEST["newsetting11"].chr(34).";\n";
      $filebuffer.= "$"."upload_height = ".chr(34).$_REQUEST["newsetting12"].chr(34).";\n";
      $filebuffer.= "$"."upload_width = ".chr(34).$_REQUEST["newsetting13"].chr(34).";\n";
      $filebuffer.= "$"."upload_quality = ".chr(34).$_REQUEST["newsetting14"].chr(34).";\n";
      $filebuffer.= "$"."gallerycopyright = ".chr(34).str_replace("©","&copy;",$_REQUEST["newsetting15"]).chr(34).";\n";
      if (isset($_SESSION["password"]) && !isset($_REQUEST["initialsetup"])) {
        $filebuffer .= "$"."adminpass = ".chr(34).$_SESSION["password"].chr(34).";\n";
      } else {
        $filebuffer .= "$"."adminpass = ".chr(34).md5($_REQUEST["newsetting16"]).chr(34).";\n";
      }
      $filebuffer .= "$"."version = ".chr(34).$this->version.chr(34).";\n";
      $filebuffer .= "?>";
      $fd = fopen("settings.php","w+");
      fwrite($fd,$filebuffer);
      fclose($fd);
      return $_REQUEST["status"];

    }
  }//EOF

//////////////////////////////
//                          //
//      ACCESS CONTROL      //
//                          //
//////////////////////////////
  function accesscontrol()
  {
    //Check pwd match, then set login var
    if (@md5($_REQUEST["password"]) == $this->adminpass && !isset($_SESSION["password"])) {
      $_SESSION["password"] = md5($_REQUEST["password"]);
      $_SESSION["accesstime"] = time();
    }

    //Check for login
    if ($_SESSION["password"] != $this->adminpass) {
      if (isset($_REQUEST["password"]) && md5($_REQUEST["password"]) != $this->adminpass) {
        echo "<div class=\"adminstatus\">" . $this->lang["wrongpwd"] . "<br /></div>\n";
      } 
?>
<table cellpadding="0" class="admintable" cellspacing="1" width="750" align="center">
  <tr>
    <td class="adminh1"><? echo $this->lang["admin"] ?>: <?echo $gallerytitle ?></td>
  </tr>
  <tr>
    <td class="admintd">
      <form name="login" method="post" action="admin.php">
        <p><? echo $this->lang["requirepwd"] ?></p>
        <p><input type="password" name="password" class="admintext" /></p>
        <p><input type="submit" name="loginsubmit" value="Enter" class="adminbutton" /></p>
      </form>
    </td>
  </tr>
</table>
</body>
</html>
<?
    session_destroy();
    exit();
    }
    // Renew timestamp if time not exceded
    elseif ((time() - $_SESSION["accesstime"]) < 900) {
      $_SESSION["accesstime"] = time();
    } else { 
      // Do security logoff
      unset($_SESSION["password"]);
      unset($_SESSION["accesstime"]);
      session_destroy();
?>
<div align="center">
  <h1><? echo $this->lang["securitylogoff1"] ?></h1>
  <p><? echo $this->lang["securitylogoff2"] ?></p>
  <p><a href="admin.php"><? echo $this->lang["login"] ?></a></p>
</div>
</body>
</html>
        
<?
      exit();
    }
    //Logout
    if (@$_REQUEST["action"] == "logoff") {
      unset($_SESSION["password"]);
      unset($_SESSION["accesstime"]);
      session_destroy();
?>
<div align="center">
  <h1><? echo $this->lang["logoff1"] ?></h1>
  <p><? echo $this->lang["logoff2"] ?></p>
  <p><a href="admin.php"><? echo $this->lang["login"] ?></a></p>
</div>
</body>
</html>
<?
      exit();
    }
  } //EOF


//////////////////////////////
//                          //
//   DROPDOWN FOLDER LIST   //
//                          //
//////////////////////////////
  function dirdropdown($base) {
    if (is_dir($base)) {
      $dh = opendir($base);
      while (false !== ($dir = readdir($dh))) {
        if (is_dir($base . $dir) && $dir !== "." && $dir !== ".." && $dir !== "thumbs" && $dir !== "styles" && $dir !== "minigal" && $dir !== "counter") {
          $subs = $dir;
          $subbase = $base . $dir . "/";
          echo "
        <option value=\"$subbase\">" . rtrim(str_replace($this->gallerydir,"",$subbase),"/") . "</option>";
          $this->dirdropdown($subbase);
        }
      }
      closedir($dh);
    }
  }//EOF

//////////////////////////////
//                          //
//         UPLOADS          //
//                          //
//////////////////////////////
  function uploads()
  {
    if (isset($this->list)) { $this->list .= "/"; }
    if (!is_dir("$this->gallerydir/" . $this->list . "thumbs")) { mkdir("$this->gallerydir/" . $this->list . "thumbs", 0755); }
    $std_upheight = $this->upload_height;
    $std_upwidth = $this->upload_width;
    $status = $this->lang["status1"];
    for ($x = 0; $x < 10; $x++) {
      $this->upload_width = $std_upwidth;
      $this->upload_height = $std_upheight;
      if (!is_file("$this->gallerydir/" . $this->list . $_FILES["file" . $x]["name"])) {
        // UPLOAD SCRIPT
        if ($_FILES["file". $x]["size"] > 0) {
            $fra = $_FILES["file" . $x]["tmp_name"];
            $tempname = $_FILES["file" . $x]["name"];
            $til = "$this->gallerydir/" . $this->list . "$tempname";
            if (function_exists("move_uploaded_file")) {
              move_uploaded_file($fra, $til);
              chmod($til,0755);
            } else {
              copy($fra, $til);
              chmod($til,0755);
            }

          // MAKE THUMBNAIL(S)
          $size = getimagesize($til);
          $filnavn = "$this->gallerydir/" . $this->list . "thumbs/tn_$tempname";
          $fileInfo = pathinfo($_FILES["file" . $x]["name"]);
          $extension = strtolower($fileInfo["extension"]);
          $rcount = 1;
          $upwidth = $this->upload_width;
          $upheight = $this->upload_height;

          // IS MEDIUMSIZED PIC NEEDED
          if ($this->resizelargeimg > 0 && ($size[0] > ($this->resizelargeimg-100) || $size[1] > ($this->resizelargeimg-100))) {
            $rcount = 2;
          }
          for ($i=1; $i <= $rcount; $i++) {
            // MEDIUMDSIZED PICTURE SETTINGS
            if ($i == 2) {
              $filnavn = "$this->gallerydir/" . $this->list . "thumbs/tn_med_$tempname";
              if ($size[0] > $size[1]) { $upwidth = $this->resizelargeimg - 100; }
              else { $upheight = $this->resizelargeimg - 100; }
            }
            if ($extension == "png") {
              // UPLOAD PNG FILE
            
              if ($size[0] > $size[1]) { 
                //Checker for Tværformat / Højformat.
                $upheight = ($upwidth/$size[0]) * $size[1]; // Regner højden ud så jeg ikke får et distorted billed.
                $src_img = imagecreatefrompng("$til"); //GD starter med at generer billedt.
                $dst_img = imagecreatetruecolor($upwidth, $upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagepng($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
                imagedestroy($src_img);
                imagedestroy($dst_img);
              } else { 
                // Ellers er billedet højformat og kører samme smøre igen.
                $upwidth = ($upheight/$size[1]) * $size[0];
                $src_img = imagecreatefrompng("$til");
                $dst_img = imagecreatetruecolor($upwidth,$upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagepng($dst_img, "$filnavn", $this->upload_quality);
                imagedestroy($src_img);
                imagedestroy($dst_img);
              }
            } else
            if ($extension == "gif") {
              // UPLOAD GIF FILE
            
              if ($size[0] > $size[1]) { //Checker for Tværformat / Højformat.
                $upheight = ($upwidth/$size[0]) * $size[1]; // Regner højden ud så jeg ikke får et distorted billed.
                $src_img = imagecreatefromgif ("$til"); //GD starter med at generer billedt.
                $dst_img = imagecreatetruecolor($upwidth, $upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagejpeg($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
                imagedestroy($src_img);
                imagedestroy($dst_img);
              } else { 
                // Ellers er billedet højformat og kører samme smøre igen.
                $upwidth = ($upheight/$size[1]) * $size[0];
                $src_img = imagecreatefromgif ("$til");
                $dst_img = imagecreatetruecolor($upwidth,$upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagejpeg($dst_img, "$filnavn", $this->upload_quality);
                imagedestroy($src_img);
                imagedestroy($dst_img);
              }
            } else
            if ($extension == "jpg" or $extension == "jpeg") { 
              // UPLOAD JPG/JPEG FILE
              if ($size[0] > $size[1]) {
                //Checker for Tværformat / Højformat.
                $upheight = ($upwidth/$size[0]) * $size[1]; // Regner højden ud så jeg ikke får et distorted billed.
                $src_img = imagecreatefromjpeg("$til"); //GD starter med at generer billedt.
                $dst_img = imagecreatetruecolor($upwidth, $upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagejpeg($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
                imagedestroy($src_img);
                imagedestroy($dst_img);
              } else { 
                // Ellers er billedet højformat og kører samme smøre igen.
                $upwidth = ($upheight/$size[1])*$size[0];
                $src_img = imagecreatefromjpeg("$til");
                $dst_img = imagecreatetruecolor($upwidth,$upheight);
                imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $upwidth, $upheight, $size[0], $size[1]);
                imagejpeg($dst_img, "$filnavn", $this->upload_quality);
                imagedestroy($src_img);
                imagedestroy($dst_img);
              }
            } else
            if ($extension == "mov" || $extension == "avi" || $extension == "mpg" || $extension == "mpeg" || $extension == "wmv" || $extension == "asf") {
            // MOVIE SUPPORT
            
            }
          }
        }
      } else {
        $status = $this->lang["status3"];
      }
    }
    if (strlen($this->list) > 0) { $this->list = rtrim($this->list, "/"); }
    return $status;
  }//EOF

//////////////////////////////
//                          //
//       FILEACTIONS        //
//                          //
//////////////////////////////
  function fileactions($action)
  {
    // DELETE FOLDER
    if ($action == "deletedir") {
      if (strlen($this->list)>0) { $this->list .= "/"; }
      if (get_magic_quotes_gpc() && isset($_REQUEST["folder"])) { $folder = stripslashes($_REQUEST["folder"]); } else $folder = $_REQUEST["folder"];
      if (is_file("$this->gallerydir/" . $this->list . "thumbs/tn_thumb.jpg")) { unlink("$this->gallerydir/" . $this->list . "thumbs/tn_thumb.jpg"); }
      if (is_file("$this->gallerydir/" . $this->list . $folder."/description.dir")) { unlink("$this->gallerydir/" . $this->list . $folder."/description.dir"); }
      if (is_file("$this->gallerydir/" . $this->list . $folder."/caption.dir")) { unlink("$this->gallerydir/" . $this->list . $folder."/caption.dir"); }
      if (is_file("$this->gallerydir/" . $this->list . $folder."/locked.dir")) { unlink("$this->gallerydir/" . $this->list . $folder."/locked.dir"); }
      if ($this->is_dir_empty($this->list . $folder) === true) {
        if (is_dir($this->list . $folder)) {
          @chmod($this->list . $folder,0777);
          if (is_dir("$this->gallerydir/" . $this->list . $folder . "/thumbs")) {
            @chmod("$this->gallerydir/" . $this->list . $folder . "/thumbs",0777);
            rmdir("$this->gallerydir/" . $this->list . $folder . "/thumbs");
          }
          rmdir($this->list . $folder);
          $this->list = rtrim($this->list, "/");
          return $this->lang["status4"];
        } else return $this->lang["status5"];
      } else {
        $this->list = rtrim($this->list, "/");
        return $this->lang["status6"];
      }
    }

    // DELETE FILES
    if ($_REQUEST["whataction"] == "delete") {
      if (isset($this->list)) { $this->list .= "/"; }
      for ($x=0; $x < $_REQUEST["i"]; $x++) {
        if (get_magic_quotes_gpc() && isset($_REQUEST["selectfile" . $x])) { 
          $file = stripslashes($_REQUEST["selectfile" . $x]);
        } else $file = $_REQUEST["selectfile" . $x];
        if (is_file("$this->gallerydir/" . $this->list . $file)) {
          //Does original file exist (reload page fix)
          @chmod("$this->gallerydir/" . $this->list . $file, 0777);
          unlink("$this->gallerydir/" . $this->list . $file);
          unlink("$this->gallerydir/" . $this->list . "thumbs/tn_" . $file);
          if (is_file("$this->gallerydir/" . $this->list . "thumbs/tn_med_" . $file)) { 
            unlink("$this->gallerydir/" . $this->list . "thumbs/tn_med_" . $file); }
          if (is_file("$this->gallerydir/" . $this->list . "thumbs/" . $file . ".cmt")) { 
            unlink("$this->gallerydir/" . $this->list . "thumbs/" . $file . ".cmt"); }
          if (is_file("$this->gallerydir/" . $this->list . "thumbs/" . $file . ".txt")) { 
            unlink("$this->gallerydir/" . $this->list . "thumbs/" . $file . ".txt"); }
        }
      }
      if (isset($this->list)) { $this->list = rtrim($this->list,"/"); }
      return $this->lang["status7"];
    }

    // SET THUMB
    if ($action == "setthumb" && isset($this->image)) {
      if (isset($this->list)) { $this->list .= "/"; }
      copy("$this->gallerydir/" . $this->list . "thumbs/tn_$this->image","$this->gallerydir/" . $this->list . "thumbs/tn_thumb.jpg");
      $this->list = rtrim($this->list, "/");
      return '"' . $this->image . '" ' . $this->lang["status8"];
    }

    // UNSET THUMB
    if ($action == "unsetthumb" && !isset($this->image))
    {
      if (isset($this->list)) { $this->list .= "/"; }
      if (is_file("$this->gallerydir/" . $this->list . $_REQUEST["selected"] . "/thumbs/tn_thumb.jpg")) {
        unlink("$this->gallerydir/" . $this->list . $_REQUEST["selected"] . "/thumbs/tn_thumb.jpg");
        $this->list = rtrim($this->list, "/");
        return $this->lang["status9"];
      } else {
        $this->list = rtrim($this->list, "/");
        return $this->lang["status10"];
      }
    }

    // MOVE IMAGES
    if ($_REQUEST["action"] == "move" && $_REQUEST["whataction"] != "delete") {
      if (get_magic_quotes_gpc() && isset($_REQUEST["whataction"])) { 
        $destination = stripslashes($_REQUEST["whataction"]); 
      } else $destination = $_REQUEST["whataction"];
      if (isset($this->list)) { $this->list .= "/"; }
      if (strlen($destination) > 0){
        //Is an action selected 
        if (($destination != "$this->gallerydir/$this->list")) {
        //Is destination folder same as current folder
          for ($x=0; $x < $_REQUEST["i"]; $x++) {
            if (is_file("$this->gallerydir/" . $this->list . stripslashes($_REQUEST["selectfile" . $x]))) {
            //Does original file exist (reload page fix)
              if (!is_file($_REQUEST["whataction"] . stripslashes($_REQUEST["selectfile" . $x]))) {
                //Continue if destination file doesn't exist
                @mkdir($destination."thumbs",0755);
                rename("$this->gallerydir/" . $this->list . stripslashes($_REQUEST["selectfile" . $x]), $destination . stripslashes($_REQUEST["selectfile" . $x]));
                rename("$this->gallerydir/" . $this->list . "thumbs/tn_" . stripslashes($_REQUEST["selectfile" . $x]), $destination . "thumbs/tn_" . stripslashes($_REQUEST["selectfile" . $x]));
                if (is_file("$this->gallerydir/" . $this->list . "thumbs/tn_med_" . $_REQUEST["selectfile" . $x])) {
                  rename("$this->gallerydir/" . $this->list . "thumbs/tn_med_" . stripslashes($_REQUEST["selectfile" . $x]), $destination . "thumbs/tn_med_" . stripslashes($_REQUEST["selectfile" . $x]));
                }
                if (is_file("$this->gallerydir/" . $this->list . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".txt")) {
                  rename("$this->gallerydir/" . $this->list . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".txt", $destination . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".txt");
                }
                if (is_file("$this->gallerydir/" . $this->list . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".cmt")) {
                  rename("$this->gallerydir/" . $this->list . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".cmt", $destination . "thumbs/" . stripslashes($_REQUEST["selectfile" . $x]) . ".cmt");
                }
                if (!isset($status)) $status = $this->lang["status11"];
              } else $status = $this->lang["status12"];
            }
          }
        } else $status = $this->lang["status13"];
      } else $status = $this->lang["status14"];
      $this->list = rtrim($this->list, "/");
      return $status;
    }

    // RENAME FILE TAB
    if (is_file("$this->gallerydir/" . $this->list . "/" . $this->image) && isset($this->list) && $action == "renamefile") {
      if (get_magic_quotes_gpc() && isset($_REQUEST["newfilename"])) {
        $newname = stripslashes($_REQUEST["newfilename"]); 
      } else $newname = $_REQUEST["newfilename"];
      if (strlen($this->list)>0) { $this->list .= "/"; }
      if (isset($newname)) {
        if (strlen($newname) > 0) {
          if (strpos($newname, chr(34)) === false) {
            if (!is_file("$this->gallerydir/$this->list" . $newname)) {
              rename("$this->gallerydir/$this->list$this->image","$this->gallerydir/$this->list" . $newname);
              rename("$this->gallerydir/" . $this->list . "thumbs/tn_$this->image","$this->gallerydir/" . $this->list . "thumbs/tn_" . $newname);
              if (is_file("$this->gallerydir/" . $this->list . "thumbs/tn_med_$this->image")) {
                rename("$this->gallerydir/" . $this->list . "thumbs/tn_med_$this->image","$this->gallerydir/" . $this->list . "thumbs/tn_med_" . $newname);
              }
              if (is_file("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt")) {
                rename("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt","$this->gallerydir/" . $this->list . "thumbs/" . $newname . ".txt");
              }
              if (is_file("$this->gallerydir/" . $this->list . "thumbs/$this->image.cmt")) {
                rename("$this->gallerydir/" . $this->list . "thumbs/$this->image.cmt","$this->gallerydir/" . $this->list . "thumbs/" . $newname . ".cmt");
              }
              $status = "$this->image " . $this->lang["status15"] . " " . $newname;
            } else $status = $this->lang["status16"];
          } else $status=$this->lang["status17"] . ": " . chr(34);
        } else $status = $this->lang["status18"];
      } else {
        echo "
    <tr>
      <td class=\"adminstatus\" colspan=\"3\">" . $this->lang["newfilename"] . "</td>
      <td class=\"admintd\" colspan=\"7\">
        <form action=\"admin.php\" method=\"get\" enctype=\"multipart/form-data\">
          <input type=\"text\" name=\"newfilename\" value=\"$this->image\" size=\"40\" class=\"admintext\" />
          <input type=\"hidden\" name=\"list\" value=\"$this->list\" />
          <input type=\"hidden\" name=\"image\" value=\"$this->image\" />
          <input type=\"hidden\" name=\"action\" value=\"renamefile\" />
          <a href=\"admin.php?list=" . rtrim($this->list,"/") . "\"><img src=\"styles/shared/exitsmall.gif\" class=\"adminpicbutton\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["abort"] . "\" alt=\"" . $this->lang["abort"] . "\" /></a>
          <input type=\"image\" src=\"styles/shared/ok.gif\" class=\"adminpicbutton\" title=\"" . $this->lang["submit"] . "\" />
        </form>
      </td>
    </tr>\n";
      }
      $this->list = rtrim($this->list, "/");
      return $status;
    }

    //RENAME FOLDER TAB
    if ($action == "renamedir" && isset($this->list)) {
      if (strlen($this->list)>0) { $this->list .= "/"; }
      if (get_magic_quotes_gpc() && isset($_REQUEST["dirname"])) {$dirname = stripslashes($_REQUEST["dirname"]); } else $dirname = $_REQUEST["dirname"];
      if (get_magic_quotes_gpc() && isset($_REQUEST["renamedir"])) {$renamedir = stripslashes($_REQUEST["renamedir"]); } else $renamedir = $_REQUEST["renamedir"];
      if (is_dir("$this->gallerydir/$this->list" . $dirname)) {
        if (strlen($renamedir) > 0) {
          if (strpos($renamedir, chr(34))===false) {
            rename("$this->gallerydir/$this->list" . $dirname,"$this->gallerydir/$this->list" . $renamedir);
            $status = $this->lang["status21"] . " \"" . $renamedir . "\"";
          } else $status=$this->lang["status22"] . ": " . chr(34);
        } else {
?>
    <tr>
      <td class="adminstatus" colspan="3"><? echo $this->lang["newfoldername"] ?></td>
      <td class="admintd" colspan="7">
        <form action="admin.php" method="get" enctype="multipart/form-data">
          <input type="text" name="renamedir" value="<? echo $dirname ?>" size="40" class="admintext" />
          <input type="hidden" name="list" value="<? echo rtrim($this->list, "/") ?>" />
          <input type="hidden" name="dirname" value="<? echo $dirname ?>" />
          <input type="hidden" name="action" value="renamedir" />
          <a href="admin.php?list=<? echo rtrim($this->list, "/") ?>"><img 
            src="styles/shared/exitsmall.gif" class="adminpicbutton" width="24" height="24" border="0" title="<? echo $this->lang["abort"] ?>" /></a>
          <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $this->lang["submit"] ?>" />
        </form>
      </td>
    </tr>
<?
        }
      } else $status = $this->lang["status23"];
      $this->list = rtrim($this->list, "/");
      return $status;
    }

    // EDIT COMMENTS TAB
    if ($action == "editcomments") {
      if (is_file("$this->gallerydir/$this->list/thumbs/$this->image.txt")) {
        if (isset($this->list)) { $this->list .= "/"; }
        if (isset($_REQUEST["delcmt"])) {
          //Delete single comment
          $bufferwrite = "";
          $i = $_REQUEST["delcmt"];
          $status = $this->lang["status19"];
          $fd = fopen("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt","r+");
          while (!feof ($fd)) {
            $bufferchat[] = fgets($fd, 4096);
          }
          fclose($fd);
          array_pop ($bufferchat);
          $bufferchat = array_reverse ($bufferchat);
          $sizeofbuffer = count($bufferchat);
          $bufferchat[$i]="";
          $bufferchat = array_reverse ($bufferchat);
          for ($i=0; $sizeofbuffer > $i; $i++) {
            $bufferwrite .= $bufferchat[$i];
          }
          $fd = fopen("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt","w+");
          fwrite($fd,$bufferwrite);
          fclose($fd);
          if ($bufferwrite == "") {
            //Delete empty comment file
            unlink("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt");
            $this->list = rtrim($this->list, "/");
            $status = $this->lang["status20"];
            return $status;
          }
        }
        $bufferchat = array();
        $fd = fopen("$this->gallerydir/" . $this->list . "thumbs/$this->image.txt","r+");
        while (!feof ($fd)) {
          $bufferchat[] = fgets($fd, 4096);
        }
        fclose($fd);
        array_pop ($bufferchat);
        $bufferchat = array_reverse ($bufferchat);
        $sizeofbuffer = count($bufferchat);
        for ($counter = 0; $counter < $sizeofbuffer; $counter++) {
          $array = explode("¤", $bufferchat[$counter]);
          echo "
        <tr height=\"20\">
          <td class=\"admintdleft\" colspan=\"2\">
            <a href=mailto:" . $array[3] . ">" . $array[2] . "</a>
          </td>
          <td class=\"admintdleft\">
            " . $array[0] . "
          </td>
          <td colspan=\"6\" class=\"admintdleft\">
            " . $array[1] . "
          </td>
          <td class=\"admintd\">
            <a href=\"admin.php?list=" . rtrim($this->list,"/") . "&image=" . $_REQUEST["image"] . "&action=editcomments&delcmt=$counter\"><img src=\"styles/shared/delete.gif\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["deletecomment"] . "\" alt=\"" . $this->lang["deletecomment"] . "\" />
          </td>
        </tr>";
        }
        $this->list = rtrim($this->list, "/");
        return $status;
    } else {
      $this->list = rtrim($this->list, "/");
      return;
    }
  }

    // ADD CAPTION TAB
    if ($action == "addcaption") {
      if (strlen($this->list) > 0) { $this->list .= "/"; }
      if (isset($_REQUEST["addtext"])) {
        $chatfile = "$this->gallerydir/" . $this->list . "thumbs/$this->image.cmt";
        $fd = fopen("$chatfile","w");
        $buffer = stripslashes($_REQUEST["addtext"]);
        fwrite($fd,$buffer);
        fclose($fd);
        if (strlen($_REQUEST["addtext"]) > 0) {
          $status =$this->lang["status24"] . " \"$this->image\"";
        } else {
          unlink("$this->gallerydir/" . $this->list . "thumbs/$this->image.cmt");
          $status =$this->lang["status25"] . " \"$this->image\"";
        }
      } else {
        $openfile = "$this->gallerydir/" . $this->list . "thumbs/$this->image.cmt";
        if (is_file($openfile)) {
          $fd = fopen ($openfile, "rt");
          $currentvalue = "";
          while(!feof($fd)) {
            $currentvalue .= fgets($fd, 4096);
          }
          fclose ($fd);
        }
      echo "
  <tr>
    <td class=\"adminstatus\" colspan=\"3\">" . $this->lang["changecaption"] . " \"$this->image\"</td>
    <td class=\"admintd\" colspan=\"7\">
      <form action=\"admin.php\" method=\"get\" enctype=\"text/plain\">
        <input type=\"text\" name=\"addtext\" value=\"$currentvalue\" size=\"40\" class=\"admintext\" />
        <input type=\"hidden\" name=\"list\" value=\"" . rtrim($this->list,"/") . "\" />
        <input type=\"hidden\" name=\"image\" value=\"$this->image\" />
        <input type=\"hidden\" name=\"action\" value=\"addcaption\" />
        <a href=\"admin.php?list=" . rtrim($this->list,"/") . "\"><img src=\"styles/shared/exitsmall.gif\" class=\"adminpicbutton\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["abort"] . "\" alt=\"" . $this->lang["abort"] . "\" /></a>
        <input type=\"image\" src=\"styles/shared/ok.gif\" class=\"adminpicbutton\" title=\"" . $this->lang["submit"] . "\"  alt=\"" . $this->lang["submit"] . "\" />
      </form>
    </td>
  </tr>\n";
      }
      $this->list = rtrim($this->list, "/");
      return $status;
    }

    // ADD FOLDER CAPTION TAB
    if ($action == "foldercaption") {
      if (strlen($this->list)>0) { $this->list .= "/"; }
      if (isset($_REQUEST["addtext"])) {
        $chatfile = "$this->gallerydir/" . $this->list . $_REQUEST['folder'] . "/caption.dir";
        $fd = fopen("$chatfile","w");
        $buffer = stripslashes($_REQUEST["addtext"]);
        fwrite($fd,$buffer);
        fclose($fd);
        if (strlen($_REQUEST["addtext"]) > 0) {
          $status = $this->lang["status24"] . " \"" . $_REQUEST['folder'] . "\"";
        } else {
          unlink("$this->gallerydir/" . $this->list . $_REQUEST['folder'] . "/caption.dir");
          $status = $this->lang["status25"] . " \"" . $_REQUEST['folder'] . "\"";
        }
      } else {
        $openfile = "$this->gallerydir/" . $this->list . $_REQUEST['folder'] . "/caption.dir";
        if (is_file($openfile)) {
          $fd = fopen ($openfile, "rt");
          $currentvalue = "";
          while(!feof($fd)) {
            $currentvalue .= fgets($fd, 4096);
          }
          fclose ($fd);
        }
      echo "
  <tr>
    <td class=\"adminstatus\" colspan=\"3\">" . $this->lang["changecaption"] . " \"" . $_REQUEST['folder'] . "\"</td>
    <td class=\"admintd\" colspan=\"7\">
      <form action=\"admin.php\" method=\"get\" enctype=\"text/plain\">
        <input type=\"text\" name=\"addtext\" value=\"$currentvalue\" size=\"40\" class=\"admintext\" />
        <input type=\"hidden\" name=\"list\" value=\"" . rtrim($this->list,"/") . "\" />
        <input type=\"hidden\" name=\"folder\" value=\"" . $_REQUEST['folder'] . "\" />
        <input type=\"hidden\" name=\"action\" value=\"foldercaption\" />
        <a href=\"admin.php?list=" . rtrim($this->list,"/") . "\"><img src=\"styles/shared/exitsmall.gif\" class=\"adminpicbutton\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["abort"] . "\" alt=\"" . $this->lang["abort"] . "\" /></a>
        <input type=\"image\" src=\"styles/shared/ok.gif\" class=\"adminpicbutton\" title=\"" . $this->lang["submit"] . "\" />
      </form>
    </td>
  </tr>";
      }
      $this->list = rtrim($this->list, "/");
      return $status;
    }

    //IMAGE UPLOAD TAB
    if ($action == "upload") {
?>
  <tr>
    <td class="admintd" colspan="10"><p><b><? echo $this->lang["PHPrestriction"] ?></b><br />
      <? echo $this->lang["maxsize"] ?>: <b><? echo ini_get("post_max_size") ?></b><br />
      (<? echo $this->lang["useftp"] ?>)</p></td>
  </tr>
  <form action="admin.php" method="post" enctype="multipart/form-data">
<? for ($x = 0; $x < 10; $x++) { ?>
  <tr class="admintdleft">
    <td colspan="2"><? echo $this->lang["image"] ?> <? echo $x+1 ?></td>
    <td colspan="8"><input type="file" name="file<? echo $x ?>" size="50" class="admintext" /></td>
  </tr>
<? } ?>
  <tr>
    <td class="admintd" colspan="10">
<?  if (strlen($this->list) > 0) { ?>
      <input type="hidden" name="list" value="<? echo $this->list ?>" />
<?  } 
    if ($debug == "yes") {  ?>
      <input type="hidden" name="debug" value="yes" />
<?  } ?>
      <input type="hidden" name="upload" value="set" />
      <a href="admin.php?list=<? echo rtrim($this->list,"/") ?>"><img src="styles/shared/exitsmall.gif" class="adminpicbutton" 
        width="24" height="24" border="0" title="<? echo $this->lang["abort"] ?>" alt="<? echo $this->lang["abort"] ?>" /></a>
      <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $this->lang["submit"] ?>" />
    </td>
  </tr>
  </form>
<?
      return;
    }

    //CREATE FOLDER TAB
    if ($action == "createdir" && isset($_REQUEST["dirname"])) {
      if (get_magic_quotes_gpc() && isset($_REQUEST["dirname"])) {
        $newdir = stripslashes($_REQUEST["dirname"]); 
      } else $newdir = $_REQUEST["dirname"];
      if (strlen($this->list)>0) { $this->list .= "/"; }
      if (strlen($newdir) > 0) {
        if (!strpos($newdir, chr(34))) {
          if (!is_dir($this->list . $newdir)) {
            mkdir($this->list . $newdir, 0755);
            mkdir($this->list . $newdir . "/thumbs", 0755);
            $this->list = rtrim($this->list, "/");
            $status = $this->lang["status26"];
          } else { 
            $this->list = rtrim($this->list, "/");
            $status = $this->lang["status27"]; 
          }
        } else $status = $this->lang["status17"] . ": " . chr(34);
      } else { $status = $this->lang["status28"]; }
      return $status;
    } else
    if ($action == "newfolder") {
?>
  <tr>
    <td class="admintdleft" colspan="2"><? echo $this->lang["newfolder"] ?></td>
    <td colspan="8" class="admintdleft">                                
      <form action="admin.php" method="get" enctype="multipart/form-data">
        <input type="text" name="dirname" size="50" class="admintext" />
        <input type="hidden" name="list" value="<? echo rtrim($this->list, "/") ?>" />
        <input type="hidden" name="action" value="createdir" />
        <a href="admin.php?list=<? echo rtrim($this->list,"/") ?>"><img src="styles/shared/exitsmall.gif" class="adminpicbutton" 
          width="24" height="24" border="0" title="<? echo $this->lang["abort"] ?>" alt="<? echo $this->lang["abort"] ?>" /></a>
        <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $this->lang["submit"] ?>" />
      </form>
    </td>
  </tr>
<?
      $this->list = rtrim($this->list, "/"); //Remove trailing slash again
      return;
    }

    // FOLDER INTRO TEXT TAB
    if ($action == "addintro") {
      if (strlen($this->list)>0) { $this->list .= "/"; } // Add slash to end of $this->list
      if (isset($_REQUEST["addtext"])) {
        $chatfile = "$this->gallerydir/" . $this->list . "description.dir";
        $fd = fopen("$chatfile","wt");
        $buffer = stripslashes($_REQUEST["addtext"]);
        fwrite($fd,$buffer);
        fclose($fd);
        if (strlen($_REQUEST["addtext"]) > 0 && strlen($this->list) > 0) { $status = $this->lang["status29"] . " \"" . rtrim($this->list,"/") . "\""; }
        if (strlen($_REQUEST["addtext"]) < 1 && strlen($this->list) > 0) { unlink ("$this->gallerydir/" . $this->list . "description.dir"); $status = $this->lang["status30"] . " \"" . rtrim($this->list,"/") . "\""; }
        if (strlen($_REQUEST["addtext"]) > 0 && strlen($this->list) < 1) { $status = $this->lang["status29"] . " \"$this->gallerytitle\""; }
        if (strlen($_REQUEST["addtext"]) < 1 && strlen($this->list) < 1) { unlink ("$this->gallerydir/" . $this->list . "description.dir"); $status = $this->lang["status30"] . " \"$this->gallerytitle\""; }
      } else {
        $openfile = "$this->gallerydir/" . $this->list . "description.dir";
        if (is_file($openfile)) {
          $currentvalue="";
          $fd = fopen ($openfile, "rt");
          while (!feof ($fd)) {
            $currentvalue .= fgets($fd, 4096);
          }
          fclose ($fd);
        }
?>
  <tr>
    <td class="admintdleft" colspan="2"><? echo $this->lang["editintrotext"] ?> "<? 
    echo (strlen($this->list) < 1) ? $this->gallerytitle : rtrim($this->list, "/") ?>"</td>
    <td class="admintd" colspan="8">
      <form action="admin.php" method="get" enctype="text/plain">
        <textarea cols="80" rows="5" name="addtext" class="admindropdown"><? echo $currentvalue ?></textarea>
        <input type="hidden" name="list" value="<? echo rtrim($this->list,"/") ?>" />
        <input type="hidden" name="action" value="addintro" />
        <a href="admin.php?list=<? echo rtrim($this->list,"/") ?>"><img src="styles/shared/exitsmall.gif" class="adminpicbutton" 
          width="24" height="24" border="0" title="<? echo $this->lang["abort"] ?>" alt="<? echo $this->lang["abort"] ?>" /></a>
        <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $this->lang["submit" ] ?>" />
      </form>
    </td>
  </tr>
<?
      }
      $this->list = rtrim($this->list, "/"); //Remove trailing slash again
      return $status;
    }

    // FOLDER LOCK TAB
    if ($action == "unlockfolder") {
      unlink("$this->gallerydir/" . $this->folder . "/locked.dir");
      return "\"" . $this->folder . "\" " . $this->lang["status31"];
    }
    if (strlen($this->list)>0) { $this->list .= "/"; } // Add slash to end of $this->list
    if ($action=="lockfolder") {
      if (strlen($_REQUEST["addtext"]) > 0) {
        $fd = fopen("$this->gallerydir/" . $this->list . "locked.dir","w");
        fwrite($fd,md5($_REQUEST["addtext"]));
        fclose($fd);
        if (strlen($_REQUEST["addtext"])>0) { $status = "\"" . rtrim($this->list,"/")."\" " . $this->lang["status32"]; }
        if (strlen($this->list)<1) {$status = $this->lang["status33"]; }
      } else
      if (strlen($this->list) < 1) {
        $status = $this->lang["status33"];
      } else {
        echo "
      <tr>
        <td class=\"adminstatus\" colspan=\"3\">" . $this->lang["enternewpwd"] . " \"" . rtrim($this->list,"/") . "\"</td>
        <td class=\"admintd\" colspan=\"7\">
        <form action=\"admin.php\" method=\"get\" enctype=\"text/plain\">
          <input type=\"text\" name=\"addtext\" value=\"\" size=\"40\" class=\"admintext\" />
          <input type=\"hidden\" name=\"list\" value=\"" . rtrim($this->list,"/") . "\" />
          <input type=\"hidden\" name=\"action\" value=\"lockfolder\" />
          <a href=\"admin.php?list=" . rtrim($this->list,"/") . "\"><img src=\"styles/shared/exitsmall.gif\" class=\"adminpicbutton\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["abort"] . "\" alt=\"" . $this->lang["abort"] . "\" /></a>
          <input type=\"image\" src=\"styles/shared/ok.gif\" class=\"adminpicbutton\" title=\"" . $this->lang["submit"] . "\" />
        </form>
        </td>
      </tr>";
      }
      $this->list = rtrim($this->list, "/"); //Remove trailing slash again
      return $status;
    }

    // CREATE THUMBS TAB
    if ($action == "createthumbs") {
       ini_set(max_execution_time, 900);
?>
  <tr>
    <td class="admintdleft" colspan="10">
      <p><? echo $this->lang["thumbs1"] ?></p>
      <p><? echo $this->lang["thumbs2"] ?>:</p>
      <p><? echo $this->lang["thumbs3"] ?><br />
         <? echo $this->lang["thumbs4"] ?><br />
         <? echo $this->lang["thumbs5"] ?></p>
      <p><? echo $this->lang["thumbs6"] ?> <b><? echo ini_get("max_execution_time") ?></b> <? echo $this->lang["thumbs7"] ?></p>
      <p align="center"><a href="admin.php?createthumbs=yes&amp;list=<? echo rtrim($this->list,"/") ?>"><? echo  $this->lang["thumbs8"] ?></a></p>
      <p align="center">(<? echo $this->lang["thumbs9"] ?>)</p>
     </td>
   </tr>
<?
    }

    // SETTINGS TAB
    if (is_file("settings.php") && ($action == "changesettings") && !isset($newsettings)) {
      $fd = fopen ("settings.php", "r");
      while (!feof ($fd)) {
        $settings[] .= fgets($fd, 4096);
      }
      array_shift($settings); //Delete first array key
      array_pop($settings); //Delete last array key
      for ($i = 0; count($settings) > $i; $i++) {
        unset($newstr);
        $newstr = explode("=", $settings[$i]);
        $settings[$i] = trim(str_replace(";", "", str_replace(chr(34), "", $newstr[1])));
      }
      fclose ($fd);
      $this->setupconfig();
      echo "
  <form action=\"admin.php\" method=\"post\" enctype=\"multipart/form-data\">
  <tr height=\"30\">
    <td class=\"adminstatus\" colspan=\"10\">" . $this->lang["changesettings"] . "</td>
  </tr>";
      for($i = 0; $i < count($settings)-2; $i++) {
      if ($i == 3) { 
      //STYLES DROPDOWN
      echo "
  <tr>
    <td class=\"admintdleft\" colspan=\"2\">" . $this->settingsname[$i] . "</td>
    <td class=\"admintdleft\">";
      if (is_dir("styles")) {
        echo "
      <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
        $workdir = opendir("styles");
        $stylearray = "";
        while ($pointer = readdir($workdir)) {
          if (is_dir("styles/$pointer") && $pointer !== "." && $pointer !== ".." && $pointer !== "shared") {
            $stylearray[] = $pointer;
          }
        }
        sort($stylearray);
        for($x = 0; $x < count($stylearray); $x++) {
          if ($settings[$i] == $stylearray[$x]) {
            echo "
        <option value=\"" . $stylearray[$x] . "\" selected=\"selected\">" . $stylearray[$x] . "</option>";
            }
          else if (is_dir("styles/" . $stylearray[$x]) && $stylearray[$x] !== "." && $stylearray[$x] !== "..") {
            echo "
        <option value=\"" . $stylearray[$x] . "\">" . $stylearray[$x] . "</option>";
            }
          }
          echo "
      </select>
    </td>";
        } else echo $this->lang["nostyles"];
        echo "
    <td class=\"admintdleft\" colspan=\"8\">" . $this->settingshelp[$i] . "</td>
  </tr>\n";
      } else if ($i == 4 || $i == 5 || $i == 6 || $i == 7) {
        //SEND MAIL DROPDOWN
        echo "
  <tr>
    <td class=\"admintdleft\" colspan=\"2\">" . $this->settingsname[$i] . "</td>
    <td class=\"admintdleft\">
      <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
      if ($settings[$i] == "1") { echo "
        <option value =\"1\" selected= \"selected\">" . $this->lang["yes"] . "</option>"; 
      } else echo "
        <option value =\"1\">" . $this->lang["yes"] . "</option>";
      if ($settings[$i] == "0") { echo "
        <option value =\"0\" selected= \"selected\">" . $this->lang["no"] . "</option>"; 
      } else echo "
        <option value =\"0\">" . $this->lang["no"] . "</option>";
      echo "
      </select>
    </td>
    <td class=\"admintdleft\" colspan=\"8\">" . $this->settingshelp[$i] . "</td>
  </tr>\n";
      } else if ($i == 8) {
        //SCREEN SIZE DROPDOWN
        echo "
  <tr>
    <td class=\"admintdleft\" colspan=\"2\">" . $this->settingsname[$i] . "</td>
    <td class=\"admintdleft\">
      <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
        if ($settings[$i] == "1280") { echo "
        <option value=\"1280\" selected=\"selected\">1280x1024</option>";
            } else echo "
        <option value=\"1280\">1280x1024</option>";
        if ($settings[$i] == "1024") { echo "
        <option value=\"1024\" selected=\"selected\">1024x768</option>";
            } else echo "
        <option value=\"1024\">1024x768</option>";
            if ($settings[$i] == "800") { echo "
        <option value=\"800\" selected=\"selected\">800x600</option>";
            } else echo "
        <option value=\"800\">800x600</option>";
            if ($settings[$i] == "640") { echo "
        <option value=\"640\" selected=\"selected\">640x480</option>";
            } else echo "
        <option value=\"640\">640x480</option>";
            if ($settings[$i] == "320") { echo "
        <option value=\"320\" selected=\"selected\">320x200</option>";
            } else echo "
        <option value=\"320\">320x200</option>";
            if ($settings[$i] == "0") { echo "
        <option value=\"0\" selected=\"selected\">" . $this->lang["no"] . "</option>";
            } else echo "
        <option value=\"0\">" . $this->lang["no"] . "</option>";
            echo "
      </select>
    </td>
    <td class=\"admintdleft\" colspan=\"8\">" . $this->settingshelp[$i] . "</td>
  </tr>
  <tr>";
        } else if ($i == 9) //DATE FORMAT DROPDOWNS
      {
        echo "
    <td class=\"admintdleft\" colspan=\"2\">" . $this->settingsname[$i] . "</td>
    <td class=\"admintdleft\">
      <select size=\"1\" name=\"newsetting$i\" class=\"admindropdown\">";
      if ($settings[$i] == "j.m.Y, H:i") {echo "
        <option value =\"j.m.Y, H:i\" selected=\"selected\">" . $this->lang["DMY"] . "</option>"; } else echo "
        <option value =\"j.m.Y, H:i\">" . $this->lang["DMY"] . "</option>";
      if ($settings[$i] == "m.j.Y, H:i") {echo "
        <option value =\"m.j.Y, H:i\" selected=\"selected\">" . $this->lang["MDY"] . "</option>"; } else echo "
        <option value =\"m.j.Y, H:i\">" . $this->lang["MDY"] . "</option>";
      echo "
      </select>
    </td>
    <td class=\"admintdleft\" colspan=\"8\">" . $this->settingshelp[$i] . "</td>
  </tr>";
      } else echo "
  <tr>
    <td class=\"admintdleft\" colspan=\"2\">" . $this->settingsname[$i] . "</td>
    <td class=\"admintdleft\"><input type=\"text\" size=\"30\" value=\"$settings[$i]\" name=\"newsetting$i\" class=\"admintext\" /></td>
    <td class=\"admintdleft\" colspan=\"8\">" . $this->settingshelp[$i] . "</td>
  </tr>";
    }
    echo "
  <tr>
    <td class=\"admintd\" align=\"center\" colspan=\"10\">
      <input type=\"hidden\" value=\"" . $this->lang["status2"] . "\" name=\"status\" />";
    if ($debug == "yes") { echo "
      <input type=\"hidden\" value=\"yes\" name=\"debug\" />"; }
    echo "
      <a href=\"admin.php?list=" . rtrim($this->list,"/") . "\"><img src=\"styles/shared/exitsmall.gif\" class=\"adminpicbutton\" width=\"24\" height=\"24\" border=\"0\" title=\"" . $this->lang["abort"] . "\"  alt=\"" . $this->lang["abort"] . "\" /></a>
      <input type=\"image\" src=\"styles/shared/ok.gif\" class=\"adminpicbutton\" title=\"" . $this->lang["submit"] . "\" />
    </td>
  </tr>
  <tr height=\"30\">
    <td class=\"adminstatus\" colspan=\"10\">Chmod</td>
  </tr>
  <tr height=\"20\">
    <td class=\"admintd\" colspan=\"10\">" . $this->lang["changechmod"] . "</td>
  </tr>
  <tr height=\"20\">
    <td class=\"admintd\" colspan=\"10\">
      <a href=\"admin.php?chmodall=yes&amp;chmod=0600\" title=\"Chmod 600\n\n" . $this->lang["owner"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . "\n" . $this->lang["group"] . ": -\n" . $this->lang["public"] . ": -\n\n" . $this->lang["chmodwarning"] . "\">600</a>&nbsp;
      <a href=\"admin.php?chmodall=yes&amp;chmod=0644\" title=\"Chmod 644\n\n" . $this->lang["owner"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . "\n" . $this->lang["group"] . ": " . $this->lang["read"] . "\n" . $this->lang["public"] . ": " . $this->lang["read"] . "\n\n" . $this->lang["chmodwarning"] . "\">644</a>&nbsp;
      <a href=\"admin.php?chmodall=yes&amp;chmod=0755\" title=\"Chmod 755\n\n" . $this->lang["owner"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . ", " . $this->lang["execute"] . "\n" . $this->lang["group"] . ": " . $this->lang["read"] . ", " . $this->lang["execute"] . "\n" . $this->lang["public"] . ": " . $this->lang["read"] . ", " . $this->lang["execute"] . "\">755</a>&nbsp;
      <a href=\"admin.php?chmodall=yes&amp;chmod=0777\" title=\"Chmod 777\n\n" . $this->lang["owner"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . ", " . $this->lang["execute"] . "\n" . $this->lang["group"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . ", " . $this->lang["execute"] . "\n" . $this->lang["public"] . ": " . $this->lang["read"] . ", " . $this->lang["write"] . ", " . $this->lang["execute"] . "\">777</a>&nbsp;
    </td>
   </tr>
  </form>\n";
  }

    // NEW PASSWORD TAB
    if ($action == "changepwd") {
      if ($_REQUEST["pwdform"] == "set") {
        if (strlen($_REQUEST["oldpwd"]) > 0 && strlen($_REQUEST["newpwd"]) > 0 && strlen($_REQUEST["newpwdagain"]) > 0) {
          if (md5($_REQUEST["oldpwd"])==$_SESSION["password"]) {
            if ($_REQUEST["newpwd"] == $_REQUEST["newpwdagain"]) {
              $filebuffer = "<?\n";
              $filebuffer.= "$"."gallerytitle = ".chr(34).$this->gallerytitle.chr(34).";\n";
              $filebuffer.= "$"."gallerydir = ".chr(34).$this->gallerydir.chr(34).";\n";
              $filebuffer.= "$"."owneremail = ".chr(34).$this->owneremail.chr(34).";\n";
              $filebuffer.= "$"."activestyle = ".chr(34).$this->activestyle.chr(34).";\n";
              $filebuffer.= "$"."sendmail = ".chr(34).$this->sendmail.chr(34).";\n";
              $filebuffer.= "$"."showexif = ".chr(34).$this->showexif.chr(34).";\n";
              $filebuffer.= "$"."showcomments = ".chr(34).$this->showcomments.chr(34).";\n";
              $filebuffer.= "$"."thumbcaptions = ".chr(34).$this->thumbcaptions.chr(34).";\n";
              $filebuffer.= "$"."resizelargeimg = ".chr(34).$this->resizelargeimg.chr(34).";\n";
              $filebuffer.= "$"."dateformat = ".chr(34).$this->dateformat.chr(34).";\n";
              $filebuffer.= "$"."images_side = ".chr(34).$this->images_side.chr(34).";\n";
              $filebuffer.= "$"."pagerows = ".chr(34).$this->pagerows.chr(34).";\n";
              $filebuffer.= "$"."upload_height = ".chr(34).$this->upload_height.chr(34).";\n";
              $filebuffer.= "$"."upload_width = ".chr(34).$this->upload_width.chr(34).";\n";
              $filebuffer.= "$"."upload_quality = ".chr(34).$this->upload_quality.chr(34).";\n";
              $filebuffer.= "$"."gallerycopyright = ".chr(34).$this->gallerycopyright.chr(34).";\n";
              $filebuffer.= "$"."adminpass = ".chr(34).md5($_REQUEST["newpwd"]).chr(34).";\n";
              $filebuffer.= "$"."version = ".chr(34).$this->version.chr(34).";\n";
              $filebuffer.= "?>";
              $fd = fopen("settings.php","w+");
              fwrite($fd,$filebuffer);
              fclose($fd);
              $_SESSION["password"] = md5($_REQUEST["newpwd"]);
              return $this->lang["status34"];
            } else return $this->lang["status35"];
          } else return $this->lang["status36"];
        } else return $this->lang["status37"];
      } else {
?>
  <form action="admin.php" method="post" enctype="multipart/form-data">
  <tr>
    <td class="admintdleft" colspan="2"><? echo $this->lang["enteroldpwd"] ?></td>
    <td class="admintd" colspan="8">
      <input type="password" name="oldpwd" value="" size="50" class="admintext" />
    </td>
  </tr>
  <tr>
    <td class="admintdleft" colspan="2"><? echo $this->lang["enternewpassword"] ?></td>
    <td class="admintd" colspan="8">
      <input type="password" name="newpwd" value="" size="50" class="admintext" />
    </td>
  </tr>
  <tr>
    <td class="admintdleft" colspan="2"><? echo $this->lang["retypenewpwd"] ?></td>
    <td class="admintd" colspan="8">
      <input type="password" name="newpwdagain" value="" size="50" class="admintext" /><br />
      <input type="hidden" name="action" value="changepwd" />
      <input type="hidden" name="pwdform" value="set" />
      <a href="admin.php?list=<? echo rtrim($this->list,"/") ?>"><img src="styles/shared/exitsmall.gif" class="adminpicbutton" width="24" height="24" border="0" title="abort" alt="<? echo $this->lang["abort"] ?>" /></a>
      <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $this->lang["submit"] ?>" />
    </td>
  </tr>
  </form>
<?
      }
    }
  }//EOF

//////////////////////////////
//                          //
//      CREATE THUMBS       //
//                          //
//////////////////////////////
  function makethumbs($extension,$til,$filnavn,$size)
  {
    if ($extension == "png") // PNG FILE
    {
      if ($size[0] > $size[1]) //Checker for Tværformat / Højformat.
      {
        $this->upload_height = ($this->upload_width/$size[0])*$size[1]; // Regner højden ud så jeg ikke får et distorted billed.
        $src_img = imagecreatefrompng("$til"); //GD starter med at generer billedt.
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagepng($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
        imagedestroy($src_img);
        imagedestroy($dst_img);
      } else
      { // Ellers er billedet højformat og kører samme smøre igen.
        $this->upload_width = ($this->upload_height/$size[1])*$size[0];
        $src_img = imagecreatefrompng("$til");
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagepng($dst_img, "$filnavn", $this->upload_quality);
        imagedestroy($src_img);
        imagedestroy($dst_img);
      }
    } else
    if ($extension == "gif") // GIF FILE
    {
      if ($size[0] > $size[1]) //Checker for Tværformat / Højformat.
      {
        $this->upload_height = ($this->upload_width/$size[0])*$size[1]; // Regner højden ud så jeg ikke får et distorted billed.
        $src_img = imagecreatefromgif ("$til"); //GD starter med at generer billedt.
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagejpeg($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
        imagedestroy($src_img);
        imagedestroy($dst_img);
      } else
      { // Ellers er billedet højformat og kører samme smøre igen.
        $this->upload_width = ($this->upload_height/$size[1])*$size[0];
        $src_img = imagecreatefromgif ("$til");
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagejpeg($dst_img, "$filnavn", $this->upload_quality);
        imagedestroy($src_img);
        imagedestroy($dst_img);
      }
    } else
    if ($extension == "jpg" or $extension == "jpeg") // JPG/JPEG FILE
    {
      if ($size[0] > $size[1]) //Checker for Tværformat / Højformat.
      {
        $this->upload_height = ($this->upload_width/$size[0])*$size[1]; // Regner højden ud så jeg ikke får et distorted billed.
        $src_img = imagecreatefromjpeg("$til"); //GD starter med at generer billedt.
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagejpeg($dst_img, "$filnavn", $this->upload_quality); // Placere mit billed og sætter kvalitet (,70) = 0-100.
        imagedestroy($src_img);
        imagedestroy($dst_img);
      } else
      { // Ellers er billedet højformat og kører samme smøre igen.
        $this->upload_width = ($this->upload_height/$size[1])*$size[0];
        $src_img = imagecreatefromjpeg("$til");
        $dst_img = imagecreatetruecolor($this->upload_width,$this->upload_height);
        imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $this->upload_width, $this->upload_height, $size[0], $size[1]);
        imagejpeg($dst_img, "$filnavn", $this->upload_quality);
        imagedestroy($src_img);
        imagedestroy($dst_img);
      }
    }
  }

  function createthumbs($base) {
    $allowed_files = array(".jpg",".jpeg",".gif",".png");
    $disallowed_dirs = array(".","..","thumbs","styles","counter","minigal");
    $std_upheight = $this->upload_height;
    $std_upwidth = $this->upload_width;
    if (is_dir($base)) {
      $dh = opendir($base);
      while (false !== ($dir = readdir($dh))) {
        if (is_file($dir) && in_array(strtolower(strrchr($dir, ".")),$allowed_files)) {
          set_time_limit();
          if (!is_file($base."thumbs/tn_" . $dir)) {
            //create thumb!!!  
            $this->status .= "<br />".ltrim(str_replace($this->gallerydir,"",$subbase),"/").$dir;
            if (!is_dir($base."thumbs")) {mkdir($base."thumbs",0755); }
            list($width, $height, $type, $attr) = getimagesize($base.$dir);
            if ($width < $std_upwidth || $height < $std_upheight) {
              $this->upload_width = $width;
              $this->upload_height = $height;
            } else {
              $this->upload_width = $std_upwidth;
              $this->upload_height = $std_upheight;
            }
            $til = $base.$dir;
            $filnavn = $base."thumbs/tn_" . $dir;
            $size = Getimagesize($til); //Henter pixel størelse af billed.
            $fileInfo = pathinfo($base.$dir);
            $extension=strtolower($fileInfo["extension"]);
            $this->makethumbs($extension,$til,$filnavn,$size);
          }
          if (!is_file($base."thumbs/tn_med_" . $dir) ) { 
            //create medium sized image!!!
            $size = Getimagesize($base.$dir);
            if ($size[0] > ($this->resizelargeimg-100) || $size[1] > ($this->resizelargeimg-100)) {
              if ($size[0] > $size[1]) { $this->upload_width = $this->resizelargeimg - 100; }
              else{ $this->upload_height = ($this->resizelargeimg-100); }
              $this->status .= "<br />MED: ".ltrim(str_replace($this->gallerydir,"",$subbase),"/").$dir;
              $til = $base.$dir;
              $filnavn = $base."thumbs/tn_med_" . $dir;
              $fileInfo = pathinfo($base.$dir);
              $extension=strtolower($fileInfo["extension"]);
              $this->makethumbs($extension,$til,$filnavn,$size);
            }
          }
        } else if (is_dir($base . $dir) && in_array(strtolower($dir),$disallowed_dirs)===false)
        {
          $subs = $dir;
          $subbase = $base . $dir . "/";
              $sdh = opendir($subbase);
              while (false !== ($subdir = readdir($sdh))) {
                if (is_file($subbase.$subdir) && in_array(strtolower(strrchr($subdir, ".")),$allowed_files)===true) {
                  if (!is_file($subbase."thumbs/tn_" . $subdir)) {
                    //create thumb!!! 
                    $this->status .= "<br />".ltrim(str_replace($this->gallerydir,"",$subbase),"/").$subdir;
                    if (!is_dir($subbase . "thumbs")) {mkdir($subbase."thumbs",0755); }
                    $this->upload_width = $std_upwidth;
                    $this->upload_height = $std_upheight;
                    $til = $subbase.$subdir;
                    $filnavn = $subbase . "thumbs/tn_" . $subdir;
                    $size = Getimagesize($til);
                    $fileInfo = pathinfo($subbase.$subdir);
                    $extension=strtolower($fileInfo["extension"]);
                    $this->makethumbs($extension,$til,$filnavn,$size);
                  }
                  if (!is_file($subbase."thumbs/tn_med_" . $subdir)) {
                    //create medium sized image!!!
                    $size = Getimagesize($subbase . $subdir);
                    if ($size[0] > ($this->resizelargeimg-100) || $size[1] > ($this->resizelargeimg-100)) {
                      if ($size[0] > $size[1]) { 
                        $this->upload_width = $this->resizelargeimg - 100; 
                      } else { $this->upload_height = ($this->resizelargeimg-100); }
                      $this->status .= "<br />MED: " . ltrim(str_replace($this->gallerydir, "", $subbase), "/") . $subdir;
                      $til = $subbase . $subdir;
                      $filnavn = $subbase . "thumbs/tn_med_" . $subdir;
                      $fileInfo = pathinfo($subbase . $subdir);
                      $extension = strtolower($fileInfo["extension"]);
                      $this->makethumbs($extension, $til, $filnavn, $size);
                    }
                  }
                }
              }
              closedir($sdh);
          $this->createthumbs($subbase);
        }
      }
      closedir($dh);
    }
    if ($this->status != "") { 
      return $this->lang["status38"] . ":<br />" . $this->status; 
    } else return $this->lang["status39"];
  } //EOF

//////////////////////////////
//                          //
//        CHMOD ALL         //
//                          //
//////////////////////////////

  function chmodall($base,$chmod) {
    $disallowed_files = array(".php");
    $disallowed_dirs = array(".","..");
    $std_upheight = $this->upload_height;
    $std_upwidth = $this->upload_width;
    if (is_dir($base)) {
      if ($chmod == "0600") { chmod("$base",0600); }
      if ($chmod == "0644") { chmod("$base",0644); }
      if ($chmod == "0755") { chmod("$base",0755); }
      if ($chmod == "0777") { chmod("$base",0777); }
      $dh = opendir($base);
      while (false !== ($dir = readdir($dh))) {
        if (is_file($dir) && in_array(strtolower(strrchr($dir, ".")),$disallowed_files)!==true) {
          if ($chmod == "0600") { chmod("$base$dir",0600); }
          if ($chmod == "0644") { chmod("$base$dir",0644); }
          if ($chmod == "0755") { chmod("$base$dir",0755); }
          if ($chmod == "0777") { chmod("$base$dir",0777); }
        } else if (is_dir($base . $dir) && in_array(strtolower($dir),$disallowed_dirs)===false) {
          $subs = $dir;
          $subbase = $base . $dir . "/";
          if ($chmod == "0600") { chmod("$subbase",0600); }
          if ($chmod == "0644") { chmod("$subbase",0644); }
          if ($chmod == "0755") { chmod("$subbase",0755); }
          if ($chmod == "0777") { chmod("$subbase",0777); }
          $sdh = opendir($subbase);
          while (false !== ($subdir = readdir($sdh))) {
            if (is_file($subbase.$subdir) && in_array(strtolower(strrchr($subdir, ".")),$disallowed_files)!==true) {
              if ($chmod == "0600") { chmod("$subbase$subdir",0600); }
              if ($chmod == "0644") { chmod("$subbase$subdir",0644); }
              if ($chmod == "0755") { chmod("$subbase$subdir",0755); }
              if ($chmod == "0777") { chmod("$subbase$subdir",0777); }
            }
          }
          closedir($sdh);
          $this->chmodall($subbase,$chmod);
        }
      }
      closedir($dh);
    }
  return $this->lang["chmodcomplete"];
  } //EOF

} //EOClass
?>
