<?
//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//                                   MiniGal                                        //
//                                                                                  //
//                        Copyright © 2004 Thomas Rybak                             //
//                      http://www.thomasrybak.com/minigal                          //
//                           minigal@thomasrybak.com                                //
//                                                                                  //
//    MiniGal is free software; you can redistribute it and/or modify               //
//    it under the terms of the GNU General Public License as published by          //
//    the Free Software Foundation; either version 2 of the License, or             //
//    (at your option) any later version.                                           //
//                                                                                  //
//    MiniGal is distributed in the hope that it will be useful,                    //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of                //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 //
//    GNU General Public License for more details.                                  //
//                                                                                  //
//    You should have received a copy of the GNU General Public License             //
//    along with this program; if not, you can find it here:                        //
//    http://www.gnu.org/copyleft/gpl.html                                          //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

class Minigal
{
  var $activestyle;
  var $list;
  var $gallerydir;
  var $page;
  var $image;
  var $images_side;
  var $pagerows;
  var $gallerytitle;
  var $dateformat;
  var $gallerycopyright;
  var $upload_height;
  var $upload_width;

//////////////////////////////
//        DEBUG MODE        //
//////////////////////////////
  function debug() {
    if (isset($_REQUEST["debug"]) && $_REQUEST["debug"] == "yes") {
?>
  <table cellpadding="0" cellspacing="0" border="0" align="center" width="600" class="table_exif" >
    <tr><td>SERVER_NAME</td><td><? if ($_SERVER["SERVER_NAME"]) echo $_SERVER["SERVER_NAME"]; ?><br /></td></tr>
    <tr><td>PHP_SELF</td><td><? if ($_SERVER["PHP_SELF"]) echo $_SERVER["PHP_SELF"]; ?><br /></td></tr>
    <tr><td>PATH_TRANSLATED</td><td><? if ($_SERVER["PATH_TRANSLATED"]) echo $_SERVER["PATH_TRANSLATED"]; ?><br /></td></tr>
    <tr><td>SERVER_SOFTWARE</td><td><? if ($_SERVER["SERVER_SOFTWARE"]) echo $_SERVER["SERVER_SOFTWARE"]; ?><br /></td></tr>
    <tr><td>Operating system</td><td><? if ($_ENV["OS"]) echo $_ENV["OS"]; ?><br /></td></tr>
    <tr><td>Gallery dir</td><td><? if ($this->gallerydir) echo $this->gallerydir; ?><br /></tr>
    <tr><td>Admin email</td><td><a href="mailto:<? $this->owneremail; ?>"><? if ($this->owneremail) echo $this->owneremail; ?></a><br /></tr>
    <tr><td>safe_mode</td><td><? if (ini_get("safe_mode")) echo ini_get("safe_mode") ?></td></tr>
    <tr><td>open_basedir</td><td><? if (ini_get("open_basedir")) echo ini_get("open_basedir") ?></td></tr>
    <tr><td>file_uploads</td><td><? if (ini_get("file_uploads")) echo ini_get("file_uploads") ?></td></tr>
  </table>
<?
    }
  }

//////////////////////////////
//   GET FILES & FOLDERS    //
//////////////////////////////
  function dirlist()
  {
    $allowed_files = array(".jpg",".jpeg",".gif",".png",".mov",".avi",".mpg",".mpeg",".wmv",".asf");
    $disallowed_dirs = array(".","..","thumbs","styles","counter","minigal");
    $dirarray = array();
    $filearray = array();
    $this->list = str_replace("..", "", $this->list);
    if (is_dir("$this->gallerydir/$this->list")) {
      $workdir = opendir("$this->gallerydir/$this->list");
      while ($pointer = readdir($workdir)) {
        if (is_dir("$this->gallerydir/$this->list/$pointer") && !in_array(strtolower($pointer),$disallowed_dirs)) { $this->dirarray[] = $pointer; }
        elseif (is_file("$this->gallerydir/$this->list/$pointer") && in_array(strtolower(strrchr($pointer, ".")), $allowed_files)) { $this->filearray[] = $pointer; }
      }
      closedir($workdir);
    }
    if (@$this->dirarray > 0) { sort($this->dirarray); }
    if (@$this->filearray > 0) { sort($this->filearray); }
  }


//////////////////////////////
//       IS DIR EMPTY       //
//////////////////////////////
  function is_dir_empty($dir)
  {
    $allowed_files = array(".jpg",".jpeg",".gif",".png",".mov",".avi",".mpg",".mpeg",".wmv",".asf");
    if (is_dir($dir)) {
      $dl = opendir($dir);
      if ($dl) {
        while($name = readdir($dl)) {
          if (!is_dir($name) && in_array(strtolower(strrchr($name, ".")), $allowed_files)) {
            return false;
            break;
          }
        }
        closedir($dl);
      }
      return true;
    } else { 
      return true;
    }
  }

//////////////////////////////
//      FIND THUMBNAIL      //
//////////////////////////////
  function setthumb($dirarray)
  {
    unset($thumb);
    $allowed_files = array(".jpg",".jpeg",".gif",".png");
    if (strlen($this->list) > 0) { $this->list .= "/"; } //Set list variable ending slash
    $thumbdir = opendir("$this->gallerydir/$this->list$dirarray");
    if (is_dir("$this->gallerydir/$this->list$dirarray/thumbs")) {
      while (false !== ($thumbtemp = readdir($thumbdir))) {
        // Standard thumb
        if (is_file("$this->gallerydir/$this->list$dirarray/thumbs/tn_thumb.jpg")) {
          return "$this->list$dirarray/thumbs/tn_thumb.jpg";
        } else 
        // Locked folder
        if (is_file("$this->gallerydir/$this->list$dirarray/locked.dir")) {
          return "styles/$this->activestyle/images/locked.gif";
        }
        //"Random thumb"
        if (is_file("$this->gallerydir/$this->list$dirarray/$thumbtemp") && in_array(strtolower(strrchr($thumbtemp, ".")), $allowed_files)) {
          return "$this->list$dirarray/thumbs/tn_$thumbtemp";
        } else 
        // Empty dir
        if ($this->is_dir_empty("$this->gallerydir/$this->list$dirarray")===true) {
          return "styles/$this->activestyle/images/emptythumb.gif";
        }
      }
    } else {
      return "styles/$this->activestyle/images/emptythumb.gif";
    }
    closedir($thumbdir);
    if (strlen($this->list) > 0) { rtrim($this->list, "/"); } //Un-Set list variable ending slash
  }

//////////////////////////////
//   FOLDER NAME/CAPTION    //
//////////////////////////////
  function getfoldername($i)
  {
    if (strlen($this->list) > 0) { $this->list .= "/"; } //Set list variable ending slash
    if (is_file("$this->gallerydir/" . $this->list . "/" . $this->dirarray[$i] . "/caption.dir")) {
      $fd = fopen ("$this->gallerydir/" . $this->list . "/" . $this->dirarray[$i] . "/caption.dir", "rt");
      $currentvalue = "";
      while (!feof($fd)) {
        $currentvalue .= fgets($fd, 4096);
      }
      fclose ($fd);
      echo $currentvalue;
    } else {
      echo $this->dirarray[$i];
    }
    if (strlen($this->list) > 0) { rtrim($this->list, "/"); } //Un-Set list variable ending slash
  }

//////////////////////////////
//     GETCURRENTFOLDER     //
//////////////////////////////
  function getcurrentfolder()
  {
    if (is_file($this->list . "/caption.dir")) {
      $fd = fopen ($this->list . "/caption.dir", "rt");
      while(!feof($fd)) {
        echo fgets($fd, 4096); }
      fclose ($fd);
    } else {
      echo (strlen($this->list) > 0) ? $this->list : $this->gallerytitle ;
    }
  }
  
//////////////////////////////
//    GALLERY NAVIGATION    //
//////////////////////////////
  function navigation($delimiter = "&gt;")
  {
    $imagecomp = 0;
    if ($this->image) { $imagecomp = 1; }
    $pos = strpos($this->list, "/");
    $updirs = explode("/", $this->list);
    $dircount = count($updirs);
    $dirstring = "";
    $updirstring = "";
    if ($dircount > 0) {
      if (strlen($this->list) > 0 || isset($_GET["image"])) {
        echo "<a href=\"index.php\">" . $this->lang["gallery"] . "</a>";
        for ($i = 0; $i < ($dircount + $imagecomp - 1); $i++) {
          if (is_file($updirstring . $updirs[$i] . "/caption.dir")) {
            $fd = fopen($updirstring . $updirs[$i] . "/caption.dir", "rt");
            while (!feof($fd)) {
              $currentdir = fgets($fd, 4096);
            }
            fclose ($fd);
          } else {
            $currentdir = $updirs[$i];
          }
          $updirstring .= $updirs[$i]. "/";
          if (strlen($updirs[$i]) > 0) {
            $dirstring .= " $delimiter <a href=\"index.php?list=" . rtrim($updirstring, "/") . "\">" . $currentdir . "</a>";
          }
        }
      }
    }
    echo $dirstring;
  }

//////////////////////////////
//    IMAGE NAVIGATION(S)   //
//////////////////////////////
  function imagenav($style)
  {
    $subpage = "1";
    $number_this = (array_search($this->image, $this->filearray)+1);
    $number_total = count($this->filearray);
    // Select style:
    if ($style == "1") {
      $nav_first_on  = '<img src="styles/' . $this->activestyle . '/images/nav_first.gif" border="0" width="17" height="11" alt="' . $this->lang["first"] . '" />';
      $nav_first_off = '<img src="styles/' . $this->activestyle . '/images/nav_first_blank.gif" border="0" width="17" height="11" alt="' . $this->lang["first"] . '" />';
      $nav_prev_on   = '<img src="styles/' . $this->activestyle . '/images/nav_previous.gif" border="0" width="11" height="11" alt="' . $this->lang["prev"] . '" />';
      $nav_prev_off  = '<img src="styles/' . $this->activestyle . '/images/nav_previous_blank.gif" border="0" width="11" height="11" alt="' . $this->lang["prev"] . '" />';
      $nav_next_on   = '<img src="styles/' . $this->activestyle . '/images/nav_next.gif" border="0" width="11" height="11" alt="' . $this->lang["next"] . '" />';
      $nav_next_off  = '<img src="styles/' . $this->activestyle . '/images/nav_next_blank.gif" border="0" width="11" height="11" alt="' . $this->lang["next"] . '" />';
      $nav_last_on   = '<img src="styles/' . $this->activestyle . '/images/nav_last.gif" border="0" width="17" height="11" alt="' . $this->lang["last"] . '" />';
      $nav_last_off  = '<img src="styles/' . $this->activestyle . '/images/nav_last_blank.gif" border="0" width="17" height="11" alt="' . $this->lang["last"] . '" />';
    } else {
      if ($style == "2") {
        $nav_first_on = $this->lang["first"];      $nav_first_off = $this->lang["first"];
        $nav_prev_on  = $this->lang["prev"];       $nav_prev_off  = $this->lang["prev"];
        $nav_next_on  = $this->lang["next"];       $nav_next_off  = $this->lang["next"];
        $nav_last_on  = $this->lang["last"];       $nav_last_off  = $this->lang["last"];
      } else {
        $nav_first_on = "&lt;&lt;&lt;&lt;";        $nav_first_off = "&lt;&lt;&lt;&lt;";
        $nav_prev_on  = "&lt;&lt;";                $nav_prev_off  = "&lt;&lt;";
        $nav_next_on  = "&gt;&gt;";                $nav_next_off  = "&gt;&gt;";
        $nav_last_on  = "&gt;&gt;&gt;&gt;";        $nav_last_off  = "&gt;&gt;&gt;&gt;";
      }
    }
    if ($_GET["page"] == "all") { $subpage = "all"; }
    if (array_search($this->image, $this->filearray) > 0) {
      $nav_first = "<a href=\"index.php?image=" . $this->filearray[0] . "&amp;list=$this->list&amp;page=$subpage\">$nav_first_on</a>";
    } else $nav_first = $nav_first_off;

    $subpage = ceil((array_search($this->image, $this->filearray)) / ($this->images_side * $this->pagerows));
    if ($_GET["page"] == "all") { $subpage = "all"; }
    if (array_search($this->image, $this->filearray) > 0) {
      $nav_previous = "<a href=\"index.php?image=" . ($this->filearray[array_search($this->image, $this->filearray)-1]) . "&amp;list=$this->list&amp;page=$subpage\">$nav_prev_on</a>";
    } else $nav_previous = $nav_prev_off;

    $subpage = ceil((array_search($this->image, $this->filearray) + 2) / ($this->images_side * $this->pagerows));
    if ($_GET["page"] == "all") { $subpage = "all"; }
    if (array_search($this->image, $this->filearray) + 1 < count($this->filearray)) {
      $nav_next = "<a href=\"index.php?image=" . ($this->filearray[array_search($this->image, $this->filearray) + 1]) . "&amp;list=$this->list&amp;page=$subpage\">$nav_next_on</a>";
    } else $nav_next = $nav_next_off;

    $subpage = ceil((count($this->filearray))/($this->images_side*$this->pagerows));
    if ($_GET["page"] == "all") { $subpage = "all"; }
    if (array_search($this->image, $this->filearray) + 1 != count($this->filearray)) {
      $nav_last = "<a href=\"index.php?image=" . ($this->filearray[(count($this->filearray) - 1)]) . "&amp;list=$this->list&amp;page=$subpage\">$nav_last_on</a>";
    } else $nav_last = $nav_last_off;
    include("styles/$this->activestyle/templates/template_imagenav.php");
  }

//////////////////////////////
//     PAGE NAVIGATION      //
//////////////////////////////
  function pagecounter()
  {
    if ($this->page == "") { $this->page = 1; }
    if (($this->images_side * $this->pagerows) < count($this->filearray)) {
      echo "<div align=\"center\">" . $this->lang["page"];
      for ($pagecount = 1; ($pagecount * $this->images_side * $this->pagerows) < count($this->filearray); $pagecount++) {
        if ($this->page == $pagecount) {
          echo " $pagecount ";
        } else {
          echo " <a href=\"index.php?list=" . trim($this->list,"/") . "&amp;page=" . $pagecount . "\">" . $pagecount . "</a>";
        }
      }
      if ($this->page == $pagecount) {
        echo " $pagecount ";
      } else {
        echo " <a href=\"index.php?list=" . trim($this->list,"/") . "&amp;page=" . $pagecount . "\">" . $pagecount . "</a>";
      }
      if ($_GET["page"] == "all") {
        echo " " . $this->lang["all"];
      } else {
        echo " <a href=\"index.php?list=" . trim($this->list,"/") . "&amp;page=all\">" . $this->lang["all"] . "</a>";
      }
      echo "</div>\n<br />\n";
    }
  }

//////////////////////////////
//       SHOW CAPTION       //
//////////////////////////////
  function showcaption()
  {
    $openfile = "$this->gallerydir/$this->list/thumbs/" . $this->image . ".cmt";
    if (is_file($openfile)) {
      $fd = fopen($openfile, "rb");
      echo fgets($fd, 4096);
      fclose ($fd);
    }
  }

//////////////////////////////
//    GALLERY COPYRIGHT     //
//////////////////////////////
  function gallerycopyright()
  {
    echo $this->gallerycopyright;
  }

//////////////////////////////
//        SHOW EXIF         //
//////////////////////////////
  function showexif($showexif)
  {
    if ($showexif == "1") {
      include("exif.php");
      $exif = read_exif_data_raw("$this->gallerydir/$this->list/$this->image","no");
      if ($exif["IFD0"]["Model"] != "") {
        include("styles/$this->activestyle/templates/template_exif.php");
      }
    }
  }
  
//////////////////////////////
//     SHOW INTRO TEXT      //
//////////////////////////////
  function showfolderintro()
  {
    if(is_file("$this->gallerydir/$this->list/description.dir")) {
      $fd = fopen ("$this->gallerydir/$this->list/description.dir", "rt");
      $currentvalue = "";
      while (!feof ($fd)) {
        $currentvalue .= fgets($fd, 4096);
      }
      fclose ($fd);
      echo '<div class="introtext">' . nl2br($currentvalue) . '</div>';
    }
  }

//////////////////////////////
//     FOLDER PASSWORD      //
//////////////////////////////
  function folderpwdcheck()
  {
    if (is_file("$this->list/locked.dir")) { // is folder locked?
      $currentpass = "";
      $fd = fopen("$this->list/locked.dir", "rt");
      $currentpass = trim(fgets($fd, 4096));
      fclose ($fd);
      if (md5($_POST["folderpass"]) == $currentpass) {      // if password is correct:
        $_SESSION["folderpass"] = $_POST["folderpass"];
        $_SESSION["logintime"] = time();
      }
      if (md5($_SESSION["folderpass"]) != $currentpass) {
        echo "<div align=\"center\">\n";
        if (isset($_POST["folderpass"])) {
          echo "<p>" . $this->lang["wrong pwd"] . "</p>\n";
        }
?>
<form name="login" method="post" action="index.php">
  <p><? echo $this->lang["folder locked"] ?></p>
  <p><input type="password" name="folderpass" class="textfield" /><br />
    <input type="hidden" name="list" value="<? echo $this->list ?>" />
    <input type="submit" name="<? echo $this->lang["submit"] ?>" value="<? echo $this->lang["enter"] ?>" class="button" /></p>
</form></div>
<?
        include("styles/$this->activestyle/templates/template_footer.php");
        exit();
      } elseif ((time() - $_SESSION["logintime"]) < 900) { // Renew timestamp if not too old
          $_SESSION["logintime"] = time();
      } else { // Do security logoff
        session_destroy();
?>
<div align="center"><form name="login" method="post" action="index.php">
  <p><? echo $this->lang["inactivity logoff"] ?></p>
  <p><input type="password" name="folderpass" class="admintext" /><br />
    <input type="hidden" name="list" value="<? echo $list ?>" />
    <input type="submit" name="<? echo $this->lang["submit"] ?>" value="<? echo $this->lang["enter"] ?>" class="adminbutton" /></p>
</form></div>
<?
        include("styles/$this->activestyle/templates/template_footer.php");
        exit();
      }
    }
  }

//////////////////////////////
//      IMAGE COMMENTS      //
//////////////////////////////
  function imagecomments($showcomments)
  {
    if (isset($_REQUEST["input"])) { // Input comments
      $chatfile = "$this->gallerydir/$this->list/thumbs/$this->image.txt";
      if (strlen($_REQUEST["input"]) > 0 && strlen($_REQUEST["name"]) > 0 && strlen($_REQUEST["email"]) > 0) {
        if (!is_file($chatfile)) {
          $fd = fopen($chatfile,"a+");
        } else 
          $fd = fopen($chatfile,"r+");
        while (!feof ($fd)) {
          $bufferprewrite[] = fgets($fd, 4096);
        }
        fclose($fd);
        array_pop($bufferprewrite);
        $bufferprewrite = array_reverse($bufferprewrite);
        $array = explode("¤", $bufferprewrite[0]);
        if (rtrim($array[1]) <> ucfirst(rtrim($_REQUEST["input"]))) {
          $buffer = date($this->dateformat) . "¤" . ucfirst($_REQUEST["input"]) . "¤" . ucfirst($_REQUEST["name"]) . "¤" . $_REQUEST["email"] . "\r\n";
          $fd = fopen($chatfile,"a+");
          fwrite($fd,$buffer);
          fclose($fd);
          // Send comment mail
          if ($this->sendmail == "1") {
            if (isset($_SERVER["SCRIPT_URI"])) {
              $preset1 = dirname($_SERVER["SCRIPT_URI"]); 
            } else {
              $preset1 = $_SERVER["HTTP_HOST"] . dirname($_SERVER["SCRIPT_NAME"]);
            }
            mail($this->owneremail, "$this->gallerytitle: " . $this->lang["mailsubj"], date($this->dateformat,time()) . "\n\n" . $_REQUEST["name"] . "(" . $_REQUEST["email"] . ") " . $this->lang["mailcontent1"] . ":\n\n" . $_REQUEST["input"] . "\n\n" . $this->lang["mailcontent2"] . "\n\n$preset1/index.php?image=" . rawurlencode("$this->image") . "&list=" . rawurlencode("$this->list"), "From: " . $_REQUEST["email"] . "\nReply-to: " . $_REQUEST["email"]);
          }
        }
      } else {
        echo '<div align="center">' . $this->lang["error comment"] . '</div>';
      }
    }
    //Show user COMMENTS
    if ($showcomments == 1) {
?>
<p>&nbsp;</p>
<form action="index.php" method="get" enctype="text/plain">
  <table cellpadding="3" cellspacing="0" border="0" width="500" align="center" class="table_comments">
    <tr>
      <td colspan="2" align="center"><b><? echo $this->lang["comments"] ?></b></td>
    </tr> 
    <tr>
<?
      if (is_file("$this->gallerydir/$this->list/thumbs/$this->image.txt")) {
        $fd = fopen("$this->gallerydir/$this->list/thumbs/$this->image.txt","r+");
        while (!feof($fd)) {
          $bufferchat[] = fgets($fd, 4096);
        }
        fclose($fd);
        array_pop ($bufferchat);
        $bufferchat = array_reverse ($bufferchat);
        $sizeofbuffer = count($bufferchat);
        for ($counter=0; $counter < $sizeofbuffer; $counter++) {
          $array = explode("¤", trim($bufferchat[$counter]));
          include("styles/$this->activestyle/templates/template_comments.php");
        }
      }
?>
      <td><? echo $this->lang["comment"]; ?><br />
        <input type="text" size="80" name="input" class="textfield" />
      </td>
    </tr>
    <tr>
       <td><? echo $this->lang["name"]; ?><br />
         <input type="text" size="80" name="name" class="textfield" /></td>
    </tr>
    <tr>
      <td><? echo $this->lang["email"] ?><br />
        <input type="text" size="80" name="email" class="textfield" /></td>
    </tr>
    <tr>
      <td>
        <input type="hidden" value="1" name="chatinput" />
        <input type="hidden" value="<?echo $this->list ?>" name="list" />
        <input type="hidden" value="<?echo $this->image?>" name="image" />
        <input type="submit" value="<?echo $this->lang["add comment"] ?>" class="button" />
      </td>
    </tr>
  </table>
</form>
<br />
<?
    }
  }

//////////////////////////////
//       GET CAPTION        //
//////////////////////////////
  function getcaption($thumbcaptions, $i)
  {
    if ($thumbcaptions == "1") {
      $this->caption = "";
      if (strlen($this->list) > 0) { $this->list .= "/"; } //Set list variable ending slash
      $openfile = "$this->gallerydir/" . $this->list . "thumbs/" . $this->filearray[$i] . ".cmt";
       if (is_file($openfile)) {
         $fd = fopen ($openfile, "rb");
         echo fgets($fd, 4096);
         fclose ($fd);
       }
    }
    if (strlen($this->list) > 0) { rtrim($this->list, "/"); } //Un-Set list variable ending slash
  }

}
?>

