<?
//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//                                   MiniGal                                        //
//                                                                                  //
//                        Copyright © 2004 Thomas Rybak                             //
//                      http://www.thomasrybak.com/minigal                          //
//                           minigal@thomasrybak.com                                //
//                                                                                  //
//    MiniGal is free software; you can redistribute it and/or modify               //
//    it under the terms of the GNU General Public License as published by          //
//    the Free Software Foundation; either version 2 of the License, or             //
//    (at your option) any later version.                                           //
//                                                                                  //
//    MiniGal is distributed in the hope that it will be useful,                    //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of                //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 //
//    GNU General Public License for more details.                                  //
//                                                                                  //
//    You should have received a copy of the GNU General Public License             //
//    along with this program; if not, you can find it here:                        //
//    http://www.gnu.org/copyleft/gpl.html                                          //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

session_start();

// Set headers to prevent browser caching of pages
header("Cache-control: private, no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); # Past date
header("Pragma: no-cache");


if (isset($_REQUEST["debug"]) && ($_REQUEST["debug"] == "yes")) { error_reporting(E_ALL); }
else { error_reporting(0); } //Turn error reporting on when debugging, else off

///////////////////////////////
//                           //
// DETECT IF MINIGAL CAN RUN //
//                           //
///////////////////////////////

// GD lib >2.00 check
if (!function_exists("imagecreatetruecolor")) {
    echo "<h1>Error: MiniGal cannot run!</h1>\n";
    echo "<p>Function \"imagecreatetruecolor\" is not available. You should install the correct <a href=\"http://www.boutell.com/gd/\">GD library</a> version with PHP</p>";
    exit();
}
//Folder access check
if (!mkdir("thumbs2") && !is_file("settings.php")) {
    echo "<h1>Error: MiniGal cannot run!</h1>\n";
    echo "<p>MiniGal does not have write access to gallery dir. Change gallery dir chmod to 777 and run script again.</p>";
    exit();
}
if (is_dir("thumbs2")) { rmdir("thumbs2"); }
// safe_mode check
if (ini_get("safe_mode")) {
   echo "<h1>Error: MiniGal cannot run!</h1>
   <p>Your PHP installation is running in safe_mode which is unsupported due to heavy file system restrictions.</p>
   <p>What you can do:<br />
     - Change \"safe_mode\" to off in php.ini (if you run the server yourself).<br />
     - Ask your host to turn it off and alternatively use \"open_basedir\" which is less restrictive but still safe.<br />
     - Find a better host!</p>
   <p>NOTE: A safe mode compatible version of MiniGal is being planned. Watch the website/forum for news about this</p>";
   exit();
}

//////////////////////////////
//                          //
//      INITIAL STUFF       //
//                          //
//////////////////////////////

//Set variables
if (isset($_REQUEST['list'])) {
  $list  = (get_magic_quotes_gpc()) ? stripslashes($_REQUEST['list']) : $_REQUEST['list'];
}
if (isset($_REQUEST['image'])) {
  $image = (get_magic_quotes_gpc()) ? stripslashes($_REQUEST['image']) : $_REQUEST['image'];
}

$folder            = (get_magic_quotes_gpc()) ? stripslashes($_REQUEST["folder"]) : $_REQUEST["folder"];
$action            = (isset($_REQUEST["action"])) ? $_REQUEST["action"] : "";
$selectfile        = (isset($_REQUEST["selectfile"])) ? $_REQUEST["selectfile"] : "";
$addtext           = (isset($_REQUEST["addtext"])) ? $_REQUEST["addtext"] : "";
$fileaction        = (isset($_REQUEST["fileaction"])) ? $_REQUEST["fileaction"] : "";
$newfilename       = (isset($_REQUEST["newfilename"])) ? $_REQUEST["newfilename"] : "";
$dirname           = (isset($_REQUEST["dirname"])) ? $_REQUEST["dirname"] : "";
$renamedir         = (isset($_REQUEST["renamedir"])) ? $_REQUEST["$renamedir"] : "";
$phpself           = (isset($_SERVER["PATH_TRANSLATED"]))? dirname($_SERVER["PATH_TRANSLATED"]) . "/" : "";

//Includes
include($phpself."settings.php");
include($phpself."classes.php");
include($phpself."classes_admin.php");
if (is_file("counter.php")) { include("counter.php"); }

//Classes
$MGaction = new Minigal;
$MGaction->list = $list;
$MGaction->gallerydir = $gallerydir;

$MGadmin = new MGadmin;
include("language.php");// Load language file
$MGadmin->headline = $gallerytitle;
$MGadmin->list = $list;
$MGadmin->image = $image;
$MGadmin->charset = $charset;
$MGadmin->folder = $folder;

// Pass settings to MGadmin
$MGadmin->gallerytitle = $gallerytitle;
$MGadmin->gallerydir = $gallerydir;
$MGadmin->owneremail = $owneremail;
$MGadmin->activestyle = $activestyle;
$MGadmin->sendmail = $sendmail;
$MGadmin->showexif = $showexif;
$MGadmin->showcomments = $showcomments;
$MGadmin->thumbcaptions = $thumbcaptions;
$MGadmin->resizelargeimg = $resizelargeimg;
$MGadmin->dateformat = $dateformat;
$MGadmin->images_side = $images_side;
$MGadmin->pagerows = $pagerows;
$MGadmin->upload_height = $upload_height;
$MGadmin->upload_width = $upload_width;
$MGadmin->upload_quality = $upload_quality;
$MGadmin->gallerycopyright = $gallerycopyright;
$MGadmin->adminpass = $adminpass;
$MGadmin->version = "B13";

$movie_ext= array(".mov",".avi",".mpg",".mpeg",".wmv",".asf");

$MGaction->debug();
$MGadmin->initialsetup();

if (!is_dir("thumbs")) { mkdir("thumbs"); } //Create gallery thumb dir if not already

//////////////////////////////
//                          //
//      OUTPUT SCRIPT       //
//                          //
//////////////////////////////

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<title><? echo $gallerytitle; ?></title>
<meta name="title" content="<? echo $gallerytitle ?>" />
<meta name="robots" content="noindex,nofollow" />
<meta http-equiv="Content-Type" content="text/html; charset=<? echo $charset ?>" />
<link href="styles/shared/admin.css" rel="stylesheet" type="text/css" />
<script language="JavaScript" type="text/javascript">
<!-- 
function checkAll() {
  for (var j = 0; j < document.fileform.i.value; j++) {
    box = eval("document.fileform.selectfile" + j);
    if (box.checked == false) box.checked = true;
  }
}
 function uncheckAll() {
  for (var j = 0; j < document.fileform.i.value; j++) {
    box = eval("document.fileform.selectfile" + j);
    if (box.checked == true) box.checked = false;
   }
}
 function formFocus() {
  if (document.forms.length > 0)  document.forms[0].elements[0].focus();
}
-->
</script>
</head>
<body onload="formFocus();">
<? 

$MGadmin->accesscontrol();
if ($_REQUEST["upload"] == "set") { $status = $MGadmin->uploads(); }
$MGaction->list = $MGadmin->list;
if ($_REQUEST["createthumbs"] == "yes") { $status = $MGadmin->createthumbs("$gallerydir/"); } //Create thumbs
if ($_REQUEST["chmodall"] == "yes") { $status = $MGadmin->chmodall("$gallerydir/",$_REQUEST["chmod"]); } //Change chmod

//------------------------------------Main display
?>
<table width="750" cellpadding="0" cellspacing="1" class="admintable" align="center">
  <tr>
    <td class="adminh1" colspan="10"><? echo $MGadmin->lang["admin"] . ": $gallerytitle" ?></td>
  </tr>
<?
///////////////////////////
//         TABS          //
///////////////////////////

if (strlen($action) > 0) { $status = $MGadmin->fileactions($action); }
if (isset($status)) { ?>
  <tr>
    <td class="adminstatus" colspan="10"><? echo $status ?></td>
  </tr>
<? }

//////////////////////////////
//                          //
//       MENU BAR           //
//                          //
//////////////////////////////

$MGaction->dirlist();
$introimg = (is_file("$gallerydir/$list/description.dir")) ? "introtext.gif" : "introtext_off.gif";

?>
  <tr>
    <td class="admintoolbar" colspan="10">
      <a href="admin.php?action=upload&amp;list=<? echo $list ?>"><img src="styles/shared/upload.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav1"] ?>" alt="<? echo $MGadmin->lang["nav1"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="admin.php?action=newfolder&amp;list=<? echo $list ?>"><img src="styles/shared/newfolder.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav2"] ?>" alt="<? echo $MGadmin->lang["nav2"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="admin.php?action=addintro&amp;list=<? echo $list ?>"><img src="styles/shared/<? echo $introimg ?>" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav3"] ?>" alt="<? echo $MGadmin->lang["nav3"] ?>"/></a>&nbsp;&nbsp;&nbsp;
<? if (is_file("$gallerydir/$list/locked.dir")) { ?>
      <a href="admin.php?folder=<? echo $list . $MGaction->dirarray[$i]; ?>&amp;action=unlockfolder&amp;list=<? echo $list ?>"><img src="styles/shared/lockfolder.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav4"] ?>" alt="<? echo $MGadmin->lang["nav4"] ?>" /></a>&nbsp;&nbsp;&nbsp;
<? } else { ?>
      <a href="admin.php?action=lockfolder&amp;list=<? echo $list ?>"><img src="styles/shared/lockfolder_off.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav5"] ?>" alt="<? echo $MGadmin->lang["nav5"] ?>"/></a>&nbsp;&nbsp;&nbsp;
<? } ?>
      <a href="admin.php?action=createthumbs&amp;list=<? echo $list ?>"><img src="styles/shared/createthumbs.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav6"] ?>" alt="<? echo $MGadmin->lang["nav6"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="admin.php?action=changesettings"><img src="styles/shared/changesettings.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav7"] ?>" alt="<? echo $MGadmin->lang["nav7"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="admin.php?action=changepwd"><img src="styles/shared/key.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav8"] ?>" alt="<? echo $MGadmin->lang["nav8"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="index.php?list=<? echo $list ?>" target="_blank"><img src="styles/shared/show.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["nav9"] ?>" alt="<? echo $MGadmin->lang["nav9"] ?>" /></a>&nbsp;&nbsp;&nbsp;
      <a href="admin.php?action=logoff"><img src="styles/shared/exit.gif" width="48" height="48" border="0" title="<? echo $MGadmin->lang["logoff1"] ?>" alt="<? echo $MGadmin->lang["logoff1"] ?>" /></a>
    </td>
  </tr>
  <tr height="20"> 
    <td class="admintdleft" colspan="3"><?
      echo $MGadmin->navigation(); // Do the rest
    ?></td>
    <td class="adminheadline" colspan="7"><? echo $MGadmin->headline ?></td>
  </tr>
  <tr height="30">
    <td width="40" class="admintd"><? echo $MGadmin->lang["select"] ?></td>
    <td width="80" class="admintd"><? echo $MGadmin->lang["preview"] ?></td>
    <td width="330" class="admintd"><? echo $MGadmin->lang["filename"] ?></td>
    <td width="100" class="admintd"><? echo $MGadmin->lang["filesize"] ?></td>
    <td width="40" class="admintd"><? echo $MGadmin->lang["chmod"] ?></td>
    <td width="160" class="admintd" colspan="5"><? echo $MGadmin->lang["actions"] ?></td>
  </tr>

<form method="post" name="fileform" action="admin.php">

<?
//////////////////////////////
//                          //
//       ECHO FOLDERS       //
//                          //
//////////////////////////////

if (strlen($MGaction->list)>0) { $MGaction->list .= "/"; } //Set list variable ending slash
if ((@count($MGaction->dirarray) < 1) && (@count($MGaction->filearray) < 1))  { 
?>
  <tr>
    <td colspan="10" class="admintdleft" height="30"><b><? echo $MGadmin->lang["folderempty"] ?></b></td>
  </tr>
<?  
}
for ($i = 0; $i < @count($MGaction->dirarray); $i++) {
?>
  <tr height="20">
    <td colspan="2" class="admintdleft" width="120">
      <a href="admin.php?list=<? echo $MGaction->list . $MGaction->dirarray[$i] ?>" title="<? echo $MGadmin->lang["created"] . " " . date("j.m.Y H:i", filectime("$gallerydir/$MGaction->list" . $MGaction->dirarray[$i])) ?>"><? echo $MGaction->dirarray[$i] ?></a>
    </td>
    <td class="admintd">
<? 
  if (strlen($MGadmin->list)>0) { $MGadmin->list .= "/"; } // Add slash to end of $this->list
  if ($MGadmin->is_dir_empty($MGadmin->list . $MGaction->dirarray[$i]) === true) {
    $MGadmin->list = rtrim($MGadmin->list, "/"); //Remove trailing slash again
      echo $MGadmin->lang["empty"];
  }
?>
    </td>
    <td class="admintd">&nbsp;</td>
    <td class="admintd" width="40"><? echo substr(sprintf("%o", fileperms($MGaction->list . $MGaction->dirarray[$i])), -3) ?></td>
    <td class="admintd" width="40">
<? if (is_file($MGaction->list.$MGaction->dirarray[$i] . "/locked.dir")) { //Display padlock if subfolder is locked ?>  
      <a href="admin.php?folder=<? echo $MGaction->list . $MGaction->dirarray[$i] ?>&amp;action=unlockfolder&amp;list=<? echo $list ?>"><img 
        src="styles/shared/lock.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["nav4"] ?>" alt="<? echo $MGadmin->lang["nav4"] ?>" /></a>
<?  }  ?>
    </td>
    <td class="admintd" width="40">
<?  if (is_file("$gallerydir/$MGaction->list" . $MGaction->dirarray[$i] . "/thumbs/tn_thumb.jpg")) { //Display delete thumb ?>
      <a href="admin.php?list=<? echo rtrim($MGaction->list,"/") ?>&amp;selected=<? echo $MGaction->dirarray[$i] ?>&amp;action=unsetthumb"><img 
        src="styles/shared/delthumb.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["deletethumb"] ?>" alt="<? echo $MGadmin->lang["deletethumb"] ?>" /></a>
<?  }  ?>
    </td>
    <td class="admintd" width="40">
      <a href="admin.php?action=renamedir&amp;list=<? echo $list ?>&amp;dirname=<? echo $MGaction->dirarray[$i] ?>"><img 
        src="styles/shared/rename.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["renamefolder"] ?>" alt="<? echo $MGadmin->lang["renamefolder"] ?>" /></a>
    </td>
    <td class="admintd" width="40">
<?  if (is_file("$gallerydir/" . $MGaction->list.$MGaction->dirarray[$i] . "/caption.dir")) { ?>
      <a href="admin.php?action=foldercaption&amp;list=<? echo $list ?>&amp;folder=<? echo $MGaction->dirarray[$i] ?>"><img 
        src="styles/shared/caption.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["editcaption"] ?>" alt="<? echo $MGadmin->lang["editcaption"] ?>" /></a>
<?  } else  { ?>
      <a href="admin.php?action=foldercaption&amp;list=<? echo $list ?>&amp;folder=<? echo $MGaction->dirarray[$i] ?>"><img 
        src="styles/shared/caption_off.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["addcaption"] ?>" alt="<? echo $MGadmin->lang["addcaption"] ?>" /></a>
<?  } ?>
    </td>
    <td class="admintd" width="40">
      <a href="admin.php?list=<? echo $MGadmin->list ?>&amp;folder=<? echo $MGaction->dirarray[$i] ?>&amp;action=deletedir"><img 
        src="styles/shared/delete.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["deletefolder"] ?>" alt="<? echo $MGadmin->lang["deletefolder"] ?>" /></a>
    </td>
  </tr>
<?
}

//////////////////////////////
//                          //
//       ECHO FILES         //
//                          //
//////////////////////////////

$totalfilesize = 0;
for ($i = 0; $i < @count($MGaction->filearray); $i++) {
  if (!in_array(strrchr($MGaction->filearray[$i], "."), $movie_ext)) { //Check if movie=false
    list($width, $height, $type, $attr) = getimagesize("$gallerydir/$MGaction->list" . "thumbs/tn_" . $MGaction->filearray[$i]);
  }
  $width = $width / 5;
  $height = $height / 5;
  $totalfilesize += filesize("$gallerydir/$MGaction->list" . $MGaction->filearray[$i]);
  $dec = "1"; $val = "bytes";
  if (strlen(filesize("$gallerydir/$MGaction->list" . $MGaction->filearray[$i])) > 3) { $dec="1000"; $val="KB"; }
  if (strlen(filesize("$gallerydir/$MGaction->list" . $MGaction->filearray[$i])) > 6) { $dec="1000000"; $val="MB"; }
?>
  <tr height="30">
    <td class="admintd">
      <input type="checkbox" name="selectfile<? echo $i ?>" value="<? echo $MGaction->filearray[$i] ?>" />
    </td>
    <td class="admintd">
<?  if (in_array(strrchr($MGaction->filearray[$i], "."), $movie_ext)) { //Check if movie=true  ?>
      <a href="<? echo $MGaction->list . $MGaction->filearray[$i] ?>" target="_blank"><img 
        src="styles/shared/movie.gif" height="33" width="50" border="0" title="<? echo $MGadmin->lang["presstoview"] ?>"
        alt="<? echo $MGadmin->lang["presstoview"] ?>"  /></a>
<?  } else { ?>
      <a href="index.php?image=<? echo $MGaction->filearray[$i] ?>&amp;list=<? echo $list ?>" target="_blank"><img 
        src="<? echo $MGaction->list ?>thumbs/tn_<? echo $MGaction->filearray[$i] ?>" height="<? echo $height ?>" width="<? echo $width ?>" border="0" 
        title="<? echo $MGadmin->lang["created"] ." " . date("j.m.Y H:i", filectime("$gallerydir/$MGaction->list" . $MGaction->filearray[$i])) ?>" alt="" /></a>
<?  } ?>
    </td>
    <td class="admintd"><? echo $MGaction->filearray[$i] ?></td>
    <td class="admintd"><? echo round((filesize("$gallerydir/$MGaction->list" . $MGaction->filearray[$i])/$dec),2) . " " . $val ?></td>
    <td class="admintd" width="40"><? echo substr(sprintf("%o", fileperms($MGaction->list.$MGaction->filearray[$i])), -3) ?></td>
    <td class="admintd" width="40">
<?  if (is_file("$gallerydir/" . $MGaction->list . "thumbs/" . $MGaction->filearray[$i] . ".txt")) { // Edit comments icon ?>
      <a href="admin.php?list=<? echo $list ?>&amp;image=<? echo $MGaction->filearray[$i] ?>&amp;action=editcomments"><img 
      src="styles/shared/comments.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["editcomments"] ?>"  
      alt="<? echo $MGadmin->lang["editcomments"] ?>" /></a>
<?  } ?>
    </td>
    <td class="admintd" width="40">
<?  if (strlen($MGadmin->list) > 0 && !in_array(strrchr($MGaction->filearray[$i], "."),$movie_ext))   { //Lets user set default thumb unless in gallery root ?>
      <a href="admin.php?list=<? echo $list ?>&amp;image=<? echo $MGaction->filearray[$i] ?>&amp;action=setthumb"><img 
      src="styles/shared/setthumb.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["setthumb"] ?>" 
      alt="<? echo $MGadmin->lang["setthumb"] ?>" /></a>
<?  } ?>
    </td>
    <td class="admintd" width="40">
      <a href="admin.php?action=renamefile&amp;list=<? echo $list ?>&amp;image=<? echo $MGaction->filearray[$i] ?>"><img 
        src="styles/shared/rename.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["renamefile"] ?>" alt="<? echo $MGadmin->lang["renamefile"] ?>" /></a>
    </td>
    <td class="admintd" width="40">
<?  if (is_file("$gallerydir/$list/thumbs/" . $MGaction->filearray[$i] . ".cmt")) { ?>
      <a href="admin.php?action=addcaption&amp;list=<? echo $list ?>&amp;image=<? echo $MGaction->filearray[$i] ?>"><img 
        src="styles/shared/caption.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["editcaption"] ?>"  
        alt="<? echo $MGadmin->lang["editcaption"] ?>" /></a>
<?  } else { ?>
      <a href="admin.php?action=addcaption&amp;list=<? echo $list ?>&amp;image=<? echo $MGaction->filearray[$i] ?>"><img 
        src="styles/shared/caption_off.gif" width="24" height="24" border="0" title="<? echo $MGadmin->lang["addcaption"] ?>"  
        alt="<? echo $MGadmin->lang["addcaption"] ?>" /></a>
<?  } ?>
    </td>
    <td class="admintd" width="40">&nbsp;</td>
  </tr>
<?
}
  // File handling options
?>
  <tr>
    <td class="admintd">
      <img src="styles/shared/checkbox_on.gif" width="13" height="13" title="<? echo $MGadmin->lang["checkall"] ?>" onclick="checkAll()" />
      <img src="styles/shared/checkbox_off.gif" width="13" height="13" title="<? echo $MGadmin->lang["uncheckall"] ?>" onclick="uncheckAll()" />
    </td>
    <td class="admintdleft" colspan="9">
      <select size="1" name="whataction" class="admindropdown">
        <option value="" selected="selected"><? echo $MGadmin->lang["chooseaction"] ?></option>
        <option value="delete"><? echo $MGadmin->lang["delete"] ?></option>
        <option value="move">--- <? echo $MGadmin->lang["moveto"] ?> ---</option>
        <option value="<? echo $gallerydir ?>/"><? echo $MGadmin->lang["galleryroot"] ?></option>
      <? $MGadmin->dirdropdown("$gallerydir/"); ?>
      </select>
      <input type="hidden" name="action" value="move" />
      <input type="hidden" name="list" value="<? echo $list ?>"/>
      <input type="hidden" name="i" value="<? echo $i ?>" />
      <input type="image" src="styles/shared/ok.gif" class="adminpicbutton" title="<? echo $MGadmin->lang["submit"] ?>" />
    </td>
  </tr>
<?
if (strlen($MGaction->list) > 0) { rtrim($MGaction->list,"/"); } //Set list variable ending slash

//////////////////////////////
//                          //
//       STATUS BAR         //
//                          //
//////////////////////////////

$dec = "1"; $val = "bytes";
if (@strlen($totalfilesize) > 3) { $dec = "1000"; $val = "KB"; }
if (@strlen($totalfilesize) > 6) { $dec = "1000000"; $val = "MB"; }
?>
  <tr height="30">
    <td class="admintd" colspan="10">
      <? echo $MGadmin->lang["total"] . ": " . @count($MGaction->filearray) . " " . $MGadmin->lang["files"] 
      . " (" . @round(($totalfilesize/$dec), 2) . " $val), " . @count($MGaction->dirarray) . " " . $MGadmin->lang["subfolders"]; ?>
    </td>
  </tr>
  <tr>
    <td class="admintd" colspan="10"><a 
      href="http://www.thomasrybak.com/minigal/download.php" target="_blank"><? echo $MGadmin->lang["newversion"] ?></a>
    </td>
  </tr>
</form>
</table>
<br />
<div align="center">
  <i><? echo $MGadmin->lang["admininterface"] . " ($version)" ?></i><br />
</div>
<br />
</body>
</html>


