<?php
/*
 input.php - input modul

 Copyright (C) 2001 Achim Winkler <achim@lkcc.org>

 This is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This software is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this package; see the file COPYING.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.  
*/

class CInput extends CTools {

	function CInput($emotion = "no") {
		$this->CTools($emotion);
	}
	

	function Write_Data(&$newname, &$newmail, &$newicq, &$newaim, &$newurl, &$newtext, &$random) {
		global $REMOTE_ADDR; 

		#flood protection
		while (file_exists("temp/ip.lck")) {
			usleep(500000);
			$i++;
			if ($i > 9) die ("ip.tmp is locked! Please try it later again!");
		}
		$lock = fopen("temp/ip.lck", "w") or die ("Can't create ip.lck!");
		fclose($lock);
		
		$oldlog = $nowrite = false;
		if (!file_exists("temp/ip.tmp")) {
			$logfile = fopen("temp/ip.tmp", "w") or die ("Can't create ip.tmp!");
		} else {
			$logfile = fopen("temp/ip.tmp", "r") or die ("Can't open ip.tmp for reading!");
			$oldlog = true;		
		}
		if ($oldlog) {
			$lastip = trim(fgets($logfile, 1024));
			$lasttime = trim(fgets($logfile, 1024));
			$lastip1 = trim(fgets($logfile, 1024));
			$lasttime1 = trim(fgets($logfile, 1024));
			if ($REMOTE_ADDR == $lastip && (time() - $this->floodwait) < $lasttime) {
				$nowrite = true;
			} 
			elseif ($REMOTE_ADDR == $lastip1 && (time() - $this->floodwait) < $lasttime1) {
				$nowrite = true;
				if ($random != -1) {
					unlink("temp/temp".$random.".dat");
				}
			} else {
				fclose($logfile);
				$logfile = fopen("temp/ip.tmp", "w") or die ("Can't create ip.tmp!");
				fputs($logfile, rtrim($REMOTE_ADDR)."\r\n");
				fputs($logfile, rtrim(time())."\r\n");
				fputs($logfile, rtrim($lastip)."\r\n");
				fputs($logfile, rtrim($lasttime)."\r\n");
			}		
		} else {
			fputs($logfile, rtrim($REMOTE_ADDR)."\r\n");
			fputs($logfile, rtrim(time())."\r\n");
			fputs($logfile, rtrim($lastip)."\r\n");
			fputs($logfile, rtrim($lasttime)."\r\n");		
		}
				
		fclose($logfile);
		unlink("temp/ip.lck");
		
		if (!$nowrite) {
			if ($this->language == "eng") {
				$newdate = strftime("%m.%d.%Y %H:%M", time() + ($this->fixedtime * 3600));
			} else {
				$newdate = strftime("%d.%m.%Y %H:%M", time() + ($this->fixedtime * 3600));
			}
						
			#tempfile available? (preview)
			if ($random != -1) {
				if (file_exists("temp/temp".$random.".dat")) {
					$input = fopen("temp/temp".$random.".dat", "r");
					
					$newname = rtrim(fgets($input, 1024));
					$newmail = rtrim(fgets($input, 1024));
					$newicq = rtrim(fgets($input, 1024));
					$newaim = rtrim(fgets($input, 1024));
					$newurl = rtrim(fgets($input, 1024));
					$newtext = rtrim(fgets($input, 16384));
										
					fclose($input);
					unlink("temp/temp".$random.".dat");
				} else {
					header ("Location: guestbook.php?act=show");
					exit();			
				}
			}
			
			$this->newname = $newname;
			$this->newmail = $newmail;
			$this->newicq = $newicq;
			$this->newaim = $newaim;
			$this->newurl = $newurl;
			$this->newtext = $newtext;
			$this->Check_Empty();
			
			$this->Format_String($newname, "name");
			$this->Format_String($newmail, "mail");
			$this->Format_String($newicq, "icq");
			$this->Format_String($newaim, "aim");
			$this->Format_String($newurl, "url");
			$this->Format_String($newtext, "text");
			
			#write data
			$i = 0;
			while (file_exists($this->datapath."/data.lck")) {
				usleep(500000);
				$i++;
				if ($i > 9) die ("Data.dat is locked! Please try it later again!");
			}
			$lock = fopen($this->datapath."/data.lck", "w") or die ("Can't create data.lck!");
			fclose($lock);
			
			$output = fopen($this->datapath."/data.dat", "a") or die ("The file data.dat is write protected!");
					
			$i = 0;
			while (file_exists($this->datapath."/index.lck")) {
				usleep(500000);
				$i++;
				if ($i > 9) die ("Index.dat is locked! Please try it later again!");
			}
			$lock = fopen($this->datapath."/index.lck", "w") or die ("Can't create index.lck!");
			fclose($lock);
			
			$output1 = fopen($this->datapath."/index.dat", "a") or die ("The file index.dat is write protected!");
					
			fseek($output, 0, SEEK_END);		#fix for windows?!?!
			$position = (string)ftell($output);
			fputs($output, rtrim("name=".$newname)."\r\n");
			fputs($output, rtrim("mail=".$newmail)."\r\n");
			fputs($output, rtrim("icq=".$newicq)."\r\n");
			fputs($output, rtrim("aim=".$newaim)."\r\n");
			fputs($output, rtrim("url=".$newurl)."\r\n");
			fputs($output, rtrim("text=".$newtext)."\r\n");
			fputs($output, rtrim("date=".$newdate)."\r\n");
			if ($this->logip != 0) {
				fputs($output, rtrim("ip=".$REMOTE_ADDR)."\r\n");
			} else {
				fputs($output, rtrim("ip=")."\r\n");
			}
					
			for ($i = strlen($position); $i < $this->indexsize; $i++)
				$dummy .= "0";
			$position = $dummy.$position;
			fputs($output1, $position);
					
			fclose($output);
			unlink($this->datapath."/data.lck");
			fclose($output1);
			unlink($this->datapath."/index.lck");
			
			if ($this->adminmail != "") {
				mail("$this->adminmail", "New entry in your guestbook!", "name = $newname\nmail = $newmail\nicq = $newicq\naim = $newaim\nurl = $newurl\ntext = $newtext\ndate = $newdate\nip = $REMOTE_ADDR\n\nYour guestbook!");
			}
			if ($this->moderatormail != "") {
				mail("$this->moderatormail", "New entry in your guestbook!", "name = $newname\nmail = $newmail\nicq = $newicq\naim = $newaim\nurl = $newurl\ntext = $newtext\ndate = $newdate\nip = $REMOTE_ADDR\n\nYour guestbook!");
			}
		}		
	}
	
}
?>