# Table structure for table 'geodesic_auctions'
#

CREATE TABLE geodesic_auctions (
   id int(14) NOT NULL auto_increment,
   seller varchar(13),
   title tinytext,
   date int(14),
   description text,
   image_url tinytext,
   category int(11),
   minimum_bid double(16,2),
   reserve_price double(16,2),
   auction_type char(1),
   duration char(2),
   location_state tinytext,
   location_zip varchar(10),
   ends int(14),
   closed tinyint(1) DEFAULT '0',
   quantity int(11),
   high_bid double(6,2) DEFAULT '0.00' NOT NULL,
   PRIMARY KEY (id),
   KEY id (id)
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_bids'
#

CREATE TABLE geodesic_auctions_bids (
   auction varchar(13),
   bidder varchar(13),
   bid double(16,4),
   time_of_bid int(14),
   quantity int(4) DEFAULT '0'
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_categories'
#

CREATE TABLE geodesic_auctions_categories (
   category_id int(4) NOT NULL auto_increment,
   parent_id int(4),
   category_name tinytext,
   description tinyblob,
   display_order tinyint(4),
   PRIMARY KEY (category_id)
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_feedbacks'
#

CREATE TABLE geodesic_auctions_feedbacks (
   rated_user_id varchar(13),
   rater_user_id varchar(20),
   feedback mediumtext,
   rate tinyint(1),
   date int(14),
   auction_id int(11) DEFAULT '0' NOT NULL,
   done tinyint(1) DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_increments'
#

CREATE TABLE geodesic_auctions_increments (
   low double(16,2),
   high double(16,2),
   increment double(16,2)
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_logins'
#

CREATE TABLE geodesic_auctions_logins (
   id int(11) NOT NULL auto_increment,
   username varchar(25) NOT NULL,
   password varchar(25) NOT NULL,
   PRIMARY KEY (id)
);

INSERT INTO geodesic_auctions_logins VALUES ( '1', 'admin', 'geodesic');

# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_states'
#

CREATE TABLE geodesic_auctions_states (
   abbreviation varchar(5) NOT NULL,
   name varchar(25) NOT NULL
);

#
# Dumping data for table 'geodesic_auctions_states'
#

INSERT INTO geodesic_auctions_states VALUES ( 'AL', 'Alabama');
INSERT INTO geodesic_auctions_states VALUES ( 'AK', 'Alaska');
INSERT INTO geodesic_auctions_states VALUES ( 'AZ', 'Arizona');
INSERT INTO geodesic_auctions_states VALUES ( 'AR', 'Arkansas');
INSERT INTO geodesic_auctions_states VALUES ( 'CA', 'California');
INSERT INTO geodesic_auctions_states VALUES ( 'CO', 'Colorado');
INSERT INTO geodesic_auctions_states VALUES ( 'CT', 'Connecticut');
INSERT INTO geodesic_auctions_states VALUES ( 'DE', 'Delaware');
INSERT INTO geodesic_auctions_states VALUES ( 'DC', 'District of Columbia');
INSERT INTO geodesic_auctions_states VALUES ( 'FL', 'Florida');
INSERT INTO geodesic_auctions_states VALUES ( 'GA', 'Georgia');
INSERT INTO geodesic_auctions_states VALUES ( 'HI', 'Hawaii');
INSERT INTO geodesic_auctions_states VALUES ( 'ID', 'Idaho');
INSERT INTO geodesic_auctions_states VALUES ( 'IL', 'Illinois');
INSERT INTO geodesic_auctions_states VALUES ( 'IN', 'Indiana');
INSERT INTO geodesic_auctions_states VALUES ( 'IA', 'Iowa');
INSERT INTO geodesic_auctions_states VALUES ( 'KS', 'Kansas');
INSERT INTO geodesic_auctions_states VALUES ( 'KY', 'Kentucky');
INSERT INTO geodesic_auctions_states VALUES ( 'LA', 'Louisiana');
INSERT INTO geodesic_auctions_states VALUES ( 'ME', 'Maine');
INSERT INTO geodesic_auctions_states VALUES ( 'MD', 'Maryland');
INSERT INTO geodesic_auctions_states VALUES ( 'MA', 'Massachusetts');
INSERT INTO geodesic_auctions_states VALUES ( 'MI', 'Michigan');
INSERT INTO geodesic_auctions_states VALUES ( 'MN', 'Minnesota');
INSERT INTO geodesic_auctions_states VALUES ( 'MS', 'Mississippi');
INSERT INTO geodesic_auctions_states VALUES ( 'MO', 'Missouri');
INSERT INTO geodesic_auctions_states VALUES ( 'MT', 'Montana');
INSERT INTO geodesic_auctions_states VALUES ( 'NE', 'Nebraska');
INSERT INTO geodesic_auctions_states VALUES ( 'NV', 'Nevada');
INSERT INTO geodesic_auctions_states VALUES ( 'NH', 'New Hampshire');
INSERT INTO geodesic_auctions_states VALUES ( 'NJ', 'New Jersey');
INSERT INTO geodesic_auctions_states VALUES ( 'NM', 'New Mexico');
INSERT INTO geodesic_auctions_states VALUES ( 'NY', 'New York');
INSERT INTO geodesic_auctions_states VALUES ( 'NC', 'North Carolina');
INSERT INTO geodesic_auctions_states VALUES ( 'ND', 'North Dakota');
INSERT INTO geodesic_auctions_states VALUES ( 'OH', 'Ohio');
INSERT INTO geodesic_auctions_states VALUES ( 'OK', 'Oklahoma');
INSERT INTO geodesic_auctions_states VALUES ( 'OR', 'Oregon');
INSERT INTO geodesic_auctions_states VALUES ( 'PA', 'Pennsylvania');
INSERT INTO geodesic_auctions_states VALUES ( 'RI', 'Rhode Island');
INSERT INTO geodesic_auctions_states VALUES ( 'SC', 'South Carolina');
INSERT INTO geodesic_auctions_states VALUES ( 'SD', 'South Dakota');
INSERT INTO geodesic_auctions_states VALUES ( 'TN', 'Tenessee');
INSERT INTO geodesic_auctions_states VALUES ( 'TX', 'Texas');
INSERT INTO geodesic_auctions_states VALUES ( 'UT', 'Utah');
INSERT INTO geodesic_auctions_states VALUES ( 'VT', 'Vermont');
INSERT INTO geodesic_auctions_states VALUES ( 'VA', 'Virginia');
INSERT INTO geodesic_auctions_states VALUES ( 'WA', 'Washington');
INSERT INTO geodesic_auctions_states VALUES ( 'WV', 'West Virginia');
INSERT INTO geodesic_auctions_states VALUES ( 'WI', 'Wisconsin');
INSERT INTO geodesic_auctions_states VALUES ( 'WY', 'Wyoming');




# --------------------------------------------------------
#
# Table structure for table 'geodesic_auctions_userdata'
#

CREATE TABLE geodesic_auctions_userdata (
   id int(11) DEFAULT '0' NOT NULL,
   username varchar(25) NOT NULL,
   email varchar(50) NOT NULL,
   newsletter smallint(1) DEFAULT '1' NOT NULL,
   level int(1) DEFAULT '0' NOT NULL,
   company_name varchar(50) NOT NULL,
   business_type varchar(30) NOT NULL,
   firstname varchar(50) NOT NULL,
   lastname varchar(50) NOT NULL,
   address varchar(50) NOT NULL,
   address_2 varchar(50),
   zip varchar(12) NOT NULL,
   city varchar(50) NOT NULL,
   state varchar(50) NOT NULL,
   country varchar(50) NOT NULL,
   phone varchar(50) NOT NULL,
   phone2 varchar(50) NOT NULL,
   fax varchar(50),
   url tinyblob,
   rate_sum int(11) DEFAULT '0' NOT NULL,
   rate_num int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id)
);

INSERT INTO geodesic_classifieds_userdata VALUES ( '1', 'admininstration', '', '0', '1', '', '', 'admin', 'admin', '', '', '', '', '', '', '', '', '', '', '0', '0');

# --------------------------------------------------------
#
# Table structure for table 'geodesic_confirm'
#

CREATE TABLE geodesic_confirm (
   id varchar(30) NOT NULL,
   mdhash varchar(100),
   username varchar(25),
   password varchar(25),
   email varchar(50),
   date int(14) DEFAULT '0' NOT NULL,
   firstname varchar(30) NOT NULL,
   lastname varchar(50) NOT NULL,
   address varchar(50) NOT NULL,
   address_2 varchar(50),
   city varchar(50) NOT NULL,
   state varchar(30) NOT NULL,
   country varchar(50) NOT NULL,
   zip varchar(15) NOT NULL,
   phone varchar(25) NOT NULL,
   phone_2 varchar(25),
   fax varchar(25),
   company_name varchar(50) NOT NULL,
   business_type varchar(30) NOT NULL,
   url varchar(75),
   newsletter varchar(10) DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'geodesic_confirm_email'
#

CREATE TABLE geodesic_confirm_email (
   id int(8) DEFAULT '0' NOT NULL,
   email varchar(50),
   mdhash varchar(100),
   date int(14) DEFAULT '0' NOT NULL
);
