<? //register_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/

class Register {

	var $registered_variables;
	var $error_found;
	var $error;
	var $username;
	var $password;
	
	//name of the site
	var $site_name = "GeoAuctions Lite Version Demo"; 
	
	//the email address that all communications will be sent to 
	//with regards to new registrations
	var $registration_admin_email = "geoauctions@geodesicsolutions.com";
	
	//url to this file
	var $registration_url = "http://www.geodesicsolutions.com/products/auctions/litedemo/register.php";
	
	//1 - send email to admin when someone completes registration
	//0 - will not send
	var $send_register_complete_email_admin = 1; 
	
	//1 - send the client an email when registration complete
	//0 - will not send the client an email when registration complete
	var $send_register_complete_email_client = 1; 
	
	//1 - send an email to the admin when someone attempts the first step of registration
	//0 - will not send an email to the admin when someone attempts the first step of registration
	var $send_register_attempt_email_admin = 1; 
	
	//random string to seed the hash with
	var $secret_for_hash = "somethingprettylong"; 
	var $hash;
	
	//names of database tables - can be left alone
	var $auction_confirmation_table = "geodesic_confirm";
	var $auction_confirm_email_table = "geodesic_confirm_email";
	var $auction_login_table = "geodesic_auctions_logins";
	var $auction_userdata_table = "geodesic_auctions_userdata";
	var $auction_states_table = "geodesic_auctions_states";
	
	var $messages = array();
	
	//font tag information used throughout several parts of the site
	var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";	
	
	//if set to 1 this field will be required to complete registration
	var $company_name_required = 0;
	var $address_field_required = 1;
	var $city_field_required = 1;
	var $state_field_required = 1;
	var $zip_field_required = 1;
	var $phone_field_required = 1;
		
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function Register () 
	{
		$this->messages[1500] = "Registration Header";
		$this->messages[1501] = "Registration Title";
		$this->messages[1502] = "business";
		$this->messages[1503] = "individual";
		$this->messages[1504] = "company name";
		$this->messages[1505] = "address";
		$this->messages[1506] = "address 2";
		$this->messages[1507] = "city";
		$this->messages[1508] = "state";
		$this->messages[1509] = "zip code";
		$this->messages[1510] = "first contact number";
		$this->messages[1511] = "second contact number";
		$this->messages[1512] = "fax number";
		$this->messages[1513] = "first name";
		$this->messages[1514] = "last name";
		$this->messages[1515] = "email address";
		$this->messages[1516] = "website url address";
		$this->messages[1517] = "Registration Title (page 2)";
		$this->messages[1518] = "Registration Step 2 Instructions";
		$this->messages[1519] = "username";
		$this->messages[1520] = "password";
		$this->messages[1521] = "password confirm";
		$this->messages[1522] = "agree to user agreement";
		$this->messages[1523] = "yes";
		$this->messages[1524] = "no";
		$this->messages[1525] = "please send future newsletters and promotional items";
		$this->messages[1526] = "yes";
		$this->messages[1527] = "registration confirmation email subject";
		$this->messages[1528] = "registration confirmation email body";
		$this->messages[1529] = "Welcome ";
		$this->messages[1530] = "registration confirmation success message";
		$this->messages[1531] = "registration confirmation not successful message";
		$this->messages[1532] = "registration confirmation error introduction";
		$this->messages[1533] = "internal confirmation error message";
		$this->messages[1534] = "internal registration error message";
		$this->messages[1535] = "registration error introduction message";
		$this->messages[1536] = "Please select a state";
		$this->messages[1537] = "Registration Confirmation";
		$this->messages[1538] = "Your Registration is almost complete.  Please check your email.  
			We have just sent you an email containing a link. Click on this link or cut and paste it into a browser.
			Once your email has been confirmed your registration will be complete.";
		$this->messages[1539] = "Your username is must be at least 6 characters and no longer than 12 (no spaces)";
		$this->messages[1540] = "The username you are trying to use already exists, please try again";
		$this->messages[1541] = "Welcome, ";
		$this->messages[1542] = "Thank you for registering with us!\n\rHere is the information we recieved :\n\n\r";;
		$this->messages[1543] = "Thank you for your decision to register with ";
		$this->messages[1544] = "For your protection, your account will not be activated until you \nreply to this email by cutting and pasting the following link and entering it into a browsers address field (please get the complete link as some email programs may spread to text over two lines):\n\n";
		$this->messages[1545] = "If you did not apply for the account please ignore this message.\n\n\rThis program provided by Geodesic Solutions\n\rhttp://www.geodesicsolutions.com";
		$this->messages[1546] = "Your registration has already been confirmed or your confirmation has expired.  You will have to reregister.";
		$this->messages[1547] = "From: ";
		$this->messages[1548] = "yes";
		$this->messages[1549] = "yes";
		$this->messages[1550] = "yes";
		$this->messages[1551] = "Your password must be at least 6 characters and no longer than 12";
		$this->messages[1552] = "Your password verifier did not match your  password, please reenter both";
		$this->messages[1553] = "Once you have read,understand and accept our User Agreement click here";
		$this->messages[1554] = "Your username has been taken before you could confirm your registration.";
		$this->messages[1555] = "please choose a state";
		
		$this->messages[5000] = "Please enter an email address";
		$this->messages[5001] = "Please enter your city information";
		$this->messages[5002] = "Please enter company name";
		$this->messages[5003] = "Please enter your first name";
		$this->messages[5004] = "Please enter your last name";
		$this->messages[5005] = "Please enter your street address information";
		$this->messages[5006] = "This email address already exists please choose another";
		$this->messages[5007] = "Please retype your email address";
		$this->messages[5008] = "Please enter your state information";
		$this->messages[5009] = "Please enter your zip code information";
		$this->messages[5010] = "Please enter your phone number";
		$this->messages[5011] = "Please enter your city information";
		$this->messages[5012] = "Please enter your city information";
		
				
	} //end of function Register

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function check_info($db,$info=0)
	{
		if ($info)
			$this->save_variables($info);
		
		$this->error = array();
		$this->error_found = 0;
		
		if ($this->company_name_required)
		{
			if (strlen(trim($this->registered_variables[company_name])) == 0) 
			{
				$this->error[company_name] = $this->messages[5002];
				$this->error_found++;
			}
		}

		if (strlen(trim($this->registered_variables[firstname])) == 0) 
		{
			$this->error[firstname] = $this->messages[5003];
			$this->error_found++;
		}

		if (strlen(trim($this->registered_variables[lastname])) == 0 ) 
		{
			$this->error[lastname] = $this->messages[5004];
			$this->error_found++;
  		}

		if ($this->address_field_required)
		{
			if (strlen(trim($this->registered_variables[address]))== 0 ) 
			{
				$this->error[address] = $this->messages[5005];
				$this->error_found++;
			}
		}

		if (strlen(trim($this->registered_variables[email])) > 0)
		{
			if (eregi("^([a-z0-9]+)(([a-z0-9._-]+))*[@]([a-z0-9]+)([._-]([a-z0-9]+))*[.]([a-z0-9]){2}([a-z0-9])?$", $this->registered_variables[email]))
			{
				$sql_query = "select id from ".$this->auction_userdata_table." where email = \"".$this->registered_variables[email]."\"";
				$result = &$db->Execute($sql_query);
				if (!$result)
				{
					//echo $sql_query." is the id check query<br>\n";
					$this->error["registration"] = $this->messages[1534];
					return false;				
				}
				elseif ($result->RecordCount() > 0)
				{
					//email already in use
					$this->error[email] = $this->messages[5006];
					$this->error_found++;
				}
			}
	  		else
	  		{
				$this->error[email] = $this->messages[5007];
				$this->error_found++;
	  		}
		}
		else
		{
			$this->error[email] = $this->messages[5000];
			$this->error_found++;
		}

		if ($this->city_field_required)
		{
			if (strlen(trim($this->registered_variables[city])) == 0 )
			{
				$this->error[city] = $this->messages[5001];
				$this->error_found++;
			}
		}
		
		if ($this->state_field_required)
		{		
			if ($this->registered_variables[state] == "none" )
			{
				$this->error[state] = $this->messages[5008];
				$this->error_found++;
			}
		}
		
		if ($this->zip_field_required)
		{		
			if (strlen(trim($this->registered_variables[zip])) == 0 )
			{
				$this->error[zip] = $this->messages[5009];
				$this->error_found++;
			}
		}
		
		if ($this->phone_field_required)
		{		
			if (strlen(trim($this->registered_variables[phone])) == 0 )
			{
				$this->error[phone] = $this->messages[5010];
				$this->error_found++;
			}
		}

		if ($this->error_found > 0)
			return false;
		else
			return true;		

	} //end of function check_info($info)
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function save_variables($info) {

		$this->registered_variables["company_name"] = $info[company_name];
   		$this->registered_variables["phone"] = $info[phone];
   		$this->registered_variables["phone_2"] = $info[phone_2];
   		$this->registered_variables["zip"] = $info[zip];
   		$this->registered_variables["state"] = $info[state];
   		$this->registered_variables["city"] = $info[city];
   		$this->registered_variables["email"] = $info[email];
   		$this->registered_variables["address"] = $info[address];
   		$this->registered_variables["address_2"] = $info[address_2];
   		$this->registered_variables["firstname"] = $info[firstname];
   		$this->registered_variables["lastname"] = $info[lastname];
   		$this->registered_variables["business_type"] = $info[business_or_individual];
   		$this->registered_variables["fax"] = $info[fax];
   		$this->registered_variables["url"] = $info[url];
   		$this->registered_variables["country"] = "United States";

	} //end of function save_variables() {

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function registration_form_1($db) 
	{
		echo "<table cellpadding=5 cellspacing=0 border=1 align=center width=600>\n";
		echo "<tr>\n\t<td>\n\t<form action=register.php?b=1 method=post>\n\t";
		echo "<table cellpadding=3 cellspacing=0 border=0 align=center width=100%>\n\t";
		echo "<tr>\n\t\t<td colspan=3>".$this->font_title_tag.$this->messages[1501]."</td>\n\t</tr>\n\t";
		echo "<tr>\n\t\t<td colspan=3>".$this->font_tag.$this->messages[1500]."</td>\n\t</tr>\n\t";
		echo "<tr><td align=right>".$this->font_tag.$this->messages[1502]."
			<input type=radio name=c[business_or_individual] value=business";

		 if ($this->registered_variables[business_or_individual] == "business") echo checked;

		 echo "></td><td left colspan=2>".$this->font_tag.$this->messages[1503]."
		 	<input type=radio name=c[business_or_individual] value=individual ";

		 if ($this->registered_variables[business_or_individual] != "individual") echo checked;

		 echo ">\n\t\t</td>\n\t</tr>\n\t";

		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1513]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=text name=c[firstname] value=\"".$this->registered_variables["firstname"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[firstname]))
			echo $this->font_tag.$this->error[firstname];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1514]."</td>\n\t\t";
		echo "<td>\n\t
			<input type=text name=c[lastname] value=\"".$this->registered_variables["lastname"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[lastname]))
			echo $this->font_tag.$this->error[lastname];
		echo "</td>\n\t</tr>\n\t";
		 
		 echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1504]."</td>\n\t\t\t";
		 echo "<td>\n\t\t
		 	<input type=text name=c[company_name] value=\"".$this->registered_variables["company_name"]."\" size=30 maxsize=50>
			</td>\n\t\t<td>&nbsp;";
			if (isset($this->error[company_name]))
				echo $this->font_tag.$this->error[company_name];
			echo "&nbsp;</td>\n\t</tr>\n\t";
		echo "<tr>\n\t\t<td valign=top align=right>".$this->font_tag.$this->messages[1505]."</td>\n\t\t";
		echo "<td>\n\t\t<input type=text name=c[address] value=\"";
		echo $this->registered_variables["address"];
		echo "\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[address]))
			echo $this->font_tag.$this->error[address];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td valign=top align=right>".$this->font_tag.$this->messages[1506]."</td>\n\t\t";
		echo "<td colspan=2>\n\t\t
			<input type=text name=c[address_2] value=\"".$this->registered_variables["address_2"]."\" size=30 maxsize=50>\n\t\t</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1507]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=text name=c[city] value=\"".$this->registered_variables["city"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[city]))
			echo $this->font_tag.$this->error[city];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1508]."</td>\n\t\t";
		echo "<td>";
		$this->show_state_dropdown($db,$this->registered_variables["state"],"c[state]");
		echo "</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[state]))
			echo $this->font_tag.$this->error[state];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1509]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=text name=c[zip] value=\"".$this->registered_variables["zip"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[zip]))
			echo $this->font_tag.$this->error[zip];
		echo "</td>\n\t</tr>\n\t";
	
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[1510]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=text name=c[phone] value=\"".$this->registered_variables["phone"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[phone]))
			echo $this->font_tag.$this->error[phone];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1511]."\n\t\t</td>\n\t\t";
		echo "<td colspan=2>\n\t\t
			<input type=text name=c[phone_2] value=\"".$this->registered_variables["phone_2"]."\" size=30 maxsize=50>\n\t\t</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1512]."</td>\n\t\t";
		echo "<td colspan=2>\n\t\t
			<input type=text name=c[fax] value=\"".$this->registered_variables["fax"]."\" size=30 maxsize=50>\n\t\t</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1515]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=text name=c[email] value=\"".$this->registered_variables["email"]."\" size=30 maxsize=50>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[email]))
			echo $this->font_tag.$this->error[email];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1516]."</td>\n\t\t";
		echo "<td colspan=2>\n\t\t
			<input type=text name=c[url] value=\"".$this->registered_variables["url"]."\" size=30 maxsize=70>\n\t\t</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td colspan=3 align=center>\n\t\t
			<input type=submit name=submit value=\"go to step 2 of registration\">\n\t\t</td>\n\t</tr>\n\t";
		echo "</table>\n\t</form>\n\t</td>\n</tr>\n</table>\n";

	} //end of function registration_form_1()

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function registration_form_2 ($info=0) 
	{
		echo "<table cellpadding=5 cellspacing=0 border=1 align=center width=600>\n<tr>\n\t";
		echo "<td>\n\t<form action=register.php?b=2 method=post>\n\t";
		echo "<table cellpadding=3 cellspacing=0 border=0 align=center width=100%>\n\t";
		echo "<tr>\n\t\t<td colspan=3>".$this->font_title_tag.$this->messages[1517]."</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td colspan=3>".$this->font_tag.$this->messages[1518]."<br><br></td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right width=33%>".$this->font_tag.$this->messages[1519]."</td>\n\t\t";
		echo "<td width=33%>\n\t\t
			<input type=text name=c[username] ";
		if ($info)
			echo "value=\"".$info["username"]."\"";
		echo " size=15 maxsize=15>\n\t\t</td>\n\t\t";
		echo "<td width=33%>&nbsp;";
		if (isset($this->error[username]))
		   	echo $this->font_tag.$this->error[username];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1520]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=password name=c[password] size=15 maxsize=15>\n\t\t</td>\n\t\t";
		echo "<td>&nbsp;";
		if (isset($this->error[password]))
			echo $this->font_tag.$this->error[password];
		echo "</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1521]."</td>\n\t\t";
		echo "<td>\n\t\t
			<input type=password name=c[password_confirm] size=15 maxsize=15>\n\t\t</td>\n\t\t";
		echo "<td>";
		if ($this->error[repeat_password])
			echo $this->font_tag.$this->error[repeat_password];
		echo "</td>\n\t</tr>\n\t";
		echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[1522]."</td>\n\t";
		echo "<td>".$this->messages[1523]."<input type=radio name=c[agreement] value=yes> "
			.$this->messages[1524]."<input type=radio name=c[agreement] checked value=no>\n\t\t</td>\n\t\t";
		echo "<td>";
		if ($this->error[yes_to_agreement])
			echo $this->font_tag.$this->error[yes_to_agreement];
		echo "</td>\n\t</tr>\n\t";
		
		//echo "<tr>\n\t\t<td align=right>".$this->messages[1525]."</td>\n\t\t";
		//echo "<td colspan=2>".$this->messages[1526]."
		//	<input type=radio name=c[newsletter] checked value=yes> no<input type=radio name=c[newsletter] value=no>\n\t\t</td>\n\t</tr>\n\t";
		
		echo "<tr>\n\t\t<td colspan=3 align=center>\n\t\t
			<input type=submit name=submit value=\"send information\">\n\t\t</td>\n\t</tr>\n\t";
		echo "</table>\n\t</form>\n\t</td>\n</tr>\n</table>";
		
	} //end of function registration_form_2 ()

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function insert_user($db) {

		//there are no error in the final part of the form so enter everything into the database
		//get unique id
		//echo "hello from insert_user<br>\n";
		do {
			$id = md5(uniqid(rand()));
			$id = eregi_replace("[a-f]","",$id);
			$id = substr( $id, 0,8);
			$sql_query = "SELECT * FROM ".$this->auction_confirm_email_table." WHERE id = \"".$id."\"";
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				echo $sql_query." is the query<br>\n";
				$this->error["registration"] = $this->messages[1534];
				return false;
			}			
		} while ($result->RecordCount() > 0);
		
		//insert into the confirm_email table and get an id
		$this->hash = md5($this->secret_for_hash.$this->username);
		$time = time();
		$sql_query = "insert into ".$this->auction_confirm_email_table." 
			(id,email,mdhash,date)
			VALUES
			(\"".$id."\",\"".$this->registered_variables["email"]."\",\"".$this->hash."\",\"".$time."\")";
		$email_confirm_result = &$db->Execute($sql_query);
		echo $sql_query." is the query<br>\n";
		if (!$email_confirm_result)
		{
			echo $sql_query." is the query<br>\n";
			$this->error["registration"] = $this->messages[1534];
			return false;
		}			
		
		//need to finish all inserts
		$sql_query="INSERT INTO ".$this->auction_confirmation_table." (mdhash, id, username, password,date,
			firstname, lastname, address, address_2, city, state, country, zip, phone,phone_2, fax, 
			email, company_name,business_type, url,newsletter)
			VALUES
			(\"$this->hash\",\"$id\", \"". Addslashes ($this->username)."\", \"". Addslashes ($this->password)."\",
			".$time." ,\""
			. Addslashes ($this->registered_variables[firstname])."\", \""
			. Addslashes ($this->registered_variables[lastname])."\", \""
			. AddSlashes ($this->registered_variables[address])."\", \""
			. Addslashes ($this->registered_variables[address_2])."\", \""
			. AddSlashes ($this->registered_variables[city])."\", \""
			. AddSlashes ($this->registered_variables[state])."\", \""
			. AddSlashes ($this->registered_variables[country])."\", \""
			. AddSlashes ($this->registered_variables[zip])."\", \""
			. AddSlashes ($this->registered_variables[phone])."\", \""
			. AddSlashes ($this->registered_variables[phone_2])."\", \""
			. Addslashes ($this->registered_variables[fax])."\", \""
			. Addslashes ($this->registered_variables[email])."\", \""
			. Addslashes ($this->registered_variables[company_name])."\", \""
			. Addslashes ($this->registered_variables[business_type])."\", \""
			. Addslashes ($this->registered_variables[url])."\",\""
			. Addslashes ($newsletter)."\"
			)";

		$result = &$db->Execute($sql_query);
		echo $sql_query." is the query<br>\n";
		if (!$result)
		{
			echo $sql_query." is the query<br>\n";
			$this->error["registration"] = $this->messages[1534];
			return false;
		}

		$confirmurl = ($this->registration_url."?b=3&hash=" . "$this->hash" . "&username=" . "$this->username");

		$mailto = $this->registered_variables[email];
		//echo $mailto." is the mailto address<br>\n";
		$subject = $this->site_name;
		//echo $subject." is the subject<br>\n";
		$message = $this->messages[1541]." ".$this->username."\n\n\r";
		$message .= $this->messages[1542];
		$message .= $this->messages[1519].": ".$this->username."\n\r".$this->messages[1520].": ".$this->password."\n\r";
		$message .= $this->messages[1515].": ".$this->registered_variables[email]."\n\n\r".$this->messages[1543].$this->site_name.".  \n\r";
		
		$message .= $this->messages[1544].$confirmurl."\n\n".$this->messages[1545];
		$from = $this->messages[1547].$this->registration_admin_email;
		
		//echo $message." is the message<br>\n";
		
		@mail($mailto, $subject, $message, $from);
		if ($this->send_register_attempt_email_admin) 
		{
		    $mailto = $this->registration_admin_email;
	 	    $subject = "NOTIFY ".$this->site_name." Registration attempt";
		    $message ="Username : ".$this->username."\n\rPassword : ".$this->password."\n\rE-Mail : ".$this->registered_variables[email]."\n\n\r";
		    $from = "From: ".$this->registration_admin_email;
		    @mail($mailto, $subject, $message, $from);
		}
		//echo $sql_query." is the sql_query<br>\n";
		return true;
	} //end of function insert_user

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function check_username($db,$username=0) 
	{
		//echo "hello from check_username<br>\n";
		$this->username = trim($username);
		$this->error[username] = "";
		$username_length = strlen(trim($username));
		if (($username_length == 0 ) || ($username_length > 12) || ($username_length < 6) || (!ereg("^[[:alnum:]_-]+$", $username)))
		{
			$this->error[username] = $this->messages[1539];
			$this->error_found++;
		 }
		else
		{
			$sql_query = "select id from ".$this->auction_login_table." where username = \"".$username."\"";
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				$this->error["registration"] = $this->messages[1534];
				return false;
			}
	
			if ($result->RecordCount() > 0)
			{
				$this->error[username] = $this->messages[1540];
				$this->error_found++;
			}
		 }
		 return true;
	} //end of function check_username($username)

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function check_password($password=0,$password_confirm=0) 
	{
		$this->password = trim($password);
		$password_length = strlen(trim($password));
		if ((($password_length == 0 ) || ($password_length >12) || ($password_length < 6)) && (!ereg("^[[:alnum:]_-]+$", $password)))	{
			$this->error[password] = $this->messages[1551];
			$this->error_found++;
		}

		if ($password_confirm != $password ) {
			$this->error[repeat_password] = $this->messages[1552];
			$this->error_found++;
		}
		return true;
	} //end of function check_password


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function check_agreement($agreement) 
	{
		//echo "hello from check_agreement<br>\n";
		if ((empty($agreement)) || ($agreement != "yes")) {
			$this->error[yes_to_agreement] =  $this->messages[1553];
			$this->error_found++;
		}
		return true;
	} //end of function check_agreement($agreement)
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	
	
	function confirm ($db,$hash=0,$username=0) 
	{
		if (!$this->expire_confirmations($db))
		{
			$this->error["confirm"] = $this->messages[1533];
			return false;
		}
		
  		if (($hash) && ($username)) 
		{
			//echo $hash." is the hash inside confirm<br>\n";
			//echo $username." is the username inside confirm<br>\n";
			$sql_query = "select * from ".$this->auction_confirmation_table." where mdhash = \"".$hash."\" AND username = \"".$username."\"";
			//echo $sql_query." is the query<br>\n";
			$result = &$db->Execute($sql_query);
			if (!$result) 
			{
				echo $sql_query." is the query<br>\n";
				$this->error["confirm"] = $this->messages[1533];
				return false;
		  	}
		  	elseif (($result->RecordCount() == 0) || ($result->RecordCount() > 1))
		  	{
		  		//bad return or not in the confirm table
		  		//echo $sql_query." is the query<br>\n";
		  		//echo "bad return<Br>\n";
		  		$this->error["confirm"] = $this->messages[1546];
		  		return false;
		  	}
		  	elseif ($result->RecordCount() == 1)
		  	{
		  		$show = $result->FetchNextObject();
		  		
		  		//double check the username again to make sure
		  		$this->error_found = 0;
		  		$this->check_username($db,$username);
		  		if ($this->error_found > 1)
		  		{
		  			//the username has been taken since trying to register the first time
		  			$this->error["confirm"] = $this->messages[1554];
		  			return false;
		  		}
		  		
		  		$sql_query = "insert into ".$this->auction_login_table." (username, password) 
		  			values
		  			(\"".$show->USERNAME."\", \"".$show->PASSWORD."\")";
		  		//echo $sql_query." is the query<br>\n";
				$result = &$db->Execute($sql_query);
				if (!$result) 
				{
					echo $sql_query." is the query<br>\n";
					$this->error["confirm"] = $this->messages[1533];
					return false;
			  	}
			  	else
			  	{
			  		$user_id = $db->Insert_ID();
			  		//insert login data into the login table
			  		$sql_query = "insert into ".$this->auction_userdata_table." values 
						(".$user_id.",'".$show->USERNAME."','".$show->EMAIL."',
						'".$show->NEWSLETTER."', 0,'".$show->COMPANY_NAME."',
						'".$show->BUSINESS_TYPE."','".$show->FIRSTNAME."','".$show->LASTNAME."',
						'".$show->ADDRESS."','".$show->ADDRESS_2."','".$show->ZIP."',
						'".$show->CITY."','".$show->STATE."','".$show->COUNTRY."',
		  				'".$show->PHONE."','".$show->PHONE_2."','".$show->FAX."','".$show->URL."',0,0)";
					$result = &$db->Execute($sql_query);
					//echo $sql_query." is the query<br>\n";
					if (!$result) 
					{
						echo $sql_query." is the query<br>\n";
						$this->error["confirm"] = $this->messages[1533];
						return false;
				  	}
				  	else
				  	{
				  		//delete from the confirm table
				  		$sql_query = "delete from ".$this->auction_confirmation_table." where username = \"".$username."\"";
				  		$result = &$db->Execute($sql_query);
				  		//echo $sql_query." is the query<br>\n";
						if (!$result) 
						{
							echo $sql_query." is the query<br>\n";
							$this->error["confirm"] = $this->messages[1533];
							return false;
			  			}

				  		$sql_query = "delete from ".$this->auction_confirm_email_table." where mdhash = \"".$hash."\"";
				  		$result = &$db->Execute($sql_query);
				  		//echo $sql_query." is the query<br>\n";
						if (!$result) 
						{
							echo $sql_query." is the query<br>\n";
							$this->error["confirm"] = $this->messages[1533];
							return false;
			  			}
				  		
				  		//send email saying registration is complete
				  		if ($this->send_register_complete_email_client)
				  		{
							$mailto = $show->EMAIL;
							$subject = $this->messages[1527];
							$message = $this->messages[1529]." ".$show->USERNAME."\n\n\r".$this->messages[1528];
							$from = "From: ".$this->registration_admin_email."\n\rReply-to: ".$this->registration_admin_email;				  		
				  			@mail($mailto, $subject, $message, $from);
				  		}
				  		
				  		if ($this->send_register_complete_email_admin)
				  		{
							$mailto = $this->registration_admin_email;
							$subject = $this->messages[1527];
							$message = "just registered: ".$show->USERNAME."\n\r";
							$message .= "user_id: ".$user_id."\n\r";
							$message .= "email: ".$show->EMAIL."\n\r";
							$message .= "company name: ".$show->COMPANY_NAME."\n\r";
							$message .= "first name: ".$show->FIRSTNAME."\n\r";
							$message .= "last name: ".$show->LASTNAME."\n\r";
							$message .= "address: ".$show->ADDRESS."\n\r";
							$message .= "address line 2: ".$show->ADDRESS_2."\n\r";
							$message .= "city: ".$show->CITY."\n\r";
							$message .= "state: ".$show->STATE."\n\r";
							$message .= "zip: ".$show->ZIP."\n\r";
							$message .= "country: ".$show->COUNTRY."\n\r";
							$message .= "phone: ".$show->PHONE."\n\r";
							$message .= "phone 2: ".$show->PHONE_2."\n\r";
							$message .= "fax: ".$show->FAX."\n\r";
							$message .= "url: ".$show->URL."\n\r";
							$from = "From: ".$this->site_name;				  		
				  			@mail($mailto, $subject, $message, $from);
				  		}				  		
				  		return true;
				  	}
			  	}
		  	}
		}
		else
		{
			$this->error["confirm"] = $this->messages[1533];
			return false;
		}
	} //end of function confirm

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function confirmation_instructions () 
	{
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[1537]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[1538]."</td>\n</tr>\n";
		echo "</table>\n";
		session_destroy();
	} //end of function confirm

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	
	
	function registration_confirmation_success() 
	{
		//registration confirmation was successfull
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[1530]."</td>\n</tr>\n";
		echo "</table>\n";
		
	} //end of function registration_confirmation_success()
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function confirmation_error() 
	{
		// confirmation was unsuccessfull
		//display the error message
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[1531]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[1532]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->error["confirm"]."</td>\n</tr>\n";
		echo "</table>\n";
		
	} //end of function confirmation_error()
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function registration_error() 
	{
		//registration was unsuccessfull
		//display the error message
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[1531]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[1532]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->error["registration"]."</td>\n</tr>\n";
		echo "</table>\n";
		
	} //end of function confirmation_error()
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function expire_confirmations($db) 
	{
		//expire the confirmation in the database that exceed the admin limit in days
		$time = time();
		$this->confirm_expiration_in_days = 1;
		$expire_time = $time - (86400 * $this->confirm_expiration_in_days);
		
		$sql_query = "select * from ".$this->auction_confirm_email_table." where date < ".$expire_time;
		$result = &$db->Execute($sql_query);
		if (!$result) 
		{
			echo $sql_query." is the query<br>\n";
			$this->error["confirm"] = $this->messages[1533];
			return false;
		}
		elseif ($result->RecordCount() > 0)
		{
			//get all the ids to delete from the confirm table
			while ($show = $result->FetchNextObject())
			{
				$sql_query = "delete from ".$this->auction_confirmation_table." where id = ".$show->ID;
				$delete_result = &$db->Execute($sql_query);
				if (!$delete_result) 
				{
					echo $sql_query." is the query<br>\n";
					$this->error["confirm"] = $this->messages[1533];
					return false;
				}	
				
				$sql_query = "delete from ".$this->auction_confirm_email_table." where id = ".$show->ID;
				$delete_result = &$db->Execute($sql_query);
				if (!$delete_result) 
				{
					echo $sql_query." is the query<br>\n";
					$this->error["confirm"] = $this->messages[1533];
					return false;
				}				
			}
		}
		return true;
		
	} //end of function confirmation_error()
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function show_state_dropdown ($db,$state,$name)
	{
		$sql_query = "select * from ".$this->auction_states_table;
		$result = &$db->Execute($sql_query);
		
		if (!$result)
		{
			echo $sql_query." is the state query<br>\n";
			$this->register_error = $this->messages[1534];
		}
		else
		{
			echo "<select name=".$name.">\n\t\t";
			echo "<option value=none>".$this->messages[1555]."\n\t\t";
			while ($show = $result->FetchNextObject()) {
				//spit out the state list
				echo "<option value=\"".$show->ABBREVIATION."\"";
				if ($state == $show->ABBREVIATION)
				echo "selected";
				echo ">".$show->NAME."\n\t\t";
			}
		
			echo "</select>\n\t";
		}

	} //end of function show_state_dropdown
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	
} //end of class Register
?>