<? //authenticate_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.01 June 22, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/

class Auth {

	   var $secret;
	   var $error;
	   var $login_cookie_time;
	   var $auction_user_id = 0;
	   var $username;
	   var $level;
	   var $auth_messages;
	   var $error_messages;
	   var $error_message;
	   var $error_found;
	   
	   //email that all administration messages will be sent to
	   var $admin_email = "geoauctions@geodesicsolutions.com";
	   
	   //final resting place for auctions.php
	   var $auctions_url = "http://www.geodesicsolutions.com/products/auctions/litedemo/auctions.php";
	   
	   //database table names - can be left alone
	   var $auctions_userdata_table = "geodesic_auctions_userdata";
	   var $auctions_logins_table = "geodesic_auctions_logins";
	   var $auction_states_table = "geodesic_auctions_states";
	   
	   //font tag information used throughout several parts of the site
	   var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	   var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";	
	   
	   var $messages = array();
	   
	   var $notify_data;

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Auth () 
	{
		//constuctor
		$this->secret = "somethingverylong";
		
		$this->messages[800] = "Login Form";
		$this->messages[801] = "login instructions";
		$this->messages[802] = "username";
		$this->messages[803] = "password";
		$this->messages[804] = "Login";
		$this->messages[805] = "Please enter your username";
		$this->messages[806] = "Please enter your password";
		$this->messages[807] = "Please re-enter your username";
		$this->messages[808] = "Please re-enter your password";
		$this->messages[809] = "We could not log you in";
		$this->messages[810] = "No account exists by that username";
		$this->messages[811] = "Edit Userdata Form";
		$this->messages[812] = "Edit userdata form instructions";
		$this->messages[813] = "username";
		$this->messages[814] = "Email address";
		$this->messages[815] = "Company name";
		$this->messages[816] = "Business type";
		$this->messages[817] = "Firstname";
		$this->messages[818] = "Lastname";
		$this->messages[819] = "Address";
		$this->messages[820] = "Address line 2";
		$this->messages[821] = "City";
		$this->messages[822] = "State";
		$this->messages[823] = "Zip Code";
		$this->messages[824] = "Country";
		$this->messages[825] = "Phone";
		$this->messages[826] = "Phone 2";
		$this->messages[827] = "Fax";
		$this->messages[828] = "Url";
		$this->messages[829] = "lost password email subject";
		$this->messages[830] = "Here is the missplaced login information";
		$this->messages[831] = "From: ";
		$this->messages[832] = "There was an error in processing your request";
		$this->messages[833] = "Change Password Form";
		$this->messages[834] = "Enter the new password twice to verify it and press submit";
		$this->messages[835] = "password verification";
		$this->messages[836] = "Please retry changing your password.";
		$this->messages[837] = "You must login before you can bid on an auction.";
		$this->messages[838] = "submit your changes";
		$this->messages[839] = "You are already logged in.";
		$this->messages[840] = "click here to logout";
		$this->messages[841] = "Lost Password Form";
		$this->messages[842] = "enter your email address below to have your password emailed to you";
		$this->messages[843] = "No account exists by that email address ";
		$this->messages[844] = "Your friends name";
		$this->messages[845] = "Your friends email address";
		$this->messages[846] = "Your name";
		$this->messages[847] = "Your email address";
		$this->messages[848] = "Comments you wish to give your friend";
		$this->messages[849] = "Notify a Friend Form";
		$this->messages[850] = "Enter your friends name and email address as well as your own name and email address if you are not logged in.  Leave comments for your friend if you like and press the submit button when through.";
		$this->messages[851] = "Your friends email address is missing";
		$this->messages[852] = "Your email address is missing";
		$this->messages[853] = "Your friends email address is invalid";
		$this->messages[854] = "Your email address is invalid";
		$this->messages[855] = "Your friends name is missing";
		$this->messages[856] = "Your name is missing";
		$this->messages[857] = "Message from ";
		$this->messages[858] = "Your friend, ";
		$this->messages[859] = "thought you would be interested in this item in the Geodesic Auctions: ";
		$this->messages[860] = "Click on the above link or cut and paste it into your browser\n\n\rThis auctions program was created by Geodesic Solutions\n\rhttp://www.geodesicsolutions.com/products/index.htm for product information";
		$this->messages[861] = "From: ";
		$this->messages[862] = "Reply-To: ";
		$this->messages[863] = "With the following comments: ";
		$this->messages[864] = "Hello ";
		$this->messages[865] = "please choose a state";
		
	} //end of function Auth
	
//#############################################################################

	function login_form($username=0,$password=0)
	{
		echo "<form action=auctions.php?a=10 method=post>\n";
		echo "<table cellpadding=3 cellspacing=1 border=0 width=600 align=center>\n";
		echo "<tr>\n\t<td colspan=2 align=center>\n\t".$this->font_title_tag.$this->messages[800]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2 align=center>\n\t".$this->font_tag.$this->messages[801]."\n\t</td>\n</tr>\n";
		if ($this->auth_messages["login"])
			echo "<tr>\n\t<td colspan=2 align=center>\n\t".$this->font_tag.$this->auth_messages["login"]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right width=50%>".$this->font_tag.$this->messages[802]."\n\t</td>\n\t";
		echo "<td width=50%>\n\t<input type=text name=b[username] size=15 ";
		if ($username)
			echo "value=\"".$username."\"";
		echo ">\n\t";
		if ($this->error_messages["username"])
			echo $this->error_messages["username"];
		echo "\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right width=50%>".$this->font_tag.$this->messages[803]."\n\t</td>\n\t";
		echo "<td width=50%>\n\t<input type=password name=b[password] size=15>\n\t";
		if ($this->error_messages["password"])
			echo $this->error_messages["password"];
		echo "\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2 align=center>\n\t<input type=submit name=submit value=\"".$this->messages[804]."\">\n\t</td>\n</tr>\n";
		echo "</table>\n";
		echo "</form>\n";
		
		$this->auth_messages["login"] = 0;
		$this->error_messages["username"] = 0;
		$this->error_messages["password"] = 0;
	
	} //end of function login_form
	
//#############################################################################

	function login ($db,$username,$password) 
	{
		$this->error_found = 0;
		$this->auth_messages["login"] = 0;
		$this->error_messages["username"] =0;
		$this->error_messages["password"] = 0;

		if (strlen(trim($username)) == 0) 
		{
			$this->error_messages["username"] = $this->messages[805];
			$this->error_found++;
		}
		
		if (strlen(trim($password)) == 0 )
		{
                        $this->error_messages["password"] = $this->messages[806];
                        $this->error_found++;
		}
		
		if (!eregi("^[[:alnum:]_-]+$", $username))
		{
                        $this->error_messages["username"] = $this->messages[807];
                        $this->error_found++;
		}
		
		if (!eregi("^[[:alnum:]_-]+$", $password)) 
		{
                        $this->error_messages["password"] = $this->messages[808];
                        $this->error_found++;
		}

		if ($this->error_found > 0)
		{
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}
		
		$sql_query = "select id,password from ".$this->auctions_logins_table." where username = \"".$username."\"";
		$username_result = &$db->Execute($sql_query);

		if (!$username_result) 
		{
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}
		elseif ($username_result->RecordCount() == 0)
		{
			//account not found
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}
		elseif ($username_result->RecordCount() == 1) 
		{
			//username match
			//check password
			$show_username_match = $username_result->FetchNextObject();
			
			if ($show_username_match->PASSWORD == $password)
			{
				//account found
				$sql_query = "select level,email,firstname,lastname from ".$this->auctions_userdata_table." where id = ".$show_username_match->ID;
				$level_result = &$db->Execute($sql_query);
				if (!$level_result) 
				{
					//echo $sql_query." is the query<br>\n";
					$this->auth_messages["login"] = $this->messages[809];
					return false;
				}			
				elseif (($level_result->RecordCount() == 0) || ($level_result->RecordCount() > 1))
				{
					//echo $sql_query." is the query<br>\n";
					$this->auth_messages["login"] = $this->messages[809];
					return false;
				}
				else
				{
					$show_level = $level_result->FetchNextObject();
					$this->auction_user_id = $show_username_match->ID;
					$this->level = $show_level->LEVEL;
					$this->email_address = $show_level->EMAIL;
					$this->firstname = $show_level->FIRSTNAME;
					$this->lastname = $show_level->LASTNAME;
					return true;
				}
			}
			else
			{
				//username found but password does not match
				$this->auth_messages["login"] = $this->messages[868];
				return false;
				
			}
		}
		else
		{
			//internal account error
			//more than one account with the same login information
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}				

	} //end of function login

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function edit_user_form($db)
	{		
		if ($this->auction_user_id)
		{
			$sql_query = "select * from ".$this->auctions_userdata_table." where id = ".$this->auction_user_id;
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->auth_messages["login"] = $this->messages[809];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNExtObject();
				//get this users info and show the form
				echo "<form action=auctions.php?a=11 method=post>\n";
				echo "<table cellpadding=2 cellspacing=1 border=0 align=center width=600>\n";
				echo "<tr>\n\t<td colspan=2>\n\t".$this->font_title_tag.$this->messages[811]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[812]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[813]."\n\t</td>\n\t";
				echo "<td>".$this->font_tag.$show->USERNAME."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[814]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[email] value=\"".$show->EMAIL."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[815]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[company_name] value=\"".$show->COMPANY_NAME."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[816]."\n\t</td>\n\t";
				echo "<td>".$this->font_tag."individual<input type=radio name=b[business_type] value=\"individual\" ";
				if ($show->BUSINESS_TYPE == "individual")
					echo "checked";
				echo "><br>".$this->font_tag."business<input type=radio name=b[business_type] value=\"business\" ";
				if ($show->BUSINESS_TYPE == "business")
					echo "checked";
				echo ">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[817]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[firstname] value=\"".$show->FIRSTNAME."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[818]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[lastname] value=\"".$show->LASTNAME."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[819]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[address] value=\"".$show->ADDRESS."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[820]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[address_2] value=\"".$show->ADDRESS_2."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[821]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[city] value=\"".$show->CITY."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[822]."\n\t</td>\n\t";
				echo "<td>\n\t";
				$this->show_state_dropdown ($db,$show->STATE,"b[state]");
				echo "</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[823]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[zip] value=\"".$show->ZIP."\">\n\t</td>\n</tr>\n";
				//echo "<tr>\n\t<td align=right>\n\t".$this->messages[824]."\n\t</td>\n\t";
				//echo "<td><input type=text name=b[country] value=\"".$show->COUNTRY."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[825]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[phone] value=\"".$show->PHONE."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[826]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[phone_2] value=\"".$show->PHONE2."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[827]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[fax] value=\"".$show->FAX."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[828]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[url] value=\"".$show->URL."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td colspan=2 align=center>\n\t<input type=submit value=\"".$this->messages[838]."\">\n\t</td>\n</tr>\n";
				echo "</table>\n";
				echo "</form>\n";
				return true;
			}
			else
			{
				$this->auth_messages["login"] = $this->messages[809];
				return false;
			}
		}
		else
		{
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}
	
	} //end of function edit_user_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_user($db,$info=0)
	{
		if (($info) && ($this->auction_user_id))
		{
			//needs error checking
			$sql_query = "update ".$this->auctions_userdata_table." set 
				email = \"".$info["email"]."\",
				company_name = \"".$info["company_name"]."\",
				business_type = \"".$info["business_type"]."\",
				firstname = \"".$info["firstname"]."\",
				lastname = \"".$info["lastname"]."\",
				address = \"".$info["address"]."\",
				address_2 = \"".$info["address_2"]."\",
				city = \"".$info["city"]."\",
				state = \"".$info["state"]."\",
				zip = \"".$info["zip"]."\",
				phone = \"".$info["phone"]."\",
				phone2 = \"".$info["phone_2"]."\",
				fax = \"".$info["fax"]."\",
				url = \"".$info["url"]."\"
				where id =".$this->auction_user_id;
			$result = &$db->Execute($sql_query);
						
			if (!$result)
			{
				
				return false;
			}
			else
				return true;
		}
		else
		{
			return false;
		}
	
	} //end of function edit_user_form
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function lostpassword ($db,$email=0) 
	{
		if ($email) 
		{
			
			$sql_query = "select id from ".$this->auctions_userdata_table." where email = \"".$email."\"";
			$result = &$db->Execute($sql_query);
			
			if (!$result) 
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[832];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show_id = $result->FetchNextObject();
				$sql_query = "select username,password from ".$this->auctions_logins_table." where id =".$show_id->ID;
				$result = &$db->Execute($sql_query);
				
				if (!$result) 
				{
					//echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[832];
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{ 
					$show = $result->FetchNextObject();
				
					$mailto = $email;
					$subject = $this->messages[829];
					$message = $this->messages[830]."\n\r".$this->messages[802].": ".$show->USERNAME."\n\r";
					$message .= $this->messages[803].": ".$show->PASSWORD."\n\r";
					$from = $this->messages[831].$this->admin_email;
					
					@mail($mailto, $subject, $message, $from);

					return true;
				}
				else
				{
					$this->error_message = $this->messages[832];
					return false;
				}
			}
			else
			{
				//no account exist by that email address
				$this->error_message = $this->messages[843];
				return false;
			}
		}
		else
		{
			//no email to send to 
			return false;
		}
	} //end of function lostpassword

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function lostpassword_form () 
	{
		//display the form to collect an email address
		echo "<form action=auctions.php?a=18 method=post>\n";
		echo "<table cellpadding=2 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td colspan=2>\n\t".$this->font_title_tag.$this->messages[841]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[842]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>\n\t".$this->font_tag.$this->messages[814]."\n\t</td>\n\t";
		echo "<td><input type=text name=b[email]>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center colspan=2>\n\t<input type=submit name=submit><br><br><br>\n\t</td>\n</tr>\n";

	} //end of function lostpassword_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function change_password ($db,$info=0) 
	{
		if ($info)
		{
			if (((strlen(trim($info[password1])) > 5) && (strlen(trim($info[password1])) < 15)) && ($info[password1] == $info[password2])) 
			{
				//the password passes the restrictions
				$sql_query = "select email from ".$this->auctions_userdata_table." where id = ".$this->auction_user_id;
				$result = &$db->Execute($sql_query);

				if (!$result)
				{
					$this->error_message = $this->messages[832];
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					$sql_query = "select * from ".$this->auctions_logins_table." where id = ".$this->auction_user_id;
					$login_result = &$db->Execute($sql_query);
					if (!$login_result)
					{
						$this->auth_message = $this->messages[832];
						return false;				
					}
					elseif ($login_result->RecordCount() == 1)
					{
						$sql_query = "update ".$this->auctions_logins_table." set
							password = \"".$info[password1]."\" 
							where id = ".$this->auction_user_id;
						$result = &$db->Execute($sql_query);
					}
					else
					{
						$this->error_message = $this->messages[832];
						return false;
					}
				}
				else
				{
					$this->error_message = $this->messages[832];
					return false;
				}
			}
			else 
			{
				$this->auth_messages["password_form"] = $this->messages[836];
			}
		}
		else
		{
			$this->error_message = $this->messages[832];
			return false;
		}
	} //end of change_password
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function change_password_form()
	{
		echo "<form action=auctions.php?a=10 method=post>\n";
		echo "<table cellpadding=3 cellspacing=1 border=0>\n";
		echo "<tr>\n\t<td colspan=3>\n\t".$this->font_title_tag.$this->messages[833]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=3>\n\t".$this->font_tag.$this->messages[834]."\n\t</td>\n</tr>\n";
		if ($this->auth_messages["password_form"])
			echo "<tr>\n\t<td colspan=3>\n\t".$this->font_tag.$this->auth_messages["password_form"]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[803]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=password name=b[password1] size=15>\n\t</td>\n\t";
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[835]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=password name=b[password2] size=15>\n\t</td>\n\t";
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2>\n\t<input type=submit name=submit value=submit>\n\t</td>\n</tr>\n";
		echo "</table>\n";
		echo "</form>\n";
		
		$this->error_message = 0;
		$this->auth_messages["password_form"] = 0;
		
	} //end of function change_password_form
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function auth_error()
	{
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[832]."</td>\n</tr>\n";
		if ($this->error_message)
			echo "<tr>\n\t<td>".$this->font_tag.$this->error_message."</td>\n</tr>\n";
		echo "</table>\n";
	} //end of function auth_error
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%	

	function show_state_dropdown ($db,$state,$name)
	{
		$sql_query = "select * from ".$this->auction_states_table;
		$result = &$db->Execute($sql_query);
		
		if (!$result)
		{
			echo $sql_query." is the state query<br>\n";
			$this->register_error = $this->messages[832];
		}
		else
		{
			echo "<select name=".$name.">\n\t\t";
			echo "<option value=none>".$this->messages[865]."\n\t\t";
			while ($show = $result->FetchNextObject()) {
				//spit out the state list
				echo "<option value=\"".$show->ABBREVIATION."\"";
				if ($state == $show->ABBREVIATION)
				echo "selected";
				echo ">".$show->NAME."\n\t\t";
			}
			echo "</select>\n\t";
		}

	} //end of function show_state_dropdown
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function already_logged_in()
	{
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td align=center>".$this->font_title_tag.$this->messages[839]."</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center><a href=auctions.php?a=17>".$this->font_tag.$this->messages[840]."</a></td>\n</tr>\n";
		echo "</table>\n";
	} //end of function auth_error

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function notify_friend_form($db,$auction_id)
	{
		if ($this->auction_user_id)
		{
			$sql_query = "select email,firstname,lastname from ".$this->auctions_userdata_table." where id = ".$this->auction_user_id;
			$result = &$db->Execute($sql_query);

			if (!$result)
			{
				//echo $sql_query." is the state query<br>\n";
				$this->error_message = $this->messages[832];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show_user = $result->FetchNextObject();
				$senders_name = $show_user->FIRSTNAME." ".$show_user->LASTNAME;
				$senders_email = $show_user->EMAIL;
			}
			else
			{
				$this->error_message = $this->messages[832];
				return false;
			}
		}

		echo "<form action=auctions.php?a=12 method=post>\n\t";
		echo "<TABLE WIDTH=600 align=center BORDER=0 CELLPADDING=3 CELLSPACING=1>\n";
		echo "<TR>\n\t<TD colspan=2>\n\t".$this->font_title_tag.$this->messages[849]."\n\t</td>\n</tr>\n";
		echo "<TR>\n\t<TD colspan=2>\n\t".$this->font_tag.$this->messages[850]."\n\t</td>\n</tr>\n";
					
		if ($error_messages["send_a_friend"] !="")
		{
			echo "<TR>\n\t\t<TD colspan=2>\n\t\t".$this->font_tag.$error_messages["send_a_friend"]."\n\t\t</TD>\n\t</TR>\n\t";
		}

		//friend's name
		echo "<TR>\n\t\t<TD ALIGN=right>\n\t\t".$this->font_tag.$this->messages[844].":\n\t\t</TD>\n\t\t";
		echo "<TD><INPUT TYPE=TEXT NAME=b[friends_name] SIZE=25 VALUE=\"".$this->notify_data["friends_name"]."\">\n\t\t</TD>\n\t</TR>\n\t";

		// friend's email
		echo "<TR><TD ALIGN=right>".$this->font_tag.$this->messages[845].":\n\t\t</TD>\n\t\t";
		echo "<TD><INPUT TYPE=TEXT NAME=b[friends_email] SIZE=25 VALUE=\"".$this->notify_data["friends_email"]."\">\n\t\t</TD>\n\t</TR>\n\t";

		//your name
		echo "<TR>\n\t\t<TD ALIGN=right>".$this->font_tag.$this->messages[846].":\n\t\t</TD>\n\t\t";
		if ($this->auction_user_id)
		{
			echo "<TD>\n\t\t".$this->font_tag.$senders_name."\n\t\t</TD>\n\t</TR>\n\t";
		}
		else
		{
			echo "<TD>\n\t\t<INPUT TYPE=TEXT NAME=b[senders_name] SIZE=25 VALUE=\"".$senders_name."\">\n\t\t</TD>\n\t</TR>\n\t";
		}

		// your email
		echo "<TR>\n\t\t<TD ALIGN=right>".$this->font_tag.$this->messages[847].":\n\t\t</TD>\n\t\t";
		if ($this->auction_user_id)
		{
			echo "<TD>\n\t\t".$this->font_tag.$senders_email.">\n\t\t</TD>\n\t</TR>\n\t";
		}
		else
		{		
			echo "<TD>\n\t\t<INPUT TYPE=TEXT NAME=b[senders_email] SIZE=25 VALUE=\"".$senders_email."\">\n\t\t</TD>\n\t</TR>\n\t";
		}

		//comment
		echo "<TR>\n\t\t<TD ALIGN=right VALIGN=TOP>\n\t\t".$this->font_tag.$this->messages[848].":\n\t\t</TD>\n\t\t";
		echo "<TD>\n\t\t<TEXTAREA NAME=b[senders_comments] COLS=23 ROWS=6>".$this->notify_data["senders_comments"]."</TEXTAREA>\n\t\t</td>\n\t</tr>\n\t";

		//submit button
	  	echo "<tr>\n\t\t<td align=center colspan=2>\n\t\t";
	  	echo "<INPUT TYPE=hidden NAME=b[auction_id] VALUE=";
	  	if ($this->error_found)
	  		echo $this->notify_data["auction_id"];
	  	else
	  		echo $auction_id;
	  	echo ">";
	  	echo "<INPUT TYPE=submit NAME=submit>";
	  	echo "<INPUT TYPE=reset NAME=reset>\n\t\t</TD>\n\t</TR>\n\t</TABLE>\n";
	  	echo "</FORM>\n\t</TD>\n</TR>\n</TABLE>\n";
	  	
	  	$this->error_found = 0;
	  	
	  	return true;
	  	
	} //end of notify_friend_form

//########################################################################

	function verify_notify_friend($db,$info)
	{
		$this->error_found = 0;
		if (!$this->auction_user_id)
		{
			//check for senders stuff
			if (strlen(trim($info["senders_email"])) > 0)
			{
				if (!eregi("^([a-z0-9]+)(([a-z0-9._-]+))*[@]([a-z0-9]+)([._-]([a-z0-9]+))*[.]([a-z0-9]){2}([a-z0-9])?$", $info["senders_email"]))
				{
					$this->error[email] = $this->messages[854];
					$this->error_found++;
				}
			}
			else
			{
				$this->error_messages["send_a_friend"] = $this->messages[852];
				$this->error_found++;
			}			
			
			if (strlen(trim($info["senders_name"])) == 0)
			{
				$this->error_messages["send_a_friend"] = $this->messages[856];
				$this->error_found++;
			}				
			
		}
		if (strlen(trim($info["friends_email"])) > 0)
		{
			if (!eregi("^([a-z0-9]+)(([a-z0-9._-]+))*[@]([a-z0-9]+)([._-]([a-z0-9]+))*[.]([a-z0-9]){2}([a-z0-9])?$", $info["friends_email"]))
			{
				$this->error[email] = $this->messages[853];
				$this->error_found++;
			}
		}
		else
		{
			$this->error_messages["send_a_friend"] = $this->messages[851];
			$this->error_found++;
		}

		if (strlen(trim($info["friends_name"])) == 0)
		{
			$this->error_messages["send_a_friend"] = $this->messages[855];
			$this->error_found++;
		}	
		
		if ($this->error_found)
		{
			if (!$this->auction_user_id)
			{
				$this->notify_data["senders_name"] = $info["senders_name"];
				$this->notify_data["senders_email"] = $info["senders_email"];				
			}
			
			$this->notify_data["friends_name"] = $info["friends_name"];
			$this->notify_data["friends_email"] = $info["friends_email"];	
			$this->notify_data["senders_comments"] = $info["senders_comments"];	
			$this->notify_data["auction_id"] = $info["auction_id"];	
			
			return false;
		}
		else
		{
			return true;
		}

	} //end of function verify_notify_friend
	
//########################################################################

	function notify_friend($db,$info=0)
	{
		if ($info)
		{
			if ($this->auction_user_id)
			{
				$sql_query = "select email,firstname,lastname from ".$this->auctions_userdata_table." where id = ".$this->auction_user_id;
				$result = &$db->Execute($sql_query);

				if (!$result)
				{
					//echo $sql_query." is the state query<br>\n";
					$this->error_message = $this->messages[832];
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					$show_user = $result->FetchNextObject();
					$senders_name = $show_user->FIRSTNAME." ".$show_user->LASTNAME;
					$senders_email = $show_user->EMAIL;
				}
				else
				{
					$this->error_message = $this->messages[832];
					return false;
				}
			}
			else
			{
				$senders_name = $info["senders_name"];
				$senders_email = $info["senders_email"];				
			}
			
			$mailto = $info["friends_email"];
			$subject = $this->messages[857].$senders_name;
			$message = $this->messages[864].$info["friends_name"].",\n\r";
			$message .= $this->messages[858]." ".$senders_name." ".$this->messages[859]."\n\n\r";
			$message .= $this->auctions_url."?a=2&b=".$info["auction_id"]."\n\n\r";
			
			if (strlen(trim($info["senders_comments"])) > 0)
				$message .= $this->messages[863]."\n\r".$info["senders_comments"]."\n\n\r";
			$message .= $this->messages[860]."\n\n\r";
			$from = $this->messages[861].$senders_email."\n";

			@mail($mailto, $subject, $message, $from);
			
			return true;
		
		}
		else
		{
			return false;
		}
	} //end of function notify_friend
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function admin_login_form($username=0,$password=0)
	{
		echo "<form action=index.php method=post>\n";
		echo "<table cellpadding=3 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td colspan=3>\n\t".$this->messages[843]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=3>\n\t".$this->messages[844]."\n\t</td>\n</tr>\n";
		if ($this->auth_messages["login"])
			echo "<tr>\n\t<td colspan=3>\n\t".$this->auth_messages["login"]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>".$this->messages[802]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=text name=b[username] size=15 ";
		if ($username)
			echo "value=\"".$username."\"";
		echo ">\n\t</td>\n\t";
		echo "<td>&nbsp;";
		if ($this->error_messages["username"])
			echo $this->error_messages["username"];
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>".$this->messages[803]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=password name=b[password] size=15>\n\t</td>\n\t";
		if ($this->error_messages["password"])
			echo $this->error_messages["password"];
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2>\n\t<input type=submit name=submit value=\"".$this->messages[804]."\">\n\t</td>\n</tr>\n";
		echo "</table>\n";
		echo "</form>\n";
		
		$this->auth_messages["login"] = 0;
		$this->error_messages["username"] = 0;
		$this->error_messages["password"] = 0;
	
	} //end of function admin_login_form
	
//#############################################################################

	function edit_admin_login_form($db)
	{
		if ($this->level == 1)
		{
			$sql_query = "select * from ".$this->auctions_logins_table." where id = 1";
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->auth_messages["login"] = $this->messages[809];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNExtObject();
				//get this users info and show the form
				echo "<form action=index.php?a=50 method=post>\n";
				echo "<table cellpadding=2 cellspacing=1 border=0>\n";
				echo "<tr>\n\t<td colspan=2>\n\t".$this->messages[841]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td colspan=2>\n\t".$this->messages[842]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->messages[802]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[username] value=\"".$show->USERNAME."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=right>\n\t".$this->messages[803]."\n\t</td>\n\t";
				echo "<td><input type=text name=b[password] value=\"".$show->PASSWORD."\">\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td colspan=2>\n\t<input type=submit value=\"".$this->messages[838]."\">\n\t</td>\n</tr>\n";
				echo "</table>\n";
				echo "</form>\n";
				return true;
			}
			else
			{
				$this->auth_messages["login"] = $this->messages[809];
				return false;
			}
		}
		else
		{
			$this->auth_messages["login"] = $this->messages[809];
			return false;
		}
	
	} //end of function edit_admin_login_form

//###############################################################################

	function update_admin_login($db,$info=0)
	{
		if (($info) && ($this->auction_user_id))
		{
			//needs error checking
			$sql_query = "update ".$this->auctions_logins_table." set 
				username = \"".$info["username"]."\",
				password = \"".$info["password"]."\"
				where id = 1";
			$result = &$db->Execute($sql_query);
			//echo $sql_query." is the query<br>\n";
			
			if (!$result)
			{
				
				return false;
			}
			else
				return true;
		}
		else
		{
			return false;
		}
	
	} //end of function update_admin_login

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


} //end of class Auth
?>