<? //auction_sell_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/


class Auction_sell {

	var $seller_id;
	var $auction_types= array (
			1 => "Standard auction",
		        2 => "Dutch auction"
  			);
	var $auction_variables;
	var $error_variables;
	var $extra_category_questions = "";
	var $terminal_category = 0;
			
	var $auction_detail_collected = 0;
	var $auction_approved = 0;
	
	var $error=0;
	var $auction_id;
		
	//number of days an auction can be displayer for
	//the numbers in this array represent the number of days the seller can
	//choose from for the length of their auction.  These values will appear in the dropdown
	//list the seller is given to list their auctions
	var $auction_duration = array(1,3,5,7,10,14,28); //number of days an auction can be
	
	//1 - to allow uploads of images to your auctions	
	//0 - to NOT allow uploads of images to your auctions
	//either way the seller can enter a url of an image to place in the ad
	var $allow_uploads = 1; 
	var $temp_auction_image = 0;
	var $temp_auction_image_type = 0;
	
	//upload path for images uploaded within the selling process.
	//this is just a temporary location. If the ad is approved by the seller the image will 
	//be moved to the permanent location.  
	var $temp_upload_path = "/home/geodesicsolutions/www/products/auctions/litedemo/uploads/";
	
	//final directory path the uploaded auction images will be placed in
	var $auction_images_path= "/home/geodesicsolutions/www/products/auctions/litedemo/auction_images/";
	
	//name of the auction images directory relative to auctions.php
	var $auction_images_directory = "/auction_images";
	
	//maximum size in KB you will allow uploaded to your site
	var $max_uploaded_image_size = 100000;
	
	//days to keep old uploaded tmp files on server
	var $days_to_keep_files = 1; 
	
	//url path to auction images directory
	var $url_to_images_directory = "http://www.geodesicsolutions.com/products/auctions/litedemo/auction_images/";
	
	//url path to temporary auction images directory
	var $url_to_tmp_images_directory = "http://www.geodesicsolutions.com/products/auctions/litedemo/uploads/";
		
	var $auction_categories_table = "geodesic_auctions_categories";
	var $auctions_table = "geodesic_auctions";
	var $auction_login_table = "geodesic_auctions_logins";
	var $auctions_states_table = "geodesic_auctions_states";
	
	//font tag information used throughout several parts of the site	
	var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";
	var $font_tag_small = "<font face=arial,helvetica size=1 color=#000000>";
	
	var $messages = array();

//#####################################################################

	function Auction_sell ($userid)
	{
		 //constructor
		 $this->seller_id = $userid;
		 
		 $this->messages[2000] = "Item category";
		 $this->messages[2001] = "Item description";
		 $this->messages[2002] = "Seller";
		 $this->messages[2003] = "Auction type";
		 $this->messages[2004] = "Number of items";
		 $this->messages[2005] = "Auction Duration";
		 $this->messages[2006] = "days";
		 $this->messages[2007] = "Starting bid";
		 $this->messages[2008] = "Reserve price";
		 $this->messages[2009] = "Buy now price";
		 $this->messages[2010] = "Item description";
		 $this->messages[2011] = "Country";
		 $this->messages[2012] = "You successfully entered your auction";
		 $this->messages[2013] = "Click here to view auction";
		 $this->messages[2014] = "Please choose the main category that your auction will appear in.";
		 $this->messages[2015] = " category has ";
		 $this->messages[2016] = " subcategories<br>They are listed below. Please choose category you wish to place your auction in.";
		 $this->messages[2017] = "The ";
		 $this->messages[2018] = "sub categories to choose from:";
		 $this->messages[2019] = " category";
		 $this->messages[2020] = "Or just place your item in the ";
		 $this->messages[2021] = "Please give your auction a title";
		 $this->messages[2022] = "Please choose the state your item is located in";
		 $this->messages[2023] = "Please fill in a zip code for the auction item";
		 $this->messages[2024] = "Please enter a valid zip code";
		 $this->messages[2025] = "You must have at least one item in an auction";
		 $this->messages[2026] = "You must enter a number in the number of items";
		 $this->messages[2027] = "Please give a brief description of your auction item";
		 $this->messages[2028] = "submit images addresses";
		 $this->messages[2029] = "Image";
		 $this->messages[2030] = "url of image you would like to use";
		 $this->messages[2031] = "url address of the image you would like to use in your auction";
		 $this->messages[2032] = "number of items";
		 $this->messages[2033] = "the number of items included in the auctions";
		 $this->messages[2034] = "reserve price";
		 $this->messages[2035] = "the lowest amount you will sell your item for";
		 $this->messages[2036] = "opening";
		 $this->messages[2037] = "the bid your auction will start at";
		 $this->messages[2038] = "zip code";
		 $this->messages[2039] = "zip code where the auction item is located";
		 $this->messages[2040] = "Auction Title";
		 $this->messages[2041] = "this will appear in any listing of auctions";
		 $this->messages[2042] = "Auction Length";
		 $this->messages[2043] = "length of your auction in days";
		 $this->messages[2044] = "Choose a state";
		 $this->messages[2045] = "approve";
		 $this->messages[2046] = "edit category";
		 $this->messages[2047] = "edit images";
		 $this->messages[2048] = "edit details";
		 $this->messages[2049] = "Main";
		 $this->messages[2050] = "Image address";
		 $this->messages[2051] = "Could not complete your request";
		 $this->messages[2052] = "There was an internal error in trying to complete your request";
		 $this->messages[2053] = "There are no main categories";
		 $this->messages[2054] = "Please fill out the details of your auction";
		 $this->messages[2055] = "Auction type";
		 $this->messages[2056] = "Is this a standard or dutch auction";
		 $this->messages[2057] = "Image url";
		 $this->messages[2058] = "Auction location";
		 $this->messages[2059] = "There are no main categories";
		 $this->messages[2060] = "quantity in auction";
		 $this->messages[2061] = "Click here to add another auction";
		 $this->messages[2062] = "Click here to end this sell process";
		 $this->messages[2063] = " or Image to upload to server";
		 $this->messages[2064] = "No image entered or uploaded";
		 
		 //need to delete old tmp images not deleted
		 $this->delete_old_tmp_files();
	
	} //end of function Auction_sell 
	
//####################################################################

	function check_if_category($db,$category=0)
	{
		if ($category)
		{
			//check to see if this number is even a category
			$sql_query = "select * from ".$this->auction_categories_table." where category_id = ".$category;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;
			}
			else
			{
				if ($result->RecordCount() == 1)
					return true;
				else
				{
					//echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2052];
					return false;
				}
			}
		}
		else
		{
			$this->error_message = $this->messages[2052];
			return false;
		}
	} //end of function check_if_category
	
//#####################################################################

	function get_sell_form_variables ($info)
	{
		//get the variables from the form and save them
		while (list($key,$value) = each($info))
		{
			$this->auction_variables[$key] = $value;
			//echo $key." is the key and this is the value - ".$value."<br>\n";
		}

	} //end of function get_sell_form_variables ($info)
	
//#####################################################################

	function choose_category($db,$parent_category=0)
	{
		//echo "hello from choose category<br>\n";
		//echo $parent_category." is the parent category<br>\n";
		if ($parent_category)
		{
			//echo $terminal_category." is the terminal category in secondary<br>\n";
			$sql_query = "select category_name from ".$this->auction_categories_table." where category_id = ".$parent_category;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNextObject();

				$sql_query = "select * from ".$this->auction_categories_table." where parent_id = ".$parent_category;
				$sub_result = &$db->Execute($sql_query);
				if (!$sub_result)
				{
					//echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2052];
					return false;
				}
				elseif ($sub_result->RecordCount() > 0)
				{
					echo "<table align=center cellpadding=5 cellspacing=0 border=0 align=center width=600>\n";
					echo "<tr>\n\t<td align=center>\n\t".$this->font_tag.$this->messages[2017].$show->CATEGORY_NAME."</b>".$this->messages[2015].
						$number_of_sub_cats.$this->messages[2016]." \n\t</td>\n</tr>\n";
					echo "<tr>\n\t<td align=center>\n\t<table cellpadding=3 cellspacing=0 border=0>\n\t";
					echo "<tr>\n\t\t<td>\n\t\t".$this->font_tag.$this->messages[2018]."\n\t\t</td>\n\t</tr>\n\t";
					 while ($show_sub_cats = $sub_result->FetchNextObject())
					 {
						//display the subcategories of this parent_category
						echo "<tr>\n\t\n\t\t<td align=center>\n\t<a href=auctions.php?a=1&b=".$show_sub_cats->CATEGORY_ID."&c=category>".$this->font_tag.$show_sub_cats->CATEGORY_NAME."</a>\n\t\t</td>\n\t</tr>\n\t";
					}
					//need to display this category as a choice here
					echo "<tr>\n\t\t<td align=center>\n\t\t".$this->font_tag.$this->messages[2020]."<a href=auctions.php?a=1&b=".$parent_category."&c=terminal>".$show->CATEGORY_NAME."</a>".$this->messages[2019]."\n\t\t</td>\n\t</tr>\n\t";
					echo "<tr>\n\t<td align=center>\n\t<br><br><a href=auctions.php?a=97>".$this->font_tag.$this->messages[2062]."</a>\n\t</td>\n</tr>\n";
					echo "\n\t</table>\n\t</td>\n</tr>\n";
					echo "</table>\n";
				}
				else
				{
					//this is the terminal category
					//there are no sub categories underneath it
					//check this is really a category
					if ($this->check_if_category($db,$parent_category))
					{
						//this is a true category id make it the terminal one
						if (!$this->set_terminal_category($db,$parent_category))
						{
							$this->error_message = $this->messages[2052];	
							return false;
						}
						else
						{
							$this->display_auction_detail_form($db);					
						}
					}
					else
					{
						$this->error_message = $this->messages[2052];
						return false;
					}
				}
				return true;
			}
			else
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;		
			}
		}
		else
		{
			//choose the main category
			$sql_query = "select * from ".$this->auction_categories_table." where parent_id = 0";
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;	
			}

			echo "<table cellpadding=5 cellspacing=0 border=0  align=center width=600 bgcolor=#ffffff>\n";
			echo "<tr>\n\t<td align=center>\n\t".$this->font_tag.$this->messages[2014]."\n\t</td>\n</tr>\n";
			if ($result->RecordCount() > 0)
			{
				while ($show = $result->FetchNextObject())
				{
					//show all the categories in the option list
					echo "<tr>\n\t<td align=center>\n\t<a href=auctions.php?a=1&b=".$show->CATEGORY_ID.">".$this->font_tag.$show->CATEGORY_NAME."</a>\n\t</td>\n</tr>\n";
				} //end of while
			}
			else
			{
				echo "<tr>\n\t<td align=center>\n\t".$this->font_tag.$this->messages[2053]."\n\t</td>\n</tr>\n";
			}

			echo "\n\t</td>\n</tr>\n";
			echo "<tr>\n\t<td align=center>\n\t<br><br><a href=auctions.php?a=97>".$this->font_tag.$this->messages[2062]."</a>\n\t</td>\n</tr>\n";
			echo "</table>\n";
			return true;
		}
	} //end of function choose_category

//#####################################################################

	function auction_detail_check()
	{
		$this->error = 0;

		if (strlen(trim($this->auction_variables["auction_title"])) ==0) 
		{
			//error in auction_title - was not entered
			$this->error++;
			$this->error_variables["auction_title"] = $this->messages[2021];
		}

		if ($this->auction_variables["state"] == "none") 
		{
			//no state chosen
			$this->error++;
			$this->error_variables["state"] = $this->messages[2022];
		}

		if (strlen(trim($this->auction_variables["zip_code"])) == 0) 
		{
			//error in auction_zip - was not entered
			$this->error++;
			$this->error_variables["zip_code"] = $this->messages[2023];
		}
		else 
		{
			//check that zip is regulation size
			if (strlen(trim($this->auction_variables["zip_code"])) < 5) 
			{
				//zip not long enough
				$this->error++;
				$this->error_variables["zip_code"] = $this->messages[2024];
			}
		}


		if ($this->auction_variables["opening_bid"] == 0)  
		{
			//the opening bid will be set to the minimum of .01
			$this->auction_variables["opening_bid"] = .01;
		}

		if ((intval($this->auction_variables["number_of_items"])) != 0) 
		{
			if ($this->auction_variables["number_of_items"] == 0)  
			{
				//The number of items in the auction must be greater than 0
				$this->error++;
				$this->error_variables["number_of_items"] = $this->messages[2025];
			}
		}
		else 
		{
			//value is not an integer which it should
			$this->error++;
			$this->error_variables["number_of_items"] = $this->messages[2026];
		} //end of else

		if (strlen(trim($this->auction_variables[description])) == 0) 
		{
			$this->error++;
			$this->error_variables["description"] = $this->messages[2027];
		}
		
		//echo $this->error." is the error count<br>\n";
		
		if ($this->error == 0)
		{
			$this->auction_details_collected = 1;
			//echo "details checked ok<br>\n";
			return true;
		}
		else
			return false;
		
	} //end of function auction_detail_check()
	
//#####################################################################################

	function insert_auction ($db) {
		$auction_starts = time();

		//set this to minutes by using the first line
		$auction_ends =  $this->DateAdd("d",$auction_starts,$this->auction_variables["auction_length"]);

		//echo gettype($auction_ends)." is the type of ends time<br>\n";
		//echo $auction_ends." is auction ends<br>\n";
		//echo $auction_starts." is auction starts<br>\n";
		
		if ($this->auction_variables["opening_bid"] == "")
			$opening_bid = .01;
		else
			$opening_bid = $this->auction_variables["opening_bid"];

		if ($this->auction_variables["reserve_price"] == "")
			$reserve_price = .01;
		else
			$reserve_price = $this->auction_variables["reserve_price"];

		$sql_query = "INSERT INTO ".$this->auctions_table."  
			(seller,title,date,description,category,minimum_bid,reserve_price,auction_type,
			duration,location_state,location_zip,ends,closed,quantity)
			VALUES  
			(\"".$this->seller_id."\",
			\"".$this->auction_variables["auction_title"]."\",
			\"".$auction_starts."\",
			\"".$this->auction_variables["description"]."\",
			".$this->terminal_category.",
			".$opening_bid.",
			".$reserve_price.",1,
			".$this->auction_variables["auction_length"].",
			\"".$this->auction_variables["state"]."\",
			\"".$this->auction_variables["zip_code"]."\",
			\"".$auction_ends."\",
			0,
			".$this->auction_variables["number_of_items"]." )";
			
		$result = &$db->Execute($sql_query);

		if (!$result) 
		{
			//echo $sql_query." is the query<br>\n";
			return false;
		}
		else
		{
			$this->auction_id = $db->Insert_ID();
			
			//echo $this->auction_id." is the auction id<bR>\n";

			if ($this->temp_auction_image)
			{
				//move the auction temp image into the images directory

				if (is_file($this->temp_upload_path.$this->temp_auction_image))
				{
					//echo $this->temp_upload_path.$this->temp_auction_image." is the temp auction image path<br>\n";
					//echo $this->auction_images_path.$this->auction_id.$this->temp_auction_image_type." is the final destination path<br>\n";
					//echo "the uploaded file is there<br>\n";
					//echo $this->temp_upload_path.$this->temp_auction_image." is the temp auction image path<br>\n";
					//echo $this->auction_images_path.$this->auction_id.$this->temp_auction_image_type." is the final destination path<br>\n";
					if (copy($this->temp_upload_path.$this->temp_auction_image,$this->auction_images_path.$this->auction_id.$this->temp_auction_image_type))
					{
						//echo $this->temp_upload_path.$this->temp_auction_image." is the temp auction image path<br>\n";
						//echo $this->auction_images_path.$this->auction_id.$this->temp_auction_image_type." is the final destination path<br>\n";					
						//echo "copy worked<Br>\n";
						chmod($this->auction_images_path.$this->auction_id.$this->temp_auction_image_type, 0755);
						$sql_query = "update	".$this->auctions_table." set image_url = \"".$this->url_to_images_directory.$this->auction_id.$this->temp_auction_image_type."\"
							where id = ".$this->auction_id;
						$result = &$db->Execute($sql_query);
						if (!$result) 
						{
							//echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[2052];
							return false;
						}
					}
					else
					{
						//echo "copy did not work<br>\n";
						
					}
				}
			}
			else
			{
				$sql_query = "update	".$this->auctions_table." set image_url = \"".$this->auction_variables["image_url"]."\"
					where id = ".$this->auction_id;
				$result = &$db->Execute($sql_query);
				if (!$result) 
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2052];
					return false;
				}
			}
			
			return true;
		}
		
	} //end of function insert_auction

//#####################################################################

	function check_user($db,$username)
	{
		if (strlen(trim($username)) > 0)
		{
			$username = htmlspecialchars($username);
			$sql_query = "select * from ".$this->auction_login_table." where username=\"".AddSlashes($username)."\"";
			$result = mysql_query($sql_query);
			if (mysql_num_rows($result) == 0)
			{
				return false;
			}
			else
			{
				$show = mysql_fetch_array($result);
				$this->seller_id = $show["id"];
				return true;
			 }
	  	}
	  	else
	  	{
			return false;
  		}
	}

//#####################################################################

	function display_auction_detail_form ($db)
	{
		echo "<form action=auctions.php?a=1 method=post enctype=multipart/form-data>\n";
		echo "<table cellpadding=5 cellspacing=0 border=0  align=center width=600>\n";
		echo "<tr>\n\t<td align=center colspan=2>".$this->font_title_tag.$this->messages[2054]."\n\t</td>\n</tr>\n";

		//auction type
		//echo "<tr>\n\t<td valign=top align=right>".$this->messages[2055]."<br>".$this->messages[2056]."\n\t</td>\n\t";
		//echo "<td><select name=b[auction_type]>\n\t";
		//echo "<option value=1";
		//if ($this->auction_variables["auction_type"] == "1")  {
		//	echo " selected ";
		//	}
		//echo ">standard\n\t";
		//echo "<option value=2";
		///if ($this->auction_variables["auction_type"] == "2")
		//	echo " selected ";
		//echo ">dutch\n\t</select>\n\t</td>\n</tr>\n";

		//auction duration
		echo "<tr>\n\t<td valign=top align=right>".$this->font_tag.$this->messages[2042]."</font><br>".$this->font_tag_small.$this->messages[2043]."\n\t</td>\n\t";
		echo "<td>\n\t".$this->font_tag."<select name=b[auction_length]>\n\t\t";
		while (list($key,$value) = each($this->auction_duration)) 
		{
			//display the possible auction lengths to choose from
			echo "<option value=".$value;
			if ($this->auction_variables["auction_length"] == $value)
				   echo " selected";
			echo ">".$value;
			if ($value == 1)
				echo " day\n\t\t";
			else
				echo " days\n\t\t";
		}
		echo "</select>\n\t</td>\n</tr>\n";
		
		//auction title
		$this->basic_input_box($this->messages[2040],$this->messages[2041],"b[auction_title]",
			$this->auction_variables["auction_title"],$this->error_variables["auction_title"]);

		//state
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[2044];
		if ($this->error_variables["state"])
			echo "<br>".$this->error_variables["state"];
		echo "</td>\n\t";
		echo "<td>\n\t";
		$this->show_state_dropdown($db,$this->auction_variables["state"],"b[state]");
		echo "</td>\n</tr>\n";

		//zip location
		$this->basic_input_box($this->messages[2038],$this->messages[2039],"b[zip_code]",
			$this->auction_variables["zip_code"],$this->error_variables["zip_code"]);

		//opening bid
		$this->basic_input_box($this->messages[2036],$this->messages[2037],"b[opening_bid]",
			$this->auction_variables["opening_bid"]);

		//reserve price
		$this->basic_input_box($this->messages[2034],$this->messages[2035],"b[reserve_price]",
			$this->auction_variables["reserve_price"]);

		//number of items
		$this->basic_input_box($this->messages[2032],$this->messages[2033],"b[number_of_items]",
			$this->auction_variables["number_of_items"],$this->error_variables["number_of_items"]);

		//image url
		$this->basic_input_box($this->messages[2030],$this->messages[2031],"b[image_url]");
			
		//or upload an image
		if ($this->allow_uploads)
		{
			echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[2063]."</td>\n\t";
			echo "<td>\n\t<input type=file name=c>
				<input type=hidden name=MAX_FILE_SIZE value=".$this->max_uploaded_image_size.">\n\t</td>\n</tr>\n";
		}

		echo "<tr>\n\t<td colspan=2>".$this->font_tag."auction description:<br>\n\t";
		if (strlen(trim($error_auction_description)) > 0) 
		{
			echo $this->error_variable["description"]."<br>\n\t";
		}
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2><textarea name=b[description] cols=50 rows=15>";
		if (strlen(trim($this->auction_variables["description"])) > 0)
			echo $this->auction_variables["description"];
		echo "</textarea>\n\t</td>\n</tr>\n";

		echo "<tr>\n\t<td colspan=2 align=center><input type=submit name=submit value=\"enter auction information\">\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center colspan=2>\n\t<br><br><a href=auctions.php?a=97>".$this->font_tag.$this->messages[2062]."</a>\n\t</td>\n</tr>\n";
		echo "</table>\n</form>";
		
	} //end of function display_auction_detail_form ()

//#####################################################################3

	function sell_success()
	{
		echo "<table  align=center width=600 BORDER=0>\n<tr>\n\t<td align=center>\n\t";
		echo $this->font_title_tag.$this->messages[2012]."</FONT>\n\t<BR><BR>\n\t";
		echo "<A HREF=\"auctions.php?a=2&b=".$this->auction_id."\">";
		echo $this->font_tag.$this->messages[2013]."</A></FONT><BR><BR>\n\t</td>\n</tr>\n</table>\n";
		session_unregister("sell");

	} //end of function sell_success

//#####################################################################

	function show_state_dropdown ($db,$state,$name)
	{
		$sql_query = "select * from ".$this->auctions_states_table;
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			//echo $sql_query." is the query<br>\n";
			$this->error_message = $this->messages[2052];
			return false;
		}
		else
		{
			echo "<select name=".$name.">\n\t\t";
			echo "<option value=none>".$this->messages[2044]."\n\t\t";
			while ($show = $result->FetchNextObject()) {
				//spit out the state list
				echo "<option value=\"".$show->ABBREVIATION."\"";
				if ($state == $show->ABBREVIATION)
				echo "selected";
				echo ">".$show->NAME."\n\t\t";
			}
		
			echo "</select>\n\t";
		}

	} //end of function show_state_dropdown

//########################################################################

	function basic_input_box($input_title,$explanation,$input_name,$input_value="",$error="")
	{
		echo "<tr>\n\t<td valign=top align=right>".$this->font_tag.$input_title."</font><br>";
  		if (strlen(trim($error)) > 0) {
   			//spit out the auction_title error
   			echo $this->font_tag_small.$error."</font><br>\n\t";
		}
   		echo $this->font_tag_small.$explanation."</font>\n\t</td>\n\t";
   		echo "<td valign=top>\n\t".$this->font_tag."<input type=text name=".$input_name." length=30 ";
 		if (strlen(trim($input_value)) > 0)
   			echo "value=\"".$input_value."\"";
   		echo " maxlength=100>\n\t";
		echo "</td>\n</tr>\n";
	}

//########################################################################

	function get_user_name($db)
	{
		$sql_query = "select username from ".$this->auction_login_table." where id = ".$this->seller_id;
		$result = &$db->Execute($sql_query);
		
		if (!$result)
		{
			//echo $sql_query." is the query<Br>\n";
			$this->error_message = $this->messages[2052];
			return false;		
		}
		
		$show = $result->FetchNextObject();
		
		return $show->USERNAME;
	}

//########################################################################

	function get_category_tree($db)
	{
		$i = 0;
		$category_next = $this->terminal_category;
		do
		{
			$sql_query = "select category_id,parent_id,category_name from ".$this->auction_categories_table." 
				where category_id = ".$category_next;
			$category_result =  &$db->Execute($sql_query);
			
			if (!$category_result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;
			}
			$show_category = $category_result->FetchNextObject();
		 	$category[$i]["parent_id"]  = $show_category->PARENT_ID;
		 	$category[$i]["category_name"] = $show_category->CATEGORY_NAME;
		 	$category[$i]["category_id"]   = $show_category->CATEGORY_ID;
		 	$i++;
		 	$category_next = $show_category->PARENT_ID;

     		} while ( $show_category->PARENT_ID != 0 );
     		
     		return $category;

	} // end of function get_category_tree($category)
	
//########################################################################

	function auction_approval_display($db)
	{
		echo "<table border=0 cellpadding=0 cellspacing=0 align=center width=600>\n";
		
		//category name
		echo "<tr>\n\t<td>\n\t<b>";
		echo $this->font_tag.$this->messages[2000]." : </b> ".$this->messages[2049]." >";
		
		$category_tree = $this->get_category_tree($db);
				
		if (is_array($category_tree))
		{
			$i = 0;
			$categories = array_reverse($category_tree);
			$num_categories = count($categories);
			while ($i < $num_categories) 
			{
				//display all the categories
				if ($i == ($num_categories - 1))
					echo "<b>".$categories[$i]["category_name"]."</b>";
				else
					echo $categories[$i]["category_name"]." > ";
				$i++;
			}
		}
		else
			echo $category_tree;
		echo "\n\t</td>\n</tr>\n";
		
		//detail box
		echo "<tr>\n\t<td>\n\t";
		echo "<table cellpadding=2 cellspacing=1 border=0>\n\t";
		
		//auction title
		echo "<tr>\n\t\t<td>".$this->font_title_tag.$this->auction_variables["auction_title"]."</td>\n\t</tr>\n\t";
		
		//auction quantity
		echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2060].": ".$this->auction_variables["number_of_items"]."</td>\n\t</tr>\n\t";
		
		//seller id
		$name = $this->get_user_name($db);		
		echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2002].": ".$name."</td>\n\t</tr>\n\t";		

		//auction type
		//maybe later versions
		//echo "<tr>\n\t\t<td>".$this->messages[2003].": ".$this->auction_types[$this->auction_variables["auction_type"]]."</td>\n\t</tr>\n\t";		
	
		//number of items
		//if ($auction_info["auction_type"] == 1 )
		//{
		//	echo "<tr>\n\t\t<td>".$this->messages[2004].": ".$this->auction_variables["number_of_items"]."</td>\n\t</tr>\n\t";		
		//}
		
		//auction ends
		echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2005].": ";
		echo intval($this->auction_variables["auction_length"]).$this->messages[2006]."</td>\n\t</tr>\n\t";		

		//starting bid
		echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2007].": ".$this->auction_variables["opening_bid"]."</td>\n\t</tr>\n\t";		

		//reserve price
		echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2008].": ".$this->auction_variables["reserve_price"]."</td>\n\t</tr>\n\t";		

		echo "</table>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2>\n\t<hr width=100% size=2 >\n\t</td>\n</tr>\n";
		
		//image
		if ($this->auction_variables["image_url"])
		{
			echo "<tr>\n\t<td colspan=2>\n\t".$this->messages[2057]."<br>".$this->auction_variables["image_url"]."<br>\n\t
			<img src=".$this->auction_variables["image_url"]." border=0>\n\t</td>\n</tr>\n\t";
		}
		elseif (($this->temp_auction_image) && ($this->temp_auction_image_type) && ($this->temp_auction_image_type != "none"))
		{
			echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[2057]."<br>uploaded image<br>\n\t
				<img src=".$this->url_to_tmp_images_directory.$this->temp_auction_image." border=0>\n\t</td>\n</tr>\n\t";
		}
		else
		{
			echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[2064]."\n\t</td>\n</tr>\n\t";
		}


		//description
		echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[2010]."<br>".$this->auction_variables["description"]."\n\t</td>\n</tr>\n";
		
		echo "<tr>\n\t<td colspan=2>\n\t<hr width=100% size=2 >\n\t</td>\n</tr>\n";
		
		//location information
		echo "<tr>\n\t<td colspan=2>\n\t".$this->font_tag.$this->messages[2058].": ".
			$this->auction_variables["state"]." ".$this->auction_variables["zip_code"]."\n\t</td>\n</tr>\n";

		echo "<tr>\n\t<td colspan=2 align=center>\n\t";
		echo "<a href=auctions.php?a=1&b=accepted>".$this->font_tag.$this->messages[2045]."</a><br>\n\t";
		echo "<a href=auctions.php?a=1&b=edit_category>".$this->font_tag.$this->messages[2046]."</a><br>\n\t";
		echo "<a href=auctions.php?a=1&b=edit_details>".$this->font_tag.$this->messages[2048]."</a>\n\t";
		echo "</td>\n</tr>\n</table>\n";
			
		return true;
			
	} //end of function auction_approval_display
	
//####################################################################################

	function DateAdd ($interval, $date,$quantity) 
	{
		$difference =  $date2 - $date1;
		switch ($interval) 
		{
			case "w":
				$timevalue  = 604800;
				break;
			case "d":
				$timevalue  = 86400;
				break;
			case "h":
				$timevalue = 3600;
				break;        
			case "m":
				$timevalue  = 60;
				break;     
		}
		
		$returnvalue = $date +($quantity * $timevalue);
	    	return $returnvalue;
	} //end of function DateDifference	    
	
//#########################################################################

	function sell_error()
	{
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2051]."</td>\n</tr>\n";
		if ($this->error_message)
			echo "<tr>\n\t<td>".$this->font_tag.$this->error_message."</td>\n</tr>\n";
		echo "</table>\n";
	
	} //end of function sell_error
	
//#########################################################################

	function set_terminal_category($db,$category_id)
	{
		//set the category name and category variables
		$sql_query = "select category_name from ".$this->auction_categories_table." where category_id = ".$category_id;
		$result = &$db->Execute($sql_query);
		
		if (!$result)
		{
			//echo $sql_query." is the query<br>\n";
			$this->error_message = $this->messages[2052];
			return false;		
		}
		elseif ($result->RecordCount() == 1)
		{
			$show = $result->FetchNextObject();
			$this->terminal_category_name = $show->CATEGORY_NAME;
			$this->terminal_category = $category_id;
			return true;
		}
		else
		{
			$this->error_message = $this->messages[2052];
			return false;
		}
	} //end of function set_terminal_category($category)

//#########################################################################

	function end_sell_process()
	{
		echo "<table  align=center width=600 BORDER=0>\n<tr>\n\t<td align=center><br><br>";
		echo $this->font_title_tag.$this->messages[2060]."\n\t<BR><BR>\n\t";
		echo "<A HREF=auctions.php?a=1>";
		echo $this->font_tag.$this->messages[2061]."</A><br><br>\n\t</td>\n</tr>\n</table>\n";	

	} //end of function end_sell_process
	
//##########################################################################
	
	function upload_the_auction_image($auction_image_file=0,$type,$size)
	{
		if ($auction_image_file)
		{
			if ($size < $this->max_uploaded_image_size)
			{
				//get temporary image file name
				switch ($type) 
				{
					case "image/gif":
						$this->temp_auction_image_type = ".gif";			
						break;
					case "image/pjpeg":
						$this->temp_auction_image_type = ".jpg";			
						break;
					case "image/jpeg":
						$this->temp_auction_image_type = ".jpg";			
						break;
					default:
						$this->temp_auction_image_type = "none";	
						return false;
						break;
				}

				do {
					srand((double)microtime()*1000000);
					$pass = rand();
					$pass = trim($pass);			
				} while (is_file($this->temp_upload_path.$pass.$this->temp_auction_image_type));
				$this->temp_auction_image = $pass.$this->temp_auction_image_type;

				move_uploaded_file($auction_image_file,$this->temp_upload_path.$this->temp_auction_image);
				//echo $this->temp_upload_path.$this->temp_auction_image." is uploaded file temp destination<br>\n";
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	} //end of upload_the_auction_image
	
//#########################################################################

	function delete_old_tmp_files()
	{
		if ($dir = @opendir($this->temp_upload_path))
		{
			$current_time = time();
			//echo $current_time." is the current time<br>\n";
			$time_limit = $this->days_to_keep_files * 60 * 60 * 24;  //length of time to keep files
			$delete_time = $current_time - $time_limit;
			//echo $delete_time." is the delete limit<br>\n";
			while (false !== ($file = readdir($dir))) {
			    if ($file != "." && $file != "..") {
			    	//echo $file."<br>\n";
			        if ($file_created = stat($this->temp_upload_path.$file))
			        {
			        	//echo $file_created[9]." is the modified time<br>\n";
			        	if ($file_created[9] < $delete_time)
			        	{
			        		//file needs to be deleted because older than time limit
			        		unlink ($this->temp_upload_path.$file);
			        	}
			        }
			    }
			}
			closedir($dir);
		}
		else
		{
			//could not open tmp directory
		}

	} //end of function delete_old_tmp_files
	
//################################################################################


} //end of Auction_sell
?>