<? //auction_feedback_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/


class Auction_feedback {

	var $auctions_feedbacks_table = "geodesic_auctions_feedbacks";
	var $auctions_table = "geodesic_auctions";
	var $auctions_userdata_table = "geodesic_auctions_userdata";
	var $auctions_bids_table = "geodesic_auctions_bids";
	
	//font tag information used throughout several parts of the site
	var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";
	var $font_tag_light = "<font face=arial,helvetica size=2 color=#ffffff>";	
	
	//color backgrounds of the classified ad listing table
	var $background_color_light = "#eeeeee";
	var $background_color_dark = "#dddddd";
	
	var $message;
	var $feedback_messages = array();
	var $error_message;
	
//####################################################################################

	function Auction_feedback()
	{
		$this->messages[2700] = "User Feedback Administration";
		$this->messages[2701] = "Choose from the options below";
		$this->messages[2702] = "List all feedbacks about you";
		$this->messages[2703] = "List all users you can leave feedback for";
		$this->messages[2704] = "Could not complete your feedback request";
		$this->messages[2705] = "There are no feedbacks for this user.";
		$this->messages[2706] = "Rater";
		$this->messages[2707] = "Auction id";
		$this->messages[2708] = "Feedback";
		$this->messages[2709] = "Rate";
		$this->messages[2710] = "Date";
		$this->messages[2711] = "back to feedback home";
		$this->messages[2712] = "Auctions you can leave feedback for";
		$this->messages[2713] = "There are no completed auctions you can leave feedback for";
		$this->messages[2714] = "auction title";
		$this->messages[2715] = "date started";
		$this->messages[2716] = "date ended";
		$this->messages[2717] = "user you are leaving feedback for";
		$this->messages[2718] = "click here to leave feedback for this auction";
		$this->messages[2719] = "Leave Feedback Form";
		$this->messages[2720] = "person you are rating";
		$this->messages[2721] = "how would you rate this user";
		$this->messages[2722] = "please type in your feedback about this transaction";
		$this->messages[2723] = "Please fill in feedback comments";
		$this->messages[2724] = "Thank You for your feedback";
		$this->messages[2725] = "Your feedback has been recorded";
		$this->messages[2726] = "click here to return to user feedback";
		$this->messages[2727] = "Please rate your transaction";
		$this->messages[2728] = "You have already left feedback for this auction.";
		$this->messages[2729] = "We could not complete your feedback request";
		$this->messages[2730] = "You must first login before being able to view your feedback";
		$this->messages[2731] = "your current cumulative rating: ";
		$this->messages[2732] = "seller";
		$this->messages[2733] = "high bidder";
		$this->messages[2734] = "enter feedback";

	}

//####################################################################################

	function feedback_home()
	{
		echo "<table border=0 cellpadding=5 cellspacing=0 width=600 align=center>\n";
		echo "<tr>\n\t<td align=center>\n\t".$this->font_title_tag.$this->messages[2700]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center>\n\t".$this->font_tag.$this->messages[2701]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center>\n\t";
		echo "<a href=auctions.php?a=13>".$this->font_tag.$this->messages[2702]."</a>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center>\n\t";
		echo "<a href=auctions.php?a=14>".$this->font_tag.$this->messages[2703]."</a>\n\t</td>\n</tr>\n";
		echo "</table>\n";	
	} //end of function feedback_home
	
//####################################################################################

	function feedback_about_user($db,$user_id)
	{
		$sql_query = "select username,rate_num,rate_sum from ".$this->auctions_userdata_table." where id = ".$user_id;
		$rated_result = &$db->Execute($sql_query);
		//echo $sql_query." is the query<br>\n";
		if ($rated_result)
		{
			$show_rated = $rated_result->FetchNExtObject();
			$rated_username = $show_rated->USERNAME;
	
			$secid = AddSlashes($id);
			$sql_query="SELECT * FROM ".$this->auctions_feedbacks_table." 
				where rated_user_id = ".$user_id." and done = 1 ORDER by date DESC";
			$result = &$db->Execute($sql_query);
			//echo $sql_query." is the query<br>\n";
			if (!$result)
			{
				$this->error_message = $this->messages[2704];
				return false;
			}
			elseif ($result->RecordCount() == 0)
			{
				//there are no feedbacks to look at
				echo "<table align=center cellpadding=3 cellspacing=0 border=0 align=center width=600>\n\t";
				echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2705]."</td>\n</tr>\n";
				echo "</table>\n";			
			}
			else
			{
				//there was feedback about this user so give it to them
				echo "<table cellpadding=10 cellspacing=0 border=0 align=center width=600>\n";
				$i=0;
				echo "<tr>\n\t<td align=center>\n\t";
				echo "<table align=center cellpadding=3 cellspacing=0 border=0>\n\t";
				echo "<tr>\n\t\t<td align=center>".$this->font_tag.$this->messages[2706]."</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2707]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2708]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2709]."\n\t\t</td>\n\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2710]."\n\t\t</td>\n\t</tr>\n\t";
				while ($show = $result->FetchNextObject())
				{
					if (($i%2) == 0) 
						$bgcolor="#dddddd";
					else
						$bgcolor = "#FFFFFF";
					$sql_query = "select username,rate_num,rate_sum from ".$this->auctions_userdata_table." where id = ".$show->RATER_USER_ID;
					$user_result = &$db->Execute($sql_query);
					//echo $sql_query." is the query<br>\n";
					if ($user_result)
					{
						$show_user = $user_result->FetchNExtObject();
						$rater_username = $show_user->USERNAME;
					}
					else
						$rater_username = $show->RATER_USER_ID;
					echo "<tr bgcolor=".$bgcolor.">\n\t\t<td align=center>".$this->font_tag.$rater_username."&nbsp;\n\t\t</td>\n\t\t";
					echo "\n\t\t<td align=center>".$this->font_tag.$show->AUCTION_ID."&nbsp;\n\t\t</td>\n\t\t";
					echo "\n\t\t<td align=center>".$this->font_tag.$show->FEEDBACK."&nbsp;\n\t\t</td>\n\t\t";
					echo "\n\t\t<td align=center>".$this->font_tag.$show->RATE."&nbsp;\n\t\t</td>\n\t\t";
					echo "\n\t\t<td align=center>".$this->font_tag.date("F d - G:i",$show->DATE)."&nbsp;\n\t\t</td>\n\t</tr>\n\t";
					$i++;
				}

				if ($show_rated->RATE_NUM > 0)
					echo "<tr>\n\t<td colspan=5>\n\t".$this->messages[2731].sprintf("%01.2f",($show_rated->RATE_SUM / $show_rated->RATE_NUM))."\n\t</td>\n</tr>\n";
				echo "</table>\n\t</td>\n</tr>\n";
			} //end of else

			echo "<tr>\n\t<td align=center><a href=auctions.php?a=12>".$this->messages[2711]."</a>\n\t</td>\n</tr>\n";
			echo "</table>\n<br>";
		}
		else
		{
			$this->error_message = $this->messages[2704];
			return false;		
		}
		return true;
	} //end of function feedback_about_you

//####################################################################################

	function list_open_feedback($db,$user_id=0)
	{
		if ($user_id)
		{
			$sql_query = "select * from ".$this->auctions_feedbacks_table." where rater_user_id=\"".$user_id."\" AND done=0 AND rate =\"\"";
			$result = &$db->Execute($sql_query);

			if (!$result)
			{
				$this->error_message = $this->messages[2704];
				return false;		
			}
			elseif ($result->RecordCount() == 0)
			{
				//no feedbacks open
				echo "<table cellpadding=10 cellspacing=0 border=0  align=center width=600>\n";
				echo "<tr>\n\t<td align=center>\n\t";
				echo $this->font_tag.$this->messages[2713]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=center>\n\t";
				echo "<a href=auctions.php?a=12>".$this->font_tag.$this->messages[2711]."</a>\n\t</td>\n</tr>\n";
				echo "</table>\n";
				return true;
			}
			else
			{
				//there are auctions this user can leave feedback for
				//so show them
				echo "<table cellpadding=10 cellspacing=0 border=0 align=center width=600>\n";
				echo "<tr>\n\t<td align=center>\n\t".$this->font_title_tag.$this->messages[2712]."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td align=center>\n\t";
				echo "<table cellpadding=3 cellspacing=0 border=1>\n\t";
				echo "<tr>\n\t\t<td align=center>\n\t\t".$this->font_tag.$this->messages[2714]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2715]."\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2716]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2717]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2707]."\n\t\t</td>\n\t\t";
				echo "<td align=center>\n\t\t".$this->font_tag.$this->messages[2718]."\n\t\t</td>\n\t";
				echo "</tr>\n\t";

				while ($show = $result->FetchNextObject()) 
				{
					//pull from the feedback table with this users criteria
					//if nothing comes back then this user has not rated this auction yet
					//if something comes back this user has already rated this auction
					$sql_query = "SELECT title,date,ends,seller FROM ".$this->auctions_table." WHERE id = ".$show->AUCTION_ID;
					$auction_result = &$db->Execute($sql_query);
					if ($auction_result)
					{
						if ($auction_result->RecordCount() == 1)
						{
							$show_auction = $auction_result->FetchNExtObject();
							$sql_query = "select username from ".$this->auctions_userdata_table." where id = ".$show->RATED_USER_ID;
							$user_result = &$db->Execute($sql_query);
							//echo $sql_query." is the query<br>\n";
							if ($user_result)
							{
								if ($user_result->RecordCount() == 1)
								{
									$show_user = $user_result->FetchNExtObject();
									$rated_user = $show_user->USERNAME;
								}
								else
									$rated_user = $show->RATED_USER_ID;
							}
							else
								$rated_user = $show->RATED_USER_ID;

							echo "<tr>\n\t\t<td align=center>".$this->font_tag.$show_auction->TITLE."\n\t\t</td>\n\t\t";
							echo "<td align=center>".$this->font_tag.date("F d, G:i",$show_auction->DATE)."\n\t\t</td>\n\t\t";
							echo "<td align=center>".$this->font_tag.date("F d, G:i",$show_auction->ENDS)."\n\t\t</td>\n\t\t";
							echo "<td align=center>".$this->font_tag;
							if ($show_auction->SELLER == $show->RATED_USER_ID)
							{
								echo $this->messages[2732]." (".$rated_user.")";
							}
							else
							{
								echo $this->messages[2733]." (".$rated_user.")";
							}
							echo "\n\t\t</td>\n\t\t";
							echo "<td align=center>".$this->font_tag.$show->AUCTION_ID."\n\t\t</td>\n\t\t";
							echo "<td align=center><a href=auctions.php?a=15&b=".$show->AUCTION_ID.">".$this->font_tag.$this->messages[2734]."</a>\n\t\t</td>\n\t</tr>\n\t";
						}
					}
				}//endo of while
				echo "</table>\n\t</td>\n</tr>\n";
			}	
		}
		else
		{
			$this->error_message = $this->messages[2730];
			return false;		
		}
		return true;
	} // end of function list_open_feedback
	
//####################################################################################

	function leave_feedback($db,$user_id=0,$auction_id=0)
	{
		if ($user_id)
		{
			if ($auction_id)
			{
				$sql_query = "select * from ".$this->auctions_feedbacks_table." where rater_user_id = ".$user_id." 
					and auction_id = ".$auction_id;
				$result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2704];
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					$show = $result->FetchNExtObject();
					if ($show->DONE == 0)
					{
						$sql_query = "select * from ".$this->auctions_table." where id = ".$auction_id;
						$result = &$db->Execute($sql_query);
	
						if (!$result)
						{
							echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[2704];
							return false;
						}
						elseif ($result->RecordCount() == 1)
						{
							$show_auction = $result->FetchNextObject();
						}
						
						$sql_query = "select username from ".$this->auctions_userdata_table." where id = ".$show->RATED_USER_ID;
						$result = &$db->Execute($sql_query);
	
						if (!$result)
						{
							echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[2704];
							return false;
						}
						elseif ($result->RecordCount() == 1)
						{
							$show_username = $result->FetchNextObject();
						}						
						echo "<table cellpadding=5 cellspacing=0 border=0 align=center width=600>\n";
						echo "<tr>\n\t<td>\n\t<form action=auctions.php?a=15&b=".$auction_id." method=post>\n\t";
						echo "<table width=80% cellspacing=0 cellpadding=4 border=0>\n\t";
						echo "<tr>\n\t\t<td colspan=2 align=center>".$this->font_title_tag.$this->messages[2719]."</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2720]."</td>\n\t\t";
						echo "<td>\n\t\t".$this->font_tag.$show_username->USERNAME."\n\t\t</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2707]."</td>\n\t\t";
						echo "<td>".$this->font_tag.$auction_id."</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2714]."</td>\n\t\t";
						echo "<td>".$this->font_tag.$show_auction->TITLE."</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2715]."</td>\n\t\t";
						echo "<td>".$this->font_tag.date("F d, G:i",$show_auction->DATE)."</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2716]."</td>\n\t\t";
						echo "<td>".date("F d, G:i",$show->DATE)."</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right valign=top>".$this->font_tag.$this->messages[2721];
						if (strlen(trim($this->feedback_messages["rating"])) > 0)
							echo "<br>".$this->feedback_messages["rating"];
						echo "</td>\n\t\t";
						echo "<td>\n\t\t
							<input type=radio name=c[rating] value=1>".$this->font_tag."1 (very poor)<br>\n\t\t
							<input type=radio name=c[rating] value=2>".$this->font_tag."2 (poor)<br>\n\t\t
							<input type=radio name=c[rating] value=3>".$this->font_tag."3 (average)<br>\n\t\t
							<input type=radio name=c[rating] value=4>".$this->font_tag."4 (above average)<br>\n\t\t
							<input type=radio name=c[rating] value=5>".$this->font_tag."5 (excellent)\n\t\t</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td align=right valign=top>".$this->font_tag.$this->messages[2722];
						if (strlen(trim($this->feedback_messages["feedback"])) > 0)
							echo "<br>".$this->feedback_messages["feedback"];
						echo "</td>\n\t\t";
						echo "<td>\n\t\t<textarea name=c[feedback] rows=10 cols=50></textarea>\n\t\t</td>\n\t</tr>\n\t";

						echo "<tr>\n\t\t<td><input type=submit name=save_feedback><input type=reset></form></td>\n\t</tr>\n\t";
						echo "</table>\n\t</td>\n</tr>\n";
						echo "</table>\n";
						return true;
					}
					else
					{
						//already left feedback for this auction
						echo "<table cellpadding=5 cellspacing=1 border=1 align=center width=600>\n";
						echo "<tr>\n\t<td>".$this->messages[2728]."</td>\n</tr>\n";
						echo "</table>\n";
						return true;
					}
				}
				else
				{
					echo "too many<br>\n";
					$this->error_message = $this->messages[2704];
					return false;		
				}
			}
			else
			{
				$this->error_message = $this->messages[2704];
				return false;			
			}
		}
		else
		{
			$this->error_message = $this->messages[2730];
			return false;		
		}
		return true;
	} // end of function leave_feedback

//####################################################################################

	function check_feedback($db,$auction_id=0,$user_id=0,$info=0)
	{
		$error=0;

		$feedback = ltrim(chop($info["feedback"]));
		if (strlen(trim($feedback)) == 0)  
		{
			$error++;
			$this->feedback_messages["feedback"] = $this->messages[2723];
		}

		if (empty($info["rating"])) 
		{
			$error++;
			$this->feedback_messages["rating"] = $this->messages[2727];
		}
		
		$sql_query = "select seller from ".$this->auctions_table." where id = ".$auction_id;
		$result = &$db->Execute($sql_query);
		//echo $sql_query." is the query<br>\n";
		if (!$result)
		{
			$this->error_message = $this->messages[2704];
			return false;		
		}
		elseif ($result->RecordCount() == 1)
		{
			$show_auction = $result->FetchNExtObject();
			if ($show_auction->SELLER != $user_id)
			{
				$sql_query = "select bidder from ".$this->auctions_bids_table." where auction = ".$auction_id." 
					order by bid desc, time_of_bid asc";
				$bid_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$bid_result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2704];
					return false;		
				}
				elseif ($bid_result->RecordCount() > 0)
				{
					$show_bid = $bid_result->FetchNextObject();
					if ($show_bid->BIDDER != $user_id)
					{
						echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[2704];
						return false;						
					}
					else
					{
						//the buyer is rating the seller
					}
				}
				else
				{
					//no bids were accepted for this auction
					//no feedback can be accepted either
					$this->error_message = $this->messages[2704];
					return false;					
				}
			}
			else
			{
				//the seller is rating the buyer
			}
		}
		else
		{
			$this->error_message = $this->messages[2704];
			return false;	
		}
		

		if ($error > 0) 
		{
			return false;
		}
		else
		{
			return true;
		}
	} //end of function check_feedback

//####################################################################################

	function save_feedback($db,$auction_id=0,$user_id=0,$info=0)
	{
		// there are no errors in the feedback field
		// lets enter it into the database
		if (($auction_id) && ($user_id) && ($info))
		{
			$sql_query = "update ".$this->auctions_feedbacks_table." 
				set 
				feedback=\"".$info["feedback"]."\", 
				rate=\"".$info["rating"]."\",
				done = 1
				where 
				auction_id=\"".$auction_id."\" AND 
				rater_user_id=\"".$user_id."\"";

			$result = &$db->Execute($sql_query);
			//echo $sql_query." is the query<br>\n";
			if (!$result) 
			{
				//error in the update
				$this->error_message = $this->messages[2704];
				return false;		
			}
			else
			{
				$sql_query = "select rated_user_id from ".$this->auctions_feedbacks_table." where 
					auction_id = ".$auction_id." and rater_user_id=\"".$user_id."\"";
				$result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$result) 
				{
					//error in getting the rated user id
					$this->error_message = $this->messages[2704];
					return false;		
				}
				elseif ($result->RecordCount() == 1)
				{
					$show_rated_user_id = $result->FetchNextObject();
										
					$sql_query = "select sum(rate) as rate_sum,count(rate) as rate_num from ".$this->auctions_feedbacks_table."
						where rated_user_id = ".$show_rated_user_id->RATED_USER_ID." and done = 1";
					$result = &$db->Execute($sql_query);				
					//echo $sql_query." is the query<br>\n";
					if (!$result) 
					{
						//error in getting the rated user id
						$sql_query = "update ".$this->auctions_feedbacks_table." 
							set 
							feedback=\"\", 
							rate=0,
							done = 0
							where 
							auction_id=\"".$auction_id."\" AND 
							rater_user_id=\"".$user_id."\"";

						$result = &$db->Execute($sql_query);
						echo $sql_query." is the query<br>\n";						
						
						$this->error_message = $this->messages[2704];
						return false;		
					}
					elseif ($result->RecordCount() == 1)
					{
						$show_ratings = $result->FetchNExtObject();
						$sql_query = "update ".$this->auctions_userdata_table." set
							rate_sum = ".$show_ratings->RATE_SUM.",
							rate_num = ".$show_ratings->RATE_NUM." 
							where id = ".$show_rated_user_id->RATED_USER_ID;
						$result = &$db->Execute($sql_query);				
						//echo $sql_query." is the query<br>\n";

						if (!$result)
						{
							//back out feedback
							$this->error_message = $this->messages[2704];
							return false;
						}

					}
					else
					{
						//no ratings yet for this user
						//when there should have been
						$sql_query = "update ".$this->auctions_feedbacks_table." 
							set 
							feedback=\"\", 
							rate=0,
							done = 0
							where 
							auction_id=\"".$auction_id."\" AND 
							rater_user_id=\"".$user_id."\"";

						$result = &$db->Execute($sql_query);
						echo $sql_query." is the query<br>\n";						
						
						$this->error_message = $this->messages[2704];
						return false;		
						
					}
				}
				else
				{
					//wrong return on rated user id
					$this->error_message = $this->messages[2704];
					return false;					
				}
			}
		}
		else
		{
			$this->error_message = $this->messages[2704];
			return false;			
		}

		return true;
	} //end of function save_feedback

//####################################################################################

	function feedback_thank_you()
	{
		echo "<table cellpadding=10 cellspacing=0 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td align=center>".$this->font_title_tag.$this->messages[2724]."</td>\n</tr>\n";
		echo "<tr>\n\t<td align=center>".$this->font_tag.$this->messages[2725]."</td>\n</tr>\n";
		echo "<tr>\n\t<td><a href=auctions.php?a=12>".$this->font_tag.$this->messages[2711]."</a></td>\n</tr>\n";
		echo "</table>\n";
	} //end of function feedback_thank_you

//####################################################################################

	function feedback_error()
	{
		echo "<table cellpadding=10 cellspacing=0 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td align=center>".$this->font_title_tag.$this->messages[2704]."</td>\n</tr>\n";
		if ($this->error_message)
			echo "<tr>\n\t<td>".$this->font_tag.$this->error_messages."</td>\n</tr>\n";
		echo "</table>\n";
	} //end of function feedback_error

//####################################################################################

} //end of class Auction_feedback
?>