<? //auction_browse_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/

class Auction_browse {

	var $messages = array();
	
	//font tag information used throughout several parts of the site
	var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";
	var $font_tag_light = "<font face=arial,helvetica size=2 color=#ffffff>";	
	
	//color backgrounds of the classified ad listing table
	var $background_color_light = "#eeeeee";
	var $background_color_dark = "#dddddd";
	
	//database table names -  can be left alone
	var $auctions_table = "geodesic_auctions";
	var $auctions_userdata_table = "geodesic_auctions_userdata";
	var $auctions_feedback_table = "geodesic_auctions_feedbacks";
	var $auctions_categories_table = "geodesic_auctions_categories";
	var $auctions_bids_table = "geodesic_auctions_bids";
	var $auctions_increments_table = "geodesic_auctions_increments";
	
	var $level;
	
	var $subcategory_array = array();
	
	var $category_tree_array = array();
	
	//final directory path the uploaded auction images will be placed in
	//used when removing expired auction images 
	//same path in classified_sell_class.php
	var $auction_images_path= "/home/geodesicsolutions/www/products/auctions/litedeomo/auction_images/";
	
	//if display_sub_category_auctions is set to 1:
	//the auctions ads in the subcategories of the currently browsed category will be displayed also
	//with those in the current category
	//if display_sub_category_auctions is set to 0:
	//only auctions ads in the currently browsed category will be displayed
	var $display_sub_category_auctions = 1; 
	
	//set to 1 to display the auction ads count for that category while browsing
	//set to 0 to turn off
	var $display_counter = 1; 	
		
//########################################################################

	function Auction_browse($auth)
	{
		$this->level = $auth->level;
	
		$this->messages[2500] = "This auction is closed";
		$this->messages[2501] = "You can no longer make bids on this auction";
		$this->messages[2502] = "Item category";
		$this->messages[2503] = "Seller(rating)";
		$this->messages[2504] = "Auction type";
		$this->messages[2505] = "High bid";
		$this->messages[2506] = "Number of bids";
		$this->messages[2507] = "Minimum bid";
		$this->messages[2508] = "Current time";
		$this->messages[2509] = "Auction ends";
		$this->messages[2510] = "Time till auction ends";
		$this->messages[2511] = "Location";
		$this->messages[2512] = "Description";
		$this->messages[2513] = "Auction id";
		$this->messages[2514] = "Number of items";
		$this->messages[2515] = "Subcategories of ";
		$this->messages[2516] = "There are no auctions in this category";
		$this->messages[2517] = "picture";
		$this->messages[2518] = "current price";
		$this->messages[2519] = "bids";
		$this->messages[2520] = "ends";
		$this->messages[2521] = "none";
		$this->messages[2522] = "Main";
		$this->messages[2523] = "Internal browse error!";
		$this->messages[2524] = "Not enough information to display the auction";
		$this->messages[2525] = "Welcome to our Auction";
		$this->messages[2526] = "Start browsing the main categories below";
		$this->messages[2527] = "There are no categories yet";
		$this->messages[2528] = "Not enough information to browse the auctions";
		$this->messages[2529] = "auction title";
		$this->messages[2530] = "There are no subcategories to ";
		$this->messages[2531] = "Click here to notify a friend of this auction ";
		$this->messages[2532] = "not rated yet";
		$this->messages[2533] = "no bids yet";
		$this->messages[2534] = "click to make a bid on this auction";
		
		
	} //end of function Auction_browse

//###########################################################

	function display_auction($db,$id=0)
	{
		if ($id)
		{
			$sql_query = "select * from ".$this->auctions_table." where id = ".$id;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				return false;
			}
			elseif ($result->RecordCount() > 1 )
			{
				//more than one auction matches
				return false;
			}
			elseif ($result->RecordCount() <= 0)
			{
				return false;
			}
			else
			{
				//the auction exists diplay it
				$show = $result->FetchNextObject();

				echo "<table width=600 cellpadding=3 cellspacing=0 align=center border=0>\n";
				
				$category_tree = $this->get_category_tree($db,$show->CATEGORY);
				reset ($this->category_tree_array);
		
				if ($category_tree)
				{
					//category tree
					echo "<tr>\n\t<td>\n\t<b>";
					echo $this->font_tag.$this->messages[2502]." : </b> <a href=auctions.php?a=5>Main</a> >";
					if (is_array($this->category_tree_array))
					{
						$i = 0;
						//$categories = array_reverse($this->category_tree_array);
						$i = count($this->category_tree_array);
						while ($i > 0 ) 
						{
							//display all the categories
							$i--;
							if ($i == 0)
								echo "<a href=auctions.php?a=5&b=".$this->category_tree_array[$i]["category_id"]."><b>".$this->font_tag.$this->category_tree_array[$i]["category_name"]."</b></a>";
							else
								echo "<a href=auctions.php?a=5&b=".$this->category_tree_array[$i]["category_id"].">".$this->font_tag.$this->category_tree_array[$i]["category_name"]."</a> > ";
						}
					}
					else
					{
						echo $category_tree;
					}
					echo "\n\t</td>\n</tr>\n";
				}
			
				if ($show->CLOSED)
				{
					//display the closed message
					echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2500]."\n\t</td>\n</tr>\n";
					echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2501]."\n\t</td>\n</tr>\n";
				}
				//auction id
				echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2513].": ".$show->ID."</font>\n\t</td>\n</tr>\n";
				
				//auction title
				echo "<tr>\n\t<td>".$this->font_title_tag.$show->TITLE."</font>\n\t</td>\n</tr>\n";

				//get sellers data				
				$sql_query = "select * from ".$this->auctions_userdata_table." where id = ".$show->SELLER;
				$user_result = &$db->Execute($sql_query);
				if (!$user_result)
					$this->site->database_error();
				$show_user  = 	$user_result->FetchNextObject();
				
				//calculate the feedback information for the seller
				if ($show_user->RATING_NUM > 0)
					$seller_rating = $show_user->RATING_SUM / $show_user->RATING_NUM;
				else
					$seller_rating = $this->messages[2532];

				//seller id
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2503].": ".$show_user->USERNAME." (".$seller_rating.")</td>\n\t</tr>\n\t";		
				
				////auction type
				//echo "<tr>\n\t\t<td>".$this->messages[2504].$show->AUCTION_TYPE."</td>\n\t</tr>\n\t";	

				//number of items
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2514].": ".$show->QUANTITY."</td>\n\t</tr>\n\t";	

				//get bid information
				$sql_query = "SELECT MAX(bid) AS maxbid,bidder FROM ".$this->auctions_bids_table." WHERE auction='".$id."' GROUP BY auction";
				$high_bid_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$high_bid_result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2524];
					return false;
				}
				$high_bid = 0;
				
				//get number of bids
				$sql_query = "select count(bid) as num_bids from ".$this->auctions_bids_table." where auction='".$id."'";
				$num_bid_result =  &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$num_bid_result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2524];
					return false;
				}
				$number_of_bids_pointer = $num_bid_result->FetchNextObject();	
				$number_of_bids = $number_of_bids_pointer->NUM_BIDS;
				
				if ($number_of_bids > 0 )
				{
					//a bid has been placed
					//get it and information on the bidder
					$show_high_bid = $high_bid_result->FetchNextObject();
					$high_bid = $show_high_bid->MAXBID;
					//$sql_query = "select bidder from ".$this->auctions_bids_table." where bid=".$show_high_bid->MAXBID." and auction= '"$id."'";
					//$high_bidder_result = &$db->Execute($sql_query);
					//if (!$high_bidder_result)
					//	return false;
					//$show_high_bidder = $high_bidder_result->FetchNextObject();
					$sql_query = "select username,rate_num,rate_sum from ".$this->auctions_userdata_table." where id = ".$show_high_bid->BIDDER;
					$high_bidder_result = &$db->Execute($sql_query);
					//echo $sql_query." is the query<br>\n";
					if (!$high_bidder_result)
					{
						echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[2524];
						return false;
					}
					$show_high_bidder = $high_bidder_result->FetchNextObject();
					
					//$sql_query = "SELECT rated_user_id FROM ".$this->auctions_feedback_table." WHERE rated_user_id='".$high_bidder."'";
					//$rating_result =  &$db->Execute($sql_query);
					//if (!$rating_result)
					//	return false;
					//$number_of_feedbacks = $rating_result->RecordCount();
					//$sql_query = "SELECT rate_sum FROM ".$this->auctions_userdata_table." WHERE nick='".$high_bidder."'";
					//$rating_result =  &$db->Execute($sql_query);
					//if (!$rating_result)
					//	return false;
					//$show_rating = $rating_result->FetchNextObject();
					if ($show_high_bidder->RATE_NUM != 0)
						$high_bidder_rating = $show_high_bidder->RATE_SUM / $show_high_bidder->RATE_NUM;
					else
						$high_bidder_rating = $this->messages[2532];

					//high bid
					echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2505].": ".$show_high_bidder->USERNAME."(".$high_bidder_rating.")</td>\n\t</tr>\n\t";	
				}
				else
				{
					//no bids yet for this auction
					echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2505].": ".$this->messages[2533]."</td>\n\t</tr>\n\t";	
				}
				
				//number of bids
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2506]." : ".$number_of_bids."</td>\n\t</tr>\n\t";	

				if ($high_bid == 0)
				{
					$next_bid = $show->MINIMUM_BID;
				}
				else
				{
					//get bid increment to calculate the next minimum bid
					$sql_query = "SELECT increment FROM ".$this->auctions_increments_table." WHERE
						((low<=$high_bid AND high>=$high_bid) OR (low<$high_bid AND high<$high_bid)) ORDER BY increment DESC";
					$increment_result =  &$db->Execute($sql_query);
					if (!$high_bidder_result)
					{
						echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[2524];
						return false;
					}
					$show_increment = $increment_result->FetchNextObject();
					$increment = $show_increment->INCREMENT;
				 	$next_bid = $high_bid + $increment;
				}
				
				//minimum bid
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2507]." : ".$next_bid."</td>\n\t</tr>\n\t";

				$current_time = time();
				//current time
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2508]." : ".date("M d, Y H:i:s", $current_time)."</td>\n\t</tr>\n\t";

				//end time
				$end_date = date("M d, Y H:i:s", $show->ENDS);
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2509]." : ".$end_date."</td>\n\t</tr>\n\t";

				if (!$show->CLOSED)
				{
					$end_difference = $this->DateDifference("s", $current_time, $show->ENDS);

					if ($end_difference > 0)
					{
						$end_days_difference = intval($this->DateDifference("d", $current_time, $show->ENDS));
						$end_hours_difference = intval(($this->DateDifference("h", $current_time, $show->ENDS)) - ($end_days_difference * 24));
						$end_minutes_difference = intval(($this->DateDifference("m", $current_time, $show->ENDS)) - (($end_hours_difference * 60) + ($end_days_difference * 24*60)));
						$end_seconds_difference = intval(($this->DateDifference("s", $current_time, $show->ENDS)) - (($end_minutes_difference * 60) + ($end_hours_difference * 60 * 60) + ($end_days_difference * 24*60 * 60)));
						
						$time_till_end = $end_days_difference." days ".$end_hours_difference." hours ".$end_minutes_difference." minutes ".$end_seconds_difference." secs";

					 	//time till end 
						echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2510]." : ".$time_till_end."</td>\n\t</tr>\n\t";
					} // end of if ($end_difference > 0)
				}
				
				//location
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2511]." : ".$show->LOCATION_STATE." ".$show->LOCATION_ZIP."</td>\n\t</tr>\n\t";

				//description
				echo "<tr>\n\t\t<td>".$this->font_tag.$this->messages[2512]."<br>".$show->DESCRIPTION."</td>\n\t</tr>\n\t";
				
				//image
				if (strlen(trim($show->IMAGE_URL)) > 0)
				{
					echo "<tr>\n\t\t<td><img src=".$show->IMAGE_URL."></td>\n\t</tr>\n\t";
				}

				if (!$show->CLOSED)
				{
					//display the bid link
					echo "<tr>\n\t<td>\n\t<a href=auctions.php?a=9&b=".$id.">".$this->font_tag.$this->messages[2534]."</a>\n\t</td>\n</tr>\n";
				}
				
				echo "</table>\n";

				return true;
			}
		}
		else
		{
			//no id to display
			return false;
		} //end of else
	} //end of function display_auction
	
//####################################################################################

	function browse($db,$category=0,$browse_type=0)
	{
		if ($category)
		{
			if (($this->display_sub_category_auctions) && ($this->display_counter))
			{
				$in_statement = $this->get_sql_in_statement($db,$category);
			}
			else
			{
				$in_statement = " in (".$category.") ";
			}
			switch($browse_type)
			{
				case 1:
					//browse the auctions closing in the next 24 hours
					$next_24 = time() + 86400;
					$sql_query = "select * from ".$this->auctions_table." where 
						category ".$in_statement." and closed = 0 and ends < ".$next_24." order by ends asc";
					break;

				case 2:
					//browse the auctions started in the last 24 hours
					$last_24 = time() - 86400;
					$sql_query = "select * from ".$this->auctions_table." where 
						category ".$in_statement." and closed = 0 and date > ".$last_24." order by date asc";;
					break;

				default:
					//browse the auctions in this category that are open
					$sql_query = "select * from ".$this->auctions_table." where 
						category ".$in_statement." and closed = 0 order by ends asc";
					break;
			}

			$result = &$db->Execute($sql_query);
			//echo $sql_query." is the query<br>\n";
			if (!$result)
			{
				$this->error_message = $this->messages[2524];
				return false;
			}
			else
			{
				echo "<table cellpadding=2 cellspacing=1 border=0 width=600 align=center>\n";
				//get this categories name
				$sql_query = "select *from ".$this->auctions_categories_table." where category_id = ".$category;
				$name_result = &$db->Execute($sql_query);	
				if (!$name_result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2524];
					return false;
				}
				elseif ($name_result->RecordCount() == 1)
				{
					$show_name = $name_result->FetchNExtObject();
					$category_name = $show_name->CATEGORY_NAME;
				}
				else
				{
					$category_name = $this->messages[2522];
				}

				//get the categories inside of this category
				$sql_query = "select * from ".$this->auctions_categories_table." where 
					parent_id = ".$category." order by display_order";
				$category_result = &$db->Execute($sql_query);

				//echo $sql_query." is the query<br>\n";
				if (!$category_result)
				{
					echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[2524];
					return false;
				}
				else
				{
					if ($category_result->RecordCount() > 0)
					{
						//display the sub categories of this category
						echo "<tr>\n\t<td>\n\t".$this->font_title_tag.$this->messages[2515]." ".$category_name."\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td>\n\t";
						while ($show_sub_categories = $category_result->FetchNextObject())
						{
							$count = $this->get_ad_count_for_category($db,$show_sub_categories->CATEGORY_ID);
							echo "<a href=auctions.php?a=5&b=".$show_sub_categories->CATEGORY_ID.">".
								$this->font_title_tag.$show_sub_categories->CATEGORY_NAME."</a>";
							if ($this->display_counter)
								echo "(".$count.")";
							echo "<br>\n\t";
						}
						echo "</td>\n</tr>\n";					
					}
					else
					{
						echo "<tr>\n\t<td>\n\t".$this->font_title_tag.$this->messages[2530]." ".$category_name."\n\t</td>\n</tr>\n";
					}
					$category_tree = $this->get_category_tree($db,$category);
					reset ($this->category_tree_array);

					if ($category_tree)
					{
						//category tree
						echo "<tr>\n\t<td>\n\t<b>";
						echo $this->font_tag.$this->messages[2502]." : </b> <a href=auctions.php?a=5>Main</a> >";
						if (is_array($this->category_tree_array))
						{
							$i = 0;
							//$categories = array_reverse($this->category_tree_array);
							$i = count($this->category_tree_array);
							while ($i > 0 ) 
							{
								//display all the categories
								$i--;
								if ($i == 0)
									echo "<b>".$this->category_tree_array[$i]["category_name"]."</b>";
								else
									echo "<a href=auctions.php?a=5&b=".$this->category_tree_array[$i]["category_id"].">".$this->category_tree_array[$i]["category_name"]."</a> > ";
							}
						}
						else
						{
							echo $category_tree;
						}
						echo "\n\t</td>\n</tr>\n";
					}

					if ($result->RecordCount() > 0)
					{
						//auctions exist in this category
						//display the auctions inside of this category
						echo "<tr>\n\t<td>\n\t";
						echo "<table cellpadding=3 cellspacing=1 border=1>\n\t";
						echo "<tr>\n\t\t
							<td>".$this->font_tag.$this->messages[2529]."</td>\n\t\t
							<td>".$this->font_tag.$this->messages[2519]."</td>\n\t\t
							<td>".$this->font_tag.$this->messages[2518]."</td>\n\t\t
							<td>".$this->font_tag.$this->messages[2520]."</td>\n\t";
						if ($this->level == 1)
						{
							echo "<td>click to delete</td>\n\t";
						}
						echo "</tr>\n\t";
						while ($show_auctions = $result->FetchNextObject())
						{
							$row_color = $this->get_row_color($i);
							echo "<tr bgcolor=".$row_color.">\n\t\t";
							//<td>\n\t\t";
							//if (strlen(trim($show_auctions->IMAGE_URL)) > 0)
							//{
							//	echo "<tr>\n\t\t<td>\n\t\t<img src=".$show_auctions->IMAGE_URLS.">\n\t\t</td>\n\t\t";
							//}
							//else
							//{
							//	echo "<tr>\n\t\t<td>\n\t\t".$this->messages[2521]."\n\t\t</td>\n\t\t";
							//}
							echo "<td>\n\t\t<a href=auctions.php?a=2&b=".$show_auctions->ID.">".$show_auctions->TITLE."</a>\n\t\t</td>\n\t\t";
								$sql_query = "select count(bid) as num_bids from ".$this->auctions_bids_table." where
								auction = ".$show_auctions->ID;
							$bids_result = &$db->Execute($sql_query);
							if (!$bids_result)
								$bids = 0;
							else
							{
								$show_bid_count = $bids_result->FetchNextObject();
								$bids = $show_bid_count->NUM_BIDS;							
							}
							echo "<td>\n\t\t".$bids."\n\t\t</td>\n\t\t";
								echo "<td>\n\t\t";
							if ($bids == 0)
								echo $show_auctions->MINIMUM_BID;
							else
								echo $show_auctions->HIGH_BID;
							echo "\n\t\t</td>\n\t\t";
								echo "<td>\n\t\t".date("F d-G:i",$show_auctions->ENDS)."\n\t\t</td>\n\t";
							if ($this->level == 1)
							{
								//this is the admin
								echo "<td>\n\t\t<a href=auctions.php?a=98&b=".$show_auctions->ID."&c=".$category.">delete</a>\n\t\t</td>\n\t";								
							}									
							echo "</tr>\n\t";						
						} //end of while
						echo "</table>\n\t</td>\n</tr>\n";
					}
					else
					{
						//no auctions in this category
						echo "<tr>\n\t<td>\n\t".$this->font_tag.$this->messages[2516]."\n\t</td>\n</tr>\n";
					}
				}
				echo "</table>\n";
			}
		}
		else
		{
			//go to browse the main category
			if (!$this->browse_main($db))
			{
				return false;
			}
		}
		return true;

	} //end of function browse
	
//########################################################################

	function get_category_tree($db,$category)
	{
		$i = 0;
		$category_next = $category;
		do
		{
			$sql_query = "select category_id,parent_id,category_name from ".$this->auctions_categories_table." 
				where category_id = ".$category_next;
			$category_result =  &$db->Execute($sql_query);
			
			//$category = array();
			
			//echo $sql_query." is the query<br>\n";
			if (!$category_result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2052];
				return false;
			}
			elseif ($category_result->RecordCount() == 1)
			{
				$show_category = $category_result->FetchNextObject();
				//echo $i." is i before increment in get_category_tree<br>\n";
				//$category[$i] = array("parent_id"=>$show_category->PARENT_ID,"category_name"=>$show_category->CATEGORY_NAME,"category_id"=>$show_category->CATEGORY_ID);
				$this->category_tree_array[$i]["parent_id"]  = $show_category->PARENT_ID;
				$this->category_tree_array[$i]["category_name"] = $show_category->CATEGORY_NAME;
				$this->category_tree_array[$i]["category_id"]   = $show_category->CATEGORY_ID;
				//echo $this->category_tree_array[$i]["category_id"]." is the category id<br>\n";
				$i++;
				$category_next = $show_category->PARENT_ID;
			}
			else
			{
				echo "wrong return<Br>\n";
				return false;
			}

     		} while ( $show_category->PARENT_ID != 0 );
     		
     		return true;

	} // end of function get_category_tree($category)
	
//####################################################################################

	function DateDifference ($interval, $date1,$date2) 
	{
		$difference =  $date2 - $date1;
		switch ($interval) 
		{
			case "w":
				$returnvalue  =$difference/604800;
				break;
			case "d":
				$returnvalue  = $difference/86400;
				break;
			case "h":
				$returnvalue = $difference/3600;
				break;        
			case "m":
				$returnvalue  = $difference/60;
				break;        
			case "s":
				$returnvalue  = $difference;
				break;        
	    	}    
	    	return $returnvalue;
	} //end of function DateDifference	    

//####################################################################################

	function auction_exists ($db,$auction_id=0) 
	{
		if ($auction_id)
		{
			$sql_query = "select id from ".$this->auctions_table." where id = ".$auction_id;
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->error_message = $this->messages[2524];
				return false;				
			}
			elseif ($result->RecordCount() == 1)
			{
				return true;
			}
			else
			{
				$this->error_message = $this->messages[2524];
				return false;			
			}
		}    
		else
		{
			//no auction id to check
			$this->error_message = $this->messages[2524];
			return false;
		}
	 } //end of function auction_exists	 
	
//####################################################################################

	function browse_error () 
	{
		//this->error_message is the class variable that will contain the error message
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->messages[2523]."</td>\n</tr>\n";
				if ($this->error_message)
			echo "<tr>\n\t<td>".$this->error_message."</td>\n</tr>\n";
		echo "</table>\n";  
	 } //end of function browse_error	 
	
//####################################################################################

	function main($db) 
	{
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[2525]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2526]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>\n\t";
		if (!$this->browse_main($db))
			$this->browse_error();
		echo "</td>\n</tr>\n";
		echo "</table>\n";  
		return true;
	 } //end of function main	 
	
//####################################################################################

	function browse_main($db) 
	{
		$sql_query = "select * from ".$this->auctions_categories_table." where parent_id = 0 order by display_order";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			$this->error_message = $this->messages[2524];
			return false;			
		}
		elseif  ($result->RecordCount() > 0)
		{
			echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n\t";
			while ($show = $result->FetchNextObject())
			{
			echo "<table cellpadding=5 cellspacing=1 border=0>\n\t";
			while ($show = $result->FetchNextObject())
			{
				$count = $this->get_ad_count_for_category($db,$show->CATEGORY_ID);
				echo "<tr>\n\t\t<td>
					<a href=auctions.php?a=5&b=".$show->CATEGORY_ID.">
					".$this->font_title_tag.$show->CATEGORY_NAME."</a>";
					
				if ($this->display_counter)
					echo "(".$count.")";
				echo "\n\t\t</td>\n\t</tr>\n\t";
			}
			echo "</table>\n";			}
			echo "</table>\n";
			return true;
		}
		else
		{
			echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n\t";
			echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[2527]."</td>\n</tr>\n";
			echo "</table>\n";		
			return true;
		}
		

	 } //end of function main	 
	
//####################################################################################

	function delete_images ($auction_id)
	{
		if (is_file($this->auction_images_path.$auction_id.".gif"))
		{
			//echo "gif exists<br>\n";
			chmod ($this->auction_images_path.$auction_id.".gif", 0777);	
			unlink($this->auction_images_path.$auction_id.".gif");
		}
		if (is_file($this->auction_images_path.$auction_id.".jpg"))
		{
			//echo "jpg exists<br>\n";
			chmod ($this->auction_images_path.$auction_id.".jpg", 0777);	
			unlink($this->auction_images_path.$auction_id.".jpg");
		}
	} //end of function delete_images

//#####################################################################

	function auction_close($db)
	{
		$current_time = time();
		
		$sql_query = "select * from ".$this->auctions_table." where ends < ".$current_time." and closed = 0";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			$this->error_message = $this->messages[2524];
			return false;			
		}
		elseif  ($result->RecordCount() > 0)
		{
			//close these auctions
			while ($show = $result->FetchNExtObject())
			{
				$sql_query = "update ".$this->auctions_table." set 
					closed = 1
					where id = ".$show->ID;
				$close_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$close_result)
				{
					$this->error_message = $this->messages[2523];
					return false;			
				}
				
				$sql_query = "select * from ".$this->auctions_bids_table." where auction = ".$show->ID." order by bid desc";
				$buyer_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$buyer_result)
				{
					$this->error_message = $this->messages[2523];
					return false;			
				}
				$show_buyer = $buyer_result->FetchNExtObject();
				$buyer = $show_buyer->BIDDER;
							
				$time = time();
				
				$sql_query = "insert into ".$this->auctions_feedback_table." values
					(".$buyer.",".$show->SELLER.",0,0,".$time.",".$show->ID.",0)";
				$feedback_1_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$feedback_1_result)
				{
					
					$this->error_message = $this->messages[2523];
					return false;			
				}
				
				$sql_query = "insert into ".$this->auctions_feedback_table." values
					(".$show->SELLER.",".$buyer.",0,0,".$time.",".$show->ID.",0)";
				$feedback_2_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$feedback_2_result)
				{
					$this->error_message = $this->messages[2523];
					return false;			
				}				

				if (is_file($this->auction_images_path.$show->ID.".gif"))
				{
					//echo "gif exists<br>\n";
					chmod ($this->auction_images_path.$show->ID.".gif", 0777);	
					unlink($this->auction_images_path.$show->ID.".gif");
				}
				if (is_file($this->auction_images_path.$show->ID.".jpg"))
				{
					//echo "jpg exists<br>\n";
					chmod ($this->auction_images_path.$show->ID.".jpg", 0777);	
					unlink($this->auction_images_path.$show->ID.".jpg");
				}			
				
			} //end of while
		}
		
	} //end of function auction_close
	
//##################################################################################3

	function auction_force_close($db)
	{
		$sql_query = "select * from ".$this->auctions_table." where closed = 0";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			$this->error_message = $this->messages[2524];
			return false;			
		}
		elseif  ($result->RecordCount() > 0)
		{
			//close these auctions
			while ($show = $result->FetchNExtObject())
			{
				$sql_query = "update ".$this->auctions_table." set 
					closed = 1
					where id = ".$show->ID;
				$close_result = &$db->Execute($sql_query);
				echo $sql_query." is the query<br>\n";
				if (!$close_result)
				{
					$this->error_message = $this->messages[2523];
					return false;			
				}
				
				$sql_query = "select * from ".$this->auctions_bids_table." where auction = ".$show->ID." order by bid desc";
				$buyer_result = &$db->Execute($sql_query);
				echo $sql_query." is the query<br>\n";
				if (!$buyer_result)
				{
					echo "error in buyer query<br>\n";
					$this->error_message = $this->messages[2523];
					return false;			
				}

				$show_buyer = $buyer_result->FetchNExtObject();
				$buyer = $show_buyer->BIDDER;

				
				$time = time();
				
				$sql_query = "insert into ".$this->auctions_feedback_table." values
					(".$buyer.",".$show->SELLER.",0,0,".$time.",".$show->ID.",0)";
				$feedback_1_result = &$db->Execute($sql_query);
				echo $sql_query." is the query<br>\n";
				if (!$feedback_1_result)
				{
					echo "error in first insert<br>\n";
					$this->error_message = $this->messages[2523];
					return false;			
				}
				
				$sql_query = "insert into ".$this->auctions_feedback_table." values
					(".$show->SELLER.",".$buyer.",0,0,".$time.",".$show->ID.",0)";
				$feedback_2_result = &$db->Execute($sql_query);
				echo $sql_query." is the query<br>\n";
				if (!$feedback_2_result)
				{
					echo "error in second insert<br>\n";
					$this->error_message = $this->messages[2523];
					return false;			
				}				
			} //end of while
		}
		
	} //end of function auction_force_close

//##################################################################################3

	function admin_delete_auction($db,$auction_id=0)
	{
		if ($auction_id)
		{
			$sql_query = "update ".$this->auctions_table." set
				closed = 1 where id = ".$auction_id;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2524];
				return false;			
			}
			return true;
		}
		else
		{
			$this->error_message = $this->messages[2524];
			return false;
		}
		
	} //end of function admin_delete_auction

//##################################################################################

	function get_row_color($i)
	{
		if (($i % 2) == 0)
			$row_color = $this->background_color_light;
		else
			$row_color = $this->background_color_dark;
		return $row_color;
	} //end of function get_row_color

//##################################################################################3

	function get_ad_count_for_category($db,$category_id=0)
	{
		if ($category_id)
		{
			//get the count for this category
			$count = 0;
			
			$sql_query = "select category_id from ".$this->auctions_categories_table." where parent_id = ".$category_id;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2524];
				return false;			
			}
			elseif ($result->RecordCount() > 0)
			{
				while ($show_category = $result->FetchNextObject())
				{
					$returned_count = $this->get_ad_count_for_category($db,$show_category->CATEGORY_ID);
					if ($returned_count)
						$count += $returned_count;
					
					//echo $count." is count returned for category ".$category_id."<br>\n";
				}
			}
		
			$count += $this->get_ad_count_this_category($db,$category_id);
			
			return $count;
		}
		else
		{
			//category_id is missing
			return false;
		}		
		
	} //end of function get_ad_count_for_category

//##################################################################################

	function get_ad_count_this_category($db,$category_id=0)
	{
		if ($category_id)
		{
			$sql_query = "select count(*) as total from ".$this->auctions_table." where category = ".$category_id.
				" and closed =0";
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2524];
				return false;			
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNextObject();
				return $show->TOTAL;				
			}
			else
			{
				return false;
			}
			
		}
		else
		{
			//category_id is missing
			return false;
		}		
		
	} //end of function get_ad_count_this_category

//##################################################################################

	function get_sql_in_array($db,$category_id)
	{
		if ($category_id)
		{
			//get the count for this category
			$count = 0;
			
			$sql_query = "select category_id from ".$this->auctions_categories_table." where parent_id = ".$category_id;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[2524];
				return false;			
			}
			elseif ($result->RecordCount() > 0)
			{
				while ($show_category = $result->FetchNextObject())
				{
					$this->get_sql_in_array($db,$show_category->CATEGORY_ID);
				}
			}
		
			array_push ($this->subcategory_array, $category_id);
						
			return true;
		}
		else
		{
			//category_id is missing
			return false;
		}		
		
	} //end of get_sql_in_array
	
//##################################################################################

	function get_sql_in_statement($db,$category_id)
	{
		if ($category_id)
		{
			$this->get_sql_in_array($db,$category_id);
			if (count($this->subcategory_array) > 0)
			{
				$in_statement .= "in (";
				while (list($key,$value) = each($this->subcategory_array))
				{
					if ($key == 0)
						$in_statement .= $value;
					else
						$in_statement .= ",".$value;
				}
				$in_statement .= ")";
				return $in_statement;
			}
			else
			{
				return false;
			}
		}
		else
		{
			//category_id is missing
			return false;
		}		
		
	} //end of get_sql_in_statement
	
//##################################################################################


} //end of class Auction_browse

?>