<? //auction_bid_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/

class Auction_bid {

	var $messages = array();
	var $auctions_table = "geodesic_auctions";
	var $auctions_increments_table = "geodesic_auctions_increments";
	var $auctions_table = "geodesic_auctions";
	var $auctions_bids_table = "geodesic_auctions_bids";
	var $auctions_users_table = "geodesic_auctions_userdata";
	
	var $site_url = "http://www.geodesicsolutions.com/products/auctions/litedemo/auctions.php";

	//font tag information used throughout several parts of the site
	var $font_title_tag = "<font face=arial,helvetica size=3 color=#003333>";
	var $font_tag = "<font face=arial,helvetica size=2 color=#000000>";
	var $font_tag_light = "<font face=arial,helvetica size=2 color=#ffffff>";	
	
	//color backgrounds of the classified ad listing table
	var $background_color_light = "#eeeeee";
	var $background_color_dark = "#dddddd";
	
	var $webmaster_email = "geoauctions@geodesicsolutions.com";
	
	var $error_message = 0;

//###########################################################

	function Auction_bid()
	{
		 $this->messages[2300] = "Bid Placement Form";
		 $this->messages[2301] = "view sellers feedback history";
		 $this->messages[2302] = "Register";
		 $this->messages[2303] = "minimum bid";
		 $this->messages[2304] = "Quantity bidding on";
		 $this->messages[2305] = "Your bid amount";
		 $this->messages[2306] = "username:";
		 $this->messages[2307] = "password:";
		 $this->messages[2308] = "You must first login before you can make a bid on an item";
		 $this->messages[2309] = "username";
		 $this->messages[2310] = "password";
		 $this->messages[2311] = "login";
		 $this->messages[2312] = "Not enough data to make a bid";
		 $this->messages[2313] = "Internal error: Could not complete your bid";
		 $this->messages[2314] = "This auction is closed - you cannot make any more bids on it";
		 $this->messages[2315] = "Your bid must be greater than the minimum bid";
		 $this->messages[2316] = "There was an error trying to place your bid.";
		 $this->messages[2317] = "Hello ";
		 $this->messages[2318] = "Your bid has been received:";
		 $this->messages[2319] = "Title: ";
		 $this->messages[2320] = "Item: ";
		 $this->messages[2321] = "End Date: ";
		 $this->messages[2322] = "view the auction here: ";
		 $this->messages[2323] = "If you have received this message in error, Please disregard.";
		 $this->messages[2324] = "If you have any questions, please contact the webmaster at the address below.";
		 $this->messages[2325] = "your bid was received";
		 $this->messages[2326] = "From: ";
		 $this->messages[2327] = "Your bid was successful!";
		 $this->messages[2328] = "You are the new high bidder!";
		 $this->messages[2329] = "Not enough information to display the bidhistory.";
		 $this->messages[2330] = "This auction is closed.";
		 $this->messages[2331] = "This auction ended:";
		 $this->messages[2332] = "This auction ends:";
		 $this->messages[2333] = "A seller cannot bid on their own auction.";
		 $this->messages[2334] = "This auction does not exist.";
		 $this->messages[2335] = "Please increase your bid.";
		 $this->messages[2336] = "time of bid";
		 $this->messages[2337] = "bidder";
		 $this->messages[2338] = "You are already the high bidder";
		 
		 
	} //end of function Auction_bid

//###########################################################

	function prepare_bid($db,$bidder_id,$auction_id=0)
	{
		if (!$bidder_id)
		{
			$this->bid_login();
		}
		else
		{
			if ($auction_id)
			{
				$sql_query = "select * from ".$this->auctions_table." where id = ".$auction_id;
				$result = &$db->Execute($sql_query);
				if (!$result)
				{
					echo $sql_query." is the query<bR>\n";
					$this->error_message = $this->messages[2313];
					return false;
				}
				elseif ($result->RecordCount() == 1)
				{
					//need to check if auction is open
					//check if bid is greater than minimum bid
					$show = $result->FetchNextObject();
					//echo $show->CLOSED." is the closed key<Br>\n";
					if (!$show->CLOSED)
					{
						echo "<table border=0 cellpadding=3 cellspacing=1 align=center width=600>\n";
						echo "<tr>\n\t<td align=center>\n\t".$this->font_title_tag.$this->messages[2300]."\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td align=center>\n\t
							<A HREF=auctions.php?a=7&b=".$show->SELLER.">".$this->font_tag.$this->messages[2301]."</A> |
							<A HREF=register.php>".$this->font_tag.$this->messages[2302]."</A></td>\n</tr>\n";

						echo "<tr>\n\t<td align=center><B>".$this->font_title_tag.$show->TITLE."</B>\n\t</td>\n</tr>\n";
						if ($this->error_message)
							echo "<tr>\n\t<td align=center>".$this->font_tag.$this->error_message."\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td align=center>\n\t";

						echo "<form action=auctions.php?a=8&b=".$auction_id." method=post>\n\t";
						echo "<table cellspacing=0 cellpadding=0 border=0 bgcolor=#eeeeee>\n\t";
						echo "<tr>\n\t\t<td align=left>".$this->font_tag.$this->messages[2305]."
							<input type=text size=7 name=c VALUE=".$bid_amount.">";

						if ($show->HIGH_BID == 0)
						{
							$increment = $this->get_increment($db,$show->MINIMUM_BID);
							$next_bid = $show->MINIMUM_BID + $increment;
						}
						elseif ($show->HIGH_BID > $show->MINIMUM_BID)
						{
							$increment = $this->get_increment($db,$show->HIGH_BID);
							$next_bid = $show->HIGH_BID + $increment;				
						}
						else
						{
							$increment = $this->get_increment($db,$show->MINIMUM_BID);
							$next_bid = $show->MINIMUM_BID + $increment;				
						}

						echo " (".$this->messages[2303].": ".$next_bid.") \n\t\t</td>\n\t</tr>\n\t";
						if ($auction_type==2) 
						{
							echo "<tr>\n\t\t<td align=right>".$this->font_tag.$this->messages[2304].":\n\t\t</td>\n\t\t";
							echo "<td align=left>\n\t\t<input type=text size=3 name=b[quantity_bid] VALUE=".$quantity_bid.">\n\t\t</td>\n\t</tr>\n\t";
						}

						echo "</table>\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td align=center><input type=submit name=submit> <input type=reset></td>\n\t</tr>\n";
						echo "</table>\n";
					}
					else
					{
						//auction closed
						$this->error_message = $this->messages[2314];
						return false;
					}
				}
				else
				{
					//wrong count return
					$this->error_message = $this->messages[2313];
					return false;
				}
			}
			else
			{
				//no auction id
				$this->error_message = $this->messages[2312];
				return false;
			}
		}
		return true;
	} //end of function prepare_bid()
	
//###########################################################

	function bid_error()
	{
		//this->error_message is the class variable that will contain the error message
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[2316]."</td>\n</tr>\n";
		if ($this->error_message)
			echo "<tr>\n\t<td>".$this->font_tag.$this->error_message."</td>\n</tr>\n";
		echo "</table>\n";

	} //end of function bid_error

//###############################################################

	function get_increment($db,$bid=0)
	{
		$sql_query = "select increment from ".$this->auctions_increments_table." where low <= ".$bid." 
			and high >= ".$bid;
		$result = &$db->Execute($sql_query);
		
		if (!$result)
		{
			echo $sql_query." is the query<br>\n";
			return false;
		}
		elseif ($result->RecordCount() == 1)
		{
			$show = $result->FetchNExtObject();
			return $show->INCREMENT;
		}
		else
		{
			return false;
		}
	
	} //end of function get_increment
	
//###############################################################

	function mail_confirmation($db,$info,$user_id)
	{
		$sql_query = "select * from ".$this->auctions_table." where id = ".$info["auction_id"];
		$auction_result = &$db->Execute($sql_query);
		
		if (!$auction_result)
		{
			$this->error_message = $this->messages[2313];
			return false;			
		}
		else
		{

			$sql_query = "select * from ".$this->auctions_users_table." where id = ".$user_id;
			$user_result = &$db->Execute($sql_query);

			if (!$user_result)
			{
				$this->error_message = $this->messages[2313];
				return false;				
			}
			else
			{
				$show_auction = $auction_result->FetchNextObject();
				$show_user = $user_result->FetchNextObject();
				$mail_message = $this->messages[2317].$show_user->USERNAME.",\n\r";
				$mail_message .= $this->messages[2318]."\n\r";
				$mail_message .= $this->messages[2319].$show_auction->TITLE."\n\r";
				$mail_message .= $this->messages[2320].$show_auction->DESCRIPTION."\n\r";
				$mail_message .= $this->messages[2321].date("M d, Y H:i:s", $show_auction->ENDS)."\n\r";
				$mail_message .= $this->messages[2322].$this->site_url."?a=2&b=".$id."\n\n\r";
				$mail_message .= $this->messages[2323]."\n\r";
				$mail_message .= $this->messages[2324]."\n\r";
				$mail_message .= $this->webmaster_email;
				
				mail($show_user->EMAIL,$this->messages[2325],$mail_message,$this->messages[2326].$this->webmaster_email);			
				
				return true;
			}
		}

	} //end of function mail_confirmation
	
//###############################################################

	function display_successful_bid($db,$auction_id)
	{
		//display a message saying the bid was successful
		echo "<table cellpadding=5 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td>".$this->font_title_tag.$this->messages[2327]."</td>\n</tr>\n";
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2328]."</td>\n</tr>\n";
		
		echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2322]."
			<a href=auctions.php?a=2&b=".$auction_id.">$this->font_tag.auctions.php?a=2&b=".$auction_id."</td>\n</tr>\n";
		
		echo "</table>\n";	
		return true;
	
	} //end of function display_successful_bid
	
//###############################################################

	function bid_login()
	{
		//you must log in first to bid on an item
		echo "<form action=auctions.php?a=10 method=post>\n";
		echo "<table cellpadding=3 cellspacing=1 border=0 align=center width=600>\n";
		echo "<tr>\n\t<td colspan=3>\n\t".$this->font_title_tag.$this->messages[2308]."\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[2309]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=text name=b[username] size=15>\n\t</td>\n\t";
		echo "<td>&nbsp;";
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td align=right>".$this->font_tag.$this->messages[2310]."\n\t</td>\n\t";
		echo "<td>\n\t<input type=password name=b[password] size=15>\n\t</td>\n\t";
		echo "</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=2>\n\t<input type=submit name=submit value=\"".$this->messages[2311]."\">\n\t</td>\n</tr>\n";
		echo "</table>\n";
		echo "</form>\n";	
	
	} //end of function bid_login
	
//###############################################################

	function auction_exists ($db,$auction_id=0) 
	{
		if ($auction_id)
		{
			$sql_query = "select id from ".$this->auctions_table." where id = ".$auction_id;
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->error_message = $this->messages[2524];
				return false;				
			}
			elseif ($result->RecordCount() == 1)
			{
				return true;
			}
			else
			{
				$this->error_message = $this->messages[2524];
				return false;			
			}
		}    
		else
		{
			//no auction id to check
			$this->error_message = $this->messages[2524];
			return false;
		}
	 } //end of function auction_exists

//####################################################################################

	function bidhistory ($db,$auction_id=0) 
	{
		if ($auction_id)
		{
			$sql_query = "select * from ".$this->auctions_table." where id = ".$auction_id;
			$auction_result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->error_message = $this->messages[2524];
				return false;				
			}
			elseif ($auction_result->RecordCount() == 1)
			{
				$show_auction = $auction_result->FetchNextObject();			
			}
			else
			{
				$this->error_message = $this->messages[2524];
				return false;					
			}
		
			$sql_query = "select * from ".$this->auctions_bids_table." where id = ".$auction_id." order by time_of_bid desc";
			$result = &$db->Execute($sql_query);
			
			if (!$result)
			{
				$this->error_message = $this->messages[2524];
				return false;				
			}
			elseif ($result->RecordCount() > 0)
			{
				echo "<table cellpadding=2 cellspacing=1 border=0 align=center width=600>\n";
				echo "<tr>\n\t<td colspan=3>".$this->font_title_tag.$show_auction->TITLE."</font><br>".$this->font_tag.$show_auction->DESCRIPTION."<br>";
				if ($show_auction->CLOSED)
					echo $this->font_tag.$this->messages[2330]."<br>".$this->messages[2331];
				else
					echo $this->font_tag.$this->messages[2332];
				echo " ".$this->font_tag.date("M d - G:i",$show_auction->ENDS)."</td>\n</tr>\n";
				echo "<tr>\n\t<td>".$this->font_tag.$this->messages[2336]."</td>\n\t";
				echo "<td>".$this->font_tag.$this->messages[2305]."</td>\n\t";
				echo "<td>".$this->font_tag.$this->messages[2337]."</td>\n</tr>\n";
				while ($show_bid = $result->FetchNExtObject())
				{
					$sql_query = "select username,rate_sum,rate_num from ".$this->auctions_userdata_table." where
						id = ".$show_bid->BIDDER;
					$user_result = &$db->Execute($sql_query);
					if (!$user_result)
					{
						$this->error_message = $this->messages[2524];
						return false;						
					}
					else
					{
						if ($user_result->RecordCount() == 1)
						{
							$show_user = $user_result->FetchNExtObject();
							echo "<tr>\n\t<td>".$this->font_tag.date("M d - G:i",$show_bids->TIME_OF_BID)."</td>\n\t";
							echo "<td>".$this->font_tag.$show_bid->BID."</td>\n\t";
							echo "<td>".$this->font_tag.$show_user->USERNAME." 
								(".$show_user->RATE_SUM/$show_user->RATE_NUM.")</td>\n</tr>\n";							
						}
						else
						{
							//the user could not be found
							//do not display the bid
						}
					}
				} //end of while
				echo "</table>\n";
				return true;
			}
			else
			{
				//no bids yet for this auction
				//display the message
				return true;			
			}
		}    
		else
		{
			//no auction id to check
			$this->error_message = $this->messages[2524];
			return false;
		}
	 } //end of function bidhistory

//####################################################################################

	function process_bid($db,$auction_id=0,$bidder=0,$bid_amount=0)
	{
		if ($auction_id)
		{
			if ($bidder)
			{
				if ($bid_amount)
				{
					//check to if bid_amount is above or = to the minimum bid
					$sql_query = "select * from ".$this->auctions_table." where id = ".$auction_id;
					//echo $sql_query." is the query<br>\n";
					$result = &$db->Execute($sql_query);
					if (!$result)
					{
						//echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[2313];
						return false;
					}
					elseif ($result->RecordCount() == 1)
					{
						$show = $result->FetchNextObject();
						//echo $show->SELLER." is the seller id<br>\n";
						//echo $bidder." is the bidder id<Br>\n";
						if ($show->SELLER == $bidder)
						{
							$this->error_message = $this->messages[2333];
							return false;
						}
						else
						{
							if (!$show->CLOSED)
							{
								//see if this person is the high bidder
								$sql_query = "select * from ".$this->auctions_bids_table." where auction = ".$auction_id."
									order by bid desc";
								$high_bidder_test_result = &$db->Execute($sql_query);
								if (!$high_bidder_test_result)
								{
									//echo $sql_query." is the query<br>\n";
									$this->error_message = $this->messages[2313];
									return false;
								}
								elseif ($high_bidder_test_result->RecordCount() > 0)
								{
									$show_high_bidder_test = $high_bidder_test_result->FetchNextObject();
									if ($show_high_bidder_test->BIDDER == $bidder)
									{
										$this->error_message = $this->messages[2338];
										return false;									
									}
								}
							
								if ($show->HIGH_BID == 0)
								{
									$increment = $this->get_increment($db,$show->MINIMUM_BID);
									$next_bid = $show->MINIMUM_BID + $increment;
								}
								elseif ($show->HIGH_BID > $show->MINIMUM_BID)
								{
									$increment = $this->get_increment($db,$show->HIGH_BID);
									$next_bid = $show->HIGH_BID + $increment;				
								}
								else
								{
									$increment = $this->get_increment($db,$show->MINIMUM_BID);
									$next_bid = $show->MINIMUM_BID + $increment;				
								}

								//echo $increment." is the increment to add to the minimum<br>\n";

								if ($bid_amount >= $next_bid)
								{
									$sql_query = "UPDATE ".$this->auctions_table." SET high_bid = \"".$bid_amount."\" WHERE id = \"".$auction_id."\"";
									$result = &$db->Execute($sql_query);
									if (!$result)
									{
										$this->error_message = $this->messages[2313];
										return false;
									}

									//echo $sql_query." is the query<br>\n";
									$time = time();
									$sql_query = "INSERT INTO ".$this->auctions_bids_table." VALUES (\"".$auction_id."\",\"". $bidder."\", \"".$bid_amount."\",\"".$time."\", 1)";
									$result = &$db->Execute($sql_query);
									if (!$result)
									{
										//back out mimimum bid
										$sql_query = "UPDATE ".$this->auctions_table." SET high_bid = \"".$show->MINIMUM_BID."\" WHERE id = \"".$auction_id."\"";
										$result = &$db->Execute($sql_query);
										if (!$result)
										{
											$this->error_message = $this->messages[2313];
											return false;
										}								

										$this->error_message = $this->messages[2313];
										return false;
									}		
									return true;
								}
								else
								{
									$this->error_message = $this->messages[2335];
									return false;											
								}

							}
							else
							{
								//auction closed
								$this->error_message = $this->messages[2314];
								return false;
							}				
						}
					}
					else
					{
						$this->error_message = $this->messages[2334];
						return false;
					}
				}
				else
				{
					//no bid information
					$this->error_message = $this->messages[2335];
					return false;				
				}				
			}
			else
			{
				//no bidder information
				//internal error
				$this->error_message = $this->messages[2313];
				return false;			
			}
		}
		else
		{
			//the auction id is missing
			$this->error_message = $this->messages[2313];
			return false;
		}
	
	} //end of function process_bid
	
//####################################################################################

} //end of class Auction_bid

?>
