<? //auctions.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctions @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoauctions@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/


include("config.php");
include("classes/adodb.inc.php");
include("classes/authenticate_class.php");
include("classes/auction_sell_class.php");

session_start();

$db = &ADONewConnection('mysql');

if (!$db->PConnect($db_host, $db_username, $db_password, $database))
{
	echo "could not connect to database";
	exit;
}

if (!session_is_registered("auth_auctions_103")) 
{
	$auth_auctions_103 = new Auth();
	session_register("auth_auctions_103");
}
//echo $auth_auctions_103->auction_user_id." is it<br>\n";
switch ($a) {

	case "1":
		//sell an auction item first step
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			if (!session_is_registered("sell_auction")) 
			{
				$sell_auction = new Auction_sell($auth_auctions_103->auction_user_id);
				session_register("sell_auction");
			}
			
			if (!$sell_auction->terminal_category)
			{
				if (($b) && ($c == "terminal"))
				{
					if ($sell_auction->set_terminal_category(&$db,$b))
						$sell_auction->display_auction_detail_form($db);
					else
						$sell_auction->sell_error();				
				}
				elseif ($b)
				{
					if (!$sell_auction->choose_category(&$db,$b))
						$sell_auction->sell_error();				
				}
				else
				{
					if (!$sell_auction->choose_category(&$db))
						$sell_auction->sell_error();
				}
			}
			elseif (!$sell_auction->auction_details_collected)
			{
				//echo $sell_auction->auction_details_collected." is the auction details collected<br>\n";
				//echo "in the auction details section<br>\n";
				//echo $HTTP_POST_FILES["c"]["tmp_name"]." is the tmp file name<br>\n";
				//echo $HTTP_POST_FILES["c"]["name"]." is the file name<br>\n";
				//echo $c." is the file<br>\n";
				if (($b) && (is_array($b)))
				{
					//echo "checking auction details<br>\n";
					$sell_auction->get_sell_form_variables($b);
					if ($sell_auction->auction_detail_check())
					{
						if (is_uploaded_file($c))
						{
							//echo $HTTP_POST_FILES["c"]["type"]." is the uploaded file type<br>";
							//upload the auction image
							$image_type = $HTTP_POST_FILES["c"]["type"];
							$image_size = $HTTP_POST_FILES["c"]["size"];
							$sell_auction->upload_the_auction_image($c,$image_type,$image_size);
						}
						$sell_auction->auction_approval_display($db);
					}
					else
						$sell_auction->display_auction_detail_form($db);	
				}
				else
				{
					//detail form has not been submitted yet
					$sell_auction->display_auction_detail_form($db);
				}

			}
			elseif (!$sell_auction->auction_approved)
			{
				//echo "in the auction approved section<br>\n";
				if ($b)
				{
					if ($b == "accepted")
					{
						if ($sell_auction->insert_auction($db))
							$sell_auction->sell_success();
						else
						{
							$sell_auction->auction_approval_display($db);
						}
					}
					elseif ($b == "edit_details")
					{
						$sell_auction->auction_details_collected = 0;
						$sell_auction->display_auction_detail_form($db);	
					}
					elseif ($b == "edit_category")
					{
						$sell_auction->terminal_category = 0;
						$sell_auction->choose_category($db);								
					}
					else
					{
						$sell_auction->auction_approval_display($db);
					}
				}
				else
				{
					$sell_auction->auction_approval_display($db);
				}			
			}
			else
				$sell_auction->choose_category($db);			
  		}
  		else
  		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case "2":
		//display an auction
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$browse = new Auction_browse($auth_auctions_103);
		$browse->auction_close($db);
		if ($b)
		{
			if ($browse->auction_exists($db,$b))
			{
				if (!$browse->display_auction($db,$b))
					$browse->browse_error();			
			}
			else
			{
				$browse->browse_error();
			}
		}
		else
		{
			//display the home page
			if (!$browse->browse($db))
				$browse->browse_error();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case "3":
		//display an auctions bid history
		//b contains id
		include("auctionheader.htm");
		include("classes/auction_bid_class.php");
		$bid = new Auction_bid();
		if ($b)
		{
			if ($bid->auction_exists($db,$b))
			{
				if (!$bid->bidhistory($db,$b))
					$bid->bid_error();			
			}
			else
			{
				$bid->bid_error();
			}
		}
		else
		{
			$bid->error_message = $bid->messages[2329];
			$bid->bid_error();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case "4":
		//display this user profile
		//b is user id
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			if (!$auth_auctions_103->edit_user_form($db))
				$auth_auctions_103->auth_error();
		}
		else
		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case "5":
		//display a category
		//b will contain the category id
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$auction_browse = new Auction_browse($auth_auctions_103);
		$auction_browse->auction_close($db);
		if ($b)
		{
			if (!$auction_browse->browse($db,$b,$c))
				$auction_browse->browse_error();
		}
		else
		{
			if (!$auction_browse->main($db))
				$auction_browse->browse_error();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case "7":
		//display this user feedback
		//b is user id
		include("auctionheader.htm");
		include("classes/auction_feedback_class.php");
		$feedback = new Auction_feedback();
		if ($b)
		{
			if (!$feedback->feedback_about_user($db,$b))
			{
				$feedback->error_message = $feedback->messages[2729];
				$feedback->feedback_error();
			}
		}
		else
		{
			$feedback->error_message = $feedback->messages[2729];
			$feedback->feedback_error();		
		}
		
		include("auctionfooter.htm");
		exit;
		break;

	case 8:
		//process a bid
		//sellers_id is b
		include("classes/auction_browse_class.php");
		$auction_browse = new Auction_browse($auth_auctions_103);
		$auction_browse->auction_close($db);
		include("auctionheader.htm");
		if (!$auth_auctions_103->auction_user_id)
		{
			$auth_auctions_103->auth_messages["login"] = $auth_auctions_103->messages[832];
			$auth_auctions_103->login_form();
		}
		else
		{
			include("classes/auction_bid_class.php");
			$bid = new Auction_bid();
			if (($b) && ($c))
			{
				if (!$bid->process_bid($db,$b,$auth_auctions_103->auction_user_id,$c))
				{
					$bid->bid_error();
				}
				else
				{
					//successful bid
					if (!$bid->display_successful_bid($db,$b))
					{
						$bid->bid_error();
					}
					else
					{
						if (!$bid->mail_confirmation($db,$b,$auth_auctions_103->auction_user_id))
							$bid->bid_error();
					}
				}			
			}
			elseif ($b)
			{
				if (!$bid->prepare_bid($db,$auth_auctions_103->auction_user_id,$b))
				{
					$bid->bid_error();
				}
			}
			else
			{
				$bid->error_message = $bid->messages[2312];
				$bid->bid_error();
			}
		}
		include("auctionfooter.htm");
		exit;
		break;		
		
	case 9:
		//bid form
		include("classes/auction_browse_class.php");
		$auction_browse = new Auction_browse($auth_auctions_103);
		$auction_browse->auction_close($db);
		include("auctionheader.htm");
		if (!$auth_auctions_103->auction_user_id)
		{
			$auth_auctions_103->auth_messages["login"] = $auth_auctions_103->messages[832];
			$auth_auctions_103->login_form();
		}
		else
		{
			include("classes/auction_bid_class.php");
			$bid = new Auction_bid();
			if ($b)
			{
				if (!$bid->prepare_bid($db,$auth_auctions_103->auction_user_id,$b))
				{
					$bid->bid_error();
				}
			}
			else
			{
				$bid->error_message = $bid->messages[2312];
				$bid->bid_error();
			}
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 10:
		//login
		include("auctionheader.htm");
		if (!$auth_auctions_103->auction_user_id)
		{
			if (($b[username]) && ($b[password]))
			{
				if ($auth_auctions_103->login($db,$b[username],$b[password]))
				{
					include("classes/auction_browse_class.php");
					$auctions_browse = new Auction_browse($auth_auctions_103);
					$auctions_browse->main($db);
				}
				else
				{
					$auth_auctions_103->login_form($b[username], $b[password]);
				}

			}
			else
			{
				$auth_auctions_103->login_form();
			}
		}
		else
		{
			$auth_auctions_103->already_logged_in();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 11:
		//update user data
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			if ($b)
			{
				if ($auth_auctions_103->update_user($db,$b))
				{
					if (!$auth_auctions_103->edit_user_form($db))
						$auth_auctions_103->auth_error();
				}
				else
				{
					$auth_auctions_103->login_form();	
				}
			}
			else
			{
				$auth_auctions_103->login_form();
			}
		}
		else
		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;
		
	case 12:
		//feedback home
		include("classes/auction_feedback_class.php");
		$feedback = new Auction_feedback();
		include("auctionheader.htm");
	    	$feedback->feedback_home();
		include("auctionfooter.htm");
		break;
		
	case 13:
		//view feedback about current user
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			include("classes/auction_feedback_class.php");
			$feedback = new Auction_feedback();
			if (!$feedback->feedback_about_user($db,$auth_auctions_103->auction_user_id))
				$feedback->feedback_error();
		}
		else
		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;
		
	case 14:
		//view auctions you can leave feedback for
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			include("classes/auction_feedback_class.php");
			$feedback = new Auction_feedback();
			if (!$feedback->list_open_feedback($db,$auth_auctions_103->auction_user_id))
				$feedback->feedback_error();
		}
		else
		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;
		
	case 15:
		//leave feedback for this auction
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			include("classes/auction_feedback_class.php");
			$feedback = new Auction_feedback();
			if ($b)
			{
				if ($c)
				{
					if ($feedback->check_feedback(&$db,$b,$auth_auctions_103->auction_user_id,$c))
					{
						if ($feedback->save_feedback(&$db,$b,$auth_auctions_103->auction_user_id,$c))
							$feedback->feedback_thank_you();
						else
						{
							echo "error save feedback<br>\n";
							if (!$feedback->leave_feedback(&$db,$auth_auctions_103->auction_user_id,$b))
								$feedback->feedback_error();	
						}
					}
					else
					{
						echo "error check feedback<br>\n";
						if (!$feedback->leave_feedback(&$db,$auth_auctions_103->auction_user_id,$b))
							$feedback->feedback_error();					
					}
				}
				else
				{
					if (!$feedback->leave_feedback(&$db,$auth_auctions_103->auction_user_id,$b))
						$feedback->feedback_error();
				}
			}
			else
			{
				if (!$feedback->feedback_home($auth_auctions_103->auction_user_id))
					$feedback->feedback_error();			
			}
			
		}
		else
		{
			$auth_auctions_103->login_form();	
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 16:
		//save feedback for this auction
		include("auctionheader.htm");
		if ($auth_auctions_103->auction_user_id)
		{
			include("classes/auction_feedback_class.php");
			$feedback = new Auction_feedback();
			if (!$feedback->feedback_home($auth_auctions_103->auction_user_id))
				$feedback->feedback_error();
		}
		else
		{
			$auth_auctions_103->login_form();
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 17:
		//log this user out
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$auctions_browse = new Auction_browse($auth_auctions_103);
		if ($auth_auctions_103->auction_user_id)
		{
			session_destroy();
			$auctions_browse->main($db);
		}
		else
		{
			$auctions_browse->main($db);
		}
		include("auctionfooter.htm");
		exit;
		break;
		
	case 18:
		//lost password
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$browse = new Auction_browse($auth_auctions_103);
		if (!$auth_auctions_103->user_id)
		{
			if ($b)
			{
				if (!$auth_auctions_103->lostpassword(&$db,$b[email]))
					$auth_auctions_103->auth_error();
				else
					$browse->main($db);	
			}
			else
			{
				//show the lost password form
				$auth_auctions_103->lostpassword_form();
			}
		}
		else
		{
			//show the change password form
			if ($b)
			{
				if (!$auth_auctions_103->change_password (&$db,$b))
				{
					if ($auth_auctions_103->error_message)
					{	
						$auth_auctions_103->auth_error();
					}
					else
					{
						if ($auth_auctions_103->change_password_form())
							$auth_auctions_103->auth_error();
					}
				}
				else
				{
					$browse->main($db);	
				}
			}
			else
			{
				if (!$auth_auctions_103->change_password_form())
					$auth_auctions_103->auth_error();
			}
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 97:
		//end this sell process
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$browse = new Auction_browse($auth_auctions_103);
		if ($auth_auctions_103->auction_user_id)
		{
			session_unregister("sell_auction");
			unset ($sell_auction);
			$browse->main($db);
		}
		else
		{
			$browse->main($db);
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 98:
		//this is the admin
		//trying to delete a auction
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$browse = new Auction_browse($auth_auctions_103);
		if ($auth_auctions_103->level == 1)
		{
			if ($b)
			{
				if ($browse->admin_delete_auction($db,$b))
				{
					if (!$browse->browse($db,$c))
						$browse->browse_error();
				}
				else
				{
					$browse->browse_error();
				}					
			}
			else
			{
				$browse->main($db);
			}
		}
		else
		{
			$browse->main($db);
		}
		include("auctionfooter.htm");
		exit;
		break;

	case 99:
		//force close for testing
		include("auctionheader.htm");
		include("classes/auction_browse_class.php");
		$auctions_browse = new Auction_browse($auth_auctions_103);
		$auctions_browse->auction_force_close($db);
		include("auctionfooter.htm");
		exit;
		break;

	default:
	{
		include("classes/auction_browse_class.php");
		$auctions_browse = new Auction_browse($auth_auctions_103);
		include("auctionheader.htm");
		$auctions_browse->main($db);
		include("auctionfooter.htm");
		exit;
	}


} //end of switch ($a)
?>