<?//admin_categories_class.php

/**************************************************************************\
Copyright (c) 2002 Geodesic Solutions, LLC
GeoAuctons @version V1.02 July 17, 2002
All rights reserved
http://www.geodesicsolutions.com
This file written by 
James Park
IT Project Manager
<geoclassifieds@geodesicsolutions.com>

Released under BSD Style with conditions below
==============================
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this list of conditions and the 
following disclaimer. 
Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the 
following disclaimer in the documentation and/or other materials provided with the distribution. 
Neither the name of the James Park nor Geodesic Solutions may be used to endorse or promote
products derived from this software without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

==========================================================

 \**************************************************************************/

class Admin_categories {

	var $categories_table = "geodesic_auctions_categories";
	var $classifieds_table = "geodesic_auctions";
	var $current_category;
	var $category_tree_array = array();
	
	var $messages = array();
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function Admin_categories ()
	{
		$this->messages[3500] = "Not enough information to display the category";
		$this->messages[3501] = "Internal browse error!";
		$this->messages[3502] = "no category id";
		$this->messages[3503] = "cannot update the main category";
		$this->messages[3504] = "category tree";
		$this->messages[3505] = "subcategories of ";
		$this->messages[3506] = "There are no subcategories";
		$this->messages[3507] = "subcategories exist";
		$this->messages[3508] = "click to delete";
		$this->messages[3509] = "cannot delete the main category";
		$this->messages[3510] = "There was an error processing your request";
	} //end of function Admin_categories
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_category_form ($db,$category=0,$type=0)
	{
		if ($category)
		{
			//edit this category after getting current info
			$sql_query = "select * from ".$this->categories_table." where category_id = ".$category;
			$result = &$db->Execute($sql_query);
			 if (!$result)
			 {
				////echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3501];
				return false;
			 }
			 elseif ($result->RecordCount() == 1)
			 {
			 	$show_category = $result->FetchNextObject();
			 }
			 else
			 {
			 	return false;
			 }
			
			if (!$type)
			{
				//edit
				echo "<form action=index.php?a=6&c=".$category." method=post>\n";
				echo "<table cellpadding=3 cellspacing=1 border=0>\n";

				echo "<tr>\n\t<td>\n\tcategory name\n\t</td>\n\t";
				echo "<td>\n\t<input type=text name=b[category_name] value=\"".$show_category->CATEGORY_NAME."\">\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td>\n\tcategory description\n\t</td>\n\t";
				echo "<td>\n\t<textarea name=b[description]>".$show_category->DESCRIPTION."</textarea>\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td>\n\tcategory order\n\t</td>\n\t";
				echo "<td>\n\t<select name=b[display_order]>\n\t\t";
				
				//get the number of subcategories to this category
				$sql_query = "select * from ".$this->categories_table." where parent_id = ".$category;
				$count_result = &$db->Execute($sql_query);
				 if (!$count_result)
				 {
					////echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[3501];
					return false;
				 }
				$num_subs =$count_result->RecordCount();
					
				for ($i=1;$i<50;$i++)
				{
					echo "<option ";
					if ($i == ($num_subs + 1))
						echo "selected";
					echo ">".$i."</option>\n\t\t";
				}
				echo "</select>\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td colspan=2><input type=submit></td>\n</tr>\n";

				echo "</table>\n</form>\n";
			}
			else
			{
				//add
				echo "<form action=index.php?a=2&c=".$category." method=post>\n";
				echo "<table cellpadding=3 cellspacing=1 border=0>\n";
				echo "<tr>\n\t<td colspan=2>\n\tInsert a subcategory to 
					the ".$show_category->CATEGORY_NAME." category\n\t</td>\n\t";

				echo "<tr>\n\t<td>\n\tcategory name\n\t</td>\n\t";
				echo "<td>\n\t<input type=text name=b[category_name]>\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td>\n\tcategory description\n\t</td>\n\t";
				echo "<td>\n\t<textarea name=b[description]></textarea>\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td>\n\tcategory order\n\t</td>\n\t";
				echo "<td>\n\t<select name=b[display_order]>\n\t\t";
				for ($i=1;$i<50;$i++)
				{
					echo "<option ";
					if ($i == $show_category->DISPLAY_ORDER)
						echo "selected";
					echo ">".$i."</option>\n\t\t";
				}
				echo "</select>\n\t</td>\n</tr>\n";

				echo "<tr>\n\t<td colspan=2><input type=submit></td>\n</tr>\n";

				echo "</table>\n</form>\n";				
			}
		}
		else
		{
			//this is the main category
			//you can only add a category to the main category
			//there is no edit of the main category
			echo "<form action=index.php?a=2&c=0 method=post>\n";
			echo "<table cellpadding=3 cellspacing=1 border=0>\n";
			echo "<tr>\n\t<td colspan=2>\n\tInsert a subcategory to 
				the Main category\n\t</td>\n\t";

			echo "<tr>\n\t<td>\n\tcategory name\n\t</td>\n\t";
			echo "<td>\n\t<input type=text name=b[category_name]>\n\t</td>\n</tr>\n";

			echo "<tr>\n\t<td>\n\tcategory description\n\t</td>\n\t";
			echo "<td>\n\t<textarea name=b[description]></textarea>\n\t</td>\n</tr>\n";

			echo "<tr>\n\t<td>\n\tcategory order\n\t</td>\n\t";
			echo "<td>\n\t<select name=b[display_order]>\n\t\t";
			for ($i=1;$i<50;$i++)
			{
				echo "<option ";
				if ($i == $show_category->DISPLAY_ORDER)
					echo "selected";
				echo ">".$i."</option>\n\t\t";
			}
			echo "</select>\n\t</td>\n</tr>\n";
			echo "<tr>\n\t<td colspan=2><input type=submit></td>\n</tr>\n";
			echo "</table>\n</form>\n";	
		}
		return true;

	} //end of function display_category_form

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function insert_category($db,$info,$parent_category=0)
	{
		$sql_query = "insert into ".$this->categories_table." 
			(parent_id,category_name,description,display_order)
			values
			(".$parent_category.",\"".$info["category_name"]."\",\"".$info["description"]."\",".$info["display_order"].")";
		$result = &$db->Execute($sql_query);
		if (!$result)
		{
			//echo $sql_query." is the query<br>\n";
			$this->error_message = $this->messages[3500];
			return false;
		}
		$category_id = $db->Insert_ID();
		return $category_id;
	
	} // end of function insert_category

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_category_check($db,$category=0)
	{
		if ($category)
		{
			$sql_query = "select * from ".$this->categories_table." where category_id = ".$category;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3500];
				return false;
			}
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNextObject();
				if ($show->PARENT_ID != 0)
				{
					$sql_query = "select * from ".$this->categories_table." where category_id = ".$show->PARENT_ID;
					$result = &$db->Execute($sql_query);
					if (!$result)
					{
						echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[3500];
						return false;
					}
					elseif ($result->RecordCount() == 1)
					{
						$show_parent = $result->FetchNextObject();

						echo "<table cellpadding=2>\n<tr>\n\t<td>Are you sure you want to 
							delete the ".$show->CATEGORY_NAME." category.  If so choose whether you want 
							to move the existing classified ads in this category to the category above (".
							$show_parent->CATEGORY_NAME.") or delete them along with the category.
							\n\t</td>\n</tr>\n";	
						echo "<tr>\n\t<td><a href=index.php?a=4&b=".$category."&c=move>
							Move the classified ads in this category to the ".
							$show_parent->CATEGORY_NAME." category above.</a>\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td>--OR--\n\t</td>\n</tr>\n";
						echo "<tr>\n\t<td><a href=index.php?a=4&b=".$category."&c=delete>
							Delete the classified ads in this category along with the category
							.</a>\n\t</td>\n</tr>\n";
					}
					else
					{
						echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[3500];
						return false;
					}				
				}
				else
				{
					//the parent of this category is the main category
					//the main category only has category no ads in it
					echo "<table cellpadding=2>\n<tr>\n\t<td>Are you sure you want to 
						delete the ".$show->CATEGORY_NAME." category.  The parent category 
						to this category is the main category.  If you choose to delete this 
						category all of the classified ads within will be deleted also.
						\n\t</td>\n</tr>\n";	
					echo "<tr>\n\t<td><a href=index.php?a=4&b=".$category."&c=delete>
						Delete the classified ads in this category along with the category
						.</a>\n\t</td>\n</tr>\n";				
				}
			}
			else
			{			
				echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3500];
				return false;
			}		
		}
		else
		{
			$this->error_message = $this->messages[3509];
			return false;
		}
	} // end of function delete_category_check
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function delete_category($db,$category=0,$type_of_delete=0)
	{
		if ($category)
		{
			if ($type_of_delete)
			{
				switch ($type_of_delete)
				{
					case "move":
						$sql_query = "select parent_id from ".$this->categories_table." 
							where category_id = ".$category;
						$result = &$db->Execute($sql_query);
						//echo $sql_query." is the query<br>\n";
						if (!$result)
						{
							//echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[3500];
							return false;
						}
						elseif ($result->RecordCount() == 1)
						{
							$show_parent = $result->FetchNExtObject();
							$sql_query = "update ".$this->classifieds_table." 
								set category = ".$show_parent->PARENT_ID." where category = ".$category;
							$update_result = &$db->Execute($sql_query);
							//echo $sql_query." is the query<br>\n";
							if (!$update_result)
							{
								//echo $sql_query." is the query<br>\n";
								$this->error_message = $this->messages[3500];
								return false;
							}	
						}
						else
						{
							//echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[3500];
							return false;
						}
						break;
					case "delete":
						$sql_query = "delete from ".$this->classifieds_table." 
							where category = ".$category;
						$delete_ad_result = &$db->Execute($sql_query);
						//echo $sql_query." is the query<br>\n";
						if (!$delete_ad_result)
						{
							//echo $sql_query." is the query<br>\n";
							$this->error_message = $this->messages[3500];
							return false;
						}
						break;
					default:
						//do nothing

				} //end of switch
				$sql_query = "delete from ".$this->categories_table." 
					where category_id = ".$category;
				$delete_category_result = &$db->Execute($sql_query);
				//echo $sql_query." is the query<br>\n";
				if (!$delete_category_result)
				{
					//echo $sql_query." is the query<br>\n";
					$this->error_message = $this->messages[3500];
					return false;
				}
			}
			else
			{
				$this->error_message = $this->messages[3500];
				return false;				
			}
			return true;
		}
		else
		{
			$this->error_message = $this->messages[3509];
			return false;
		}
	} // end of function delete_category	
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function update_category($db,$info,$category=0)
	{
		if ($category)
		{
			$sql_query = "update ".$this->categories_table." set
				category_name = \"".$info["category_name"]."\",
				description = \"".$info["description"]."\",
				display_order = ".$info["display_order"]."
				where category_id = ".$category;
			$result = &$db->Execute($sql_query);
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3500];
				return false;
			}
			return true;
		}
		else
		{
			$this->error_message = $this->messages[3503];
			return false;
		}
	} // end of function update_category

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function home ()
	{
		echo "<table align=center width=600>\n";
		echo "<tr>\n\t<td><a href=index.php?a=7>browse and edit categories</a>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td>To delete an individual classified ad browse the classifieds as you normally would while logged in
		as admin.  Next to the classified in the category listing will appear a delete choice.  Click that link to delete that
		classified ad.<br><a href=../auctions.php>click to browse as admin and delete auctions</a>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td><a href=index.php?a=50>edit admin login</a>\n\t</td>\n</tr>\n";
		echo "</table>\n";
	} //end of function home
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function get_category_tree($db,$category)
	{
		$i = 0;
		$category_next = $category;
		do
		{
			$sql_query = "select category_id,parent_id,category_name from ".$this->categories_table." 
				where category_id = ".$category_next;
			$category_result =  &$db->Execute($sql_query);
			
			//$category = array();
			
			////echo $sql_query." is the query<br>\n";
			if (!$category_result)
			{
				////echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3501];
				return false;
			}
			elseif ($category_result->RecordCount() == 1)
			{
				$show_category = $category_result->FetchNextObject();
				//echo $i." is i before increment in get_category_tree<br>\n";
				//$category[$i] = array("parent_id"=>$show_category->PARENT_ID,"category_name"=>$show_category->CATEGORY_NAME,"category_id"=>$show_category->CATEGORY_ID);
				$this->category_tree_array[$i]["parent_id"]  = $show_category->PARENT_ID;
				$this->category_tree_array[$i]["category_name"] = $show_category->CATEGORY_NAME;
				$this->category_tree_array[$i]["category_id"]   = $show_category->CATEGORY_ID;
				//echo $this->category_tree_array[$i]["category_id"]." is the category id<br>\n";
				$i++;
				$category_next = $show_category->PARENT_ID;
			}
			else
			{
				echo "wrong return<Br>\n";
				return false;
			}

     		} while ( $show_category->PARENT_ID != 0 );
     		
     		return true;

	} // end of function get_category_tree($category)

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function display_current_category($db,$category=0) 
	{
		//echo $category." is category in the top of display_current_category<br>\n";
		echo "<table cellpadding=3 cellspacing=0 border=1>\n<tr>\n\t<td colspan=5>\n\t";
		$sql_query = "select * from ".$this->categories_table." where category_id = ".$category;
		$result = &$db->Execute($sql_query);
		 if (!$result)
		 {
			//echo $sql_query." is the query<br>\n";
			$this->error_message = $this->messages[3501];
			return false;
		 }
		 elseif ($result->RecordCount() == 1)
		 {
			$show_this_category = $result->FetchNextObject();

			 $sql_query = "select * from ".$this->categories_table." where parent_id = ".$category;
			 $subcategory_result = &$db->Execute($sql_query);
			 //echo $sql_query." is the query<br>\n";
			 if (!$subcategory_result)
			 {
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[3500];
				return false;
			 }

			 if ($category == 0) 
			 {
				//parent is main
				echo "categories under the main category";
			 }
			 else 
			 {
				echo "categories under the ".$show_this_category->CATEGORY_NAME." category --- #".$show_this_category->CATEGORY_ID;
			 }
			echo "</td>\n</tr>\n";
			echo "<tr>\n\t<td>category <br>click to enter</td>\n\t<td>description</td>\n\t<td>display order</td>\n\t<td>click to edit</td>\n\t<td>click to delete</td>\n</tr>\n";
			while ($show = $subcategory_result->FetchNextObject()) 
			{
				//show each subcategory
				echo "<tr>\n\t<td><a href=index.php?a=3&b=$show->CATEGORY_ID>".$show->CATEGORY_NAME."</a></td>\n\t";
				echo "<td>".$show->DESCRIPTION."&nbsp;</td>\n\t";
				echo "<td>".$show->DISPLAY_ORDER."</td>\n\t";
				echo "<td><a href=index.php?a=5&b=".$show->CATEGORY_ID.">edit</a></td>\n\t";
				echo "<td><a href=index.php?a=4&b=".$show->CATEGORY_ID.">delete</a></td>\n";
				echo "</tr>\n";
			}
				echo "</table>\n";
				echo "<br><br><a href=index.php?a=1&b=".$category.">add a sub category to this category</a>";
				echo "<br><br><a href=index.php?a=3&b=0>back to main category</a>";
		}
		else
		{
			//category does not exist
			$this->error_message = $this->messages[3500];
			return false;
		}
		return true;
	} //end of function display_current_category
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function browse($db,$category=0)
	{
		echo "<table cellpadding=2 cellspacing=1 border=0>\n";
		//browse the auctions in this category that are open

		if ($category)
		{
			$sql_query = "select * from ".$this->categories_table." where category_id = ".$category;
			$result = &$db->Execute($sql_query);
			////echo $sql_query." is the query<br>\n";
			if (!$result)
			{
				//echo $sql_query." is the query<br>\n";
				$this->error_message = $this->messages[5501];
				return false;
			}		
			elseif ($result->RecordCount() == 1)
			{
				$show = $result->FetchNextObject();
				$parent_id = $show->PARENT_ID;
				$category_name = $show->CATEGORY_NAME;
				$description = $show->DESCRIPTION;
			}
			else
			{
				//category does not exist
				$this->error_message = $this->messages["5500"];
				return false;
			}
		}
		else
		{
			$parent_id = 0;
			$category_name = "main";
			$description = "main category for all categories";
		}

		$sql_query = "select * from ".$this->categories_table." where parent_id = ".$category." order by display_order";
		$result = &$db->Execute($sql_query);
		////echo $sql_query." is the query<br>\n";
		if (!$result)
		{
			//echo $sql_query." is the query<br>\n";
			$this->error_message = $this->messages[5501];
			return false;
		}
		else
		{
			if ($category)
			{
				$category_tree = $this->get_category_tree($db,$category);
				reset ($this->category_tree_array);
				if ($category_tree)
				{

					//category tree
					echo "<tr>\n\t<td colspan=4>\n\t<b>";
					echo $this->messages[3504]." : </b> <a href=index.php?a=7>Main</a> >";
					if (is_array($this->category_tree_array))
					{
						$i = 0;
						//$categories = array_reverse($this->category_tree_array);
						$i = count($this->category_tree_array);
						while ($i > 0 ) 
						{
							//display all the categories
							$i--;
							if ($i == 0)
								echo "<b>".$this->category_tree_array[$i]["category_name"]."</b>";
							else
								echo "<a href=index.php?a=7&b=".$this->category_tree_array[$i]["category_id"].">".$this->category_tree_array[$i]["category_name"]."</a> > ";
						}
					}
					else
					{
						echo $category_tree;
					}
					echo "\n\t</td>\n</tr>\n";
				}
			}
			else
			{
				echo "<tr>\n\t<td colspan=4>\n\t<b>main category</b>\n\t</td>\n</tr>\n";
			}

			if ($result->RecordCount() > 0)
			{
				//echo $result->RecordCount()." is the record count<br>\n";
				//display the sub categories of this category
				echo "<tr>\n\t<td colspan=4>\n\t".$this->messages[3505]." ".$category_name."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td>category name\n\t</td>\n\t";
				echo "<td>\n\tedit category\n\t</td>\n\t";
				echo "<td>\n\tdelete category\n\t</td>\n\t";
				echo "<td>\n\tenter category\n\t</td>\n</tr>";
				while ($show_sub_categories = $result->FetchNextObject())
				{
					echo "<tr>\n\t<td>\n\t<a href=index.php?a=7&b=".$show_sub_categories->CATEGORY_ID.">".
						$show_sub_categories->CATEGORY_NAME."</a></td>\n\t";
					echo "<td align=center>\n\t<a href=index.php?a=5&b=".$show_sub_categories->CATEGORY_ID.">edit</a>\n\t</font>\n\t";
					$sql_query = "select * from ".$this->categories_table." where parent_id = ".$show_sub_categories->CATEGORY_ID;
					$subcategory_result = &$db->Execute($sql_query);
					////echo $sql_query." is the query<br>\n";
					if (!$subcategory_result)
					{
						//echo $sql_query." is the query<br>\n";
						$this->error_message = $this->messages[5501];
						return false;
					}					
					elseif ($subcategory_result->RecordCount() == 0)
					{
						echo "<td align=center>\n\t
							<a href=index.php?a=4&b=".$show_sub_categories->CATEGORY_ID.">".$this->messages[3508]."\n\t</td>\n";
						echo "<td align=center>---</td>\n\t";
					}
					else
					{
						//echo "<td>\n\t".$this->messages[3507]."\n\t</td>\n";
						echo "<td align=center>\n\t---\n\t</td>\n";
						echo "<td align=center><a href=index.php?a=7&b=".$category.">enter</a></td>\n\t";
					}
					
										
					echo "</tr>\n";
				}
			}
			else
			{
				//no sub categories to this category
				echo "<tr>\n\t<td colspan=4>\n\t".$this->messages[3505]." ".$category_name."\n\t</td>\n</tr>\n";
				echo "<tr>\n\t<td colspan=4>\n\t".$this->messages[3506]."\n\t</td>\n</tr>\n";
				
			}
		}
		echo "<tr>\n\t<td colspan=4>\n\t<a href=index.php?a=1&b=".$category.">
			add a subcategory to the ".$category_name." category</a>\n\t</td>\n</tr>\n";
		echo "<tr>\n\t<td colspan=4>\n\t<a href=index.php>admin home</a>\n\t</td>\n</tr>\n";
		echo "</table>\n";
		return true;
	} //end of function browse
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	function category_error()
	{
		echo "<table cellpadding=5 cellspacing=1 border=0>\n";
		echo "<tr>\n\t<td>".$this->messages[3510]."</td>\n</tr>\n";
		if ($this->error_message)
			echo "<tr>\n\t<td>".$this->error_messages."</td>\n</tr>\n";
		echo "</table>\n";
	} //end of function category_error
	
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

} // end of class Admin_categories

?>