<?php
/* 
   Gallery Thingie version 1.0 - Andreas Haugstrup Pedersen <andreas@solitude.dk> Ocotber 27th, 2003
   Comments, suggestions etc. are welcome and encouraged at the above e-mail.
   
   LICENSE INFORMATION:
   This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike License.
   To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/1.0/

   Changelog from version 0.9 to 1.0
    - Fixed the link in the 'categories' column to point to the right place.
    - Fixed extra <li> in displayList().
	- Added support for thumbnails.
	- Feature: displayRandomImage() shows a random image.
	- Feature: displayNextCategory() and displayNextCategory().
*/

/* Setup information. Change as appropriate. */

$username = "USERNAME"; // Your preferred username.
$password = "PASSWORD"; // Your preferred password.
$path = "images/"; /* This is the path to the folder with the images. */
$xmlfile = "gt-data.xml"; /* The path to the XML data file. */
$phpfile = "gallery.php"; /* The file used in links. */
$maxsize = 2000000; /* Max file size in bytes. */
$limit = 30; /* The limit when displaying descriptions in the administration. */
$allowedfiles = array("jpg", "gif", "png"); /* The types of images allowed for upload. */
$enableThumbnails = FALSE; /* TRUE is you want to enable thumbnails, FALSE if you don't. FALSE is default to save system resources. You can enable this at any time. */
$thumbnailwidth = 150; /* The width of the thumbnail in pixels or percent. Height will be calculated accordingly. */
$thumbnailquality = 100; /* Thumbnail quality. 100 is the highest, 0 is the lowest. Only applies to JPG images. */

/* End setup */

$self = basename($_SERVER["PHP_SELF"]);
function parseFile($xmlfile, $start, $end, $cdata) { /* This function parses the xml data file. */
	global $xml_parser;
	$xml_parser = xml_parser_create();
	xml_set_element_handler($xml_parser, $start, $end);
	xml_set_character_data_handler($xml_parser, $cdata);
	$fp = @fopen($xmlfile, "r") or die("Cannot locate XML data file: {$xmlfile}");
	while ($data = fread($fp, filesize($xmlfile))) {
		if (!xml_parse($xml_parser, $data, feof($fp))) {
		    die(sprintf("XML error: %s at line %d",	xml_error_string(xml_get_error_code($xml_parser)), xml_get_current_line_number($xml_parser)));
	    }
	}
	xml_parser_free($xml_parser);
}
function startImages($parser, $name, $a) { /* This function is executed everytime an xml start tag is met. */
	global $currentTag, $imgId, $cId;
	$currentTag = strtolower($name);
	if ($currentTag == "image") {
		$imgId = $a["ID"];
	} elseif ($currentTag == "category") {
		$cId = $a["CID"];
	}
}
function imgData($parser, $data) { /* This function is executed on all xml content. */
	global $currentTag, $imgId, $name, $title, $description, $cat, $categories, $cId;
	switch($currentTag) {
		case "file" :
			$name[$imgId] = $data;
			break;
		case "title" :
			$title[$imgId] = $data;
			break;
		case "description" :
			$description[$imgId] = $data;
			break;
		case "imgcategory" :
			$cat[$imgId] = $data;
			break;
		case "category" :
			$categories[$cId] = $data;
			break;
		default :
			break;
	}
}
function endElement($parser, $name) { /* This function is executed everytime an xml end tag is met. */
	global $currentTag, $status;
	$currentTag = "";
}
function isIncluded() {
	global $self;
	$includedFiles = get_included_files();
	if (count($includedFiles) > 1) {
		UnSet($includedFiles[0]);
		foreach($includedFiles as $file) {
			$temp[] = basename($file);
		}
		if (!in_array($self, $temp)) {
			return TRUE;
		}
	} else {
		return FALSE;
	}
}
// The XML file is parsed and the content is put into arrays so we can access it easily later.
parseFile($xmlfile, "startImages", "endElement", "imgData");

if (isIncluded() == TRUE) { // If this file is not being included get the public gallery functions.
	// If no ID is specified in the URL we set the ID to 0 in order to show the first image.
	if (!IsSet($_GET["id"]) || $_GET["id"] == "") {
		$id = 0;
	} else {
		$id = $_GET["id"];
	}
	// If no category is set in the URL we unset the $category variable.
	if (!IsSet($_GET["category"]) || $_GET["category"] == "") {
		UnSet($category);
	} else {
		$category = $_GET["category"];
		if ($category != $cat[$id]) {
			for($i=0;$i<count($name);$i++) {
				if ($category == $cat[$i]) {
					$id = $i;
					break;
				}
			}
		}
	}
	function displayTitle($id) {
		global $title;
		echo $title[$id];
	}
	function displayImage($id, $type = "full") {
		global $description, $path, $name;
		if ($type == "thumbnail") {
			$imgpath = "{$path}thumbs/{$name[$id]}";
		} else {
			$imgpath = "{$path}{$name[$id]}";
		}
		$img = @getimagesize($imgpath);
		echo "<img src=\"{$imgpath}\" width=\"{$img[0]}\" height=\"{$img[1]}\" alt=\"{$description[$id]}\" />";
	}
	function displayRandomImage($phpfile, $type = "full") {
		global $description, $path, $name;
		srand((float) microtime() * 10000000);
		$id = array_rand($name, 1);
		if ($type == "thumbnail") {
			$imgpath = "{$path}thumbs/{$name[$id]}";
		} else {
			$imgpath = "{$path}{$name[$id]}";
		}
		$img = @getimagesize($imgpath);
		echo "<a href=\"{$phpfile}?id={$id}\"><img src=\"{$imgpath}\" width=\"{$img[0]}\" height=\"{$img[1]}\" alt=\"{$description[$id]}\" /></a>";
	}
	function displayDescription($id) {
		global $description;
		echo "{$description[$id]}";
	}
	function displayCategories($phpfile) {
		global $categories, $category, $name, $cat;
		for ($i=0;$i<count($categories);$i++) {
			UnSet($antal);
			for ($z=0;$z<count($name);$z++) {
				if ($cat[$z] == $i) {
					$antal++;
				}
			}
			if (IsSet($category) && $i == $category) {
				echo "<li class=\"current\">{$categories[$i]} ({$antal})</li>";
			} else {
				echo "<li><a href=\"{$phpfile}?category={$i}\">{$categories[$i]} ({$antal})</a></li>";
			}
		}
	}
	function displayCategory($id) {
		global $category, $categories;
		if (IsSet($category)) {
			echo $categories[$id];
		} else {
			echo "All Photos";
		}
	}
	function displayList($phpfile, $linktitle = "number") {
		global $name, $id, $category, $cat, $title, $path;
		for ($i=0;$i<count($name);$i++) {
			if ($i == $id) {
				if ($linktitle == "thumbnail" && file_exists("{$path}thumbs/{$name[$i]}")) {
					$size = @getimagesize("{$path}thumbs/{$name[$id]}");
					echo "<li class=\"current\"><img src=\"{$path}thumbs/{$name[$id]}\" alt=\"{$title[$i]}\" {$size[3]} /></li>";
				} elseif ($linktitle == "number") {
					echo "<li class=\"current\">{$i}</li>";
				} else {
					echo "<li class=\"current\">{$title[$i]}</li>";
				}
			} else {
				if (IsSet($category)) {
					if ($category == $cat[$i]) {
						if ($linktitle == "thumbnail" && file_exists("{$path}thumbs/{$name[$i]}")) {
							$size = @getimagesize("{$path}thumbs/{$name[$i]}");
							echo "<li><a href=\"{$phpfile}?id={$i}&amp;category={$category}\"><img src=\"{$path}thumbs/{$name[$i]}\" alt=\"{$title[$i]}\" {$size[3]} /></a></li>";
						} elseif ($linktitle == "number") {
							echo "<li><a href=\"{$phpfile}?id={$i}&amp;category={$category}\">{$i}</a></li>";
						} else {
							echo "<li><a href=\"{$phpfile}?id={$i}&amp;category={$category}\">{$title[$i]}</a></li>";
						}
					}
				} else {
					if ($linktitle == "thumbnail" && file_exists("{$path}thumbs/{$name[$i]}")) {
						$size = @getimagesize("{$path}thumbs/{$name[$i]}");
						echo "<li><a href=\"{$phpfile}?id={$i}\"><img src=\"{$path}thumbs/{$name[$i]}\" alt=\"{$title[$i]}\" {$size[3]} /></a></li>";
					} elseif ($linktitle == "number") {
						echo "<li><a href=\"{$phpfile}?id={$i}\">{$i}</a></li>";
					} else {
						echo "<li><a href=\"{$phpfile}?id={$i}\">{$title[$i]}</a></li>";
					}
				}
			}
		}
	}
	function displayNextCategory($category, $phpfile, $linktitle) {
		global $categories;
		if (is_array($categories) && count($categories) > 1) {
			if (!IsSet($category)) {
				echo "<a href=\"{$phpfile}?category=0\">{$linktitle}</a>";
			} else {
				$nextid = $category+1;
				if (IsSet($categories[$nextid])) {
					echo "<a href=\"{$phpfile}?category={$nextid}\">{$linktitle}</a>";
				} else {
					echo "<a href=\"{$phpfile}?category=0\">{$linktitle}</a>";
				}
			}
		}
	}
	function displayPrevCategory($category, $phpfile, $linktitle) {
		global $categories;
		if (is_array($categories) && count($categories) > 1) {
			if (!IsSet($category) || $category == 0) {
				// Get last category.
				end($categories);
				$previd = each($categories);
				$previd = $previd["key"];
				reset($categories);
				echo "<a href=\"{$phpfile}?category={$previd}\">{$linktitle}</a>";
			} else {
				$previd = $category-1;
				echo "<a href=\"{$phpfile}?category={$previd}\">{$linktitle}</a>";
			}
		}
	}
	function displayNextLink($id, $phpfile, $linktitle) {
		global $name, $category, $cat;
		if (!IsSet($category)) {
			if ($id == count($name)-1) {
				$nextid = 0;
			} else {
				$nextid = $id+1;
			}
		} else {
			for ($i=0;$i<count($name);$i++) {
				if ($category == $cat[$i]) {
					$nextidarr[] = $i;
				}
			}
			ksort($nextidarr);
			reset($nextidarr);
			foreach ($nextidarr as $key => $value) {
				if ($value == $id) {
					if(next($nextidarr)) {
						$nextid = each($nextidarr);
					} else {
						reset($nextidarr);
						$nextid = each($nextidarr);
					}
					$nextid = "{$nextid["value"]}&amp;category={$category}";
					break;
				}
				next($nextidarr);
			}
		}
		echo "<a href=\"{$phpfile}?id={$nextid}\">$linktitle</a>";
	}
	function displayPrevLink($id, $phpfile, $linktitle) {
		global $name, $category, $cat;
		if (!IsSet($category)) {
			if ($id == 0) {
				$previd = count($navn)-1;
			} else {
				$previd = $id-1;
			}
		} else {
			for ($i=0;$i<count($name);$i++) {
				if ($category == $cat[$i]) {
					$previdarr[] = $i;
				}
			}
			ksort($previdarr);
			reset($previdarr);
			foreach ($previdarr as $key => $value) {
				if ($value == $id) {
					if ($key == 0) {
						end($previdarr);
						$previd = each($previdarr);
						$previd = "{$previd["value"]}&amp;category={$category}";
						break;
					} else {
						prev($previdarr);
						$previd = each($previdarr);
						$previd = "{$previd["value"]}&amp;category={$category}";
						break;
					}
				}
				next($previdarr);
			}
		}
		echo "<a href=\"{$phpfile}?id={$previd}\">$linktitle</a>";
	}
} else {
header ("Content-Type: text/html; charset=ISO-8859-1");
// If the visitor is not logged in the login box is displayed.
if (!isset($_SERVER['PHP_AUTH_USER'])) {
	header('WWW-Authenticate: Basic realm="Start Page"');
	header('HTTP/1.0 401 Unauthorized');
	echo "Don't hit 'Cancel', stupid.";
	exit;
}
function checkUser() { // Checks if the username and password are correct.
	global $_SERVER, $username, $password;
	if ($_SERVER['PHP_AUTH_USER'] == $username && $_SERVER['PHP_AUTH_PW'] == $password) {
		return TRUE;
	} else {
		return FALSE;
	}
}
function printValue($type) {
	global $_GET, $title, $name, $description;
	$id = $_GET["id"];
	if ($_GET["action"] == "edit") {
		switch ($type) {
			case "title" :
				echo "value=\"{$title[$id]}\" ";
				break;
			case "description" :
				echo "value=\"{$description[$id]}\" ";
				break;
			case "id" :
				echo "value=\"{$_GET["id"]}\" ";
				break;
		}
	}
}
function printMenuItem($action, $text) {
	global $self;
	if (IsSet($_REQUEST["action"])) {
		if ($action == $_REQUEST["action"]) {
			if ($_REQUEST["action"] == "edit") {
				$id = "&amp;id={$_GET["id"]}";
			}
			echo "<a href=\"{$self}?action={$action}{$id}\" class=\"current\">{$text}</a>";
		} else {
			if ($action == "") {
				if ($_REQUEST["action"] == "submitadd" || $_REQUEST["action"] == "submitedit" || $_REQUEST["action"] == "delete" || $_REQUEST["action"] == "submitcats") {
					echo "<a href=\"{$self}\" class=\"current\">{$text}</a>";
				} else {
					echo "<a href=\"{$self}\">{$text}</a>";
				}
			} else {
				echo "<a href=\"{$self}?action={$action}\">{$text}</a>";
			}
		}
	} else {
		if ($action == "") {
			echo "<a href=\"{$self}\" class=\"current\">{$text}</a>";
		} else {
			echo "<a href=\"{$self}?action={$action}\">{$text}</a>";
		}
	}
}
function getExt ($name) {
	// This function returns the file ending without the "."
	if (strstr($name, ".")) {
		$ext = str_replace(".", "", strrchr($name, "."));
	} else {
		$ext = "";
	}
	return $ext;
}
function saveFile () {
	global $xmlfile, $name, $title, $description, $cat, $categories;
	$xmlstring = "<?xml  version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<gallery>";
	// Categories are added
	$xmlstring = "{$xmlstring}\r\n\t<categories>";
	if (is_array($categories)) {
		foreach ($categories as $cid => $catname) {
			$xmlstring = "{$xmlstring}\r\n\t\t<category cid=\"{$cid}\">{$catname}</category>";
		}
	}
	$xmlstring = "{$xmlstring}\r\n\t</categories>";
	// Images are added
	$xmlstring = "{$xmlstring}\r\n\t<images>";
	if (is_array($name)) {
		foreach ($name as $id => $filename) {
			$xmlstring = "{$xmlstring}\r\n\t\t<image id=\"{$id}\">\r\n\t\t\t<file>{$name[$id]}</file>\r\n\t\t\t<title>{$title[$id]}</title>\r\n\t\t\t<description>{$description[$id]}</description>\r\n\t\t\t<imgcategory>{$cat[$id]}</imgcategory>\r\n\t\t</image>";
		}
	}
	$xmlstring = "{$xmlstring}\r\n\t</images>";
	$xmlstring = "{$xmlstring}\r\n</gallery>";
	if (is_writeable($xmlfile)) {
		$fp = fopen($xmlfile, "wb");
		fputs ($fp, $xmlstring);
		fclose($fp);
		return TRUE;
	} else {
		return FALSE;
	}
}
?><?php
function updateCats($newcats) {
	global $categories;
	foreach ($newcats as $currentid => $currentcat) {
		$currentcat = strip_tags(stripslashes(trim($currentcat)));
		if ($currentcat != "") {
			$categories[$currentid] = $currentcat;
		} else {
			UnSet($categories[$currentid]);
		}
	}
	if (saveFile() == TRUE) {
		echo "<p class=\"ok\">Categories updated.</p>";
		return TRUE;
	} else {
		echo "<p class=\"alarm\">Could not update data file.</p>";
		return FALSE;
	}
}
function editImage($oldid, $newid, $newtitle, $newdescription, $newcat, $filename = "", $updatethumb = "") {
	global $name, $title, $description, $cat, $enableThumbnails, $thumbnailwidth, $thumbnailquality, $path;
	if ($enableThumbnails == TRUE && $updatethumb != "") {
		// Delete old thumbnail file.
		if (!file_exists("{$path}thumbs/{$filename}") || !@unlink("{$path}thumbs/{$filename}")) {
			// Create thumbnail.
			$msg = createThumbnail($filename, $thumbnailwidth, $thumbnailquality);
			if ($msg == 0) {
				echo "<p class=\"ok\">Thumbnail updated.</p>";
			} else {
				echo "<p class=\"alarm\">{$msg}</p>";
			}
		} else {
			echo "<p class=\"alarm\">Old thumbnail file could not be deleted.</p>";
		}
	}
	if ($oldid == $newid) {
		$title[$newid] = $newtitle;
		$description[$newid] = $newdescription;
		$cat[$newid] = $newcat;
		if (saveFile() == TRUE) {
			echo "<p class=\"ok\">Image edited.</p>";
			return TRUE;
		} else {
			echo "<p class=\"alarm\">Could not update data file.</p>";
			return FALSE;
		}
	} else {
		$newname = $name[$oldid];
		if (!IsSet($name[$newid])) {
			if (deleteImage($oldid, "no", "no") == TRUE) {
				$name[] = $newname;
				$title[] = $newtitle;
				$description[] = $newdescription;
				$cat[] = $newcat;
				if (saveFile() == TRUE) {
					echo "<p class=\"ok\">Image edited.</p>";
					return TRUE;
				} else {
					echo "<p class=\"alarm\">Could not update data file.</p>";
					return FALSE;
				}
			} else {
				echo "<p class=\"alarm\">Could not remove old ID.</p>";
				return FALSE;
			}
		} else {
			if (deleteImage($oldid, "no", "no") == TRUE) {
				$temp = array_splice($name, $newid);
				$name[] = $newname;
				foreach ($temp as $value) {
					$name[] = $value;
				}
				UnSet($temp);
				$temp = array_splice($title, $newid);
				$title[] = $newtitle;
				foreach ($temp as $value) {
					$title[] = $value;
				}
				UnSet($temp);
				$temp = array_splice($description, $newid);
				$description[] = $newdescription;
				foreach ($temp as $value) {
					$description[] = $value;
				}
				UnSet($temp);
				$temp = array_splice($cat, $newid);
				$cat[] = $newcat;
				foreach ($temp as $value) {
					$cat[] = $value;
				}
				UnSet($temp);
				if (saveFile() == TRUE) {
					echo "<p class=\"ok\">Image edited.</p>";
					return TRUE;
				} else {
					echo "<p class=\"alarm\">Could not update data file.</p>";
					return FALSE;
				}
			} else {
				echo "<p class=\"alarm\">Could not remove old ID.</p>";
				return FALSE;
			}
		}
	}
}
function deleteImage($id, $delfile = "yes", $output = "yes", $delthumb = "yes") {
	global $name, $description, $title, $cat, $path;
	if (IsSet($name[$id])) {
		if ($delfile == "yes") {
			if (@unlink("{$path}{$name[$id]}")) {
				echo "<p class=\"ok\">File deleted. ";
			} else {
				echo "<p class=\"alarm\">File not deleted. ";
			}
		}
		if ($delthumb == "yes") {
			if (@unlink("{$path}thumbs/{$name[$id]}")) {
				echo "<span class=\"ok\">Thumbnail deleted. </span>";
			} else {
				echo "<span class=\"alarm\">Thumbnail not deleted. </span>";
			}
		}
		$temp = array_splice($name, $id);
		array_shift($temp);
		foreach ($temp as $value) {
			$name[] = $value;
		}
		UnSet($temp);
		$temp = array_splice($title, $id);
		array_shift($temp);
		foreach ($temp as $value) {
			$title[] = $value;
		}
		UnSet($temp);
		$temp = array_splice($description, $id);
		array_shift($temp);
		foreach ($temp as $value) {
			$description[] = $value;
		}
		UnSet($temp);
		$temp = array_splice($cat, $id);
		array_shift($temp);
		foreach ($temp as $value) {
			$cat[] = $value;
		}
		UnSet($temp);
		if (saveFile() == TRUE) {
			if ($output != "no") {
				echo "<span class=\"ok\">Image removed.</span></p>";
			}
			return TRUE;
		} else {
			if ($output != "no") {
				echo "<span class=\"alarm\">Could not update data file.</span></p>";
			}
			return FALSE;
		}
	}
}
function createThumbnail($orgimg, $thumbnailwidth, $thumbnailquality) {
	global $path;
	$thumbpath = "{$path}thumbs/{$orgimg}";
	$orgimg = "{$path}{$orgimg}";
	$error = 0;
	if (function_exists('imagecreate') && function_exists('imagecopyresized')) {
		// Check if thumbnail directory exists. If not try to create it.
		if (!is_dir("{$path}thumbs")) {
			$oldumask = umask(0);
			if (@!mkdir("{$path}thumbs", 0777)) {
				$error = "Thumbnail directory could not be created.";
			}
			umask($oldumask);
		}
		// Get file size and file type.
		if ($error == 0) {
			if (!$size = @getimagesize($orgimg)) {
				$error = "Size of original image could not be calculated.";
			}
		}
		// Create link to old image.
		if ($error == 0) {
			switch ($size[2]) {
				case 1 :
					if (function_exists('imagecreatefromgif')) {
						$img = @imagecreatefromgif($orgimg);
						if ($img == "") {
							$error = "Could not open link to original image.";
						}
					} else {
						$error = "Could not open link to original image.";
					}
					break;
				case 2 :
					if (function_exists('imagecreatefromjpeg')) {
						$img = @imagecreatefromjpeg($orgimg);
						if ($img == "") {
							$error = "Could not open link to original image.";
						}
					} else {
						$error = "Could not open link to original image.";
					}
					break;
				case 3 :
					if (function_exists('imagecreatefrompng')) {
						$img = @imagecreatefrompng($orgimg);
						if ($img == "") {
							$error = "Could not open link to original image.";
						}
					} else {
						$error = "Could not open link to original image.";
					}
					break;
				default :
					$error = "Cannot create thumbnail. Original image is of an unsupported type.";
					break;
	        }
		}
		// Calculate the dimensions of the new image.
		if (!strstr($thumbnailwidth, "%")) {
			if($size[0] > $size[1]) {
				$ratio = $size[0]/$thumbnailwidth;
				$height = $size[1]/$ratio;
				$height = round($height);
				$width = $size[0]/$ratio;
			} else {
				$ratio = $size[1]/$thumbnailwidth;
				$width = $size[0]/$ratio;
				$width = round($width);
				$height = $size[1]/$ratio;
			}
		} else {
			$ratio = str_replace("%", "", $thumbnailwidth)/100;
			$width = round($size[0]*$ratio);
			$height = round($size[1]*$ratio);
		}
		// Create new image (true colour if available).
		if ($error == 0) {
			if (function_exists('imagecreatetruecolor')) {
				$newimg = imagecreatetruecolor($width, $height);
			} else {
				$newimg = imagecreate($width, $height);
			}
		}
		// Resample old image over new image.
		if ($error == 0) {
			if(!function_exists('imagecopyresampled') || !function_exists('imagecreatetruecolor')) {
				if (!@imagecopyresized($newimg, $img, 0, 0, 0, 0, $width, $height, $size[0], $size[1])) {
					$error = "Could not resize image.";
				}
			} else {
				if (!@imagecopyresampled($newimg, $img, 0, 0, 0, 0, $width, $height, $size[0], $size[1])) {
					$error = "Could not resample image.";
				}
			}
		}
		// Make the thumbnails, and save files.
		if ($error == 0) {
			switch ($size[2]) {
				case 1:
					if (!@imagegif($newimg, $thumbpath)) {
						$error = "Could not save thumbnail.";
					}
					break;
				case 2:
					if (!@imagejpeg($newimg, $thumbpath, $thumbnailquality)) {
						$error = "Could not save thumbnail.";
					}
					break;
				case 3:
					if (!@imagepng($newimg, $thumbpath)) {
						$error = "Could not save thumbnail.";
					}
					break;
				default :
					$error = "Could not create thumbnail. Image type not supported.";
			}
		}
		// Destroy image both links.
		@imagedestroy($newimg);
		@imagedestroy($img);
	} else {
		$error = "Image functions not available for thumbnail.";
	}
	return $error;
}
function addImage($newtitle, $newdescription, $newcat) {
	global $name, $title, $description, $cat, $allowedfiles, $maxsize, $path, $enableThumbnails, $thumbnailwidth, $thumbnailquality;
	$newtitle = strip_tags(stripslashes(trim($newtitle)));
	$newdescription = strip_tags(stripslashes(trim($newdescription)));
	// If there are no categories configured we add a category
	if ($newcat == "NoCatIsAvailable") {
		$temp = array("Untitled");
		updateCats($temp);
		UnSet($temp);
		$newcat = 0;
	}
	if ($newtitle != "" && $_FILES["localfile"]["error"] == 0) {
		// Handle the file upload.
		if ($type = @getimagesize($_FILES["localfile"]["tmp_name"])) {
			if (in_array(strtolower(getExt($_FILES["localfile"]["name"])), $allowedfiles)) {
				if (filesize($_FILES["localfile"]["tmp_name"]) <= $maxsize) {
					if (@move_uploaded_file($_FILES["localfile"]["tmp_name"], "{$path}{$_FILES["localfile"]["name"]}")) {
						// Build and save the xml data file.
						$name[] = $_FILES["localfile"]["name"];
						$title[] = $newtitle;
						$description[] = $newdescription;
						$cat[] = $newcat;
						if (saveFile() == TRUE) {
							if ($_POST["submit"] != "Add Image") {
								UnSet($_REQUEST["action"]);
							} else {
								$_REQUEST["action"] = "add";
							}
							echo "<p class=\"ok\">Image added.</p>";
							if ($enableThumbnails == TRUE) {
								$msg = createThumbnail($_FILES["localfile"]["name"], $thumbnailwidth, $thumbnailquality);
								if ($msg == 0) {
									echo "<p class=\"ok\">Thumbnail created.</p>";
								} else {
									echo "<p class=\"alarm\">{$msg}</p>";
								}
							}
							return TRUE;
						} else {
							echo "<p class=\"alarm\">Error: The script couldn't save the data file.</p>";
							return FALSE;
						}
					} else {
						echo "<p class=\"alarm\">Error: The script couldn't move the file.</p>";
						return FALSE;
					}
				} else {
					echo "<p class=\"alarm\">Error: The was was too big.</p>";
					return FALSE;
				}
			} else {
				echo "<p class=\"alarm\">Error: This type of image is not allowed.</p>";
				return FALSE;
			}
		} else {
			echo "<p class=\"alarm\">Error: The file you tried to upload was not an image file.</p>";
			return FALSE;
		}
	} else {
		echo "<p class=\"alarm\">Error: You did specify a title or file for upload (or the file was too big).</p>";
		return FALSE;
	}
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
	<head>
		<title>Gallery Thingie: Administration</title>
		<style type="text/css">
			body {
				font-family:Verdana, sans-serif;
				font-size:12px;
				padding:1.5em 2em;
				color:black;
				background:white;
			}
			td {
				font-size:12px;
			}
			a {
				color:blue;
				text-decoration:none;
			}
			a:hover {
				color:red;
				border-bottom:1px solid red;
			}
			h1 {
				font-size:2em;
				font-weight:normal;
				margin:0;
			}
			input, select {
				vertical-align:middle;
				width:35ex;
				margin-bottom:0.5em;
			}
			.checkbox {
				width:auto;
				display:inline;
				text-align:center;
				vertical-align:middle;
			}
			input.checkbox {
				vertical-align:text-top;
			}
			input.half {
				width:17.5ex;
			}
			label {
				display:block;
				font-size:10px;
				font-weight:bold;
				color:white;
			}
			thead, tbody,tfoot {
				display:table-row-group;
			}
			table, fieldset {
				border:2px solid #999;
				margin:1em 1em 1em 1em;
			}
			th, td {
				padding:0.3em 1ex;
			}
			th {
				font-size:14px;
				text-align:left;
				font-weight:normal;
			}
			th, tfoot td {
				background:#369;
				color:white;
			}
			legend {
				color:#369;
				font-weight:bold;
			}
			tr.org td {
				background:#eee;
			}
			tr.alt td {
				background:#ccc;
			}
			.center {
				text-align:center;
			}
			tfoot td {
				font-size:10px;
				text-align:right;
			}
			fieldset {
				border:0px solid white;
				padding:1em 1em 0 1em;
				width:40ex;
				background:#369;
			}
			ol {
				list-style:none;
				margin:1em 1em 2em 1em;
			}
			ol li {
				display:inline;
				margin:0 0.5em;
			}
			ol li a {
				padding:0.25em;
				font-weight:bold;
				text-decoration:none;
				border-bottom:2px solid #ccc;
				color:black;
				font-size:10px;
			}
			ol li a:hover {
				border-bottom:2px solid #369;
				color:red;
			}
			ol li a.current {
				border-bottom:2px solid red;
			}
			p {
				font-size:12px;
				font-weight:normal;
				text-align:left;
				margin:0 1em;
			}
			p.footer {
				font-size:10px;
				font-weight:bold;
				text-align:left;
				margin:1em 0;
			}
			.alarm {
				color:red;
				background:white;
			}
			.ok {
				color:green;
				background:white;
			}
			table input {
				margin:0.3em;
			}
		</style>
		<script type="text/javascript">
		function checkDelete() {
			var value = confirm("Are you sure that you want to delete this entry and file?");
			if (value == true) {
				return true;
			} else {
				return false;
			}
		}
		</script>
	</head>
	<body>
<?php
if (checkUser() == TRUE) {
?>
		<h1>Gallery Thingie: Administration</h1>
			<ol>
				<li><?php printMenuItem("", "List Images");?></li>
				<li><?php printMenuItem("add", "Add Image");?></li>
				<?php if ($_REQUEST["action"] == "edit") { echo "<li>";printMenuItem("edit", "Edit Image");echo "</li>";}?>
				<li><?php printMenuItem("cats", "Categories");?></li>
			</ol>
<?php
if ($_REQUEST["action"] == "submitadd") { // We try to add the image.
	addImage($_POST["newtitle"], $_POST["newdescription"], $_POST["newcat"]);
} elseif ($_REQUEST["action"] == "delete" && IsSet($name[$_GET["id"]])) { // We try to delete the image.
	deleteImage($_GET["id"]);
} elseif ($_REQUEST["action"] == "submitedit" && IsSet($name[$_POST["oldid"]])) { // We try to edit the image
	editImage($_POST["oldid"], $_POST["newid"], $_POST["newtitle"], $_POST["newdescription"], $_POST["newcat"], $_POST["filename"], $_POST["thumb"]);
} elseif ($_REQUEST["action"] == "submitcats") { // We try to update categories
	updateCats($_POST["newcats"]);
}
if ($_REQUEST["action"] == "edit" || $_REQUEST["action"] == "add") { ?>
		<form action="<?php echo $self;?>" method="post" enctype="multipart/form-data">
			<fieldset>
<?php	if ($_GET["action"] == "edit") { ?>
				<div>
					<label for="newid">Id:</label>
					<input type="text" name="newid" id="newid" size="4" <?php printValue("id");?>/>
				</div>
<?php	} ?>
				<div>
					<label for="newtitle">Title: </label>
					<input type="text" name="newtitle" id="newtitle" size="30" <?php printValue("title");?>/>
				</div>
				<div>
					<label for="newdescription">Description: </label>
					<input name="newdescription" id="newdescription" size="30" <?php printValue("description");?>/>
				</div>
				<div>
					<label for="newcat">Category: </label>
					<select name="newcat" id="newcat">
<?php
if (is_array($categories)) {
	foreach ($categories as $key => $currentcat) {
		if ($_GET["action"] == "edit" && $cat[$_GET["id"]] == $key) {
			echo "\t\t\t\t\t\t<option value=\"{$key}\" selected=\"selected\">{$currentcat}</option>\r\n";
		} else {
			echo "\t\t\t\t\t\t<option value=\"{$key}\">{$currentcat}</option>\r\n";
		}
	}
} else {
	echo "\t\t\t\t\t\t<option value=\"NoCatIsAvailable\">No category is available</option>\r\n";
}
?>
					</select>
				</div>
<?php	if ($_GET["action"] == "edit") { ?>
				<div>
					<input type="checkbox" class="checkbox" name="thumb" id="thumb" /> <label class="checkbox" for="thumb">Update thumbnail.</label>
				</div>
				<div>
					<input type="hidden" name="filename" value="<?php echo $name[$_GET["id"]];?>" />
					<input type="hidden" name="action" value="submitedit" />
					<input type="hidden" name="oldid" value="<?php echo $_GET["id"];?>" />
					<input type="submit" value="Edit image" />
<?php	} else { ?>
				<div>
					<label for="localfile">File: </label>
					<input type="file" name="localfile" id="localfile" />
				</div>
				<div>
					<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $maxsize;?>" />
					<input type="hidden" name="action" value="submitadd" />
					<input type="submit" name="submit" value="Add Image" class="half" />
					<input type="submit" name="submit" value="Add &amp; Exit" class="half" />
<?php	} ?>
				</div>
			</fieldset>
		</form>
<?php } elseif ($_REQUEST["action"] == "cats") { ?>
		<form action="<?php echo $self;?>" method="post">
		<table>
			<thead>
				<tr>
					<th class="center">#</th>
					<th>Category</th>
				</tr>
			</thead>
			<tbody>
<?php
$categories[] = "";
foreach ($categories as $currentid => $currentcat) {
	if ($currentid%2 == 0) {
		echo "\t\t\t\t<tr class=\"org\">";
	} else {
		echo "\t\t\t\t<tr class=\"alt\">";
	}
	echo "\r\n\t\t\t\t<td class=\"center\">{$currentid}</td>\r\n\t\t\t\t<td><input type=\"text\" name=\"newcats[]\" value=\"{$currentcat}\" /></td>\r\n\t\t\t</tr>\r\n";
}
?>
			</tbody>
			<tfoot>
				<tr><td colspan="2"><input type="hidden" name="action" value="submitcats" /><input type="submit" value="Submit changes" /></td></tr>
			</tfoot>
		</table>
		</form>

<?php } else {?>
		<table>
			<thead>
				<tr>
					<th class="center">#</th>
					<th>Title</th>
					<th>Category</th>
					<th>Description</th>
					<th>File name</th>
					<th>Dimensions</th>
					<th class="center">Size</th>
					<th class="center">Options</th>
				</tr>
			</thead>
			<tbody>
<?php
if (is_array($name)) {
	$totalsize = 0;
	foreach ($name as $currentid => $currentfile) {
		if (file_exists("{$path}{$currentfile}")) {
			$currentsize = @filesize("{$path}{$currentfile}")/1024;
			$totalsize = $totalsize+$currentsize;
			$currentsize = round($currentsize, 1);
			$currentdimensions = @getimagesize("{$path}{$currentfile}");
			if ($enableThumbnails == TRUE && !file_exists("{$path}thumbs/{$currentfile}")) {
				$thumbExists = " &dagger;";
			} else {
				$thumbExists = "";
			}
			if ($currentid%2 == 0) {
				echo "\t\t\t\t<tr class=\"org\">";
			} else {
				echo "\t\t\t\t<tr class=\"alt\">";
			}
			if (strlen($description[$currentid]) > $limit) {
				$currentdescription = trim(substr($description[$currentid], 0, $limit))."...";
			} else {
				$currentdescription = $description[$currentid];
			}
			echo "\r\n\t\t\t\t\t<td class=\"center\">{$currentid}</td>\r\n\t\t\t\t\t<td><a href=\"{$phpfile}?id={$currentid}\">{$title[$currentid]}</a>{$thumbExists}</td>\r\n\t\t\t\t\t<td><a href=\"{$phpfile}?category={$cat[$currentid]}\">{$categories[$cat[$currentid]]}</a></td>\r\n\t\t\t\t\t<td>{$currentdescription}</td>\r\n\t\t\t\t\t<td><a href=\"{$path}{$currentfile}\">{$currentfile}</a></td>\r\n\t\t\t\t\t<td class=\"center\">{$currentdimensions[0]}x{$currentdimensions[1]}</td>\r\n\t\t\t\t\t<td class=\"center\">{$currentsize}kb</td>\r\n\t\t\t\t\t<td><a href=\"{$self}?action=edit&amp;id={$currentid}\">edit</a> / <a href=\"{$self}?action=delete&amp;id={$currentid}\" onclick=\"if(checkDelete() == true) {return true;} else {return false;}\">del</a></td>\r\n\t\t\t\t</tr>\r\n";
			UnSet($currentsize);
			UnSet($currentdimensions);
			UnSet($currentdescription);
		} else {
			echo "\t\t\t\t<tr>\r\n\t\t\t\t\t<td colspan=\"7\" class=\"alarm\">File not found: {$currentfile}</td>\r\n\t\t\t\t\t<td><a href=\"{$self}?action=edit&amp;id={$currentid}\">edit</a> / <a href=\"{$self}?action=delete&amp;id={$currentid}\" onclick=\"if(checkDelete() == true) {return true;} else {return false;}\">del</a></td>\r\n\t\t\t\t</tr>\r\n";
		}
	}
} else {
	echo "\t\t\t\t<tr>\r\n\t\t\t\t\t<td colspan=\"8\" class=\"alarm\">No images in database.</td>\r\n\t\t\t\t</tr>\r\n";
}
$totalsize = round($totalsize, 2);
?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="8"><?php echo count($name);?> image(s) taking up <?php echo $totalsize;?>kb</td>
				</tr>
			</tfoot>
		</table>
<?php
}
} else {
	echo "<p>You have not entered the correct username/password combination.</p>";
}
?>
		<p class="footer"><a href="http://www.solitude.dk/gallerythingie/">Gallery Thingie</a> is copyright <a href="http://www.solitude.dk/">Andreas Haugstrup</a>, 2003.</a>
	</body>
</html>
<?php
}
?>