#!/usr/bin/perl -w
#
# copyright 2000 by Gottfried Szing e9625460@stud3.tuwien.ac.at
#
# version 0.10
# 

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, you can either send email to this
# program's maintainer or write to: The Free Software Foundation,
# Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.
#
#
# best vieved under vi with tabstop=4
#
#

# ============== CONFIGURATION START =========================
my $version 	= "0.10";		    # dont touch this ;-)
my $datebin 	= "/bin/date";		# where is the date?
my $serverName 	= "localhost";		# where is the server?
my $serverPort 	= "3306";
my $serverUser 	= "root";			# user and password
my $serverPass 	= "";
my $serverDb 	= "apache2";		# tablename
my $timezone 	= "+0100";			# your timezone


# =============== CONFIGURATION END ==========================

$| = 1;

use strict;
use DBI;		# db-connection
use DBI::DBD;
use Entry;
my ($line, @req);

if (@ARGV == 0)
{
	print_usage()
}

my $quiet = 0;
my $where = "1";
my $LOG = "";

foreach my $param (@ARGV)
{
	if ($param =~ /^-c/)
	{
		$quiet = 1;
	}
	else 
	{
		if ($param =~ /-w(.*)/)
		{
			$where = $1;
		}
		else
		{
			$LOG = $param;
		}
	}
}

# open DB
my $dbh 	= DBI->connect("DBI:mysql:database=$serverDb;host=$serverName;port=$serverPort",$serverUser,$serverPass);


# print header
print <<EOF unless ($quiet);
deflate version $version 
written by gottfried szing (e9625460\@stud3.tuwien.ac.at)
Converts an log saved in MySQL back to a flat log file

Where:     $where
Output:    $LOG
Database:  $serverDb\@$serverName:$serverPort
EOF



# open new logfile and select data
open(LOG, ">$LOG") || die ("cannot open log $LOG");

my $cur1 = $dbh->prepare(  "
select  host.host, transfer.ident, transfer.remoteuser, DATE_FORMAT(transfer.time, '%d/%b/%Y:%H:%i:%S $timezone'), 
        method.method, request.request, cgi.cgi, httpversion.httpversion, transfer.response, 
        transfer.size, referrer.referrer, agent.agent
from    host, hostip, method, request, cgi, httpversion, referrer, agent, transfer
where   transfer.hostid = host.id and
        transfer.methodid = method.id and
        transfer.requestid = request.id and
        transfer.cgiid = cgi.id and
        transfer.httpversionid = httpversion.id and
        transfer.referrerid = referrer.id and
        transfer.agentid = agent.id and $where");
																		
$cur1->execute;

print <<EOF unless ($quiet);
Progress (. == 100 lines in log):
--------------------------------

EOF





# data
my ($id, $host, $ident, $remoteuser, $datetime, $method, $request, $httpversion, $response, $size, $referrer, $agent, $hostip, $cookie, $cgi, $virt) =
   ("", "", "", "", "", "". "", "", "", "", "", "". "", "", "");

# open log-file
my $totalcount = 0;

INPUT: while (@req=$cur1->fetchrow_array())
{
	$totalcount++;

	print "."                       if ( ($totalcount % 100) == 0 && not $quiet);
	print " $totalcount\n"          if ( ($totalcount % 10000) == 0 && not $quiet);

	($host, $ident, $remoteuser, $datetime, $method, $request, $cgi, $httpversion, $response, $size, $referrer, $agent) = @req;

	if ($cgi eq "-") 	{$cgi = "" }
	else 			{$cgi = "\?$cgi" };

	if ($size eq "" || $size eq "-") { $size = "0"; };
	if ($response eq "" || $response eq "-") { $response = "0"; };

	print LOG "$host $ident $remoteuser [$datetime] \"$method $request$cgi HTTP/$httpversion\" $response $size \"$referrer\" \"$agent\"\n";
}

# close logfile and database-connection
$cur1->finish();
$dbh->disconnect();
close(LOG);

print "\n" unless ($quiet); 

exit 0;

# print header
sub print_usage()
{
	print <<EOF;
deflate version $version 
$0 [-c] [-w"where clause"] <logfile> 
written by gottfried szing (e9625460\@stud3.tuwien.ac.at)
Converts an log saved in MySQL back to a flat log file

logfile       where to write loglins to ("-" prints to console)
-c            be quiet (useful for crontab)
-w            filter output

where clause  filters the data written. eg.
              "response = 400" prints all correct served requests

deflate -w"time > '01/Jan/2000'" access.log

EOF

exit 1;
}
