/*
 * Decompiled with CFR 0.152.
 */
package com.coolservlets.email;

import com.coolservlets.email.Address;
import com.coolservlets.email.Message;
import com.coolservlets.email.TransportException;
import com.coolservlets.email.Transportable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class Transport
implements Transportable {
    private String smtpHost;
    private String smtpResponse;
    private int smtpPort;

    public Transport(String string, int n) {
        this.smtpHost = string;
        this.smtpPort = n;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void send(Message message) throws TransportException {
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        try {
            Socket socket = new Socket(this.smtpHost, this.smtpPort);
            printWriter = new PrintWriter(socket.getOutputStream(), true);
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (this.smtpErrorExists(bufferedReader, "220")) {
                throw new TransportException("Can't connect to: " + this.smtpHost + ". Port: " + this.smtpPort + "\t" + this.smtpResponse);
            }
        }
        catch (IOException iOException) {
            throw new TransportException("Can't connect to: " + this.smtpHost + ". Port: " + this.smtpPort + "\t ");
        }
        this.sendMessage(message, bufferedReader, printWriter);
    }

    private void sendMessage(Message message, BufferedReader bufferedReader, PrintWriter printWriter) throws TransportException {
        String string;
        Address address;
        int n;
        Address[] addressArray;
        printWriter.println("HELO " + this.smtpHost);
        if (this.smtpErrorExists(bufferedReader, "250")) {
            throw new TransportException("SMTP error: HELO failed.\t" + this.smtpResponse);
        }
        Address[] addressArray2 = message.getFrom();
        if (addressArray2 == null) {
            throw new TransportException("SMTP error: No FROM address specified, can't send email.\t ");
        }
        if (addressArray2[0].getAddress() != null && addressArray2[0].getAddress().length() > 0) {
            printWriter.println("MAIL FROM: <" + addressArray2[0].getAddress() + ">");
            if (this.smtpErrorExists(bufferedReader, "250")) {
                throw new TransportException("SMTP error: adding a sender failed (FROM field).\t" + this.smtpResponse);
            }
        } else {
            throw new TransportException("SMTP error: No FROM address specified, can't send email.");
        }
        Address[] addressArray3 = message.getRecipients(1);
        if (addressArray3 == null || addressArray3.length == 0) {
            throw new TransportException("SMTP error: no RCPT TO (a recipient) specified.");
        }
        int n2 = 0;
        while (n2 < addressArray3.length) {
            printWriter.println("RCPT TO: <" + addressArray3[n2].getAddress() + ">");
            if (this.smtpErrorExists(bufferedReader, "250")) {
                throw new TransportException("SMTP error: adding a TO recipient failed. Error with this address: " + addressArray3[n2].getAddress() + "\t" + this.smtpResponse);
            }
            ++n2;
        }
        Address[] addressArray4 = message.getRecipients(2);
        if (addressArray4 != null) {
            int n3 = 0;
            while (n3 < addressArray4.length) {
                printWriter.println("RCPT TO: <" + addressArray4[n3].getAddress() + ">");
                if (this.smtpErrorExists(bufferedReader, "250")) {
                    throw new TransportException("SMTP error: adding a CC recipient failed. Error with this address: " + addressArray4[n3].getAddress() + "\t" + this.smtpResponse);
                }
                ++n3;
            }
        }
        if ((addressArray = message.getRecipients(3)) != null) {
            int n4 = 0;
            while (n4 < addressArray.length) {
                printWriter.println("RCPT TO: <" + addressArray[n4].getAddress() + ">");
                if (this.smtpErrorExists(bufferedReader, "250")) {
                    throw new TransportException("SMTP error: adding a BCC recipient failed. Error with this address: " + addressArray[n4].getAddress() + "\t" + this.smtpResponse);
                }
                ++n4;
            }
        }
        printWriter.println("DATA");
        if (this.smtpErrorExists(bufferedReader, "354")) {
            throw new TransportException("SMTP error: Writing DATA field of message failed.\t" + this.smtpResponse);
        }
        if (addressArray2 != null) {
            printWriter.println("From: " + (addressArray2[0].getPersonal() != null ? String.valueOf(addressArray2[0].getPersonal()) + " " : "") + "<" + addressArray2[0].getAddress() + ">");
        }
        if (addressArray3 != null && addressArray3.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("To: ");
            n = 0;
            while (n < addressArray3.length) {
                stringBuffer.append(addressArray3[n].getPersonal() != null ? String.valueOf(addressArray3[n].getPersonal()) + " <" + addressArray3[n].getAddress() + ">" : addressArray3[n].getAddress());
                if (n < addressArray3.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            printWriter.println(stringBuffer.toString());
        }
        if (addressArray4 != null && addressArray4.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CC: ");
            n = 0;
            while (n < addressArray4.length) {
                stringBuffer.append(addressArray4[n].getPersonal() != null ? String.valueOf(addressArray4[n].getPersonal()) + " <" + addressArray4[n].getAddress() + ">" : addressArray4[n].getAddress());
                if (n < addressArray4.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            printWriter.println(stringBuffer.toString());
        }
        if ((address = message.getReplyTo()) != null && (string = address.getAddress()) != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Reply-To: ");
            stringBuffer.append(address.getPersonal() != null ? String.valueOf(address.getPersonal()) + " <" + address.getAddress() + ">" : address.getAddress());
            printWriter.println(stringBuffer.toString());
        }
        if (message.getSubject() != null) {
            printWriter.println("Subject: " + message.getSubject());
        }
        if (message.getText() != null) {
            printWriter.println(message.getText());
        }
        printWriter.println(".");
        if (this.smtpErrorExists(bufferedReader, "250")) {
            throw new TransportException("Error: Message failed to be sent.\t" + this.smtpResponse);
        }
        printWriter.println("QUIT");
        printWriter.close();
    }

    public void setSmtpHost(String string) {
        this.smtpHost = string;
    }

    public void setSmtpPort(int n) {
        this.smtpPort = n;
    }

    private boolean smtpErrorExists(BufferedReader bufferedReader, String string) {
        try {
            this.smtpResponse = bufferedReader.readLine();
            return !this.smtpResponse.startsWith(string);
        }
        catch (IOException iOException) {
            return true;
        }
    }
}

