<?
/**
 * Arquivo de Exemplo da classe AJAX/PHP AutoComplete
 * Example file for AJAX Powered PHP auto-complete
 *
 * @author Rafael Dohms <rafael at rafaeldohms dot com dot br>
 * @package dmsAutoComplete
 * @version 1.0
 */
 
/**
* Funo de auxilio para exemplo, ela filtra o array
* retornando apenas as entradas que se iniciam com
* a string recebida
* 
* Filter function used in example, it filters an array
* returning only entries starting with the given string
*
* @param item
*/
function arrfilter(&$item){
	return preg_match('/^'.$_POST['string'].'/',$item);
}

//Criar documento XML atraves de DOM
//Create XML Doc through DOM
$xmlDoc = new DOMDocument('1.0', 'utf-8');
$xmlDoc->formatOutput = true;

//Criar elementos Raz do XML
//Create root XML element
$root = $xmlDoc->createElement('root');
$root = $xmlDoc->appendChild($root);

/**
 * :pt-br:
 * Definir Lista (itens) a ser mostrada.
 * 
 * Neste passo podemos realizar buscas em banco de dados, filtrar arrays
 * Ou qualquer outra tarefa que retorne um resultado baseado no string
 * recebido
 * 
 * :en:
 * Define list to be returned
 * 
 * In this step we could do a database search, filter arryas or perform
 * other actions which would return a resultig list based on an input
 * string
 */
if ($_POST['string'] != ''){
	//Fazer filtro ou busca
	//Filter ou search
	//SQL, Array, etc...
	$ostring = "O cuidado em identificar pontos crticos na revoluo dos costumes nos obriga  anlise dos conhecimentos estratgicos para atingir a excelncia. Acima de tudo,  fundamental ressaltar que o acompanhamento das preferncias de consumo cumpre um papel essencial na formulao dos procedimentos normalmente adotados. Podemos j vislumbrar o modo pelo qual a estrutura atual da organizao agrega valor ao estabelecimento dos mtodos utilizados na avaliao de resultados. 
			  No entanto, no podemos esquecer que a competitividade nas transaes comerciais possibilita uma melhor viso global das diretrizes de desenvolvimento para o futuro. Por conseguinte, a adoo de polticas descentralizadoras maximiza as possibilidades por conta das direes preferenciais no sentido do progresso. Nunca  demais lembrar o peso e o significado destes problemas, uma vez que o entendimento das metas propostas causa impacto indireto na reavaliao do retorno esperado a longo prazo. A prtica cotidiana prova que a percepo das dificuldades assume importantes posies no estabelecimento do fluxo de informaes.  claro que a execuo dos pontos do programa obstaculiza a apreciao da importncia do investimento em reciclagem tcnica. 
			  No obstante, a consulta aos diversos militantes oferece uma interessante oportunidade para verificao do remanejamento dos quadros funcionais. Neste sentido, a determinao clara de objetivos acarreta um processo de reformulao e modernizao das condies inegavelmente apropriadas. A certificao de metodologias que nos auxiliam a lidar com o desenvolvimento contnuo de distintas formas de atuao pode nos levar a considerar a reestruturao dos relacionamentos verticais entre as hierarquias. 
			  Gostaria de enfatizar que o consenso sobre a necessidade de qualificao representa uma abertura para a melhoria do oramento setorial. Pensando mais a longo prazo, o fenmeno da Internet estimula a padronizao dos paradigmas corporativos. O que temos que ter sempre em mente  que o desafiador cenrio globalizado talvez venha a ressaltar a relatividade do impacto na agilidade decisria. 
			  Assim mesmo, a expanso dos mercados mundiais aponta para a melhoria de todos os recursos funcionais envolvidos. O incentivo ao avano tecnolgico, assim como o julgamento imparcial das eventualidades faz parte de um processo de gerenciamento dos nveis de motivao departamental. Todavia, o novo modelo estrutural aqui preconizado desafia a capacidade de equalizao da gesto inovadora da qual fazemos parte.  importante questionar o quanto a valorizao de fatores subjetivos garante a contribuio de um grupo importante na determinao dos ndices pretendidos. O empenho em analisar a contnua expanso de nossa atividade auxilia a preparao e a composio das formas de ao. ";
	$available = array_unique(explode(" ",$ostring));
	
	$results = array_filter($available,'arrfilter');
	
	//Construir elementos ITEM
	//built ITEM elements
	foreach($results as $key=>$label){
		//Cadastrar na lista
		//Add to list
		$item = $xmlDoc->createElement('item');
		$item = $root->appendChild($item);
		$item->setAttribute('id',$key);
		$item->setAttribute('label',rawurlencode($label)); 
		//rawurlencode evita problemas de charset
		//rawurlencode avoids charset problems
	}
}


//Retornar XML de resultado para AJAX
//Return XML code for AJAX Request
header("Content-type:application/xml; charset=utf-8");
echo $xmlDoc->saveXML();
?>