<?php

function string($modo,$para1,$para2) {
	if($para1=="") return $para2;
	if($modo=='addslash') {
		if(substr($para1,-1)!='/') $para1.='/';
		return $para1;
	}
	if($modo=='int') {
		if(!is_int(intval($para1))) $para1=$para2;
		if($para1>$para2) $para1=$para2;	
		return $para1;
	}
}

function media($modo,$data1,$data2,$data3) {
    if($modo=="dias") {
        $seg=abs($data1-$data2);
        $dias=$seg/86400;
        return number_format($dias,0,'.','');
    }
    if($modo=="minutos") {
        $seg=abs($data1-$data2);
        $minutos=$seg/60;
        return number_format($minutos,0,'.','');
    }
    if($modo=="pordia") {
        $dias=abs($data1-$data2)/86400;
        if($dias<1) {
            $media=$data3;
        } else {
            $media=$data3/$dias;
        }
        return number_format($media,1,'.','');
    }
}

function barra($modo,$para1,$para2,$para3) {
    if($modo=="simple") {
        if($para3==0) {
            $cociente=0;
        } else {
            $cociente=number_format(($para1*$para2)/$para3,0,'.','');
        }
        $HTML='<img src="gif/bar_blue.jpg" valign="middle" border="0" height="10" width="'.$cociente.'">';
        return $HTML;
    }

    if($modo=="ratio") {
        if($para2+$para3==0) {
            $cociente1=0;
            $cociente2=0;
        } else {
            $cociente1=number_format($para1*$para2/($para2+$para3),0,'.','');
            $cociente2=number_format($para1*$para3/($para2+$para3),0,'.','');
        }
        if($para2<=$para3) {
            if($para2) {
                $para3=number_format($para3/$para2,0,'.','');
                $para2=1;
            } else {
                $para2='';
            }
        } else {
            if($para3) {
                $para2=number_format($para2/$para3,0,'.','');
                $para3=1;
            } else {
                $para3='';
            }
        }
        $HTML='<table class="textobar" border="0" cellspacing="0" cellpadding="0"><tr>';
        $HTML.='<td class="bar1" width="'.$cociente1.'" align="center">'.$para2.'</td>';
        $HTML.='<td class="bar2" width="'.$cociente2.'" align="center">'.$para3.'</td>';
        $HTML.='</tr></table>';
        return $HTML;
    }
}


function datos($modo,$ID,$data) {
    $archivo='data/'.$ID.'datos.dat';
    if($modo=="reset") {    //Se llama a ella misma en $modo="read" y $modo="write";
        if(file_exists($archivo)) {
            $datos=datos("read",$ID,0);
            $datos[0]=$datos[1]=0;
        } else {
            $datos[0]=$datos[1]=$datos[2]=$datos[3]=$datos[4]=$datos[5]=$datos[6]=$datos[8]=0;
            $datos[7]=time();
        }
        $ok=datos("write",$ID,$datos);
        return $ok;
    }
    if($modo=="read") {
        $fp=fopen($archivo,"r");
        $raw=fread($fp,filesize($archivo));
        fclose($fp);
        $datos=explode("||",$raw);
        return $datos;
    }
    if($modo=="write") {
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $raw=$data[0]."||".$data[1]."||".$data[2]."||".$data[3]."||".$data[4]."||".$data[5]."||".$data[6]."||".$data[7]."||".$data[8]."||";
        $ok=fwrite($fp,$raw);
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
}

function index($modo,$ID,$data1,$data2) {
    if($modo=="write") {
        if(file_exists("data/index.dat")) {
            $fp=fopen("data/index.dat","a");
        } else {
            $fp=fopen("data/index.dat","w");
        }
        flock($fp,2);
        $ok=fwrite($fp,$ID."||".$data1."||".$data2."||\n");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
    if($modo=="delete") {     //Llamada recursiva.
        $datos=index("search",$ID,0,0);
        $fp=fopen("data/index.dat","r");
        $raw=fread($fp,filesize("data/index.dat"));
        fclose($fp);
        $raw=str_replace($ID."||".$datos[0]."||".$datos[1]."||\n","",$raw);
        $fp=fopen("data/index.dat","w");
        flock($fp,2);
        $ok=fwrite($fp,$raw);
        fclose($fp);
        //Borramos todos los archivos asociados a ID
		unlink("data/".$ID."comentarios.dat");
		unlink("data/".$ID."datos.dat");
		unlink("data/".$ID."info.php");
		unlink("data/".$ID."ip.dat");
		unlink("data/".$ID."notas.dat");
        return $ok;
    }
    if($modo=="change") {     //Llamada recursiva.
        $datos=index("search",$ID,0,0);
        $fp=fopen("data/index.dat","r");
        $raw=fread($fp,filesize("data/index.dat"));
        fclose($fp);
        $raw=str_replace($ID."||".$datos[0]."||".$datos[1]."||\n",$ID."||".$data1."||".$data2."||\n",$raw);
        $fp=fopen("data/index.dat","w");
        flock($fp,2);
        $ok=fwrite($fp,$raw);
        fclose($fp);
        return $ok;
    }
    if($modo=="search") {
        if(!file_exists("data/index.dat")) return FALSE;
        $linea=file("data/index.dat");
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $index[$aux[0]]=$aux[1]."||".$aux[2]."||";
        }
        if(array_key_exists($ID,$index)) {
            $output=explode("||",$index[$ID]);
            return $output;
        } else {
            return FALSE;
        }
    }
    if($modo=="select") {
        $output="";
        $linea=file("data/index.dat");
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            if($aux[2]) $output.='<OPTION value="'.$aux[0].'">'.$aux[1].'</OPTION>';
        }
        return $output;
    }
}


function ip($modo,$ID,$data) {
    $archivo='data/'.$ID.'ip.dat';
    if($modo=="reset") {
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,"");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
    if($modo=="write") {
        $fp=fopen($archivo,"a");
        flock($fp,2);
        $ok=fwrite($fp,$data."||".time()."||\n");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
    if($modo=="update") {
        if(filesize($archivo)<10) return 1;
        $datos="";
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            if($aux[1]>$data) $datos.=$aux[0]."||".$aux[1]."||\n";
        }
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,$datos);
        fclose($fp);
        return $ok;
    }
    if($modo=="search") {
        if(filesize($archivo)<10) return 0;
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $ip[$aux[0]]=$aux[1];
        }
        if(array_key_exists($data,$ip)) {
            return $ip[$data];
        } else {
            return 0;
        }
    }
}


function notas($modo,$ID,$data1,$data2) {
    $archivo='data/'.$ID.'notas.dat';
    if($modo=="reset") {
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,"");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
    if($modo=="write") {
        $fp=fopen($archivo,"a");
        flock($fp,2);
        $ok=fwrite($fp,$data1."||".time()."||".$data2."||\n");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
    if($modo=="update") {
        if(filesize($archivo)<10) return -1;
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $notas[$aux[0]]=$aux[1]."||".$aux[2];
        }
        $notas[$data1]=time()."||".$data2;
        $datos="";
        foreach($notas as $key => $value) {
            if($value!="") $datos.=$key."||".$value."||\n";
        }
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,$datos);
        fclose($fp);
        return $ok;
    }
    if($modo=="search") {
        if(filesize($archivo)<10) return -1;
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $notas[$aux[0]]=$aux[1]."||".$aux[2]."||";
        }
        if(array_key_exists($data1,$notas)) {
            $output=explode("||",$notas[$data1]);
            return $output;
        } else {
            return -1;
        }
    }
    if($modo=="stats") {
		if(filesize($archivo)<5) return 0;
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $notas[$i++]=$aux[2];
        }
        foreach($notas as $value) {
            $output[$value]++;
            $sumatotal+=$value;
            $output[11]++;
        }
        $max=$output[14]=0;
        for($i=0;$i<=10;$i++) {
            if($output[$i]>$max) {
                $max=$output[$i];
                $output[14]=$i;
            }
        }
        $output[13]=number_format($sumatotal/$output[11],1,'.','');
        return $output;
    }
}

function comentarios($modo,$ID,$data1,$data2) {
    $archivo='data/'.$ID.'comentarios.dat';
    if($modo=="reset") {
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,"");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }

    if($modo=="read") {
        if(filesize($archivo)<10) {
            return 0;
        } else {
            $linea=file($archivo);
            return $linea;
        }
    }

    if($modo=="write") {
        $fp=fopen($archivo,"a");
        flock($fp,2);
        $ok=fwrite($fp,$data1[0]."||".$data1[1]."||".$data1[2]."||".$data1[3]."||".$data1[4]."||".$data1[5]."||\n");
        fclose($fp);
        @chmod($archivo,0666);
        return $ok;
    }
	
    if($modo=="delete") {     //Llamada recursiva.
        $linea=comentarios("read",$ID,0,0);
		foreach($linea as $raw) {
			$aux=explode("||",$raw);
			if($aux[1]==$data1) break;
		}
		$fp=fopen($archivo,"r");
        $raw=fread($fp,filesize($archivo));
        fclose($fp);
        $raw=str_replace($aux[0]."||".$aux[1]."||".$aux[2]."||".$aux[3]."||".$aux[4]."||".$aux[5]."||\n","",$raw);
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,$raw);
        fclose($fp);
        return $ok;
    }
	
    if($modo=="update") {
        $aux=$data1[0]."||".$data1[1]."||".$data1[2]."||".$data1[3]."||".$data1[4]."||".$data1[5]."||\n";
        $fp=fopen($archivo,"r");
        $raw=fread($fp,filesize($archivo));
        fclose($fp);
        $raw=str_replace($data2,$aux,$raw);
        $fp=fopen($archivo,"w");
        flock($fp,2);
        $ok=fwrite($fp,$raw);
        fclose($fp);
        return $ok;
    }
    if($modo=="search") {
        if(filesize($archivo)<10) return 0;
        $linea=file($archivo);
        foreach($linea as $raw) {
            $aux=explode("||",$raw);
            $comentarios[$aux[0]]=$aux[0]."||".$aux[1]."||".$aux[2]."||".$aux[3]."||".$aux[4]."||".$aux[5]."||\n";
        }
        if(array_key_exists($data1,$comentarios)) {
            return $comentarios[$data1];
        } else {
            return 0;
        }
    }
}

function config($modo,$data1,$data2) {
    $fp=fopen("config.php","r");
    $raw=fread($fp,filesize("config.php"));
    fclose($fp);
    if($modo=="simple") {
        $raw=str_replace($data1,$data2,$raw);
    }
    if($modo=="parcial") {
        $raw=str_replace($data1,$data2,$raw);
    }
    $fp=fopen("config.php","w");
    flock($fp,2);
    $ok=fwrite($fp,$raw);
    fclose($fp);
    return $ok;
}

function cookies($modo,$ID,$data) {
    $cookie='topo'.$ID;
    global $$cookie;
    if($modo=="read") {
        if(isset($$cookie)) {
            return $$cookie;
        } else {
            return 0;
        }
    }
    if($modo=="write") {
        $ok=setcookie($cookie,time(),time()+$data,"/");
        return $ok;
    }
}

function orden($modo,$criterio) {
    if($modo=="update") {
        $linea=file("data/index.dat");
        foreach($linea as $raw) {
            $data=explode("||",$raw);
            if($data[2]) {
                $datos=datos("read",$data[0],0);
                //Ordenamos los votos.
                $ceros[6]="0"; $ceros[5]="00"; $ceros[4]="000";
                $ceros[3]="0000"; $ceros[2]="00000"; $ceros[1]="000000";
                //Reconstruimos la linea completando con ceros hasta 6 cifras.
                $datos[$criterio]=$ceros[strlen($datos[$criterio])].$datos[$criterio];
                $desorden[$i++]=$datos[$criterio]."||".$data[0]."||";
            }
        }
        rsort($desorden);
        $i=1;
        foreach($desorden as $valor) {
            $aux=explode("||",$valor);
            $orden[$i++]=$aux[1];
        }
        $data_bin=serialize($orden);
        $fp=fopen("data/orden.dat","w");
        flock($fp,2);
        fwrite($fp,$data_bin);
        fclose($fp);
        @chmod("data/orden.dat",0666);
        return $orden;
    }
    if($modo=="read") {
        $fp=fopen("data/orden.dat","r");
        $data=fread($fp,filesize("data/orden.dat"));
        fclose($fp);
        return unserialize($data);
    }
}

?>