<?php
/*
 @Autor    : Dyego Fernandes de Sousa
 @Date     : 2005-06-16 (16/06/2005)
 @Title    : OO in PHP (Programao Orientada  Objetos em PHP)
 @SubTitle : Bd Connect and Reports (Conexo  Banco de Dados e Relatrios)
 @License  : GNU (Public License)
 @email    : dyegofernandes@centauronet.com.br, dyegofern@hotmail.com

 Classe para gerar Relatrios, por enquanto, estou apenas conectando ao banco SQL Server da Microsoft e
 MySQL mas, logo aps terminar a confeco dos tipos de relatrios irei disponibilizar conexo para 
 bancos Oracle, PostgreSQL e FireBird e mais algum banco de dados que eu encontrar por ai.
 {
   Classe to generate Reports. Only supports SQL server. 
 }
*/
class Relatorio{
// String para selecionar a Arquitetura do Banco de Dados (MSSQL,MYSQL,FIREBIRD,etc...)
// { String to select the DB type }
 var $tipo_db; 
// Host de conexo com o Banco de Dados
// { Host of the Server DB }
 var $serv_db; 
// Nome do Banco de Dados (Exemplo: Banco_Teste)
// { Name for the DB (for example: Test_Base) } 
 var $nome_db; 
// Nome do Usurio do Banco de Dados
// { Name of the User } 
 var $user_db; 
// Senha do Banco de Dados
// { Password to DB } 
 var $pass_db; 
// Uma String de Consulta SQL
// { A SQL String }
 var $sql;     
// Titulo do Relatrio
// { Report Title } 
 var $titulo;  
// id da conexo com O BD
// { id to the Connection } 
 var $conn;    
// Valor inicial para o lote de registros
// { Initial value to the Record Batch }
 var $qtd_lote = 1;
// Nmero total de Pginas do Relatrio
// { Number of Report Pages }
 var $paginas;
 var $linhas_Pagina;

 /*
   Funo de Tratamento de Erros
   { Function to handle the Errors }
 */
 function Erro($nerro){
   switch($nerro){
    case 0: {
	 //Erro de conexo Ao Servidor de banco de Dados
	 //{ Error in Server BD connection }
	 $msgInicio = "<div style='border:solid red 1px; background-color: beige; width: 770; color: blue; font-family: verdana; font-size:90%'><center><< <b>DFS</b> PhP - Reports >><br>";
	 $msgFinal  = "<center></div>";
	 $msgCorpo  = "ERRO :: <b style='color:red'>".$nerro." </b>::<br/>NO FOI POSSVEL CONECTAR AO SERVIDOR DE BANCO DE DADOS.";
	 $strerro   = @mssql_get_last_message();
	 $msgCorpo .= $strerro;
     $msg       = $msgInicio.$msgCorpo.$msgFinal;
	 print($msg);
	 exit;
	 break;
	}
	case 1:{
	 //Erro de conexo Ao banco de Dados
	 //{ Error in the BD connection }
	 $msgInicio = "<div style='border:solid red 1px; background-color: beige; width: 770; color: blue; font-family: verdana; font-size:90%'><center><< <b>DFS</b> PhP - Reports >><br>";
	 $msgFinal  = "<center></div>";
	 $msgCorpo  = "ERRO :: <b style='color:red'> ".$nerro."</b>::<br/>NO FOI POSSVEL CONECTAR AO BANCO DE DADOS.";
	 $strerro   = @mssql_get_last_message();
	 $msgCorpo .= $strerro;
	 $msg       = $msgInicio.$msgCorpo.$msgFinal;
	 print($msg);
	 exit;
	 break;
	}
    case 2:{
	 //Erro de consulta
	 //{ Error in the query }
	 $msgInicio = "<div style='border:solid red 1px; background-color: beige; width: 770; color: blue; font-family: verdana; font-size:90%'><center><< <b>DFS</b> PhP - Reports >><br>";
	 $msgFinal  = "<center></div>";
	 $msgCorpo  = "ERRO ::  <b style='color:red'>".$nerro." </b>::<br/>ERRO NA CONSULTA SQL.<br/>";
	 $strerro   = @mssql_get_last_message();
	 $msgCorpo .= $strerro;
	 $msg       = $msgInicio.$msgCorpo.$msgFinal;
	 print($msg);
	 exit;
	 break;
	}
	case 3:{
	 //Tipo_db foi passado em Branco ou invlido
	 //{ Tipo_db (Type of the DB) is invalid }
	 $msgInicio = "<div style='border:solid red 1px; background-color: beige; width: 770; color: blue; font-family: verdana; font-size:90%'><center><< <b>DFS</b> PhP - Reports >><br>";
	 $msgFinal  = "<center></div>";
	 $msgCorpo  = "ERRO :: <b style='color:red'> ".$nerro."</b>::<br/>TIPO DE BANCO DE DADOS NO SELECIONADO OU INVLIDO.";
	 $strerro   = @mssql_get_last_message();
	 $msgCorpo .= $strerro;
	 $msg       = $msgInicio.$msgCorpo.$msgFinal;
	 print($msg);
	 exit;
	 break;
	}	
   }
 }
 /*
  Essa Funo conecta ao Banco de Dados. Se o usurio passar o parmetro mssql para a classe ele se conceta
  no banco de dados SQL SERVER, se ele passar o parmetro mysql ele se conecta ao banco de dados MySQL
  { 
   This function connects to DB. if the user pass the parameter mssql to the class, it connects in a SQL 
   SERVER DB, if he pass the parameter mysql it connects in a MySQL BD
  }
 */
 function conectaDB(){
  //Teste se o Parmetro tipo_db foi passado em branco
   if(trim($this->tipo_db,'') == ''){
    $this->Erro(3);
   }
   if(strtoupper($this->tipo_db) == 'MSSQL'){
    if(!$conn = @mssql_connect($this->serv_db,$this->user_db,$this->pass_db)){
	  return $this->Erro(0);
	}
	if(!@mssql_select_db($this->nome_db,$conn)){
	  return $this->Erro(1);
	} else {
	         $this->conn = $conn;
	         return true;
		   }
   }
   if(strtoupper($this->tipo_db) == 'MYSQL'){
    $conn = @mysql_connect($this->serv_db,$this->user_db,$this->pass_db) or die ("Erro ao conectar Ao Servidor de Banco de Dados");
	if(!@mysql_select_db($this->nome_db,$conn)){
	  return $this->Erro(2);
	} else {
	         return true;
		   }
   }
   
 }
/*
 Realiza a consulta no Banco de Dados
 { Resolve a Query in the DB }
*/ 
 function consultaSQL(){
   if(!$res   = @mssql_query($this->sql,$this->conn,$this->linhas_Pagina)){
    return $this->Erro(2);
   } else{ for($i=1; $i < $this->qtd_lote; $i++){
             @mssql_fetch_batch($res);
			}
           return $res;
         }
 }
/*
 Iprime na tela a Tabela Resultante do Produto Cartesiano realizado pela Consulta SQL
 { Shows the product from SQL query with a table }
*/  
function montaTabela($pagina = 1){
  print($this->retTabela());
 }
/*
 Imprime na tela o Cabealho com uma imagem, ambos passados como parmetros
*/
function cabecalho($imagem, $titulo){
 $cabecalho = "<table><tr><td><img src='".$imagem."' /></td><td style='font-family:verdana;font-size:150%'>".$titulo."</td></tr></table>";
 print($cabecalho);
}
/*
 Conta linhas e colunas, Chama a execuo da Query e retorna uma string com o HTML da tabela
 Montado.
 { Count the lines and columns, call the Query execution an returns a String with the HTML for the table }
*/ 
 function retTabela(){
  $resultado2 = @mssql_query($this->sql);
  $tlinhas    = @mssql_num_rows($resultado2);
  
  $resultado  = $this->consultaSQL();
  $linhas     = @mssql_num_rows($resultado);
  $colunas    = @mssql_num_fields($resultado);

  $paginas   = ceil($tlinhas/$this->linhas_Pagina);
  $this->paginas = $paginas;
  
  $texto = "<table style='font-size:70%; font-family:verdana; width:950px'>\n";
  $texto.= '<tr><td colspan="'.$colunas.'" align="center" style="font-family:verdada; font-size:140%"><b>'.$this->titulo.'<b></td></tr>';
  for($i=-1;$i<$linhas;$i++){
  if($i % 2 == 0){
	 $cor = 'lightblue';
	} else {
	         $cor = '';
	       }

   $texto .= "<tr style='border:solid black 1px'>\n";
   for($j=0;$j<$colunas;$j++){
    if($i == -1){
	 $texto .= '<td style="background-color:gray; color:white; border:solid blue 1px; font-size: 102%" ><b><center>'.@mssql_field_name($resultado,$j).'</center></b></td>';
	} else {
	         if(@mssql_result($resultado,$i,@mssql_field_name($resultado,$j)) == ''){
			  $valor = 'NULL';
			 } else {
			          $valor = @mssql_result($resultado,$i,@mssql_field_name($resultado,$j));
					  if (@mssql_field_type($resultado,$j) == 'money'){
					   $valor = 'R$ '.number_format($valor,2,',','.');
					  }
			        }
			 $texto .= '<td style="background-color:'.$cor.';border:solid blue 1px" >'.$valor.'</td>';
	       }
   }
   $texto .= '</td>';
   if($colunas == $j){
    $texto .= "\n</tr>\n"; 
   }
  }
  $texto .= "\n</table>\n";
  $texto .= "\n<table style='font-size:70%; font-family:verdana; width:950px'>\n";
  $texto .= "\n<tr><td align='right'>Pgina <b>".$this->qtd_lote."</b> de <b>".$this->paginas."</b></td></tr>\n";
  $texto .= "\n</table>\n";
  return $texto;
 }

function RetQtdlote(){
 return $this->qtd_lote;
}

/*
 Construtor {Constructor}
*/  
 function Relatorio($tipo_db,$serv_db,$nome_db,$user_db,$pass_db,$sql,$titulo,$linhas_pagina=20,$lote=1){
  $this->tipo_db       = $tipo_db; // Atribui os Valores              { set the values what
  $this->serv_db       = $serv_db; // Passados por parmetro            are passed with parameter
  $this->nome_db       = $nome_db; // para a nova                       to the new instance
  $this->user_db       = $user_db; // Instncia da                      of the
  $this->pass_db       = $pass_db; // Classe                            class }
  $this->sql           = $sql;     // String de Consulta SQL           { String SQL }
  $this->titulo        = $titulo;  // Titulo                           { Title of the Report}
  $this->qtd_lote      = $lote;    // Inicializa/Atualiza o lote atual { Start or update the batch }
  $this->linhas_Pagina = $linhas_pagina;
  $this->conectaDB();           // Conecta-se ao Banco de Dados     { Connects with the DB }
 }
}
/*
 Exemplo de utilizao:
 {Example}
 #Instruo SQL {SQL Query}
 $sql    = 'Select * from users';
 #Ttulo {Title}
 $titulo = 'Relatrio de Usurios';
 #Linhas por pagina {Lines per Page}
 $linhas_pagina = 20;
 #Lote atual {This batch}
 $lote = NULL;
 if($lote == NULL){
   $relatorio = new Relatorio('mssql','192.***.*.***','******','******','*****',$sql,$titulo,$linhas_pagina);
  else {
         $relatorio = new Relatorio('mssql','192.***.*.***','******','******','*****',$sql,$titulo,$linhas_pagina,$lote);
       }
*/
?>