<?php

	// hold the moment! ;-)
	$now = gmmktime();

	// summertime?
	$lt = localtime( $now, 1 );
	$is_dst = $lt["tm_isdst"];

	$now_year  = intval( gmdate( "Y", $now ) );
	$now_month = intval( gmdate( "m", $now ) );
	$now_day   = intval( gmdate( "d", $now ) );
	$now_hour  = gmdate( "H", $now );
	$now_min   = gmdate( "i", $now );
	$now_sec   = gmdate( "s", $now );

	
	// global variables (have to be fitted)
	require ("globals.inc.php");

	// (If exists) include localization file for the favoured language
	if ( file_exists( "language/" . $language . ".inc.php" ) )
		$loc_lang = $language; 
	else
		$loc_lang = $default_language; 

	require ( "language/" . $loc_lang . ".inc.php" );

	if ( $data_source == "mysql" )
	{
		// include class for database support
		require ( "mysql.inc.php" );

		// prepare objects for database access
		// list of subscribers which signed in/off
		$calendar_list           = new mysql;
		$calendar_list->name     = $calendar_file;
		$calendar_list->server   = $db_server;
		$calendar_list->login    = $db_login;
		$calendar_list->password = $db_password;
		$calendar_list->database = $db_database;
		$calendar_list->init();
		$calendar_list->order_criterion = "event_start";

		$event_list           = new mysql;
		$event_list->name     = $event_file;
		$event_list->server   = $db_server;
		$event_list->login    = $db_login;
		$event_list->password = $db_password;
		$event_list->database = $db_database;
		$event_list->init();
	}

	if ( $data_source == "csvfile" )
	{
		// include class for CSV-textfile support
		require ( "csvfile.inc.php" );

		// prepeare objects for file access
		// list of subscribers which signed in/off
		$calendar_list        = new csvfile;
		$calendar_list->name  = $calendar_file;
		$calendar_list->init();
		
		$event_list        = new csvfile;
		$event_list->name  = $event_file;
		$event_list->init();
	}

	if ( !empty( $HTTP_GET_VARS[ "Y" ] ) )
		$cal_year = $HTTP_GET_VARS[ "Y" ];
	else 
		$cal_year = $now_year;
	
	if ( !empty( $HTTP_GET_VARS[ "m" ] ) )
		$cal_month = $HTTP_GET_VARS[ "m" ];
	else 
		$cal_month = $now_month;

	if ( !empty( $HTTP_GET_VARS[ "d" ] ) )
		$cal_day = $HTTP_GET_VARS[ "d" ];
	else 
		$cal_day = $now_day;
	
	// calc following month and year
	$cal_next_year = $cal_year;
	if ( $cal_month < 12 )
	{
		$cal_next_month = $cal_month + 1;
	} 
	else 
	{
		$cal_next_month = 1;
		$cal_next_year = $cal_year + 1;
	}
	
	// calc previous month and year
	$cal_prev_year = $cal_year;
	if ( $cal_month > 1 )
	{
		$cal_prev_month = $cal_month - 1;
	} 
	else 
	{
		$cal_prev_month = 12;
		$cal_prev_year = $cal_year - 1;
	}	
	
	function num_days( $year, $month )
	{
		$num = 31;
		while (!checkdate( $month, $num, $year ) ) { $num--; }
		return $num;	
	}
?>
