#!/usr/bin/perl

use Time::Local;

# Config variables will be stored in %varhash, then, for each file listed
#  in @filelist, filename.in will be read, replacing all occurrences of
#  "<<varname>>" with $varhash{"varname"} and writing the results to filename

@filelist = ("Makefile", "php-utils/Make.common", "sql-dumps/srccalendar.sql",
	"sql-dumps/auth.sql", "auth/sql/sql.php3", "calendar/sql/sql.php3" );

@time_arr = localtime;
$time_arr[0] = 0;
$time_arr[1] = 0;
$time_arr[2] = 0;
$varhash{"configdate"} = timelocal(@time_arr);

$varhash{"psql"} = getProgPath("psql");
$varhash{"createdb"} = getProgPath("createdb");
$varhash{"createuser"} = getProgPath("createuser");
$varhash{"dbuser"} = promptUser("Username that can create databases and database users", "postgres");
$varhash{"wwwdir"} = promptUser("Path to install auth and calendar", "/var/www");
$varhash{"owner"} = promptUser("Owner of source files and auth executables", "root");
$varhash{"group"} = promptUser("Group of source files and auth executables", "www");
$varhash{"phputils"} = promptUser("Directory to install auth-module executables", "/usr/local/php3");
$varhash{"authmod"} = promptUser("Authenication module, such as auth-shadow.php3, auth-pam.php3, or auth-nis.php3", "auth-shadow.php3");

if ($varhash{"authmod"} eq "auth-shadow.php3")
{
	$varhash{"getpwinfo"} = $varhash{"phputils"} . "/getpwinfo";
	$varhash{"getuidinfo"} = $varhash{"phputils"} . "/getuidinfo";
	$varhash{"chkpass"} = $varhash{"phputils"} . "/getshcrypt";
}
elsif ($varhash{"authmod"} eq "auth-pam.php3")
{
	$varhash{"getpwinfo"} = $varhash{"phputils"} . "/getpwinfo";
	$varhash{"getuidinfo"} = $varhash{"phputils"} . "/getuidinfo";
	$varhash{"chkpass"} = $varhash{"phputils"} . "/chkpass";
}
elsif ($varhash{"authmod"} eq "auth-nis.php3")
{
	$varhash{"getpwinfo"} = $varhash{"phputils"} . "/getpwinfo.pl";
	$varhash{"getuidinfo"} = $varhash{"phputils"} . "/getpwinfo.pl";
	$varhash{"chkpass"} = $varhash{"phputils"} . "/runshcrypt";
}
else
{
	print("I don't recognize the auth module you specified, so...\n");
	$varhash{"getpwinfo"} = promptUser("getpwinfo", $varhash{"phputils"} . "/getpwinfo");
	$varhash{"getuidinfo"} = promptUser("getuidinfo", $varhash{"phputils"} . "/getuidinfo");
	$varhash{"chkpass"} = promptUser("chkpass", $varhash{"phputils"} . "/getshcrypt");
}
$varhash{"authtarget"} = $varhash{"authmod"};
$varhash{"authtarget"} =~ s/\.php3$//;

$varhash{"adminid"} = promptUser("User ID to grant admin access", $<);

$varhash{"sslreq"} = promptUser("SSL required for logins? (Y/N)", "Y");
if (($varhash{"sslreq"} eq "Y") || ($varhash{"sslreq"} eq "y"))
{
	$varhash{"sslreq"} = 1;
}
else
{
	$varhash{"sslreq"} = 0;
}

$varhash{"installcss"} = promptUser("Install basic.css stylesheet? (Y/N)", "Y");
if (($varhash{"installcss"} eq "Y") || ($varhash{"installcss"} eq "y"))
{
	$varhash{"installcss"} = "install-css";
	$varhash{"css"} = "../basic.css";
}
else
{
	$varhash{"installcss"} = "";
	$varhash{"css"} = promptUser("Path to stylesheet, relative to index.php3", "../basic.css");
}

$varhash{"authdb"} = promptUser("Database for auth tables", "auth");
$varhash{"caldb"} = promptUser("Database for calendar tables", "srccalendar");
$varhash{"dbro"} = promptUser("Read-only user for $authdb and $caldb database", "guest");
$varhash{"dbrw"} = promptUser("Read-write user for $authdb and $caldb database", "srccalendar");


print <<"EOF";

Using the following configuration:
             Path to psql: $varhash{"psql"}
         Path to createdb: $varhash{"createdb"}
       Path to createuser: $varhash{"createuser"}
Installing php3 source to: $varhash{"wwwdir"}
 Installing auth utils to: $varhash{"phputils"}
               Stylesheet: $varhash{"css"}
 User to create databases: $varhash{"dbuser"}
 Owner of installed files: $varhash{"owner"}
 Group of installed files: $varhash{"group"}
        Using auth module: $varhash{"authmod"}
                getpwinfo: $varhash{"getpwinfo"}
               getuidinfo: $varhash{"getuidinfo"}
                  chkpass: $varhash{"chkpass"}
  SSL required for logins: $varhash{"sslreq"}
            Admin user ID: $varhash{"adminid"}
            Auth database: $varhash{"authdb"}
        Calendar database: $varhash{"caldb"}
           Read-only user: $varhash{"dbro"}
          Read-write user: $varhash{"dbrw"}
EOF

for $file (@filelist)
{
	print("Generating $file...\n");
	open(INFILE, "$file.in") or die "Can't open $file.in for reading";
	open(OUTFILE, ">$file") or die "Can't open $file for writing";

	while ($line = <INFILE>)
	{
		$line =~ s/\<\<([^>]*?)\>\>/$varhash{$1}/g;
		print(OUTFILE $line);
	}
	close(INFILE);
	close(OUTFILE);
}


# Prompt the user with the argument to the function, return what they enter.
sub promptUser
{
	my $prompt = shift;
	my $default = shift;
	my $result = "";

	print("$prompt " . ($default ? "[$default]" : "") . ": ");
	chomp($result = <STDIN>);

	if ($result eq "")
	{
		$result = $default;
	}

	return $result;
}

# Try to find the program named in the function call using which.
# If what's found is not executable, prompt the user.
sub getProgPath
{
	my $progname = shift;
	my $prog = "";

	chomp($prog = `which $progname`);

	if ( !-x "$prog" )
	{
		print("Can't find $progname.\n");
		$prog = promptUser("Please enter the full path to $progname");
		if ( !-x "$prog" )
		{
			print("\"$prog\" is not executable by the current user, but I'll take your word for it.\n");
		}
	}
	else
	{
		print("$progname found at: $prog\n");
	}

	return $prog;
}
