<?php
//  Simon's Rock Web Calendar
//  Copyright (C) 1999-2000 Ryan Krebs and Simon's Rock College of Bard
//  Please read the accompanying files "COPYING" and "COPYRIGHT"
//  for more information

if( !isSet( $BOX_INCLUDED ) ) {
	$BOX_INCLUDED = 1;

// This is a pretty generic class that the real boxes will inherit from
	class SRCBox {
// login_required tells us if a session should exist for the box to be active
// login_url is the page to point to if a login is required
// action is what the box is doing ( login, submit, etc )
// perms is permissions
// action_url is the url to use in the form tag
// uses_headers is whether or not the box needs to be parsed before sending html
// error and during are used if there's an error to report while outputting results
// help_available tells the help box whether or not to display help for this box
//  help_topic is what to list the help as.
		var $login_required, $action_url, $session_var,
			$uses_headers, $error, $during,
			$help_available, $help_topic;

		function SRCBox( $new_action_url = "", $new_session_var = "",
				$new_login_req = 0 ) {
			$this->action_url = $new_action_url;
			$this->login_required = $new_login_req;
			$this->session_var = $new_session_var;
			$this->uses_headers = 0;
			$this->help_available = 0;
			$this->error = "";
		}

// not allowed to approve anything
		function outputPDeniedNotice() {
?>
You are not allowed to use this box.  If you think
you've received this message in error, you can try logging in,
or send an email to 
<? echo "<A HREF=\"mailto:" . $GLOBALS["CONFIG"]["errormailto"] . "\">" . $GLOBALS["CONFIG"]["errormailto"]. "</A>"; ?>
<?php
		}

// The form action may place the action variable in the url, or it could
// be placed in a hidden input.  Things like searches should use the url
// so they can be bookmarked
		function outputBox() {
?>
<P>This is a box.</P>
<FORM METHOD=POST ACTION="<?php echo $this->action_url ?>">
<INPUT TYPE=hidden NAME="form_action" VALUE="click">
<INPUT TYPE=submit VALUE="Click me">
</FORM>
<?php
		}

// Parse the submitted stuff before html is output
		function parseBox() {
			return;
		}

// This will probably be used on the right side of the page
		function outputResults() {
			if ( isSet( $GLOBALS["form_action"] ) ) {
				echo( "<P>You clicked in the box.</P>\n" );
			} else {
				echo( "<P>Click in the box.</P>\n" );
			}
		}

		function outputHelp() {
		}

		function verifyPermissions() {
			return 1;
		}
	}
}
?>
