<?php
/*
Autor: Theofilo Brito
Data: 29/07/2002
-------------------------------------------
Verso: 1.0
-------------------------------------------
Descrio: Esta classe busca o endereo pelo CEP na pgina do correios...   ...se for utilizar em seu site,
no esqueca de colocar a logomarca do busca cep em seu site...  ...mais detalhes veja 
em http://www.correios.com.br/servicos/cep/Download_busca_CEP.cfm
-------------------------------------------
obs:  necessrio o modulo curl estar ativo
*/

class BUSCACEP{
	// propriedades
	var $CEP;
	var $UF;
	var $LOCALIDADE;
	var $LOGRADOURO;
	var $BAIRRO;
	var $ERRO; // 1 - Cep nao est cadastrado //2 - mudana no layout site correio
	
	function post_url_correios(){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, "http://www.correios.com.br/servicos/cep/Resultado_CEP.cfm");
		curl_setopt($ch, CURLOPT_FAILONERROR, 1);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 40); // segundos 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1); 
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS,"CEP=" . $this->CEP);
		$result=curl_exec ($ch);
		curl_close ($ch);
		return $result;
	}
	
	
	function extract_result( $page_result){
		function extract_next_field(&$dados){
			$pos = strpos($dados, "<TD>");
			$dados = substr($dados, $pos);
			$pos = strpos($dados, "</TD>");
			$result = substr($dados, 4, $pos - 4); 
			$dados =  substr($dados, $pos);
			return $result;
		}
		
		$dados = $page_result;
		$pos = strpos( $dados, $this->CEP);
		if( !($pos > 0) ){
			$this->ERRO = 2;
			return "";
		}
		$dados = substr( $dados, $pos);
		$pos = strpos($dados, "</tr>");
		$dados = substr( $dados,1, $pos);
		
		// Pegar Estado
		$this->UF = extract_next_field($dados);
		
		// Pegar Localidade
		$this->LOCALIDADE = extract_next_field($dados);
		
		//Pegar logradouro
		$this->LOGRADOURO = extract_next_field($dados);
		
		//Pegar Bairro
		$this->BAIRRO = extract_next_field($dados);
	}

	//constructor
	function BUSCACEP( $cep ){
			if(!empty($cep) ){
				$this->CEP = $cep;
				$page_result = $this->post_url_correios();
				$pos = strpos( $page_result, "no est cadastrado");
				if($pos > 0){
					$this->ERRO = 1;				
				} else {
					$this->extract_result( $page_result );
				}
			}
	}
};
?>
