<?

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

# Gecko Search-Tab

# This file generated a XUL file send to the browser, in a view to have a native GUI.
# XUL works on Gecko based browser : Mozilla, Netscape 6+, Galeon, Konqueror, Phoenix, ...

# created by Etienne Juliot, gizmoo@laposte.net at 2002-10-30


include("inc/common.php"); 

CheckAuth('read');

if ($text == 'dos') $eol = "\r\n"; else $eol = "\n";   # end of line

header("Content-type: application/vnd.mozilla.xul+xml; charset=iso-8859-1");

echo("<?xml version=\"1.0\" encoding=\"$env[doc_encoding]\"?>$eol");

$now = date('Y-m-d H:i:s');
echo ("<!-- generated by Bookmark4U version $env[version] at $now -->$eol");

echo ("<?xml-stylesheet href=\"chrome://global/skin/\" type=\"text/css\"?>$eol");

echo ("<window id=\"Bookmark4U\" title=\"Bookmark4U\"
        xmlns:html=\"http://www.w3.org/1999/xhtml\"
        xmlns=\"http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul\">$eol");

XulAddScript();

echo ("<tree id=\"bookmarkTree\" flex=\"1\" seltype=\"single\" onselect=\"redirect()\">$eol");

XulAddTitle();

echo("  <treechildren>$eol");

$result = $mgr->findAllItems(null, 'type DESC, title ASC');
$rootTree = CreateTree($result, 0);

XulBookmarks($rootTree, 1);
echo("  </treechildren>$eol");
      
echo ("</tree>$eol");

# add the button to redirect to list.php
echo ("<button label=\"$lang[edit]\" oncommand=\"javascript:window._content.location='list.php';\"/>$eol");
# add the button to add a bookmark (redirect to quickmark). 
//echo ("<button label=\"$lang[add]\" oncommand=\"javascript:void(open('$env[sitehome]/bookmark.php?userid=$env[user]&url='+escape(window._content.location)+'&pagetitle='+escape(window._content.title)+'&dummy='+Math.random(),'bookmark4u','width=600,height=400,scrollbars=1,resizable=1'));\"/>$eol");


# end of xul window
echo ("</window>$eol");

echo("<!-- $cnt_b bookmarks, $cnt_c folders -->$eol");
//exit;

# add name of columns
function XulAddTitle() {
  global $eol, $lang, $env;
  
  echo ("  <treecols>$eol");
  echo ("    <treecol id=\"title\" label=\"$lang[title]\" primary=\"true\" flex=\"3\" persist=\"width ordinal hidden\"/>$eol");
  echo ("    <splitter class=\"tree-splitter\"/>$eol");
  echo ("    <treecol id=\"url\" label=\"$lang[url]\" flex=\"1\" hidden=\"false\" persist=\"width ordinal hidden\"/>$eol");
  echo ("    <splitter class=\"tree-splitter\"/>$eol");
  echo ("    <treecol id=\"comment\" label=\"$lang[comment]\" flex=\"1\" hidden=\"true\" persist=\"width ordinal hidden\"/>$eol");

  echo ("  </treecols>$eol");
}

# add javascript to enable redirect
function XulAddScript() {
	echo ("<script type=\"application/x-javascript\">

function redirect()
{
  var tree = document.getElementById('bookmarkTree');
  var item = tree.currentIndex;
  var url = tree.view.getCellText(item, \"url\");
  if ( url.length > 0 )
	window._content.location = url;
}

</script>
");
}

  
# generate a XUL file for bookmarks under the parent folder
function XulBookmarks($parent, $indent) {
  global $env;
  global $eol;
  global $cnt_b, $cnt_c;
  global $exp_private;
  
  $indentstr = "  ";
  $sp = "";
  for ($j = 0; $j <= $indent; $j++) { $sp .= $indentstr; }

  while (list($key, $row) = each($parent[children])) {
  
  //while ($row = $result->fetchRow()) {

    # skip if 'do not export private items' and 'this is private'
    //if (!$exp_private && !$row[public]) continue;

    $title   = ereg_replace("&", "&amp;", $row[title]);
    $url     = ereg_replace("&", "&amp;", $row[url]);
    $comment = ereg_replace("&", "&amp;", $row[comment]);

    $title   = ereg_replace("<", "&lt;", $title);
    $url     = ereg_replace("<", "&lt;", $url);
    $comment = ereg_replace("<", "&lt;", $comment);

    $title   = ereg_replace(">", "&gt;", $title);
    $url     = ereg_replace(">", "&gt;", $url);
    $comment = ereg_replace(">", "&gt;", $comment);

    $title   = ereg_replace("\"", "&quot;", $title);
    $url     = ereg_replace("\"", "&quot;", $url);
    $comment = ereg_replace("\"", "&quot;", $comment);

    if ($row[type] == 'c') {  # folder
      $cnt_c++;
      
      echo("$sp<treeitem container=\"true\">$eol");
      echo("$sp$indentstr<treerow>$eol");
      echo("$sp$indentstr$indentstr<treecell label=\"$title\"/>$eol");
      echo("$sp$indentstr$indentstr<treecell/>$eol");
      echo("$sp$indentstr$indentstr<treecell label=\"$comment\"/>$eol");
      echo("$sp$indentstr</treerow>$eol");

      echo("$sp$indentstr<treechildren>$eol");
      XulBookmarks($row, $indent+2);
      echo("$sp$indentstr</treechildren>$eol");

      echo("$sp</treeitem>$eol$eol");
      
    } else if ($row[type] == 'b') { # bookmark
      $cnt_b++;
      
      echo("$sp<treeitem>$eol");
      echo("$sp$indentstr<treerow>$eol");
      echo("$sp$indentstr$indentstr<treecell label=\"$title\"/>$eol");
      echo("$sp$indentstr$indentstr<treecell label=\"$url\"/>$eol");
      echo("$sp$indentstr$indentstr<treecell label=\"$comment\"/>$eol");
      echo("$sp$indentstr</treerow>$eol");
      echo("$sp</treeitem>$eol");
     
    }
  }
}

