<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('bkpath', 'mode', 'page', 'sort', 'type');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write');

function Head1() {
  global $env, $lang;
  global $mode, $type, $bkpath;

  $color1 = ($type == 'b') ? $env[th] : $env[td];
  $color2 = ($type == 'c') ? $env[th] : $env[td];
  $color3 = ($mode == 'recent')   ? $env[th] : $env[td];
  $title1 = ($type == 'b') ? "<b>$lang[bookmark]</b>" : $lang[bookmark];
  $title2 = ($type == 'c') ? "<b>$lang[folder]</b>" : $lang[folder];
  $title3 = ($mode == 'recent')   ? "<b>$lang[recent]</b>" : $lang[recent];
  $parm = "";
  if ($page) $parm .= "&page=$page";
  if ($bkpath) $parm .= "&bkpath=$bkpath";

  echo("<table border=0 cellpadding=3 cellspacing=1 width=100%>
<tr>
<td bgcolor='$color3' align='center' width='34%'><a href='visited.php?mode=recent'>$title3</a><sup>[R]</sup></td>
<td bgcolor='$color2' align='center' width='33%'><img src='$env[icon_fo]' align='top'><a href='visited.php?mode=folder$parm'>$title2</a><sup>[F]</sup></td>
<td bgcolor='$color1' align='center' width='33%'><img src='$env[icon_bk]' align='top'><a href='visited.php?mode=bookmark$parm'>$title1</a><sup>[B]</sup></td>
</tr>
</table>\n");
}
  
# if (!$mode) { # visited bookmark or visited folder
#   $vmode = GetCookie('VISITED_MODE');
#   if ($vmode) $mode = $vmode;
#   else $mode = 'recent'; # default mode
# } else {
#   $vmode = GetCookie('VISITED_MODE');
#   if ($vmode != $mode) { # remember type in cookie
#     PutCookie("VISITED_MODE", $mode);
#   }
# }

session_register('visited_mode', 'visited_page', 'visited_sort');

if (!$mode) { # visited bookmark or visited folder
  if ($visited_mode) $mode = $visited_mode;
  else $mode = 'recent'; # default mode
} else {
  if ($visited_mode != $mode) $visited_mode = $mode;
}
if (!$page) {
  if ($visited_page) $page = $visited_page;
  else $page = 1;
} else {
  if ($visited_page != $page) $visited_page = $page;
}
if (!$sort) {
  if ($visited_sort) $sort = $visited_sort;
  else $sort = 'vdate';
} else {
  if ($visited_sort != $sort) $visited_sort = $sort;
}


function KeyProcessingScript() {
  echo("<script>
var _dom = 0;
function keypresshandler(e) {
  if (document.all) e=window.event; // for IE
  if (_dom == 3) var EventStatus = e.srcElement.tagName;
  else if (_dom == 1) var EventStatus = e.target.nodeName; // for Mozilla

  if (EventStatus == 'INPUT' || EventStatus == 'TEXTAREA' || _dom == 2) return;

  var cc = '';
  var ch = '';

  if (_dom == 3) {                   // for IE
    if (e.keyCode > 0) {
    ch = String.fromCharCode(e.keyCode);
    cc = e.keyCode;
    }
  } else {                       // for Mozilla
    cc = (e.keyCode);
    if (e.charCode > 0) {
      ch = String.fromCharCode(e.charCode);
    }
  }

  if (e.altKey || e.ctrlKey) return;

  if (ch == 'b') {
    self.location = '$env[php_self]?mode=bookmark';
  } else if (ch == 'f') {
    self.location = '$env[php_self]?mode=folder';
  } else if (ch == 'r') {
    self.location = '$env[php_self]?mode=recent';
  }
  return;
}
_dom = document.all ? 3 : (document.getElementById ? 1 : (document.layers ? 2 : 0));
document.onkeypress = keypresshandler;
</script>\n");
}


if ($mode == 'bookmark' || $mode == 'folder') {

  if ($mode == 'bookmark') {
    $type = 'b';
    $total = $mgr->getBookmarksNumber();
  }
  else {
    $type = 'c';
    $total = $mgr->getFoldersNumber();
  }
  
  # on/off buttons
  $imgattr = " width='$env[icon_size_x]' height='$env[icon_size_y]' align='top' border='0'";
  $urlorig = "visited.php?mode=$mode&page=$page&sort=$sort&exp=$env[exp]%s";
  $arg1 = "&dispurl=$dispurl";
  $env[headline_right] = "";
  if ($env[enable_swap_bkpath]) { # On/Off path
    $str = ($env[show_icon_name]) ? $lang[path] : "";
    if ($bkpath) $str = "<b>$str</b>";
    $arg1c = ($bkpath) ? "&bkpath=0" : "&bkpath=1";
    $url = sprintf($urlorig, $arg1c);
    $env[headline_right] .= "<a href='$url'><img src='$env[icon_v_path]'$imgattr>$str</a>";
    $env[disp_visitd_bk_path] = ($bkpath) ? 1 : 0;
  }

  $env[title_icon] = $env[icon_visited];
  PageHead("$lang[visited_0]");
  ButtonSet();
  Head1();

  $title = ($type == 'b') ? $lang[bookmark] : $lang[folder];
  $cellpad = $env[line_gap];

  echo("<table border='0' cellpadding='$cellpad' cellspacing='0' width='100%'>");
  echo("<tr>
<td><img src='$env[icon_trdot]' width='$env[icon_size_x]' height='$env[icon_size_y]'> $title</td>\n");
  if (!$env[disp_visitd_bk_path]) {
    $parm = "";
    if ($bkpath) $parm .= "&bkpath=$bkpath";
    if ($page) $parm .= "&page=$page";

    $str = "<u>$lang[visited_2]</u>";
    if ($sort == 'mdate') $str = "<b>$str</b>";
    echo("<td align='center'>
    <img src='$env[icon_trdot]' width='88' height='1' border='0'><br>
    <a href='visited.php?sort=mdate$parm'>$str</a></td>\n");

    $str = "<u>$lang[visited_3]</u>";
    if ($sort == 'count') $str = "<b>$str</b>";
    echo("<td align='center'>
    <img src='$env[icon_trdot]' width='40' height='1' border='0'><br>
    <a href='visited.php?sort=count$parm'>$str</a></td>\n");

    $str = "<u>$lang[visited_4]</u>";
    if ($sort == 'vdate') $str = "<b>$str</b>";
    echo("<td align='center'>
    <img src='$env[icon_trdot]' width='88' height='1' border='0'><br>
    <a href='visited.php?sort=vdate$parm'>$str</a></td>\n");

    $str = "<u>$lang[ip]</u>";
    if ($sort == 'ip') $str = "<b>$str</b>";
    echo("<td align='center'>
    <img src='$env[icon_trdot]' width='120' height='1' border='0'><br>
    <a href='visited.php?sort=ip$parm'>$str</a></td>\n");
  }
  echo("</tr>\n");
    
  # sorting
  if ($sort=='count')      $qryOrder .= "visit DESC"; # sort by count
  else if ($sort=='mdate') $qryOrder .= "rdate DESC"; # modification time
  else if ($sort=='ip')    $qryOrder .= "lastwhere DESC"; # IP
  else if ($sort=='vdate') $qryOrder .= "lastvisit DESC"; # visit time
  else $qryOrder .= "lastvisit DESC"; # last visit time by defalut

  $start = ($page-1) * $env[ipp];
  $qryOrder .= " LIMIT $start, $env[ipp]";
  
  $result = $mgr->findAllItems($type, $qryOrder);

  $cnt = 0;
  while ($row = $result->fetchRow()) {
    $cnt++;

    $date = $row[lastvisit];
    $m = substr($date, 5, 2);
    $d = substr($date, 8, 2);
    $t = substr($date, 10, 6);
    $date = "$m/$d $t";

    $rdate = $row[rdate];
    $m = substr($rdate, 5, 2);
    $d = substr($rdate, 8, 2);
    $t = substr($rdate, 10, 6);
    $rdate = "$m/$d $t";

    list($newimg, $v_new_img) = GetNewString($row);

    if ($env[newwin]) { $tget_str = " target=_blank"; }
    else if ($env[link_target]) { $tget_str = " target=$env[link_target]"; }
    else { $tget_str = ""; }

    $icon = ($type == 'b') ? (($row[public]) ? $env[icon_bk] : $env[icon_hbk])
                           : (($row[public]) ? $env[icon_fo] : $env[icon_hfo]);
    $img_str = GetIconString($row, $icon);

    if ($env[row_highlight]) {
      $attr = " onmouseover=this.style.background='$env[td]'"
             ." onmouseout=this.style.background=''";
    } else $attr = "";
      echo("<tr$attr>
       <td width='100%'><a href='modifyform.php?id=$row[id]'>$img_str</a> ");
    if ($env[disp_visitd_bk_path]) {
      PrintPath($row, $bold=0);
      echo("$newimg$v_new_img");
      echo("</td>");
    } else {
      if ($type == 'b') {  ### bookmark
        $title_str = GetTitleString($row, $tget_str);
        echo $title_str;
        echo $newimg;
        echo $v_new_img;
      } else if ($type == 'c') { ### folder
        # private items in blured text
        if (!$row[public]) $title = "<font color=$env[blur]>$row[title]</font>";
        else $title = $row[title];
        echo("<a href='list.php?root=$row[id]'>$title</a>");
        echo("$newimg$v_new_img");
      }
      echo("</td>\n");
      echo("<td align='center'>$rdate</td>\n");
      echo("<td align='center'>$row[visit]</td>\n");
      echo("<td align='center'>$date</td>\n");
      echo("<td align='center'>$row[lastwhere]</td>\n");
    }
    echo("</tr>\n");
  }
  echo("</table>\n");

  echo("<center>\n");
  $url = "visited.php?sort=$sort";
  if ($bkpath) $url .= "&bkpath=$bkpath";
  Pager($url, $page, $total);
  echo("</center>\n");
  KeyProcessingScript();
  PageTail();
  exit;

} elseif ($mode == 'recent') {

  $env[title_icon] = $env[icon_visited];
  PageHead("$lang[visited_0]");
  ButtonSet();
  Head1();

  echo("<table border='0' width='100%' cellspacing='1' cellpadding='3'>
<tr>
  <td><a href='search.php?mode=edit_history'>$lang[historylayer_1]</a></td>
  <td><a href='$env[php_self]?mode=folder'>$lang[historylayer_2]</a></td>
  <td><a href='$env[php_self]?mode=bookmark'>$lang[historylayer_3]</a></td>
</tr>\n");
  echo("<tr><td valign=top>");

  $height = (int)($env[line_gap] * 2);
  $gap_img = "<img src=$env[icon_trdot] width=1 height='$height'>";
  $img_attr = " align='top' border='0'";

  # search keywords list
  $str = "";
  for ($i = 0; $i < sizeof($env[searchwords]); $i++) {
    $key = $env[searchwords][$i];
    echo("<img src='$env[icon_search]'$img_attr>"
        ." <a href='search.php?k=$key'>$key</a><br>\n$gap_img<br>");
  }

  echo("</td><td valign='top'>");

  # recent folders
  $str = "";
  $qryOrder = "lastvisit DESC LIMIT $env[history_max]";
  $result = $mgr->findAllFolders($qryOrder);
  while ($row = $result->fetchRow()) {
    $icon = ($row[public]) ? $env[icon_fo] : $env[icon_hfo];
    $img_str = GetIconString($row, $icon);
    echo("<a href='modifyform.php?id=$row[id]'>$img_str</a>"
     ." <a href='list.php?root=$row[id]'>$row[title]</a><br>\n"
     ."$gap_img<br>\n");
  }

  echo("</td><td valign='top'>");

  # recent bookmarks
  $str = "";
  $qryOrder = "lastvisit DESC LIMIT $env[history_max]";
  $result = $mgr->findAllBookmarks($qryOrder);
  while ($row = $result->fetchRow()) {
    $icon = ($row[public]) ? $env[icon_bk] : $env[icon_hbk];
    $img_str = GetIconString($row, $icon);
    echo("<a href='modifyform.php?id=$row[id]'>$img_str</a>"
     ." <a href='linkto.php?id=$row[id]'$env[main_target]>$row[title]</a><br>"
     ."$gap_img<br>\n");
  }
  echo("</td></tr></table>\n");
  KeyProcessingScript();
  PageTail();
  exit;

}

?>
