<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'passwd');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');

if ($mode == 'unregister') {

  # in demonstration mode, new user registration, unregistration, clearing
  # database, changing passwords, password restoration features are not allowed.
  if ($conf[demo_mode]) Error("Sorry, you can't use this feature now.");

  if (!$passwd) Error($lang[msg_req_pw]);
  if (CheckPassword($env[user], $passwd) == 0) Error($lang[msg_wrong_pw]);

  $userMgr = createUserManager();
  $userMgr->deleteUser();

  # and logout
  $msg = "You are eliminated from Bookmark4U. Bye~";
  $url = "logout.php";
  ErrorRedir($msg, $url);
  exit;
}

$env[title_icon] = $env[icon_clear];
PageHead("$lang[unregister_0]");
ButtonSet();
echo("<center><img src=$env[icon_stop] width=16 height=16 align=top>
<b>$lang[unregister_1]</b><br></center>
<br>
<table border=0 align=center>
<form action='$HTTP_SERVER_VARS[PHP_SELF]' method=post>
<tr>
 <td align=right>$lang[password]: </td>
 <td><input type=password name=passwd size=20></td>
</tr>
<tr>
 <td colspan=2 align=center><input type=submit value='$lang[unregister_2]'>
 <input type=hidden name=mode value=unregister>
 </td>
</tr>
</form>
</table>\n");
PageTail();
exit;

?>
