<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'id', 'exp', 'listfolder');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write');

$trashMgr = createTrashManager();

if ($mode == 'del') {
  if (!$id) Error("Missing id");
  $trashMgr->deleteItem($id);
  $url = "trash.php?dummy=$env[dummy]";
  header("Location: $url");
  exit;

} else if ($mode == 'delall') {
  $trashMgr->deleteAllItems($id);
  $url = "trash.php?dummy=$env[dummy]";
  header("Location: $url");
  exit;

} else if ($mode == 'undel') {
  if (!$id) Error("Missing id");
  $row = $trashMgr->findItemById($id);

  # get the parent of $id
  if ($row[parent] > 0) {
    $row2 = $mgr->findItemById($row[parent]);
    if (!$row2) Error("You can't restore it");
  }

  # restore
  $total = ($row[type] == 'b') ? 1 : 0;
  $mgr->addItem($row);
  DBError('restore');

  # delete from trash
  $trashMgr->deleteItem($id);

  # update total value
  UpdateTotalLeaf($row[parent]);

  $url = "trash.php?dummy=$env[dummy]";
  header("Location: $url");
  exit;

} else if ($mode == 'info') {
  if (!$id) Error("Missing id");
  $env[title_icon] = $env[icon_trash];
  PageHead($lang[trash]);
  ButtonSet();

  $row = $trashMgr->findItemById($id);
  
  $col1 = $env[th]; $aln1 = " align=right";
  $col2 = $env[td]; $aln2 = "";

  $type_str = ($row[type] == 'c') ? $lang[folder] : $lang[bookmark];
  echo("<table align='center' width='90%' cellpadding='3' cellspacing='1'>
<tr>
  <td bgcolor='$col1' colspan='2' align='center'>$lang[trash_1]</td>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[title]</td>
  <td bgcolor='$col2'$aln2><b>$row[title]</b></td>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[url]</td>
  <td bgcolor='$col2'$aln2><b>$row[url]</b><br>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[description]</td>
  <td bgcolor='$col2'$aln2><b>$row[comment]</b></td>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[type]</td>
  <td bgcolor='$col2'$aln2><b>$type_str</b></td>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[path]</td>
  <td bgcolor='$col2'$aln2>");
  PrintPath($row);
  echo("</td>
</tr><tr>
  <td bgcolor='$col1'$aln1>$lang[trash_2]</td>
  <td bgcolor='$col2'$aln2><b>$row[ddate]</b></td>
</tr>
<tr>
  <td colspan='2' align='center' bgcolor='$env[th]'>
   <a href='trash.php?mode=del&id=$row[id]'>$lang[delete]</a> |
   <a href='trash.php?mode=undel&id=$row[id]'>$lang[restore]</a>
  </td>
</tr>
</table>\n");
  PageTail();
  exit;
}

$env[title_icon] = $env[icon_trash];
PageHead($lang[trash]);
ButtonSet();

# get the number of items in the trash
$cnt_bk = $trashMgr->getBookmarksNumber();
$cnt_fo = $trashMgr->getFoldersNumber();

$qryOrder = "ddate DESC, title";
$return = $trashMgr->findAllItems(null, $qryOrder);

echo("<table border='0' width='100%' cellpadding='2' cellspacing='1'>
<tr bgcolor='$env[th]'>
  <td align='center'>&nbsp;&nbsp;&nbsp;&nbsp;<b>$lang[title] & $lang[url]</b></td>
  <td align='center'><b>$lang[trash_2]</b></td>
  <td align='center'><b>$lang[action]</b></td>
</tr>\n");

while ($row = $return->fetchRow()) {
  if ($row[type]=='b') $icon = $env[icon_bk];
  elseif ($row[type]=='c') $icon = $env[icon_fo];
  elseif ($row[type]=='l') $icon = $env[icon_ln];
  $img_str = GetIconString($row, $icon);

  $title = $row[title];
  $url = $row[url];
  CutString($url, $env[cut_url]);

  if ($env[row_highlight]) {
    $attr = " onmouseover=\"this.style.background='$env[td]'\""
           ." onmouseout=\"this.style.background=''\"";
  } else $attr = "";

  echo("<tr$attr>
  <td>$img_str <a href='trash.php?mode=info&id=$row[id]'>$title</a><br>");

  if ($row[type]=='b') {
  echo("<img src='$env[icon_trdot]' width='$env[icon_size_x]' height='$env[icon_size_y]' align='top'>
  <a href='$row[url]'>$url</a>");
  }

  echo("</td>
  <td align='center' nowrap>$row[ddate]</td>
  <td align='center' nowrap>
    <a href='trash.php?mode=del&id=$row[id]'>$lang[delete]</a><br>
    <a href='trash.php?mode=undel&id=$row[id]'>$lang[restore]</a>
  </td>
</tr>\n");
}

echo("<tr bgcolor='$env[th]'>
  <td colspan='2'>
  <img src='$env[icon_fo]' align='top'> $cnt_fo
  <img src='$env[icon_bk]' align='top'> $cnt_bk
  </td>
  <td align='center'>
   <a href='trash.php?mode=delall'>[[$lang[trash_3]]]
  </td>
</tr>
</table>\n");

PageTail();
exit;

?>
