<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

CheckAuth('read');

$fp = fopen("http://bookmark4u.sourceforge.net/latest.php", "r");
if (!$fp) Error("Can not contact the server.");
$latest_version = fgets($fp, 80);
fclose($fp);

PageHead("Check the latest version of Bookmark4U");
ButtonSet();

echo("<center>");
echo("You are using <b>Bookmark4U</b> version <b>$env[version]</b><br><br>");
echo("Checking ... <a href=http://bookmark4u.sourceforge.net/latest.php>http://bookmark4u.sourceforge.net/latest.php</a><br><br>");
if ($latest_version == $env[version]) {
  echo("<b>Ok! This is the latest version</b>");
} else {
  echo("<a href=http://bookmark4u.sourceforge.net>A later version <b>$latest_version</b> is available !!</a>");
}
echo("</center>");

PageTail();

?>
