<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$sql_cmds[table_passwd] = 
 "# password table
  CREATE TABLE %NAME% (
    user      CHAR(20) NOT NULL PRIMARY KEY,    # user login name
    uid       INTEGER NOT NULL AUTO_INCREMENT,  # user ID (integer)
    passwd    CHAR(20),    # encrypted password
    name      CHAR(40),    # user real name
    email     CHAR(50),    # email address
    lastlogin DATETIME,    # last login time
    lastip    CHAR(15),    # last login IP
    logincnt  INTEGER,     # login counter
    rdate     DATETIME,    # registration date and time
    KEY(uid)
  );";

$sql_cmds[table_passwd_temp] =
 "# temporary password table (for un-allowed user, same definition with PASSWD)
  CREATE TABLE %NAME% (
    user      CHAR(20) NOT NULL PRIMARY KEY,    # user login name
    uid       INTEGER NOT NULL AUTO_INCREMENT,  # user ID (integer)
    passwd    CHAR(20),    # encrypted password
    name      CHAR(40),    # user real name
    email     CHAR(50),    # email address
    lastlogin DATETIME,    # last login time
    lastip    CHAR(15),    # last login IP
    logincnt  INTEGER,     # login counter
    rdate     DATETIME,    # registration date and time
    KEY(uid)
  );";

$sql_cmds[table_config] =
 "# config table
  CREATE TABLE %NAME% (
  uid       INTEGER NOT NULL PRIMARY KEY,
    memo      TEXT,
    config    TEXT
  );";

$sql_cmds[table_trash] =
 "# bookmark trash
  CREATE TABLE %NAME% (
    user       CHAR(20),     # user name
    id         INTEGER,      # bookmark id
    type       CHAR(1),      # bookmark or folder
    parent     INTEGER,      # parent's id
    title      CHAR(255),    # title
    url        CHAR(255),    # bookmark url
    comment    CHAR(255),    # bookmark/folder description
    rdate      DATETIME,     # registration time
    visit      INTEGER,      # how many time visited (visit counter)
    public     CHAR(1),      # '1' for public, '0' for private
    lastvisit  DATETIME,     # time of the last visit
    lastwhere  CHAR(15),     # IP address of the last visit
    ddate      DATETIME      # deletion time
  );";

$sql_cmds[table_calendar] =
 "# bookmark calendar
  CREATE TABLE %NAME% (
    id         INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY, # schedule id
    uid        INTEGER,      # user id
    rdate      DATETIME,     # registration date
    title      CHAR(255),    # title
    comment    CHAR(255),    # comment
    sdate      DATETIME,     # scheduled date (start data)
    edate      DATETIME,     # scheduled date (end date)
    public     CHAR(1),      # public/private (default=0)
    periodic   CHAR(1),      # scheduled periodically
    period     CHAR(1),      # 'w' for weekly, 'm' for monthly or 'y' for yearly
    disabled   CHAR(1),      # disabled or enabled
    priority   CHAR(1),      # prioriry
    bkid       INTEGER,      # bookmark id
    url        CHAR(255)     # bookmark URL
  );";

$sql_cmds[table_address] =
 "# address table
  CREATE TABLE %NAME% (
  id               INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  uid              INTEGER,    # user id
  name             CHAR(40),   # name
  email            CHAR(50),   # email address
  mobile           CHAR(50),   # mobile phone
  home_address     CHAR(200),  # home address
  home_tel         CHAR(20),   # home telephone
  business_address CHAR(200),  # bisiness
  business_tel     CHAR(20),   #
  birthday         DATE,       #
  agroup           CHAR(20),   #
  comment          CHAR(255)   # comment
  );";

$sql_cmds[table_memo] =
 "# memo table
  CREATE TABLE %NAME% (
  id               INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  uid              INTEGER,    # user id
  title            CHAR(255),    # title
  memo             TEXT,
  mdate            DATETIME,    # modification date and time
  rdate            DATETIME     # registration date and time
  );";

$sql_cmds[add_user_admin] =
 "# add a administrator (initial password is 'test')
  INSERT INTO %TABLE% SET user='admin',passwd=PASSWORD('test'),rdate=NOW();
  UPDATE %TABLE% SET uid=0 WHERE user='admin';";

$sql_cmds[table_user] = 
 "CREATE TABLE %NAME% (
    id         INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY, # bookmark id
    type       CHAR(1),      # 'b' for bookmark or 'f' for folder
    parent     INTEGER,      # parent folder's id
    title      CHAR(255),    # bookmark/folder title
    url        CHAR(255),    # bookmark url
    comment    CHAR(255),    # bookmark/folder description
    rdate      DATETIME,     # registration time
    visit      INTEGER,      # how many time visited (visit counter)
    public     CHAR(1),      # '1' for public, '0' for private
    lastvisit  DATETIME,     # the time of last visit
    lastwhere  CHAR(15),     # IP address last visit
    total      INTEGER,      # total number of bookmarks under folder
    # added in v1.8.0
    icon       CHAR(80),            # bookmark/folder icon
    rate       INTEGER DEFAULT 0,   # bookmark rate
    lnid       INTEGER,             # symbolic link
    uid        INTEGER,             # user UID
    rtime      INTEGER  DEFAULT -1, # response time
    chkdate    DATETIME             # url checking date
  );";

# v1.8.0 user table patches
$sql_cmds[table_user_patch1] =
 "ALTER TABLE %NAME% ADD COLUMN icon  CHAR(80);
  UPDATE %NAME% SET icon='';
  ALTER TABLE %NAME% ADD COLUMN rate INTEGER;
  UPDATE %NAME% SET rate='0';
  ALTER TABLE %NAME% ADD COLUMN lnid  INTEGER;
  ALTER TABLE %NAME% ADD COLUMN uid   INTEGER;
  ALTER TABLE %NAME% ADD COLUMN rtime INTEGER DEFAULT -1;
  UPDATE %NAME% SET rtime='-1';
  ALTER TABLE %NAME% ADD COLUMN chkdate DATETIME;";

?>
