##############################################
# Bookmark4U
# MySQL basic tables and rows
##############################################

#DROP TABLE IF EXISTS CALENDAR;
#DROP TABLE IF EXISTS CONFIG;
#DROP TABLE IF EXISTS PASSWD;
#DROP TABLE IF EXISTS PASSWD_TEMP;
#DROP TABLE IF EXISTS TRASH;

# password table
CREATE TABLE PASSWD (
  user      CHAR(20) NOT NULL PRIMARY KEY,    # user login name
  uid       INTEGER NOT NULL AUTO_INCREMENT,  # user ID (integer)
  passwd    CHAR(20),    # encrypted password
  name      CHAR(40),    # user real name
  email     CHAR(50),    # email address
  lastlogin DATETIME,    # last login time
  lastip    CHAR(15),    # last login IP
  logincnt  INTEGER,     # login counter
  rdate     DATETIME,    # registration date and time
  KEY(uid)
);

# temporary password table (for un-allowed user, same definition with PASSWD)
CREATE TABLE PASSWD_TEMP (
  user      CHAR(20) NOT NULL PRIMARY KEY,    # user login name
  uid       INTEGER NOT NULL AUTO_INCREMENT,  # user ID (integer)
  passwd    CHAR(20),    # encrypted password
  name      CHAR(40),    # user real name
  email     CHAR(50),    # email address
  lastlogin DATETIME,    # last login time
  lastip    CHAR(15),    # last login IP
  logincnt  INTEGER,     # login counter
  rdate     DATETIME,    # registration date and time
  KEY(uid)
);

# add a administrator
INSERT INTO PASSWD SET user='admin',passwd=PASSWORD('test'),rdate=NOW();
UPDATE PASSWD SET uid=0 WHERE user='admin';

# config table
CREATE TABLE CONFIG (
  uid       INTEGER NOT NULL PRIMARY KEY,
  memo      TEXT,
  config    TEXT
);

# bookmark trash
CREATE TABLE TRASH (
  user       CHAR(20),     # user name
  id         INTEGER,      # bookmark id
  type       CHAR(1),      # bookmark or folder
  parent     INTEGER,      # parent's id
  title      CHAR(255),    # title
  url        CHAR(255),    # bookmark url
  comment    CHAR(255),    # bookmark/folder description
  rdate      DATETIME,     # registration time
  visit      INTEGER,      # how many time visited (visit counter)
  public     CHAR(1),      # '1' for public, '0' for private
  lastvisit  DATETIME,     # time of the last visit
  lastwhere  VARCHAR(15),  # IP address of the last visit
  ddate      DATETIME      # deletion time
);

# bookmark calendar
CREATE TABLE CALENDAR (
  id         INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY, # schedule id
  uid        INTEGER,      # user id
  rdate      DATETIME,     # registration date
  title      CHAR(255),    # title
  comment    CHAR(255),    # comment
  sdate      DATETIME,     # scheduled date (start data)
  edate      DATETIME,     # scheduled date (end date)
  public     CHAR(1),      # public/private (default=0)
  periodic   CHAR(1),      # scheduled periodically
  period     CHAR(1),      # 'w' for weekly, 'm' for monthly or 'y' for yearly
  disabled   CHAR(1),      # disabled or enabled
  priority   CHAR(1),      # prioriry
  bkid       INTEGER,      # bookmark id
  url        CHAR(255)     # bookmark URL
);


CREATE TABLE ADDRESS (
  id               INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  uid              INTEGER,    # user id
  name             CHAR(40),   # name
  email            CHAR(50),   # email address
  mobile           CHAR(50),   # mobile phone
  home_address     CHAR(200),  # home address
  home_tel         CHAR(20),   # home telephone
  business_address CHAR(200),  # bisiness
  business_tel     CHAR(20),   #
  birthday         DATE,       #
  agroup           CHAR(20),   #
  comment          CHAR(255)   # comment
);


CREATE TABLE MEMO (
  id               INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  uid              INTEGER,    # user id
  title            CHAR(255),    # title
  memo             TEXT,
  mdate            DATETIME,    # modification date and time
  rdate            DATETIME     # registration date and time
);


