<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('k', 'w', 'page', 'dispurl', 'spath');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('read');

$env[title_icon] = $env[icon_zoom];
$env[page_focus] = 1;
PageHead("$lang[searchform_0]");
ButtonSet();

$attr1 = " align='right' nowrap";
$attr2 = " align='left'";
echo("<table border='0' width='100%'>
<form name='searchform' method='get' action='search.php'>
<tr>
 <td$attr1>$lang[searchform_1] :</td>
 <td$attr2>
  <input type='text' name='k' size='20' value=\"$k\">
 </td>
</tr><tr>
 <td$attr1>$lang[recent] :</td>
 <td$attr2>\n");
# recent search list
for ($i = 0; $i < sizeof($env[searchwords]); $i++) {
  $key = $env[searchwords][$i];
  if ($i) echo(", ");
  echo("<span onClick=\"javascript:document.searchform.k.value='$key';document.searchform.k.select()\">$key</span>");
}
echo("</td>
</tr><tr>
 <td$attr1>$lang[searchform_2] :</td>
 <td$attr2>
  <input type='radio' name='w' value='all' checked> $lang[all]
  <input type='radio' name='w' value='title'> $lang[title]
  <input type='radio' name='w' value='url'> $lang[url]
  <input type='radio' name='w' value='comment'> $lang[description]
 </td>
</tr><tr>
 <td$attr1>$lang[searchform_3] :</td>
 <td$attr2>");
  $values = array(10, 15, 20, 30, 50, 100);
  FormRadios(6, 'ipp', $values, $values, $env[ipp]);
echo("</td>
</tr><tr>
 <td$attr1></td>
 <td$attr2><input type='submit' value='$lang[search]'></td>
</tr>
</form></table>
<script>
function PageFocus() { document.searchform.k.focus(); }
</script>\n");


PageTail();
exit;

?>
