<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('k', 'w', 'ipp', 'page', 'dispurl', 'spath');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

function PrintPath2($orig, $id, $indent, $key, $dest) {
  global $env, $mgr;
  global $print_slash;
  global $tgt_linkto;
  global $tgt_modify;

  $imgattr = " border=0 align=top";

  if ($id == 0) { # first call
    if ($dest[type] == 'c') { # folder
      $icon = ($dest[public]) ? $env[icon_fo] : $env[icon_hfo];
      $img_str = GetIconString($dest, $icon);
      echo("<a href='modifyform.php?id=$dest[id]'$tgt_modify>$img_str</a>");
    } elseif ($dest[type] == 'b') { # bookmark
      $icon = ($dest[public]) ? $env[icon_bk] : $env[icon_hbk];
      $img_str = GetIconString($dest, $icon);
      echo("<a href='modifyform.php?id=$dest[id]'$tgt_modify>$img_str</a>");
    } elseif ($dest[type] == 'l') { # symbolic link
      $icon = $env[icon_ln];
      $img_str = GetIconString($dest, $icon);
      echo("<a href='modifyform.php?id=$dest[id]'$tgt_modify>$img_str</a>");
    }
    if ($env[search_disp_path]) {
      $top_folder = sprintf($env[top_folder_name], $env[user]);
      echo(" <a href='list.php?root=0'>$top_folder</a>");
      $print_slash = 1;
    }
    return;
  }

  $row = $mgr->findItemById($id);
  $title = $row[title];

  # guest can not acess to private item.
  if ($env[guest] && !$row[public]) return 'private';

  # recursive call
  if ($indent == 0) { # first call
    $ret = PrintPath2($orig, $row[parent], $indent+1, $key, $row);
    if ($ret == 'private') return $ret;
    if ($k) $title = eregi_replace("($key)",
         "<font class='highlight'>\\1</font>", $title);
  } else {
    $ret = PrintPath2($orig, $row[parent], $indent+1, $key, $dest);
    if ($ret == 'private') return $ret;
  }

  if ($env[long_description] > 0
    && strlen($row[comment]) > $env[long_description]) $desc_next_line = 1;
  else $desc_next_line = 0;

  if ($row[type] == 'c') { # folder
    if ($print_slash) echo(" /");
    if ($env[search_disp_path] || $row[id] == $orig) {
      if (!$row[public]) $title = "<font color=$env[blur]>$title</font>";
      echo(" <a href='list.php?root=$row[id]'>$title</a>");
      if ($row[comment]) $print_comment = 1;
    }
  } else if ($row[type] == 'b') { # bookmark
    if ($env[show_alt_url]) { $alt_attr = " title=\"$row[url]\""; }
    if ($print_slash) echo(" /");

    $title_str = GetTitleString($row, $tgt_linkto);
    echo(" $title_str");

    if ($row[comment]) $print_comment = 1;

  } else if ($row[type] == 'l') { # symbolic link
    if ($env[show_alt_url]) { $alt_attr = " title=\"$row[url]\""; }
    if ($print_slash) echo(" /");
    $title = (!$row[public])
           ? "<font color=$env[blur]>$title</font>"
           : "$title";
    if ($env[usecount]) { # increase visit counter and link
      echo(" <a href=linkto.php?id=$row[id]$alt_attr$tgt_linkto>$title</a>");
    } else {  # link directly
      echo(" <a href=\"$row[url]\"$alt_attr$tgt_linkto>$title</a>");
    }
    if ($row[comment]) $print_comment = 1;

  }

  list($mnewimg, $vnewimg) = GetNewString($row);
  echo("$mnewimg$vnewimg");

# if ($row[comment]) echo(" : $row[comment]");
  if ($print_comment) {
    if ($desc_next_line) {
      echo("<br><img src=$env[icon_trdot] width=$env[icon_size_x] height=$env[icon_size_y] align=top> $row[comment]");
    } else {
      echo(" : $row[comment]");
    }
  }
  return;
}

CheckAuth('read');


if ($mode == 'edit_history') {
  if ($action == 'clear') {
    if ($env[store_search_cookie]) PutCookie("SEARCHES", "", 3600*24*365);
    else PutCookie("SEARCHES", "");
    header("Location: search.php?mode=edit_history");
    exit;
  } elseif ($action == 'del') {
    $new_history = "";
    foreach($env[searchwords] as $word) {
      if ($word == $k) continue;
      if ($new_history) $new_history .= "::$word";
      else $new_history = $word;
    }
    if ($env[store_search_cookie])
      PutCookie("SEARCHES", "$new_history", 3600*24*365);
    else
      PutCookie("SEARCHES", "$new_history");
    header("Location: search.php?mode=edit_history");
    exit;
  }

  $env[title_icon] = $env[icon_zoom];
  PageHead("$lang[search_3]");
  ButtonSet();

  echo("<table border='0' align='center' cellspacing='0' width='200'>
  <tr><td bgcolor='$env[th]' align='center'><b>$lang[search]</b></td>
  <td bgcolor='$env[th]' align='center'><b>$lang[action]</b></td></tr>\n");
  $cnt = 0;
  foreach($env[searchwords] as $word) {
    echo("<tr><td bgcolor='$env[td]' align='center'><a href='search.php?k=$word'>$word</a>
    </td><td bgcolor='$env[td]' align='center'>
    <a href='search.php?mode=edit_history&action=del&k=$word'>[[$lang[delete]]]</a></td></tr>\n");
    $cnt++;
  }
  echo("<tr><td align='center' bgcolor='$env[th]'>$lang[total] $cnt</td>
<td align='center' bgcolor='$env[th]'><a href='search.php?mode=edit_history&action=clear'>[[$lang[clear]]]</a></td>
</tr>
</table>\n");

  PageTail();
  exit;
}


if (!$k) Error($lang[msg_no_keyword]);
$esc_k = ereg_replace("'", "\'", $k);

if (!sizeof($env[searchwords])) { # no search keyword history yet
  if ($env[store_search_cookie])
    PutCookie("SEARCHES", "$k", 3600*24*365);
  else
    PutCookie("SEARCHES", "$k");
} else {
  if (!in_array($k, $env[searchwords])) {
    if ($k) {
      if ($env[store_search_cookie])
        PutCookie("SEARCHES", "$k::$search", 3600*24*365);
      else
        PutCookie("SEARCHES", "$k::$search");
      header("Location: search.php?k=$k&w=$w");
      exit;
    }
  }
}

# on/off buttons
$imgattr = "  width='$env[icon_size_x]' height='$env[icon_size_y]' align='top' border='0'";
$urlorig = "search.php?k=$k&exp=$env[exp]&page=$page%s%s%s";
$arg1 = "&dispurl=$dispurl";
$arg2 = "&urlcheck=$urlcheck";
$arg3 = "&spath=$spath";
$env[headline_right] = "";
if ($env[enable_swap_dispurl]) { # On/Off bookmark URL
  $str = ($env[show_icon_name]) ? $lang[url] : "";
  if ($dispurl) $str = "<b>$str</b>";
  $arg1c = ($dispurl) ? "&dispurl=0" : "&dispurl=1";
  $url = sprintf($urlorig, $arg1c, $arg2, $arg3);
  $env[headline_right] .= "<a href='$url'><img src='$env[icon_p_dispurl]'$imgattr>$str</a>";
  if ($dispurl != '') $env[dispurl] = ($dispurl) ? 1 : 0;
}
$env[headline_right] .= " ";
if ($env[enable_urlcheck]) { # On/Off check URL
  $str = ($env[show_icon_name]) ? $lang[list_4] : "";
  if ($urlcheck) $str = "<b>$str</b>";
  $arg2c = ($urlcheck) ? "&urlcheck=0" : "&urlcheck=1";
  $url = sprintf($urlorig, $arg1, $arg2c, $arg3);
  $env[headline_right] .= "<a href='$url'><img src='$env[icon_urlcheck]'$imgattr alt='$lang[list_5]'>$str</a>\n";
}
$env[headline_right] .= " ";
{ # On/Off display path
  $str = ($env[show_icon_name]) ? $lang[path] : "";
  if ($spath != '') $env[search_disp_path] = ($spath) ? 1 : 0;
  if ($env[search_disp_path]) $str = "<b>$str</b>";
  $arg3c = ($env[search_disp_path]) ? "&spath=0" : "&spath=1";
  $url = sprintf($urlorig, $arg1, $arg2, $arg3c);
  $env[headline_right] .= "<a href='$url'><img src='$env[icon_s_path]'$imgattr alt='$lang[list_5]'>$str</a>\n";
}

$env[page_focus] = $env[search_focus];
$env[title_icon] = $env[icon_zoom];
PageHead("$lang[search_0] : $k");
ButtonSet();

# target string such as " target=something"
$tgt_linkto = $env[main_target];
$tgt_modify = $env[aid_target];

$script_selectvalue = "function SelectValue(select, value) {
  var len = select.options.length;
  for (i = 0; i < len; i++) {
    if (select.options[i].value == value) {
      select.options[i].selected = true;
      break;
    }
  }
}\n";
echo("<script>\n");
echo $script_selectvalue;
echo("</script>\n");

if (!$w || $w == 'a') $w = 'all';

$where = "";
if ($w == 'title') { $where .= " (title LIKE '%$esc_k%')"; }
else if ($w == 'url') { $where .= " (url LIKE '%$esc_k%')"; }
else if ($w == 'comment') { $where .= " (comment LIKE '%$esc_k%')"; }
else if ($w == 'all') {
  $where .= " ((title LIKE '%$esc_k%')"
         ." OR (url LIKE '%$esc_k%')"
         ." OR (comment LIKE '%$esc_k%'))";
}

$qryOrder = "type DESC, parent, title";

if (!$page) $page = 1;
if (!$ipp) $ipp = $env[ipp]; # items per page
$start = ($page-1) * $ipp;
$qryOrder .= " LIMIT $start,$ipp";

if (!$env[guest]) {
  $c_total = $mgr->getFoldersNumber($where);
  $b_total = $mgr->getBookmarksNumber($where);

  $total = $c_total + $b_total;
}

echo("<table border=0 width=100% cellpadding=4 cellspacing=0>
<form action=search.php name=searchform1>
<tr>
<td bgcolor=$env[th]>
$lang[search_1]: <b>$k</b>\n");
if ($w == 'all') $str = "($lang[title]|$lang[url]|$lang[description])=*$str*";
elseif ($w == 'title') $str = "($lang[title])=*$str*";
elseif ($w == 'url') $str = "($lang[title])=*$str*";
elseif ($w == 'comment') $str = "($lang[description])=*$str*";
echo("$str");

if (!$env[guest]) echo("&nbsp;
<nobr><img src=$env[icon_fo] align=top> ${c_total} &nbsp;
<img src=$env[icon_bk] align=top> ${b_total}</nobr>\n");
echo("</td>\n");

echo("<td align=right bgcolor=$env[th]>");
SearchOptions('searchform1', 1);
echo("<input type=hidden name=m value=search>");
echo("</td>\n");
echo("</form></table>\n");

# echo $qry;
$result = $mgr->searchItems($where, $qryOrder);

$height = (int)($env[line_gap] * 2);
$gap_img = "<img src='$env[icon_trdot]' width='1' height='$height'>";

echo("<table border=0 cellpadding=$cellpad cellspacing=0 width=100%>\n");
$cnt = 0;
while ($row = $result->fetchRow()) {
  $url = $row[url];
  $cnt++;
  echo("<tr><td>");

  if ($row[type] == 'c') {
    $ret = PrintPath2($row[id], $row[id], 0, $k, NULL);
    if ($ret == 'private') continue;

  } else if ($row[type] == 'b') {
    # URL check results
    if ($env[enable_urlcheck] && $urlcheck) {
      $ret = LinkAlive($row[url], $msg);
      if ($ret == 'alive') $alive = " ... Alive $msg";
      elseif ($ret == 'dead') $alive = " ... Dead $msg";
      elseif ($ret == 'unknown') $alive = " ... $msg";
      $alive = "<font color=$env[blur]>$alive</font>";
    } else $alive = "";

    $ret = PrintPath2($row[id], $row[id], 0, $k, NULL);
    echo("$alive");
    if ($ret == 'private') continue;
    if ($env[dispurl]) {
      if ($env[cut_url]) {
        if (strlen($row[url]) > $env[cut_url]) {
          $url = substr($row[url], 0, $env[cut_url]);
          $url .= "...";
        }
      }
      if ($k) $url_str = eregi_replace("\($key\)",
          "<font class='highlight'><b>$key</b></font>", $url);
      echo("<br>\n<img src=$env[icon_trdot] width=16 height=1>");
      if ($env[usecount] && !$env[url_direct_link]) {
        echo(" <a href='linkto.php?id=$row[id]'$tgt_linkto><font color=$env[blur]>$url_str</font></a>");
      } else {
        echo(" <a href=\"$row[url]\"$tgt_linkto><font color='$env[blur]'>$url_str</font></a>");
      }
    }

  } else if ($row[type] == 'l') {
    $ret = PrintPath2($row[id], $row[id], 0, $k, NULL);
    if ($ret == 'private') continue;
  }
  echo("<br>$gap_img</td></tr>\n");

  # split a long table
  if ($urlcheck) {
    echo("</table>\n");
    echo("<table border=0 width=100% cellpadding=0 cellspacing=0>\n");
  }
}

echo("<tr><td align=center>\n");
$url = "search.php?k=$k&w=$w&p=$p$arg1$arg2$arg3";
Pager($url, $page, $total);
echo("</td></tr>\n");
echo("</table>\n");

# if no search result
#if ($c_total == 0 && $b_total == 0) {
if ($cnt == 0) {
  echo("<table border=0 width=100%>
<td align=center><b>$lang[no_search_result]</b></td>
</table>");
}

echo("<table border='0' width='100%' cellpadding='0' cellspacing='0'>
<form action='search.php' name='searchform2'>
<tr>
<td bgcolor='$env[th]'>
<a href='searchform.php?k=$k'><img
 src='$env[icon_search]' align='top' border='0'>$lang[search_2]</a></td>
<td align='right' bgcolor='$env[th]'>\n");
SearchOptions('searchform2', 0);
echo("<input type=hidden name='m' value=search>");
echo("</td></form></table>\n");

# auto focus to a search form
if ($env[search_focus]) {
  $script = "function PageFocus() {\n";
  $script .= "  document.searchform1.k.focus();\n";
  $script .= "  document.searchform1.k.select();\n";
  $script .= "}\n";
}
echo("<script>\n");
echo $script;
echo("</script>\n");

PageTail($script);

?>
