<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");

include("sql/sql.mysql.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'userid', 'passwd1', 'passwd2', 'name',
       'email');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

if ($mode == 'register') {

  # in demonstration mode, new user registration, unregistration,
  # clearing database, changing passwords, and password restoration features
  # are not allowed.
  if ($conf[demo_mode]) Error($lang[msg_demo_limit]);

# $pattern = "[ \\\\\_\~\`\!\@\#\$\%\^\&\*\(\)\-\+\=\|\{\}\:\"\;\'\<\>\?\,\.\/]";
# if (ereg($pattern, $userid)) {
#   $char = ereg_replace("\($pattern\)", "\1", $userid);
#   Error("Invalid User Name.");
# }

  # User ID validation check
  if (!$userid) Error($lang[msg_req_id]);
  if (!preg_match("/^[a-zA-Z0-9]+$/", $userid)) { ## MEDDAUGH
    Error("Invalid characters in login ID");
  }
  if (strlen($userid) < 2) Error("Login ID is too short. (Min 2 chars)");
  if (strlen($userid) > 20) Error("Login ID is too long. (Max 20 chars)");

  if (!$env[generate_user_passwd]) {
    if (!$passwd1) Error("Please specify a Password");
    if ($passwd1 != $passwd2) Error("Password entries does not match");
  }
  # check the password length
  # $msg = "Password must be betwwen 6-10 letters";
  # if (strlen($passwd1)<6) Error($msg); ## added by MEDDAUGH
  # if (strlen($passwd1)>10) Error($msg); ## added by MEDDAUGH

  if (!$name) Error("Please specify your name");

  if (!$email) Error("Please specify an email address");
  if (!preg_match("/[a-zA-Z0-9].*\@[a-zA-Z0-9].*\.[a-zA-Z0-9].*/",$email)) {
    Error("Invalid email address");  ## added by MEDDAUGH
  }

  if ($env[generate_user_passwd]) { # generate a random password
    $rand = rand(1, $env[dummy]);
    $hash = md5($rand);
    $passwd1 = substr($hash, 0, 8);  # new password
  }

  # check if this userid exist already
  $row = $userMgr->findUserByLogin($userid);
  //DBError();
  if ($row) Error($lang[msg_exist_userid]);

  # insert into PASSWD, if registration_verify is true insert into PASSWD_TEMP
  $rowCreate = array();
  $rowCreate[user]    = $userid;
  $rowCreate[passwd]  = $passwd1;
  $rowCreate[name]    = $name;
  $rowCreate[email]   = $email;
  $userMgr->addUser($rowCreate);
  DBError();

  $mgr->setUser( $userid );

  # account initialization
  # make user bookmark table and insert row into config table
  if (!$env[registration_verify]) {
    # insert a sample bookmark
    $rowBk = array();
    $rowBk[type] = 'b';
    $rowBk[parent] = 0;
    $rowBk[title] = 'Bookmark4U';
    $rowBk[url] = 'http://bookmark4u.sourceforge.net';
    $rowBk[comment] = 'Welcome to Bookmark4U';
    $rowBk[public] = 1;
    $mgr->addItem($rowBk);
    DBError();
  }

  if ($env[registration_verify]) {
    $subject    = $lang[register_9];
    $message    = sprintf($lang[register_10], $userid);
    $msg        = $lang[register_11];
  } else {
    $subject    = $lang[register_12];
    $message    = sprintf($lang[register_13], $userid);
    $msg        = $lang[register_14];
  }
  # send an email to administrator
  $header = "From: $env[site_title]<$env[admin_email]>\n";
  if ($env[admin_email]) mail($env[admin_email], $subject, $message, $header);

  if ($env[generate_user_passwd]) { # generate a random password
    # send an email to administrator
    $subject = $lang[register_15];
    $message = sprintf($lang[register_16], $passwd1);
    $header = "From: Bookmark4U<$env[admin_email]>\n";
    if ($email) mail($email, $subject, $message, $header);
  }

  echo("<html>
<head>
</head>
<body>
<script>
  alert('$msg');
  window.location='index.php?userid=$userid';
</script>
</body>
\n");
  exit;
}

echo("<html>
<head>
<style type='text/css'>
a:link    { text-decoration:none; }
a:visited { text-decoration:none; }
a:hover   { text-decoration:underline; }
td,body   {
  color: black;
  font-family: Verdana,Arial,Helvetica;
  font-size: x-small;
}
input,select,textarea {
  border:1 solid black;
  background-color:#eeeeee;
  color:black;
}
</style>
<title>$lang[register_0]</title>
</head>
<body bgcolor='white' text='black' link='#aa4444' alink='#aa4444' vlink='#aa4444'>\n");

echo("<center>
<h2>Bookmark4U</h2>
<table border='0' width='90%'>
<tr><td>
<b>$lang[register_0]</b><br>
</td></tr>
</table>
</center>
<table border='0' align='center'>
<form action='register.php' method='post'>
<tr>
  <td align=right>$lang[register_1]:</td>
  <td><input type=text name='userid' size='15'> $lang[register_3]</td>
</tr>");
if ($env[generate_user_passwd]) {
  echo("<tr>
  <td align=right>$lang[password]:</td>
  <td>$lang[register_2]</td>
</tr>");
} else {
  echo("<tr>
  <td align=right>$lang[password]:</td>
  <td><input type='password' name='passwd1' size='15'> $lang[register_4]</td>
</tr><tr>
  <td align=right>$lang[repeat_passwd]:</td>
  <td><input type='password' name='passwd2' size='15'> $lang[register_5]</td>
</tr>");
}
echo("<tr>
  <td align=right>$lang[name]:</td>
  <td><input type='text' name='name' size='30'> $lang[register_6]</td>
</tr><tr>
  <td align='right'>$lang[email]:</td>
  <td><input type='text' name='email' size='30'></td>
</tr><tr>
  <td></td>
  <td>
    <input type='hidden' name='mode' value='register'>
    <input type='submit' value='$lang[register_7]'><br>
    <br>
  <a href='index.php'>$lang[register_8]</a>
  </td>
</tr>
</form>
</table>\n");

echo("</body></html>\n");

exit;

?>
