<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'sel');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'edit_continue');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');

if ($mode == 'save') { # save preference in DB
# global $uconf, $fenv;

  # variables should not be saved
  $http_post = $HTTP_POST_VARS;
  unset($http_post[mode]);
  unset($http_post[edit_continue]);
  unset($http_post[configtext]);

  SaveConfiguration($http_post);

  if ($edit_continue) header("Location: preference.php?dummy=$env[dummy]");
  else header("Location: list.php?dummy=$env[dummy]");
  exit;

} elseif ($mode == 'configsave') {
  $uid = GetCookie('UID');
  $userMgr->updateUserConfig($configtext);

  header("Location: list.php");
  exit;
}

function ConfigTab1() {
  global $env, $lang, $uenv;
  global $tdattr1, $tdattr2;

  ## language
  $langs = GetSubDirs('lang');
  echo("<tr>
  <td$tdattr1 width='50%'><img src='$env[icon_p_lang]' align='top'>
  $lang[preference_1]</td>
  <td$tdattr2 width='50%'><select name='lang' onchange=\"Reload()\">\n");
  FormOptions(sizeof($langs), $langs, $langs, $uenv[lang]);
  echo("</select>
  <font color=$env[text]>($lang[preference_38])</font>
  </td></tr>\n");

  ## document encoding
  echo("<tr><td$tdattr1>$lang[preference_97]</td>
  <td$tdattr2>\n");
  FormText('doc_encoding', $uenv[doc_encoding], 10);
  echo("</td></tr>\n");

  ## theme
  $themes = GetSubDirs('theme');
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_theme] align=top>
  $lang[preference_2]</td>
  <td$tdattr2><select name=theme onchange=\"Reload()\">\n");
  FormOptions(sizeof($themes), $themes, $themes, $uenv[theme]);
  echo("</select>
  <font color=$env[text]>($lang[preference_38])</font>
  </td></tr>\n");

  ## new bookmark marking time
  echo("<tr>
  <td$tdattr1><img src=$env[icon_new] align=top>
  $lang[preference_3]</td>
  <td$tdattr2><select name=newtime>\n");
  $values = array('3600', '43200', '86400', '172800', '604800');
  $disps = array($lang[preference_3_1], $lang[preference_3_2],
      $lang[preference_3_3], $lang[preference_3_4], $lang[preference_3_5]);
  FormOptions(sizeof($values), $values, $disps, $uenv[newtime]);
  echo("</select></td></tr>\n");

  ## use visit info
  echo("<tr>
  <td$tdattr1><img src='$env[icon_p_usecount]' align='top'>
  $lang[preference_5]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[preference_5_1], $lang[preference_5_2]);
  FormRadios(2, 'usecount', $values, $disps, $uenv[usecount]);
  echo("</td></tr>\n");

  ## URLs are linked directly
  echo("<tr>
  <td$tdattr1><img src='$env[icon_p_usecount]' align='top'>
  $lang[preference_90]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'url_direct_link', $values, $disps, $uenv[url_direct_link]);
  echo("</td></tr>\n");

  ## open page in a new windows
  echo("<tr>
  <td$tdattr1><img src=$env[icon_linkpage] align=top>
  $lang[preference_59]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'newwin', $values, $disps, $uenv[newwin]);
  echo("</td></tr>\n");

  ## print linkto page
  echo("<tr>
  <td$tdattr1><img src=$env[icon_linkpage] align=top>
  $lang[preference_51]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'print_linkto_page', $values, $disps, $uenv[print_linkto_page]);
  echo("</td></tr>\n");

  ## refresh time
  echo("<tr><td$tdattr1><img src='$env[icon_timer]' align='top'> $lang[preference_56]</td>
  <td$tdattr2>\n");
  echo("<nobr>");
  FormText('refresh_time', $uenv[refresh_time], '5');
  echo("<input type='button' value=' + '
  onclick='javascript:AddValue(document.form.refresh_time, 1)'><input
  type='button' value=' - '
  onclick='javascript:AddValue(document.form.refresh_time, -1)'>");
  echo(" $lang[unit_sec]</nobr>\n");
  echo("</td></tr>\n");

  ## delete confirm
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_delconfrm] align=top>
  $lang[preference_15]</td>
  <td$tdattr2>");
  $values = array(1, 0);
  $disps = array($lang[on], $lang[off]);
  FormRadios(2, 'delconfirm', $values, $disps, $uenv[delconfirm]);
  echo("</td></tr>\n");

  ## auto search focus
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_focus] align=top>
  $lang[preference_14]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[on], $lang[off]);
  FormRadios(2, 'search_focus', $values, $disps, $uenv[search_focus]);
  echo("</td></tr>\n");

  ## list form
  echo("<tr>
  <td$tdattr1><img src='$env[icon_p_tree_on]' align='top'>
  $lang[preference_13]</td>
  <td$tdattr2>\n");
# $values = array('static', 'flat');
  $values = array('static', 'flat', 'dynamic');
#  $disps = array($lang[preference_13_1], $lang[preference_13_2]);
  $disps = array($lang[preference_13_1], $lang[preference_13_2], $lang[preference_13_3]);
  FormRadios(3, 'tree_view', $values, $disps, $uenv[tree_view]);
  echo("</td></tr>\n");

  ## starting page
  echo("<tr>
  <td$tdattr1><img src=$env[icon_start_page] align=top>
  $lang[preference_62]</td>
  <td$tdattr2>\n");
  $values = array('list', 'calendar', 'visited', 'memo');
  $disps = array($lang['bookmark'],$lang[calendar],$lang[visited],$lang[memo]);
  FormRadios(4, 'start_script', $values, $disps, $uenv[start_script]);
  echo("</td></tr>\n");

  ## default sorting method
  echo("<tr>
  <td$tdattr1><img src=$env[icon_bksort] align=top>
  $lang[preference_73]</td>
  <td$tdattr2>\n");
  $values = array('type','title','url','rdate','visit','lastvisit','rate');
  $disps = array($lang['type'], $lang[title], $lang[url], $lang[rdate], $lang[visit], $lang[lastvisit], $lang[rate]);
  FormRadios(7, 'default_list_sort', $values, $disps, $uenv[default_list_sort]);
  echo("</td></tr>\n");

}

function ConfigTab2() {
  global $env, $lang, $uenv;
  global $tdattr1, $tdattr2;

  ## icon name
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_iconname] align=top>
  $lang[preference_6]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_icon_name', $values, $disps, $uenv[show_icon_name]);
  echo("</td></tr>\n");

  ## buttons in a row
  echo("<tr>
  <td$tdattr1><img src=$env[icon_row] align=top>
  $lang[preference_32]</td>
  <td$tdattr2>\n");
  $values = array(0, 7, 6, 5, 4, 3);
  $disps = array($lang[preference_33], 7, 6, 5, 4, 3);
  FormRadios(sizeof($values), 'buttons_in_a_row', $values, $disps,
    $uenv[buttons_in_a_row]);
  echo("</td></tr>\n");

  ## clipboard icon
  echo("<tr>
  <td$tdattr1 width=50%><img src=$env[icon_clipboard]
  align=top>
  $lang[preference_30]</td>
  <td$tdattr2 width=50%>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_clipbrd_icon', $values, $disps, $uenv[show_clipbrd_icon]);
  echo("</td></tr>\n");

  ## trash icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_trash] align=top>
  $lang[preference_37]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_trash_icon', $values, $disps, $uenv[show_trash_icon]);
  echo("</td></tr>\n");

  ## memo icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_memo] align=top>
  $lang[preference_41]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_memo_icon', $values, $disps, $uenv[show_memo_icon]);
  echo("</td></tr>\n");

  ## calendar icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_calendar] align=top>
  $lang[preference_55]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_calendar_icon', $values,$disps,$uenv[show_calendar_icon]);
  echo("</td></tr>\n");

  ## address book icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_address] align=top>
  $lang[preference_85]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_address_icon', $values,$disps,$uenv[show_address_icon]);
  echo("</td></tr>\n");

  ## visited icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_visited] align=top>
  $lang[preference_42]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_visited_icon', $values, $disps, $uenv[show_visited_icon]);
  echo("</td></tr>\n");

  ## expand/collapse icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_expand] align=top>
  $lang[preference_43]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_expand_icon', $values, $disps, $uenv[show_expand_icon]);
  echo("</td></tr>\n");

  ## bookmark/folder icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_fo] align=top>
  $lang[preference_44]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_onlyfolder_icon', $values, $disps, $uenv[show_onlyfolder_icon]);
  echo("</td></tr>\n");

  ## content reload icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_reload] align=top>
  $lang[preference_69]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_reload_icon', $values, $disps, $uenv[show_reload_icon]);
  echo("</td></tr>\n");

  ## window resize icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_resize] align=top>
  $lang[preference_49]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_resize_icon', $values, $disps, $uenv[show_resize_icon]);
  echo("</td></tr>\n");

  ## import icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_import] align=top>
  $lang[preference_95]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_import_icon', $values, $disps, $uenv[show_import_icon]);
  echo("</td></tr>\n");

  ## export icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_export] align=top>
  $lang[preference_96]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_export_icon', $values, $disps, $uenv[show_export_icon]);
  echo("</td></tr>\n");

  ## display quick links
  echo("<tr>
  <td$tdattr1><img src=$env[icon_quicklink] align=top>
  $lang[preference_83]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'quick_links', $values, $disps, $uenv[quick_links]);
  echo("</td></tr>\n");

  ## icon size
  echo("<tr>
  <td$tdattr1><img src=$env[icon_icon_size] align=top>
  $lang[preference_50]</td>
  <td$tdattr2>\n");
  FormText('icon_size_x', $uenv[icon_size_x], 5); 
  echo(" X ");
  FormText('icon_size_y', $uenv[icon_size_y], 5); 
  echo("</td></tr>\n");

  ## buttons set align
  echo("<tr>
  <td$tdattr1><img src=$env[icon_icon_align] align=top>
  $lang[preference_72]</td>
  <td$tdattr2>\n");
  $values = array('left', 'center', 'right');
  $disps= array($lang[left], $lang[center], $lang[right]);
  FormRadios(sizeof($values), 'buttons_align', $values, $disps,
    $uenv[buttons_align]);
  echo("</td></tr>\n");

}

function ConfigTab3() {
  global $env, $lang, $uenv, $uconf;
  global $tdattr1, $tdattr2;

  ## top folder name
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_root_name] align=top>
  $lang[preference_40]</td>
  <td$tdattr2>
  <script>
  function SetDefaultTopFolderName() {
    document.form.top_folder_name.value = \"$uconf[top_folder_name]\";
  }
  </script>\n");
  FormText('top_folder_name', $uenv[top_folder_name], '15');
  echo("<a href='javascript:SetDefaultTopFolderName()'>[Set Default]</a>
  </td></tr>\n");

  ## url cut length
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_url_cut] align=top>
  $lang[preference_11]</td>
  <td$tdattr2>\n");
  FormText('cut_url', $uenv[cut_url], 5);
  echo(" $lang[chars]</td></tr>\n");

  ## long description
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_desc_cut] align=top>
  $lang[preference_27]</td>
  <td$tdattr2>\n");
  FormText('long_description', $uenv[long_description], 5);
  echo(" $lang[chars]</td></tr>\n");

  ## spacing between rows
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_bkgap] align=top>
  $lang[preference_7]</td>
  <td$tdattr2>\n");
  $values = array(0, 1, 2, 3);
  $disps = array($lang[preference_7_1], 1, 2, 3);
  FormRadios(sizeof($values), 'line_gap', $values, $disps, $uenv[line_gap]);
  echo("</td></tr>\n");

  ## font family
  echo("<script>
  function SetDefaultStyleFont() {
    document.form.style_font.value = \"$lang[style_font]\";
  }
  </script>
  <tr><td$tdattr1><img src=$env[icon_p_fonttype] align=top>
  <a href='javascript:void(0)' onclick=\"document.form.style_font.select()\">
  $lang[preference_47]</a></td>
  <td$tdattr2>\n");
  FormText('style_font', $uenv[style_font], '15');
  echo("<a href='javascript:void(0)'
  onclick='SetDefaultStyleFont()'>[Set Default]</a></td></tr>\n");

  ## font size
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_fontsize] align=top>
  $lang[preference_25]</td>
  <td$tdattr2><select name=font_size
  onchange=\"javascript:Reload()\">\n");
  $values = array('8pt','9pt','10pt','x-small','small',
                  'medium','large','x-large');
  FormOptions(sizeof($values), $values, $values, $uenv[font_size]);
  echo("</select>
  <font color=$env[text]>($lang[preference_38])</font></td></tr>\n");

  ## the number of reacent folders in history layer
  echo("<tr>
  <td$tdattr1><img src=$env[icon_h_layer] align=top>
  $lang[preference_52]</td>
  <td$tdattr2>\n");
  $vals = array(5, 10, 15, 20);
  FormRadios(sizeof($vals), 'history_max', $vals, $vals, $uenv[history_max]);
  echo("</td></tr>\n");

  ## urlcheck_timeout
  echo("<tr>
  <td$tdattr1><img src=$env[icon_urlcheck] align=top>
  $lang[preference_65]</td>
  <td$tdattr2>\n");
  $values = array(1, 2, 3, 5, 10);
  FormRadios(sizeof($values), 'urlcheck_timeout', $values, $values, $uenv[urlcheck_timeout]);
  echo(" $lang[seconds]</td></tr>\n");

  ## window resizing size
  echo("<tr>
  <td$tdattr1><img src=$env[icon_resize] align=top>
  $lang[preference_57] (1)</td>
  <td$tdattr2>\n");
  FormText('resize_wx', $uenv[resize_wx], 5); 
  echo(" X ");
  FormText('resize_wy', $uenv[resize_wy], 5); 
  echo("</td></tr>\n");

  ## window resizing size
  echo("<tr>
  <td$tdattr1><img src=$env[icon_resize] align=top>
  $lang[preference_57] (2)</td>
  <td$tdattr2>\n");
  FormText('resize_wx2', $uenv[resize_wx2], 5); 
  echo(" X ");
  FormText('resize_wy2', $uenv[resize_wy2], 5); 
  echo("</td></tr>\n");

# ## disp_visitd_bk_path
# echo("<tr>
# <td$tdattr1><img src=$env[icon_v_path] align=top>
# $lang[preference_60]</td>
# <td$tdattr2>\n");
# $values = array(1, 0);
# $disps = array($lang[show], $lang[hide]);
# FormRadios(2, 'disp_visitd_bk_path', $values, $disps, $uenv[disp_visitd_bk_path]);
# echo("</td></tr>\n");

  # login information page
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_logininfo] align=top>
  $lang[preference_4]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'login_info', $values, $disps, $uenv[login_info]);
  echo("</td></tr>\n");

  # login information page
  echo("<tr>
  <td$tdattr1><img src='$env[icon_p_logininfo]' align='top'>
  $lang[preference_91]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'login_page_schedules', $values, $disps, $uenv[login_page_schedules]);
  echo("</td></tr>\n");

  ## time to close (close control)
  echo("<tr>
  <td$tdattr1><img src='$env[icon_timer]' align='top'>
  $lang[preference_63]</td>
  <td$tdattr2>\n");
  FormText('time_to_close', $uenv[time_to_close], 5); 
  echo("<input type=button value='+'
  onclick='javascript:AddValue(document.form.time_to_close, 1)'><input
  type=button value='-'
  onclick='javascript:AddValue(document.form.time_to_close, -1)'>");
  echo(" $lang[seconds]</td></tr>\n");

  # error message reporting
  echo("<tr>
  <td$tdattr1><img src='$env[icon_error]' align='top'>
  $lang[preference_66]</td>
  <td$tdattr2>\n");
  $values = array('script', 'onpage');
  $disps = array("$lang[preference_67]", "$lang[preference_68]");
  FormRadios(2, 'errmsg_method', $values, $disps, $uenv[errmsg_method]);
  echo("</td></tr>\n");

  # default folder listing
  echo("<tr>
  <td$tdattr1>
  $lang[preference_70]</td>
  <td$tdattr2>\n");
  $values = array('recent', 'all');
  $disps = array("$lang[recent]", "$lang[all]");
  FormRadios(2, 'folder_list_default', $values, $disps, $uenv[folder_list_default]);
  echo("</td></tr>\n");

  # pager type
  echo("<tr>
  <td$tdattr1>
  $lang[preference_75]</td>
  <td$tdattr2>\n");
  $values = array('1', '2');
  $disps = array($lang[preference_76], $lang[preference_77]);
  FormRadios(2, 'pager_type', $values, $disps, $uenv[pager_type]);
  echo("</td></tr>\n");

  ## url_check_only_ip
  echo("<tr>
  <td$tdattr1>
  $lang[preference_98]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[on], $lang[off]);
  FormRadios(2, 'url_check_only_ip', $values, $disps, $uenv[url_check_only_ip]);
  echo("</td></tr>\n");

}

function ConfigTab6() {
  global $env, $lang, $uenv, $userMgr;
  global $tdattr1, $tdattr2;

  $row = $userMgr->findUserConfig();

  $style_str = ($env[textarea_full_width]) ? " style=\"width: 100%\"" : "";

  echo("<script>
function ta_resize(value) {
  ta = document.form.configtext;
  if (value == 'narrow') { if (ta.cols > 60) ta.cols -= 5; }
  if (value == 'wide') ta.cols += 5;
  if (value == 'short') { if (ta.rows > 10) ta.rows -= 5; }
  if (value == 'long') ta.rows += 5;
}
</script>\n");

  echo("<table border=0 align=center width=100% cellpadding=0 cellspacing=0>
<tr>
<td align=center>
[[
<a href=\"javascript:ta_resize('long');\">$lang[textarea_1]</a> |
<a href=\"javascript:ta_resize('short');\">$lang[textarea_2]</a>
]]
[[ <a href=\"javascript:void(document.form.configtext.value='');\">
<img src=$env[icon_clear] align=top border=0 width=16 height=16
alt='Reset my preference settings'>$lang[clear]</a> ]]

<textarea name=configtext rows=$env[textarea_rows]
 cols=$env[textarea_cols]$style_str>$row[config]</textarea>
</td>
</tr>
<tr>
<td align=center>\n");
}

function ConfigTab5() {
  global $env, $lang, $uenv;
  global $tdattr1, $tdattr2;

  ## bookmark url
  echo("<tr>
  <td$tdattr1><img src=$env[icon_p_dispurl] align=top>
  $lang[preference_10]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'dispurl', $values, $disps, $uenv[dispurl]);
  echo("</td></tr>\n");

  ## bookmark url
  echo("<tr>
  <td$tdattr1><img src=$env[icon_inc_head] align=top>
  $lang[preference_58]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'list_heading', $values, $disps, $uenv[list_heading]);
  echo("</td></tr>\n");

  ## background image
  echo("<tr>
  <td$tdattr1><img src=$env[icon_bgimg] align=top>
  $lang[preference_71]</td>
  <td$tdattr2>\n");
  FormText('bgimg', $uenv[bgimg], '20');
  echo(" <a href=\"javascript:void(open('selimage.php','','width=300,height=400,scrollbas=1,resizable=1'))\">[[$lang[list]]]</a>
  <a href=\"javascript:void(document.form.bgimg.value='')\">[[$lang[delete]]]</a>
  </td></tr>\n");

  ## set my icon as default icon
  echo("<tr>
  <td$tdattr1>
  $lang[preference_80]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'myicon_as_default', $values, $disps, $uenv[myicon_as_default]);
  echo("</td></tr>\n");

  ## gradient header
  echo("<tr>
  <td$tdattr1><img src='$env[icon_gradient]' align='top'>
  $lang[preference_86]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'table_header_gradient', $values, $disps, $uenv[table_header_gradient]);
  echo("</td></tr>\n");

  ## display a year or a month per page
  echo("<tr>
  <td$tdattr1>
  $lang[preference_84]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[year], $lang[month]);
  FormRadios(2, 'calendar_year_per_page', $values, $disps, $uenv[calendar_year_per_page]);
  echo("</td></tr>\n");

  ## display top folder name in the title bar
  echo("<tr>
  <td$tdattr1>
  $lang[preference_88]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'top_folder_name_in_title', $values, $disps, $uenv[top_folder_name_in_title]);
  echo("</td></tr>\n");

  ## highlight the pointed row
  echo("<tr>
  <td$tdattr1>
  $lang[preference_89]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[on], $lang[off]);
  FormRadios(2, 'row_highlight', $values, $disps, $uenv[row_highlight]);
  echo("</td></tr>\n");

  ## page refresing
  echo("<tr>
  <td$tdattr1>
  $lang[preference_92]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[on], $lang[off]);
  FormRadios(2, 'page_refreshing', $values, $disps, $uenv[page_refreshing]);
  echo("</td></tr>\n");

  ## page refresing time
  echo("<tr>
  <td$tdattr1>
  $lang[preference_93]</td>
  <td$tdattr2>\n");
  $values = array(600, 1800, 3600, 7200);
  FormRadios(sizeof($values), 'page_refresh_time', $values, $values, $uenv[page_refresh_time]);
  echo("</td></tr>\n");
}

function ConfigTab4() {
  global $env, $lang, $uenv;
  global $tdattr1, $tdattr2;

  ## search icon
  echo("<tr>
  <td$tdattr1><img src=$env[icon_search] align=top>
  $lang[preference_46]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'show_search_icon', $values, $disps, $uenv[show_search_icon]);
  echo("</td></tr>\n");

  ## advanced search for search icon
  echo("<tr>
  <td$tdattr1>
  $lang[preference_81]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'adv_search_button', $values, $disps, $uenv[adv_search_button]);
  echo("</td></tr>\n");

  ## hide search form
  echo("<tr>
  <td$tdattr1><img src='$env[icon_p_focus]' align='top'>
  $lang[preference_48]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'hide_searchform', $values, $disps, $uenv[hide_searchform]);
  echo("</td></tr>\n");

  ## history layer width and position
  echo("<tr>
  <td$tdattr1><img src=$env[icon_h_layer] align=top>
  $lang[preference_36]</td>
  <td$tdattr2> $lang[width]=");
  FormText('history_layer_w', $uenv[history_layer_w], 5); 
  echo(" X=");
  FormText('history_layer_px', $uenv[history_layer_px], 5); 
  echo(" Y=");
  FormText('history_layer_py', $uenv[history_layer_py], 5); 
  echo("</td></tr>\n");

  ## search results per page
  echo("<tr>
  <td$tdattr1><img src=$env[icon_search] align=top>
  $lang[preference_39]</td>
  <td$tdattr2>\n");
  $values = array(5, 10, 15, 20, 30, 50);
  FormRadios(sizeof($values), 'ipp', $values, $values, $uenv[ipp]);
  echo("</td></tr>\n");

  ## bookmark path in search results
  echo("<tr>
  <td$tdattr1><img src=$env[icon_s_path] align=top>
  $lang[preference_26]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'search_disp_path', $values, $disps, $uenv[search_disp_path]);
  echo("</td></tr>\n");

  ## recent folders in history layer
  echo("<tr>
  <td$tdattr1><img src='$env[icon_fo]' align='top'>
  $lang[preference_78]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'h_layer_folist', $values, $disps, $uenv[h_layer_folist]);
  echo("</td></tr>\n");

  ## recent bookmarks in history layer
  echo("<tr>
  <td$tdattr1><img src='$env[icon_bk]' align='top'>
  $lang[preference_79]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[show], $lang[hide]);
  FormRadios(2, 'h_layer_bklist', $values, $disps, $uenv[h_layer_folist]);
  echo("</td></tr>\n");

  ## fade in/out history layer
  echo("<tr>
  <td$tdattr1>
  $lang[preference_82]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'h_layer_fading', $values, $disps, $uenv[h_layer_fading]);
  echo("</td></tr>\n");

  ## search keywords in cookie
  echo("<tr>
  <td$tdattr1>
  $lang[preference_87]</td>
  <td$tdattr2>\n");
  $values = array(1, 0);
  $disps = array($lang[yes], $lang[no]);
  FormRadios(2, 'store_search_cookie', $values, $disps, $uenv[store_search_cookie]);
}

session_register('preference_tab_select');

# persist perference tab selection status

# using cookie
# if ($sel) PutCookie("PREFERENCE_SEL_TAB", $sel);
# else {
#   $sel = GetCookie("PREFERENCE_SEL_TAB");
#   if (!$sel) $sel = 1;
# }

# using session
if ($sel) $preference_tab_select = $sel;
else $sel = $preference_tab_select;
if (!$sel) $sel = 1;

$env[title_icon] = $env[icon_config];
$env[script] = "
  function Reload() {
    document.form.edit_continue.value = '1';
    document.form.submit();
  }
  function AddValue(text, inc) {
    value = Math.floor(text.value) + inc;
    if (value <= 0) return;
    text.value = value;
  }";

if ($sel == '6' && !$env[enable_manual_config]) {
  ErrorRedir("Manual configuration is not allowed", "preference.php?sel=1");
}



PageHead($lang[preference_0]);
ButtonSet();

# default environment
$uenv = $uconf;
$temp = LoadUserConfig($env[self_uid], "");
$uenv = array_merge($uenv, $temp);
$fenv = $fconf;
$temp = LoadUserConfig($env[self_uid], "frame");
$fenv = array_merge($fenv, $temp);

if (!isset($uenv[style_font])) $uenv[style_font] = $lang[style_font];

$tdattr1 = " align='right' bgcolor='$env[td]'";
$tdattr2 = " align='left' bgcolor='$env[td]'";

echo("<table cellpadding=2 cellspacing=1 border=0 width=100% align=center
 bordercolordark=$env[th] bordercolorlight=$env[td]>
<form name='form' action='preference.php' method='post'>\n");

for ($i=1; $i<=10; $i++) $attr2[$i] = " class='headline'";
if (!$sel) $sel = 1;
$attr2[$sel] = " class='tabselect'";

$tab_str[1] = $lang[preference_main];
$tab_str[2] = $lang[button];
$tab_str[3] = $lang[preference_misc];
$tab_str[4] = $lang[search];
$tab_str[5] = $lang[preference_display];
$tab_str[6] = $lang[preference_manual];
$tabl_str[$sel] = "<b>$tabl_str[$sel]</b>";

$attr = " width='33%' align='center'";
echo("<tr>
<td$attr$attr2[1] nowrap><a href='preference.php?sel=1'>$tab_str[1]</a></td>
<td$attr$attr2[2] nowrap><a href='preference.php?sel=2'>$tab_str[2]</a></td>
<td$attr$attr2[3] nowrap><a href='preference.php?sel=3'>$tab_str[3]</a></td>
</tr><tr>
<td$attr$attr2[4] nowrap><a href='preference.php?sel=4'>$tab_str[4]</a></td>
<td$attr$attr2[5] nowrap><a href='preference.php?sel=5'>$tab_str[5]</a></td>
<td$attr$attr2[6] nowrap><a href='preference.php?sel=6'>$tab_str[6]</a></td>
</tr>\n");

echo("<tr><td colspan='5' bgcolor='$env[th]'>\n");
echo("<table cellpadding='3' cellspacing='0' border='0' width='100%'
 align='center'><tr>
<td width='50%' align='right'></td>
<td width='50%'></td></tr>\n");
if ($sel == 1) ConfigTab1();
elseif ($sel == 2) ConfigTab2();
elseif ($sel == 3) ConfigTab3();
elseif ($sel == 4) ConfigTab4();
elseif ($sel == 5) ConfigTab5();
elseif ($sel == 6) ConfigTab6();
echo("</table></td></tr>\n");

$mode = ($sel == 6) ? "configsave" : "save";
echo("<tr>
  <td align='center' colspan='5'>
  <input type='hidden' name='mode' value='$mode'>
  <input type='hidden' name='edit_continue' value='0'>
  <a href=\"javascript:document.form.submit()\">$lang[preference_save]</a>
  </td>
</tr></form></table>\n");

PageTail();
exit;

?>
