<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

CheckAuth('write');

# detect the used protocol
$protocol = GetProtocol();

$row = $userMgr->findUserByLogin($env[user]);

$env[title_icon] = $env[icon_myinfo];
PageHead($lang[myinfo_0]);
ButtonSet();

$lastlogin = FormatDateAndTime($row[lastlogin], $lang[dateformat]);
$rdate = FormatDateAndTime($row[rdate], $lang[dateformat]);

$attr1 = " bgcolor='$env[th]' align='center'";
$attr2 = " bgcolor='$env[td]' align='center'";
echo("<table cellpadding='3' cellspacing='1' width='90%' border='0' align='center'>
<tr>
  <td bgcolor='$env[th]' colspan='2' align='center'><b>$lang[myinfo_0]</b></td>
</tr>
<tr>
  <td$attr1>$lang[username]</td>
  <td$attr2><b>$row[user]</b></td>
</tr>
<tr>
  <td$attr1>$lang[realname]</td>
  <td$attr2><b>$row[name]</b></td>
</tr>
<tr>
  <td$attr1>$lang[email]</td>
  <td$attr2><a href='mailto:$row[email]'><b>$row[email]</b></a></td>
</tr>
<tr>
  <td$attr1>$lang[lastlogin]</td>
  <td$attr2><b>$lastlogin</b></td>
</tr>
<tr>
  <td$attr1>$lang[lastloginip]</td>
  <td$attr2><b>$row[lastip]</b></td>
</tr>
<tr>
  <td$attr1>$lang[logincounter]</td>
  <td$attr2><b>$row[logincnt]</b></td>
</tr>
<tr>
  <td$attr1>$lang[registerdate]</td>
  <td$attr2><b>$rdate</b></td>
</tr>
<tr>
  <td$attr1>Current Browser</td>
  <td$attr2><b>$HTTP_SERVER_VARS[HTTP_USER_AGENT]</b></td>
</tr>
<tr>
  <td$attr1>Current IP Address</td>
  <td$attr2>IP:port = <b>$HTTP_SERVER_VARS[REMOTE_ADDR]:$HTTP_SERVER_VARS[REMOTE_PORT]</b></td>
</tr>
<tr>
  <td$attr1>Current Protocol</td>
  <td$attr2><b>$protocol</b></td>
</tr>\n");

$cnt_b = $mgr->getBookmarksNumber();
$cnt_c = $mgr->getFoldersNumber();

echo("<tr>
  <td$attr1># of bookmarks</td>
  <td$attr2><b>
  $lang[bookmark]: $cnt_b &nbsp;&nbsp;
  $lang[folder]: $cnt_c
  </b></td>
</tr>\n");

$tot_b = $mgr->getBookmarksTotalVisit();
$tot_c = $mgr->getFoldersTotalVisit();

echo("<tr>
  <td$attr1>Total visits</td>
  <td$attr2><b>
  $lang[bookmark]: $tot_b &nbsp;&nbsp;
  $lang[folder]: $tot_c
  </b></td>
</tr>\n");

echo("<tr><td$attr1>Cookies</td><td$attr2>");
PrintArray($HTTP_COOKIE_VARS,'COOKIE');
echo("</td></tr>\n");

echo("<tr><td$attr1>Sessions</td><td$attr2>");
echo session_encode();
echo("</td></tr>\n");

$php_version = GetPhpVersion($format='string');
echo("<tr><td$attr1>PHP Version</td><td$attr2>$php_version</td></tr>\n");

echo("</table>\n");
PageTail();

?>
