<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");
include("inc/addmodify.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $id = $HTTP_GET_VARS[id];
    $foid = $HTTP_GET_VARS[foid];
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
  }
}

CheckAuth('write');

if ($id == '0') { # if root folder
  $row[title] = sprintf($env[top_folder_name], $env[user]);
  $addform = 1;
  $modifyform = $moveform = $deleteform = $linkform = 0;
  $cutform = 0;
} else { # if not root folder
  $row = $mgr->findItemById($id);
  if (!$row) Error("Item with id=$id does not exist");

  $addform = 0;
  $modifyform = $moveform = $deleteform = $linkform = 1;
  $cutform = 1;
  if ($row[type]=='l') $linkform = 0;
  if ($id == $env[root]) $deleteform = 0; # can't delete current folder
}

$env[title_icon] = $env[icon_change];
$env[page_unload] = 1;
PageHead($lang[modifyform_0]);
ButtonSet();

echo("<center>\n");
echo("$lang[location]: ");
PrintPath($row);
echo("<br><br>");
if ($modifyform) ModifyForm($row);
if ($addform) AddForm($row);
if ($cutform) ClipboardForm($row);
if ($moveform) MoveForm($row);
if ($deleteform) DeleteForm($row);
if ($linkform) AddLinkForm($row);
echo("</center>\n");
echo("<script>
var iconselwin;
function PageUnLoad() {
  if (iconselwin) iconselwin.close();
}
</script>\n");
PageTail();

?>
