<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('id', 'type', 'title', 'url', 'comment', 'public',
      'exp', 'recursive', 'rate', 'foid', 'lnid');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');

# check if valid input
if ($type == 'b') {
  if (!$title) { Error($lang[msg_req_title]); }
  if (!$url)   { Error($lang[msg_req_url]); }
} else {
  if (!$title) { Error($lang[msg_req_title]); }
}

# get the current information
$row = $mgr->findItemById($id);

$need_to_update_total = 0;
if ($row[type]=='b' && $type=='c') { # change the type from bookmark to folder
  $total = 0; # the number of included bookmarks to be updated
  $need_to_update_total = 1;
} else if ($row[type]=='c' && $type=='b') { # change a folder to a bookmark
  $subs = $row[total];
  if ($subs > 0) Error($lang[msg_not_empty]);
  $total = 1; # the number of included bookmarks
  $need_to_update_total = 1;
}

$rowCreate = array();
$rowCreate[id]      = $id;
$rowCreate[type]    = $type;
$rowCreate[parent]  = $row[parent];
$rowCreate[title]   = $title;
$rowCreate[url]     = $url;
$rowCreate[comment] = $comment;
$rowCreate[public]  = $public;
$rowCreate[icon]    = $icon;
$rowCreate[visit]   = $row[visit];
$rowCreate[lastWhere]= $row[lastWhere];
$rowCreate[chkdate] = $row[chkdate];
$rowCreate[rate]    = $rate;
$rowCreate[total]   = $row[total];
if ($type == 'l') $rowCreate[lnid] = $lnid;

# update database
$mgr->updateItem($rowCreate);

if ($need_to_update_total) UpdateTotalLeaf($id);

# callback function to change the public attribute
function Callback($row, $args) {
  global $env, $mgr;
  $row[public] = $args[public];
  $mgr->updateItem($row);
}

if ($recursive) { # change private/public attribute recursively
  # traverse tree
  $args = array(public=>"$public"); 
  TraverseTree($id, 'Callback', $args);
}

$exp_parm = ($env[tree_view] && $exp) ? "&exp=$exp" : "";
if ($foid != '') $root_str = "root=$foid";
else $root_str = "";
header("Location: list.php?$root_str$exp_parm&dummy=$env[dummy]#$id");
exit;

?>
