<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
    $which_list = array('mode', 'id', 'format');
    ExtractVars($HTTP_GET_VARS, $which_list);
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'id', 'title', 'memotext', 'rmode');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

CheckAuth('write');
$env[title_icon] = $env[icon_memo];

$memoMgr = createMemoManager();

function Head1() {
  global $env, $lang;
  global $mode;
  global $id;

  if (!$mode) $mode = 'list';
  $tab1 = ($mode=='list')   ? "<b>$lang[list]</b>" : "$lang[list]";
  $tab2 = ($mode=='add')    ? "<b>$lang[add]</b>" : "$lang[add]";
  $tab3 = ($mode=='edit')   ? "<b>$lang[edit]</b>" : "$lang[edit]";
  $tab4 = ($mode=='view')   ? "<b>$lang[view]</b>" : "$lang[view]";
  $tab5 = ($mode=='export') ? "<b>$lang[export]</b>" : "$lang[export]";

  $col1 = ($mode=='list')   ? $env[th] : $env[td];
  $col2 = ($mode=='add')    ? $env[th] : $env[td];
  $col3 = ($mode=='edit')   ? $env[th] : $env[td];
  $col4 = ($mode=='view')   ? $env[th] : $env[td];
  $col5 = ($mode=='export') ? $env[th] : $env[td];

  $attr = " width='20%' align='center'";
  $attrf = " class='tabselect'";
  $attrf .= " bgcolor='$env[th]'";

  $attr1 = ($mode=='list')   ? $attr.$attrf : $attr;
  $attr2 = ($mode=='add')    ? $attr.$attrf : $attr;
  $attr3 = ($mode=='edit')   ? $attr.$attrf : $attr;
  $attr4 = ($mode=='view')   ? $attr.$attrf : $attr;
  $attr5 = ($mode=='export') ? $attr.$attrf : $attr;

  $opt = "";
  if ($mode=='edit') $tab4 = "<a href='memo.php?mode=view&id=$id'>$tab4</a>";
  if ($mode=='view') $tab3 = "<a href='memo.php?mode=edit&id=$id'>$tab3</a>";
  echo("<table border='0' cellpadding='2' cellspacing='1' width='100%'>
<tr>
 <td bgcolor='$col1'$attr1><a href='memo.php?mode=list$opt'>$tab1</a></td>
 <td bgcolor='$col2'$attr2><a href='memo.php?mode=add$opt'>$tab2</a></td>
 <td bgcolor='$col3'$attr3>$tab3</td>
 <td bgcolor='$col4'$attr4>$tab4</td>
 <td bgcolor='$col5'$attr5><a href='memo.php?mode=export$opt'>$tab5</a></td>
</tr></table>\n");
}

function AddEditForm($mode='add', $row) {
  global $env, $lang;

  $style_str = ($env[textarea_full_width]) ? " style=\"width: 100%\"" : "";

  echo("<script>
var modified = 0;
function PageFocus() {
// document.memoform.memotext.focus();
  MemoSize();
}
function PageUnLoad() {
  if (modified) {
    if (window.confirm('$lang[memo_2]')) {
      document.memoform.submit();
    } else {
      return;
    }
  }
}
function MemoResize(value) {
  form = document.memoform;
  if (value == 'narrow') {
    if (form.memotext.cols > 60)
      form.memotext.cols -= 5;
  }
  if (value == 'wide') form.memotext.cols += 5;
  if (value == 'short') {
    if (form.memotext.rows > 10) form.memotext.rows -= 5;
  }
  if (value == 'long') form.memotext.rows += 5;
}
function MemoSize() {
  var onechar;
  var tcount = 0;
  var len = 0;

  str = document.memoform.memotext.value;
  string = String(str);
  len = string.length;
  document.memoform.length.value = len;
}
function MemoChange() {
  modified = 1;
  document.memoform.changed.value = '*';
  MemoSize();
}
function MemoSave(rmode) {
  modified = 0;
  if (rmode == 'view') document.memoform.rmode.value='view';
  else if (rmode == 'edit') document.memoform.rmode.value='edit';
  document.memoform.submit();
}
</script>\n");

  echo("<tr>
<td align='left'>
$lang[title] :
<input type='text' name='title' size='40' value=\"$row[title]\">
</td><td align='right'>
[[
<a href=\"javascript:MemoResize('long');\">$lang[textarea_1]</a> |
<a href=\"javascript:MemoResize('short');\">$lang[textarea_2]</a>
]]
</td>
</tr>");
  echo("<tr>
<td colspan='2'>
<textarea name='memotext' rows='$env[textarea_rows]'
 cols='$env[textarea_cols]'$style_str
 onkeyup=\"javascript:MemoChange()\">$row[memo]</textarea>
</td>
</tr>");
  if ($mode == 'edit') {
    $rdate = FormatDateAndTime($row[rdate], $lang[dateformat3]);
    $mdate = FormatDateAndTime($row[mdate], $lang[dateformat3]);
    echo("<tr>
<td colspan='2'>
$lang[rtime]: $rdate<br>
$lang[mtime]: $mdate<br>
</td>
</tr>");
  }
}

if ($mode=='view') {
  $row = $memoMgr->findMemoById($id);
  if (!$row) Error("You can't edit this memo");
  DBError();

  PageHead("$lang[memo_0] - $lang[view]");
  ButtonSet();
  Head1();

  # URL auto link
  $memo = $row[memo];

  if (!$format) $format = 'text';
  if ($format == 'text') {
    $reg = "(http|https|ftp|telnet|news):\/\/(([\xA1-\xFEa-z0-9_\-]+\.[][\xA1-\xFEa-z0-9:;&#@=_~%\?\/\.\,\+\-]+)(\/|[\.]*[a-z0-9]))";
    $memo = eregi_replace("\r\n", "\n", $memo);
    $memo = eregi_replace("<([a-z][^>]*)>", "&lt;\\1&gt;",$memo); # strip tags
    $memo = eregi_replace("<(/[a-z]*)>", "&lt;\\1&gt;",$memo); # strip tags
    $memo = eregi_replace("($reg)","<a href=\"\\1\" target='_blank'>\\1</a>",$memo);
    $memo = nl2br($memo);
  }

  echo("$lang[title] : <b>$row[title]</b>");
  echo("&nbsp; &nbsp; &nbsp; &nbsp;");
  if ($format == 'text')
    echo("<a href='memo.php?mode=view&id=$row[id]&format=html'>[[HTML]]</a>");
  else
    echo("<a href='memo.php?mode=view&id=$row[id]&format=text'>[[TEXT]]</a>");
#  echo("<br>
#<blockquote style=\"margin:5px 5px 5px 5px; background:$env[td];\">
#$memo<br>
#</blockquote>");
  echo("<br>
<blockquote style=\"margin:5px 5px 5px 5px; background:$env[td];\">
<!pre>
$memo
<!/pre>
</blockquote>");

  PageTail();
  exit;
}

if ($mode=='add' || $mode=='edit') {

  if ($mode=='edit') {
    if (!$id) Error("require id");

    $row = $memoMgr->findMemoById($id);
    if (!$row) Error("You can't edit this memo");
    DBError();
  } else {
    $row = array();
  }

  $env[page_focus] = 1;
  $env[page_unload] = 1;
  if ($mode == 'add') PageHead("$lang[memo_0] - $lang[add]");
  elseif ($mode == 'edit') PageHead("$lang[memo_0] - $lang[edit]");
  ButtonSet();
  Head1();

  echo("<table border='0' align='center' width='100%' cellpadding='0'
  cellspacing='0'>
  <form action='memo.php' method='post' name='memoform'>\n");

  if ($mode == 'add') {
    AddEditForm('add', $row);
  } elseif ($mode == 'edit') {
    AddEditForm('edit', $row);
  }

  if ($mode == 'add') {
    $mode_str = 'addsubmit';
    $hidden = "";
  } elseif ($mode == 'edit') {
    $mode_str = 'editsubmit';
    $hidden = "<input type='hidden' name='id' value='$id'>";
    $del_link = "<script>
function Question(msg, url) {
  if (confirm(msg)) document.location = url
  else return;
}
</script>
<a href=\"javascript:MemoSave('view')\">[[$lang[view]]]</a>
&nbsp; &nbsp; &nbsp; &nbsp;
<a href=\"javascript:Question('$lang[delete_really]', 'memo.php?mode=del&id=$row[id]')\">[[$lang[delete]]]</a>"; # end of string del_link
  }

  echo("<tr>
<td align='center' colspan='2'>
<input type='text' name='changed' value='' size='1'><input
 type='text' name='length' size=4>$lang[unit_char]
<input type='hidden' name='mode' value='$mode_str'>
<input type='hidden' name='rmode' value=''>
<a href=\"javascript:MemoSave('edit')\">[[$lang[memo_1]]]</a>
$del_link
$hidden</td>
</tr>\n");
  echo("</form></table>\n");

  PageTail();
  exit;

} elseif ($mode == 'del') {
  if (!$id) Error("require id");

  $memoMgr->deleteMemo($id);
  DBError();

  header("Location: memo.php?dummy=$env[dummy]");
  exit;

} elseif ($mode == 'editsubmit') {
  if (!$title) Error("require title");
  if (!$id) Error("require id");

  $memoMgr->updateMemo($id, $title, $memotext);
  DBError();

  if ($rmode == 'view') {
    header("Location: memo.php?mode=view&id=$id&dummy=$env[dummy]");
  } elseif ($rmode == 'edit') {
    header("Location: memo.php?mode=edit&id=$id&dummy=$env[dummy]");
  } else header("Location: memo.php?dummy=$env[dummy]");
  exit;

} elseif ($mode == 'addsubmit') {
  if (!$title) Error("require title");

  $memoMgr->addMemo($title, $memotext);
  DBError();

  header("Location: memo.php?dummy=$env[dummy]");
  exit;

} elseif ($mode == 'export') {
  Error("Not yet implemented");
  exit;
}


PageHead($lang[memo_0]);
ButtonSet();

Head1();

$attr1 = " bgcolor='$env[th]' align='center'";
$attr2 = " bgcolor='$env[td]'";
echo("<table border='0' width='100%' cellpadding='2' cellspacing='1'
 align='center'>
<tr>
<td$attr1>$lang[title]</td>
<td$attr1>$lang[size]</td>
<td$attr1>$lang[rtime]</td>
</tr>\n");

$return = $memoMgr->findAllMemos("title");
DBError();

$cnt = 0;
while ($row = $return->fetchRow()) {
  $rnew = (IsNew($row[rdate])) ? " <img src='$env[icon_new]' align='top' border='0'>" : "";
  $mnew = (IsNew($row[mdate])) ? " <img src='$env[icon_new]' align='top' border='0'>" : "";

  $size = strlen($row[memo]);
  list($size_format, $size_unit) = FormatByteDown($size,3,1);

  $rdate = FormatDateAndTime($row[rdate], $lang[dateformat3]);
  $mdate = FormatDateAndTime($row[mdate], $lang[dateformat3]);

  echo("<tr>
<td$attr2>
  <a href='memo.php?mode=view&id=$row[id]'>
  <img src='$env[icon_memo]' align='top' border='0'>
  $row[title]$mnew</a>
</td>
<td$attr2 align='center' nowrap>$size_format $size_unit</td>
<td$attr2 align='center' nowrap>$rdate$rnew</td>
</tr>\n");
  $cnt++;
}

echo("<tr>
<td align='center' colspan='3' bgcolor='$env[th]'>$lang[total] <b>$cnt</b>
</td>
</tr>
</table>\n");

PageTail();

?>
