<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('mode', 'userid', 'email');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

function PageHead1() {
  echo("<html>
<head>
<style type='text/css'>
a:link    { text-decoration:none; }
a:visited { text-decoration:none; }
a:hover   { text-decoration:underline; }
td,body   {
  color: black;
  font-family: Verdana,Arial,Helvetica;
  font-size: x-small;
}
input,select,textarea {
  border:1 solid black;
  background-color:#eeeeee;
  color:black;
}
</style>
<title>$env[meta_title]</title>
</head>
<body bgcolor=white text=black link=#aa4444 alink=#aa4444 vlink=#aa4444>\n");
}

function PageTail1() {
  echo("</body></html>\n");
}

if ($mode == 'new') {

  # in demonstration mode, new user registration, unregistration, clearing
  # database, changing passwords, password restoration features are not allowed.
  if ($conf[demo_mode]) Error($lang[msg_demo_limit]);

  $rand = rand(1, $env[dummy]);
  $hash = md5($rand);
  $new_pw = substr($hash, 0, 8);  # new password

  # get user's email address
  $row = $userMgr->findUserByLogin($userid);

  if (!$row) Error($lang[lostpw_3]);
  else if (strcmp($row[email], $email)) Error($lang[lostpw_4]);
  if (!$row[email]) Error($lang[lostpw_5]);

  # send an e-mail to the user
  $header = "From: $env[site_title]-<$env[admin_email]>\n"; # added by gizmoeti
  #$header .= "X-Sender: <$env[admin_email]>\n";
  #$header .= "X-Mailer: PHP\n";
  #$header .= "Return-Path: "; # email for callback errors

  $subject = $lang[lostpw_6];
  $text = sprintf($lang[lostpw_7], $env[sitehome], $userid, $new_pw, $env[site_title]);
  mail($row[email], $subject, $text, $header);

  # update user's password
  $row[passwd] = $new_pw;
  $userMgr->updateUser($row);

  PageHead1();
  printf($lang[lostpw_8], $userid);
  echo("<br /><a href=index.php>$lang[lostpw_9]</a>");
  PageTail1();
  exit;
}

PageHead1();

echo("<center>
<h2>$env[site_title]</h2>
<table border=0 width=90% align='center'>
<tr><td align='center'>
<b>$lang[lostpw_2]</b><br>
</td></tr>
</table>
</center>\n");

echo("<table border='0' width='90%' align='center'>
<form action='lostpasswd.php' method='post'>
<tr>
  <td align='right'>$lang[index_1] :</td>
  <td><input type='text' name='userid' size='20'></td>
</tr><tr>
  <td align='right'>$lang[email] :</td>
  <td><input type='text' name='email' size='20'></td>
</tr><tr>
  <td></td>
  <td>
<input type='hidden' name='mode' value='new'>
<input type='submit' value='$lang[lostpw_1]'>
  </td>
</tr>
</form></table>\n");

PageTail1();

exit;

?>
