<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

$env[pass_without_login] = 1;
include("inc/common.php");
include("inc/calendar.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('userid', 'passwd', 'url', 'pagetitle', 'remember',
       'duration');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

if (!$userid) Error($lang[msg_req_id]);
if (!$passwd) Error($lang[msg_req_pw]);

# check password and update login information of database
LoginAndUpdate($userid, $passwd);

$env[logined] = 1;  ### login successfully

# load configuration, language, and theme
include("inc/common.load.php");

# set cookie variables
if ($duration) $env[persist_duration] = (int)$duration;
if ($remember) SetLoginCookies($userid, $env[uid], $env[dummy], 1);
else SetLoginCookies($userid, $env[uid], $env[dummy]);

if ($url) $redirect = "bookmark.php?url=$url&pagetitle=$pagetitle";
else $redirect = "list.php";

if ($env[login_info]) {
  LoginPage($redirect, $lastlogin, $lastip);
} else {
  header("Location: $redirect");
}

?>
