<?php

/************************************************************************/
/* Bookmark4U: Web-based personal bookmarking environment               */
/* ======================================================               */
/* Please read LICENSE.txt                                              */
/************************************************************************/

include("inc/common.php");

if ($env[register_global_off]) {  # register get/post variables as global
  if ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'GET') {
  } elseif ($HTTP_SERVER_VARS[REQUEST_METHOD] == 'POST') {
    $which_list = array('order', 'asc');
    ExtractVars($HTTP_POST_VARS, $which_list);
  }
}

function getAscValue($orderCurrent) {
  global $asc, $order;

  if ( $order == $orderCurrent )
    return ($asc == 1) ? 0 : 1;
  else
    return 1;
}

PageHead("$lang[listuser_0]");
ButtonSet();

if (!isset($order)) $order = $env[list_user_default_sort];
if (!isset($asc)) $asc = 1;

$orderQry = $order;
if ($asc == 1) $orderQry .= " ASC";
else $orderQry .= " DESC";

$result = $userMgr->findAllUsers($orderQry);
$attr1 = " align='center' bgcolor='$env[th]'";
echo("<table border=0 cellpadding=2 cellspacing=1 width=100%>
<tr>
<td$attr1><a href=listuser.php?order=user&asc=" . getAscValue("user") . " title=\"$lang[list_8] $lang[user]\"><b>$lang[user]</b></a></td>
<td$attr1><a href=listuser.php?order=name&asc=" . getAscValue("name") . " title=\"$lang[list_8] $lang[name]\"><b>$lang[name]</b></a></td>
<td$attr1><a href=listuser.php?order=lastlogin&asc=" . getAscValue("lastlogin") . " title=\"$lang[list_8] $lang[lastlogin]\"><b>$lang[lastlogin]</b></a></td>
<td$attr1><b>$lang[bookmark]</b></td>\n");
if ($env[list_user_show_nb_bk])
  echo("<td$attr1><b>$lang[public]</b></td>\n");
echo("</tr>\n");

$cnt = 0;
while ($row = $result->fetchRow()) {
  $lastlogin = FormatDateAndTime($row[lastlogin], $lang[dateformat]);
  if ($lastlogin == 'NULL') $lastlogin = $lang[listuser_1];

  if ($env[row_highlight]) {
    $attr = " onmouseover=this.style.background='$env[td]'"
           ." onmouseout=this.style.background=''";
  } else $attr = "";

  echo("<tr$attr>
<td align='center'><a href=guestlogin.php?userid=$row[user]>$row[user]</a></td>
<td align='center'><a href=guestlogin.php?userid=$row[user]>$row[name]</a></td>
<td align='center'>$lastlogin</td>
<td align='center'><a href=guestlogin.php?userid=$row[user]>$lang[view]</a></td>\n");
if($env[list_user_show_nb_bk]) {
  $mgr->setUser( $row[user] );
  $total_b = $mgr->getBookmarksNumber(null, true);
  echo("<td align=center>$total_b</td>\n");
}
echo("</tr>\n");
  $cnt++;
}
echo("<tr>
<td colspan='5' align='center' bgcolor='$env[th]'>$lang[total] <b>$cnt</b> ");
if ($cnt > 1) echo $lang[users];
else echo $lang[user];
echo("</td>
</tr>
</table>\n");

PageTail();

?>
